/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.flow.placeholders.recipe;

import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.exec.join.JoinRecipeMeta;
import com.dataiku.dip.dataflow.exec.join.JoinRecipePayloadParams;
import com.dataiku.dip.dataflow.exec.joinlike.JoinOutputRole;
import com.dataiku.dip.dataflow.exec.joinlike.JoinType;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.docgen.flow.FlowDocumentContext;
import com.dataiku.dip.docgen.flow.FlowPlaceholder;
import com.dataiku.dip.docgen.helpers.PlaceholderOutputFactory;
import com.dataiku.dip.docgen.resolver.BadTemplatePlaceholderException;
import com.dataiku.dip.docgen.resolver.IterableDescription;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JoinUnmatchedRecipePlaceholders {
    private static void checkRecipeIsJoin(SerializedRecipe recipe) throws BadTemplatePlaceholderException {
        if (!JoinRecipeMeta.META.getType().equals(recipe.type)) {
            throw new BadTemplatePlaceholderException("Placeholder not available for recipe " + recipe.name + ".");
        }
    }

    public static class UnmatchedOutput
    implements FlowPlaceholder.IterablePlaceholder<SerializedRecipe, SerializedDataset> {
        JoinOutputRole role;

        public UnmatchedOutput(JoinOutputRole role) {
            this.role = role;
        }

        @Override
        public IterableDescription<SerializedRecipe, SerializedDataset> getDescription() {
            return IterableDescription.iterablePlaceholder(SerializedRecipe.class, SerializedDataset.class, "$dataset");
        }

        @Override
        public Collection<SerializedDataset> resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            JoinUnmatchedRecipePlaceholders.checkRecipeIsJoin(recipe);
            List<SerializedRecipe.RecipeOutput> recipeOutputs = recipe.getOutputsForRole(this.role.name);
            if (recipeOutputs.isEmpty()) {
                return new ArrayList<SerializedDataset>();
            }
            String fullName = AnyLoc.resolveSmart(context.projectKey, recipeOutputs.get((int)0).ref).getFullName();
            return context.getSerializedDatasets(Lists.newArrayList((Object[])new FlowDataset[]{(FlowDataset)context.getProjectFlowGraph().datasets.get(fullName)}));
        }
    }

    public static class UnmatchedOutputRef
    implements FlowPlaceholder.TextPlaceholder<SerializedRecipe> {
        JoinOutputRole role;

        public UnmatchedOutputRef(JoinOutputRole role) {
            this.role = role;
        }

        @Override
        public Class<SerializedRecipe> getInputType() {
            return SerializedRecipe.class;
        }

        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            JoinUnmatchedRecipePlaceholders.checkRecipeIsJoin(recipe);
            List<SerializedRecipe.RecipeOutput> recipeOutputs = recipe.getOutputsForRole(this.role.name);
            if (recipeOutputs.isEmpty()) {
                return new PlaceholderOutput.Text("");
            }
            String ref = recipeOutputs.get((int)0).ref;
            return new PlaceholderOutput.Text(ref);
        }
    }

    public static class CanHaveUnmatchedOutput
    implements FlowPlaceholder.TextPlaceholder<SerializedRecipe> {
        List<JoinType> compatibleJoinTypes;

        public CanHaveUnmatchedOutput(JoinOutputRole role) {
            switch (role) {
                case UNMATCHED_ROWS_LEFT: {
                    this.compatibleJoinTypes = Lists.newArrayList((Object[])new JoinType[]{JoinType.RIGHT, JoinType.INNER});
                    break;
                }
                case UNMATCHED_ROWS_RIGHT: {
                    this.compatibleJoinTypes = Lists.newArrayList((Object[])new JoinType[]{JoinType.LEFT, JoinType.INNER});
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot create unmatched output placeholder with output role" + String.valueOf((Object)role));
                }
            }
        }

        @Override
        public Class<SerializedRecipe> getInputType() {
            return SerializedRecipe.class;
        }

        @Override
        public PlaceholderOutput.Text resolve(FlowDocumentContext context, SerializedRecipe recipe) throws PlaceholderExpectedException {
            JoinUnmatchedRecipePlaceholders.checkRecipeIsJoin(recipe);
            JoinRecipePayloadParams payload = (JoinRecipePayloadParams)JSON.parse((String)context.getCachedPayload(recipe), JoinRecipePayloadParams.class);
            if (payload.joins.size() != 1) {
                return PlaceholderOutputFactory.makeBoolean(false);
            }
            return PlaceholderOutputFactory.makeBoolean(this.compatibleJoinTypes.contains((Object)((JoinRecipePayloadParams.JoinDesc)payload.joins.get((int)0)).type));
        }
    }
}

