/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute.sampling;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.utils.SchemaComparator;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.FilesystemDatasetConfig;
import com.dataiku.dip.eda.compute.sampling.DataSpec;
import com.dataiku.dip.eda.compute.sampling.SampleRequest;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.csv.CSVFormatExtractor;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.ImmutableValueObject;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import java.io.File;
import java.util.Objects;

@UIModel
public class Sample
extends ImmutableValueObject {
    public DataSpec dataSpec;
    public String projectKey;
    public long nbRows;
    public boolean isWholeDataset;
    public String datasetBasicSignature;
    public String datasetContentSignature;
    public String id;
    public long computeTime;
    public Schema schema;
    public String containerConfName;
    public static final String META_FILE_NAME = "meta.json";
    public static final String DATA_FILE_NAME = "data.csv.gz";

    public static String generateNewSampleId(Dataset dataset, String projectKey) {
        return projectKey + "/" + dataset.getSmartName(projectKey) + "/" + SecretKeyGenerator.generate();
    }

    public static AnyLoc getDatasetLocFromSampleId(String sampleId) {
        if (null == sampleId) {
            return null;
        }
        String[] parts = Sample.parseSampleId(sampleId);
        return DatasetLocUtils.DatasetLoc.resolveSmart(parts[0], parts[1]);
    }

    public Sample(String datasetBasicSignature, String datasetContentSignature, String projectKey, String id, long computeTime, DataSpec dataSpec, Schema schema, String containerConfName) {
        this.datasetBasicSignature = datasetBasicSignature;
        this.datasetContentSignature = datasetContentSignature;
        this.containerConfName = containerConfName;
        this.projectKey = projectKey;
        this.id = id;
        this.computeTime = computeTime;
        this.dataSpec = dataSpec;
        this.schema = schema;
    }

    private Sample() {
    }

    public File getDataFile() {
        return Sample.dataFile(this.getId());
    }

    public String getId() {
        return this.id;
    }

    public StreamableDatasetSelection getSelection() {
        return this.dataSpec.datasetSelection;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public AnyLoc getDatasetLoc() {
        return DatasetLocUtils.DatasetLoc.resolveSmart(this.projectKey, this.dataSpec.inputDatasetSmartName);
    }

    public String getDatasetContentSignature() {
        return this.datasetContentSignature;
    }

    public String getDatasetBasicSignature() {
        return this.datasetBasicSignature;
    }

    public boolean canFulfillRequest(SampleRequest request) {
        return Objects.equals(this.getDatasetLoc(), request.dataset.getLoc()) && Objects.equals(this.datasetBasicSignature, request.basicSignature) && this.dataSpec.refreshTrigger == request.dataSpec.refreshTrigger && JSON.jsonEquals((Object)((Object)this.dataSpec.datasetSelection), (Object)((Object)request.dataSpec.datasetSelection)) && Objects.equals(this.containerConfName, request.containerConfName) && SchemaComparator.findIncompatibilities(this.schema, request.dataset.getSchema(), true).isEmpty();
    }

    public Dataset asFakeDataset() {
        CSVFormatConfig config = CSVFormatConfig.getStandardTabExcelFormat();
        config.parseHeaderRow = false;
        config.compress = "gz";
        FilesystemDatasetConfig fakeConfig = new FilesystemDatasetConfig(null, this.getDataFile().getAbsolutePath());
        Dataset fakeDataset = new Dataset();
        fakeDataset.setFullName(this.getProjectKey() + ".this_is_not_a_real_dataset");
        fakeDataset.setType(BuiltinFSDatasets.FS_META.getType());
        fakeDataset.setParams(fakeConfig);
        fakeDataset.setFormatType(CSVFormatExtractor.META.getType());
        fakeDataset.setFormatParams(config);
        fakeDataset.setSchema(this.schema);
        return fakeDataset;
    }

    public File getSampleDir() {
        return Sample.sampleDir(this.getId());
    }

    private static String[] parseSampleId(String sampleId) {
        String[] parsedSampleId = sampleId.split("/");
        if (parsedSampleId.length != 3) {
            throw new IllegalArgumentException("Invalid sample id: " + sampleId);
        }
        return parsedSampleId;
    }

    public static File metaFile(String sampleId) {
        return DKUFileUtils.getWithin((File)Sample.sampleDir(sampleId), (String[])new String[]{META_FILE_NAME});
    }

    public static File dataFile(String sampleId) {
        return DKUFileUtils.getWithin((File)Sample.sampleDir(sampleId), (String[])new String[]{DATA_FILE_NAME});
    }

    public static File sampleDir(String sampleId) {
        String[] parsedSampleId = Sample.parseSampleId(sampleId);
        return DKUFileUtils.getWithin((File)Sample.samplesDir(), (String[])new String[]{parsedSampleId[0], parsedSampleId[1], parsedSampleId[2]});
    }

    public static File samplesDir() {
        return ApplicationConfigurator.getFile((String[])new String[]{"caches", "eda", "samples"});
    }
}

