/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class SerializedExportOption {
    public final String id;
    public final String label;
    public final boolean canStream;
    public final JsonObject predefinedConfig;
    public final ExportOptionType optionType;
    public final String ownerPluginId;

    private SerializedExportOption(@Nonnull String id, String label, ExportOptionType optionType, boolean canStream, JsonObject predefinedConfig, @Nullable String ownerPluginId) {
        this.id = id;
        this.optionType = optionType;
        this.label = label;
        this.canStream = canStream;
        this.predefinedConfig = (JsonObject)JSON.deepCopy((Object)predefinedConfig);
        this.ownerPluginId = ownerPluginId;
    }

    public static enum ExportOptionType {
        BUILTIN_FORMAT,
        CUSTOM_FORMAT,
        CUSTOM_TO_FILE,
        CUSTOM_MANAGED;

    }

    public static class FromExporter
    extends SerializedExportOption {
        public final String exporterType;

        public FromExporter(@Nonnull String id, String label, ExportOptionType optionType, String exporterType, boolean canStream, JsonObject predefinedConfig, @Nullable String ownerPluginId) {
            super(id, label, optionType, canStream, predefinedConfig, ownerPluginId);
            this.exporterType = exporterType;
        }
    }

    public static class FromFormat
    extends SerializedExportOption {
        public final String formatType;

        public FromFormat(@Nonnull String id, String label, ExportOptionType optionType, String formatType, boolean canStream, JsonObject predefinedConfig, @Nullable String ownerPluginId) {
            super(id, label, optionType, canStream, predefinedConfig, ownerPluginId);
            this.formatType = formatType;
        }

        public FromFormat(@Nonnull String id, String label, ExportOptionType optionType, String formatType, boolean canStream, FormatParams predefinedConfig) {
            super(id, label, optionType, canStream, (JsonObject)JSON.parse((String)JSON.json((Object)predefinedConfig), JsonObject.class), null);
            this.formatType = formatType;
        }
    }
}

