/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.exposition;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.containers.exec.KubernetesExecUtils;
import com.dataiku.dip.coremodel.DkuComponentMetadata;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.exposition.AbstractKubernetesExpositionHandler;
import com.dataiku.dip.exposition.Exposables;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.exposition.ExpositionDesc;
import com.dataiku.dip.exposition.ExpositionHandler;
import com.dataiku.dip.exposition.ExpositionMeta;
import com.dataiku.dip.exposition.ExpositionParams;
import com.dataiku.dip.futures.IStateLabelAggregator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.webapps.backend.NginxUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ArbitraryYamlExposition {
    public static final ExpositionMeta META = new ExpositionMeta(){

        @Override
        public String getType() {
            return "arbitrary_yaml";
        }

        @Override
        public Class<? extends ExpositionParams> getParamsClass() {
            return ArbitraryYamlExpositionParams.class;
        }

        @Override
        public ExpositionDesc getDesc(ExpositionMeta.ExpositionUsageContext usageContext) {
            ParamDesc yaml = new ParamDesc();
            yaml.type = ParamDesc.Type.TEXTAREA;
            yaml.name = "yaml";
            yaml.label = "Yaml";
            yaml.codeMirrorDialect = "text/x-yaml";
            ExpositionDesc desc = new ExpositionDesc().withType(this.getType()).withMeta(new DkuComponentMetadata("Arbitrary Yaml", "Define your exposition in Yaml", null, null)).withParam(yaml);
            ArrayList lines = Lists.newArrayList();
            lines.add("Replace variables in the Yaml with the ${} syntax.");
            String docRootUrl = DKUApp.getParams().getParam("dip.doc.root.url", "https://doc.dataiku.com");
            lines.add("See [the doc](" + docRootUrl + "/apinode/kubernetes/expositions.html#arbitrary-yaml)");
            desc.longDescription = Joiner.on((String)"\n").join((Iterable)lines);
            return desc;
        }

        @Override
        public long getMaxStartWait(AuthCtx authCtx) {
            return 120000L;
        }

        @Override
        public boolean handles(ContainerExecRuntimeConfig containerConfig) {
            return containerConfig.type == ContainerExecRuntimeConfig.Container.KUBERNETES;
        }

        @Override
        public boolean handles(ContainerExecRuntimeConfig.Container containerType) {
            return containerType == ContainerExecRuntimeConfig.Container.KUBERNETES;
        }

        @Override
        public boolean handles(Exposables.ExposableKind kind) {
            return kind == Exposables.ExposableKind.WEBAPP || kind == Exposables.ExposableKind.API_DEPLOYER;
        }

        @Override
        public ExpositionHandler buildHandler(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, Exposition exposition, ExposedEndpointConsumer endpointConsumer) {
            ArbitraryYamlExpositionParams params = exposition.getParamsAs(ArbitraryYamlExpositionParams.class);
            return new ArbitraryYamlExpositionHandler(authCtx, projectKey, containerConfig, params, endpointConsumer);
        }

        @Override
        public void expandParametersInPlace(VariablesContext vc, Exposition exposition) {
            ArbitraryYamlExpositionParams params = exposition.getParamsAs(ArbitraryYamlExpositionParams.class);
            params.yaml = vc.expandAllowUnresolved(StringUtils.defaultIfEmpty((String)params.yaml, (String)""));
        }
    };
    private static Logger logger = Logger.getLogger((String)"dip.webapp.expose");

    private static class ArbitraryYamlExpositionHandler
    extends AbstractKubernetesExpositionHandler {
        private final ArbitraryYamlExpositionParams params;
        private File serviceFile;
        private String serviceId;
        private String ingressId;
        private String servicePath;
        private String scheme;
        private String forcedUrl;
        private IStateLabelAggregator stateLabelAggregator;
        private ExpositionHandler.ExpositionStatus status = new ExpositionHandler.ExpositionStatus();
        private boolean closed;

        ArbitraryYamlExpositionHandler(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, ArbitraryYamlExpositionParams params, ExposedEndpointConsumer endpointConsumer) {
            super(authCtx, projectKey, containerConfig, endpointConsumer);
            this.params = params;
        }

        @Override
        public void cleanup() {
            this.closed = true;
            if (this.serviceFile != null) {
                logger.info((Object)"Remove arbitraryyaml service");
                try {
                    KubernetesExecUtils.delete(this.authCtx, this.projectKey, this.containerConfig, true, "-f", this.serviceFile.getAbsolutePath());
                }
                catch (IOException e) {
                    logger.error((Object)"Could not stop Kubernetes service", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.error((Object)"Interrupted while stopping Kubernetes service", (Throwable)e);
                }
            }
        }

        private static String mapToIndentedKeyValueString(Map<String, String> map) {
            return map.entrySet().stream().map(entry -> String.format("    %s: %s", entry.getKey(), entry.getValue())).collect(Collectors.joining("\n"));
        }

        private static String removeOuterCurlyBraces(String jsonString) {
            return jsonString.substring(0, jsonString.length() - 1).substring(1);
        }

        @Override
        public void init(Exposables.Exposable exposable, IStateLabelAggregator stateLabelAggregator) throws IOException {
            this.stateLabelAggregator = stateLabelAggregator;
            super.init(exposable, stateLabelAggregator);
            logger.info((Object)"Add arbitraryyaml service");
            String serviceAnnotations = ArbitraryYamlExpositionHandler.mapToIndentedKeyValueString(this.annotations);
            String serviceLabels = ArbitraryYamlExpositionHandler.mapToIndentedKeyValueString(this.labels);
            String serviceSelectors = ArbitraryYamlExpositionHandler.mapToIndentedKeyValueString(this.selectors);
            this.serviceFile = new File(this.tmpDir, "service_" + this.executionId + ".yaml");
            String serviceDesc = this.params.yaml;
            VariablesContext vc = ((VariablesService)SpringUtils.getBean(VariablesService.class)).getForGlobal();
            vc.add("executionId", this.executionId);
            vc.add("apiDeployerDeploymentId", this.executionId);
            vc.add("namePrefix", this.namePrefix);
            vc.add("exposedPort", Integer.toString(this.exposedPort));
            vc.add("labels", serviceLabels);
            vc.add("labelsJsonFields", ArbitraryYamlExpositionHandler.removeOuterCurlyBraces(KubernetesExecUtils.makeLabelsOrAnnotationsMap("labels", this.labels, "", false)));
            vc.add("labelsHeader", serviceLabels.isEmpty() ? "" : "  labels:\n");
            vc.add("labelsHeaderNoNewline", serviceLabels.isEmpty() ? "" : "  labels: ");
            vc.add("annotations", serviceAnnotations);
            vc.add("annotationsJsonFields", ArbitraryYamlExpositionHandler.removeOuterCurlyBraces(KubernetesExecUtils.makeLabelsOrAnnotationsMap("annotations", this.annotations, "", false)));
            vc.add("annotationsHeader", serviceAnnotations.isEmpty() ? "" : "  annotations:\n");
            vc.add("annotationsHeaderNoNewline", serviceAnnotations.isEmpty() ? "" : "  annotations: ");
            vc.add("selector", serviceSelectors);
            vc.add("selectorJsonFields", ArbitraryYamlExpositionHandler.removeOuterCurlyBraces(KubernetesExecUtils.makeLabelsOrAnnotationsMap("selector", this.selectors, "", false)));
            vc.add("selectorHeader", serviceSelectors.isEmpty() ? "" : "  selector:\n");
            vc.add("selectorHeaderNoNewline", serviceSelectors.isEmpty() ? "" : "  selector: ");
            for (SimpleKeyValue kv : this.properties) {
                vc.add((String)(StringUtils.isNotBlank((String)this.propertiesPrefix) ? this.propertiesPrefix + ":" : "") + kv.key, kv.value);
            }
            String expandedServiceDesc = vc.expandAllowUnresolved(serviceDesc);
            logger.info((Object)("service=\n" + expandedServiceDesc));
            DKUFileUtils.writeFileUTF8((File)this.serviceFile, (String)expandedServiceDesc);
            Pattern serviceIdLine = Pattern.compile("^.*name\\s*:\\s*([^\\s]+)\\s*#\\s?__exposed_service_id__.*$");
            Pattern ingressIdLine = Pattern.compile("^.*name\\s*:\\s*([^\\s]+)\\s*#\\s?__exposed_ingress_id__.*$");
            Pattern servicePathLine = Pattern.compile("^.*\\s*:\\s*([^\\s]+)\\s*#\\s?__exposed_service_path__.*$");
            Pattern schemeLine = Pattern.compile("^.*\\s*:\\s*([^\\s]+)\\s*#\\s?__exposed_scheme__.*$");
            Pattern forcedUrlLine = Pattern.compile("^[^:]*\\s*:\\s*([^\\s]+)\\s*#\\s?__exposed_forced_url__.*$");
            for (String line : expandedServiceDesc.split("\n")) {
                Matcher lineForcedUrlMatcher;
                Matcher lineSchemeMatcher;
                Matcher linePathMatcher;
                Matcher lineIngressIdMatcher;
                Matcher lineServiceIdMatcher = serviceIdLine.matcher(line);
                if (lineServiceIdMatcher.matches()) {
                    this.serviceId = lineServiceIdMatcher.group(1);
                }
                if ((lineIngressIdMatcher = ingressIdLine.matcher(line)).matches()) {
                    this.ingressId = lineIngressIdMatcher.group(1);
                }
                if ((linePathMatcher = servicePathLine.matcher(line)).matches()) {
                    this.servicePath = linePathMatcher.group(1);
                }
                if ((lineSchemeMatcher = schemeLine.matcher(line)).matches()) {
                    this.scheme = lineSchemeMatcher.group(1);
                }
                if (!(lineForcedUrlMatcher = forcedUrlLine.matcher(line)).matches()) continue;
                this.forcedUrl = lineForcedUrlMatcher.group(1);
            }
        }

        @Override
        public void start(DKUtils.LineSubscriptionAttacher mainLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
            Object[] cmd = KubernetesExecUtils.getKubeCtlApplyCommand(this.authCtx, this.projectKey, this.containerConfig, "-f", this.serviceFile.getAbsolutePath());
            mainLog.handle("Running arbitrary yaml " + Joiner.on((String)" ").join(cmd), false);
            smartLogTailBuilder.appendLine("Deploying arbitrary YAML exposition with YAML content:\n" + DKUFileUtils.readFileToStringUTF8((File)this.serviceFile));
            new DKUtils.ExecBuilder().withCwd(this.tmpDir).withEnv(KubernetesExecUtils.getKubeCtlEnv(this.containerConfig)).withArgs((String[])cmd).withErrorConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(smartLogTailBuilder)).withOutputConsumer((DKUtils.ExecSubscription)new DKUtils.TailerLineSubscription(smartLogTailBuilder)).withOutputConsumer((DKUtils.ExecSubscription)mainLog.getSubSubscription("[ay] ")).withErrorConsumer((DKUtils.ExecSubscription)mainLog.getSubSubscription("[ay] ")).withCompletionHandler((DKUtils.ExecCompletionHandler)new DKUtils.SimpleExceptionExecCompletionHandler((List)Lists.newArrayList((Object[])cmd)).withLogTailBuilder(smartLogTailBuilder)).exec();
        }

        @Override
        public void waitReady(DKUtils.LineSubscriptionAttacher mainLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
            List<ExposedEndpointConsumer.ExposedEndpoint> endpoints;
            if (StringUtils.isBlank((String)this.serviceId) && StringUtils.isBlank((String)this.ingressId)) {
                logger.info((Object)"The exposition doesn't declare a service or ingress to hook to");
                return;
            }
            long pollInterval = KubernetesExecUtils.getWebappsPollingPeriodInMillis();
            Closeable ipState = this.stateLabelAggregator.startWaitingOn("Waiting on exposed service");
            do {
                JsonObject obj;
                Thread.sleep(pollInterval);
                this.status.raw = obj = this.describeServiceOrIngress(mainLog, smartLogTailBuilder);
                endpoints = AbstractKubernetesExpositionHandler.inferExposedEndpoints(this.authCtx, this.projectKey, META.getType(), obj, mainLog, smartLogTailBuilder, this.containerConfig, this.tmpDir, this.scheme, this.servicePath);
                if (!StringUtils.isNotBlank((String)this.forcedUrl)) continue;
                endpoints.stream().forEach(e -> e.withForcedUrl(this.forcedUrl));
            } while (endpoints.isEmpty());
            ipState.close();
            HashSet hosts = Sets.newHashSet();
            for (ExposedEndpointConsumer.ExposedEndpoint endpoint : endpoints) {
                if (!StringUtils.isNotBlank((String)endpoint.host)) continue;
                hosts.add(endpoint.host);
            }
            for (String host : hosts) {
                NginxUtils.waitForHost(host, this.stateLabelAggregator);
            }
            for (ExposedEndpointConsumer.ExposedEndpoint endpoint : endpoints) {
                this.endpointConsumer.registerPort(endpoint);
            }
            this.status.endpoints.addAll(endpoints);
            this.status.isHealthy = true;
        }

        @Override
        public ExpositionHandler.ExpositionStatus getStatus(DKUtils.LineSubscriptionAttacher mainLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
            ExpositionHandler.ExpositionStatus status = new ExpositionHandler.ExpositionStatus();
            if (StringUtils.isBlank((String)this.serviceId) && StringUtils.isBlank((String)this.ingressId)) {
                logger.info((Object)"The exposition doesn't declare a service or ingress to hook to");
                return status;
            }
            if (!this.closed) {
                JsonObject obj = this.describeServiceOrIngress(mainLog, smartLogTailBuilder);
                List<ExposedEndpointConsumer.ExposedEndpoint> endpoints = AbstractKubernetesExpositionHandler.inferExposedEndpoints(this.authCtx, this.projectKey, META.getType(), obj, mainLog, smartLogTailBuilder, this.containerConfig, this.tmpDir, this.scheme, this.servicePath);
                if (StringUtils.isNotBlank((String)this.forcedUrl)) {
                    endpoints.stream().forEach(e -> e.withForcedUrl(this.forcedUrl));
                }
                if (!endpoints.isEmpty()) {
                    status.endpoints.addAll(endpoints);
                    status.isHealthy = true;
                }
            }
            return status;
        }

        private JsonObject describeServiceOrIngress(DKUtils.LineSubscriptionAttacher mainLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws IOException, InterruptedException, Exception {
            JsonObject obj;
            if (StringUtils.isNotBlank((String)this.serviceId)) {
                obj = AbstractKubernetesExpositionHandler.describeService(this.authCtx, this.projectKey, mainLog, smartLogTailBuilder, this.containerConfig, this.tmpDir, this.serviceId, "[ay] ");
            } else {
                obj = AbstractKubernetesExpositionHandler.describeIngress(this.authCtx, this.projectKey, mainLog, smartLogTailBuilder, this.containerConfig, this.tmpDir, this.ingressId, "[ay] ");
                if (obj.has("spec") && !obj.getAsJsonObject("spec").has("type")) {
                    obj.getAsJsonObject("spec").addProperty("type", "ingress");
                }
            }
            return obj;
        }

        @Override
        public ExposedEndpointConsumer.ExposedEndpoint getExpectedExposedEndpoint() {
            return new ExposedEndpointConsumer.ExposedEndpoint(META.getType(), null, null, null, -1, null, ExposedEndpointConsumer.ExposedEndpointAvailability.PUBLIC);
        }
    }

    public static class ArbitraryYamlExpositionParams
    implements ExpositionParams {
        public String yaml;
    }
}

