/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras.azureml.datamodel;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.externalinfras.azureml.datamodel.AzureMLResourceIdentifier;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.annotations.JsonAdapter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public abstract class AzureMLResource {
    private static final String CONFIG_YAML_NAME_FIELD = "__AZ_RESOURCE_NAME__";
    private static final String CONFIG_YAML_DESCRIPTION_FIELD = "__AZ_RESOURCE_DESCRIPTION__";
    private static final String CONFIG_YAML_TAGS_FIELD = "__AZ_RESOURCE_TAGS__";
    public String name;
    public String id;
    public String type;
    public String description = "";
    public String resourceGroup = "";
    public String workspace = "";
    public String subscription = "";
    public Map<String, String> tags = new HashMap<String, String>();
    public SystemData systemData;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.externalinfras.azureml.datamodel.azureml-resource");

    protected AzureMLResource() {
    }

    protected AzureMLResource(AzureMLResourceIdentifier resourceId) {
        this.resourceGroup = resourceId.resourceGroup;
        this.workspace = resourceId.workspace;
        this.subscription = resourceId.subscription;
        this.name = resourceId.name;
    }

    public abstract String getResourceType();

    public abstract String getResourceTypeLabel();

    public abstract String toYamlConfig() throws IOException;

    public AzureMLResourceIdentifier getResourceIdentifier() {
        return new AzureMLResourceIdentifier(this);
    }

    private String replaceTagsYamlField(String yaml) {
        StringBuilder tagsSection = new StringBuilder();
        if (!this.tags.isEmpty()) {
            tagsSection = new StringBuilder("tags:\n");
            for (Map.Entry<String, String> entry : this.tags.entrySet()) {
                tagsSection.append(String.format("  %s: \"%s\"%n", entry.getKey(), entry.getValue()));
            }
        }
        return yaml.replace(CONFIG_YAML_TAGS_FIELD, tagsSection.toString());
    }

    protected String replaceBaseYamlFields() throws IOException {
        File resourceYamlTemplate = DKUApp.getResourceFile((String[])new String[]{"api-deployer", "azureml", this.getResourceType() + ".yaml.template"});
        String yaml = DKUFileUtils.readFileToStringUTF8((File)resourceYamlTemplate).replace(CONFIG_YAML_NAME_FIELD, this.name).replace(CONFIG_YAML_DESCRIPTION_FIELD, this.description);
        return this.replaceTagsYamlField(yaml);
    }

    @JsonAdapter(value=ResourceProvisioningStateAdapter.class)
    public static enum ResourceProvisioningState {
        CREATING("Creating"),
        DELETING("Deleting"),
        UPDATING("Updating"),
        SUCCEEDED("Succeeded"),
        FAILED("Failed"),
        CANCELED("Canceled");

        private final String name;

        private ResourceProvisioningState(String name) {
            this.name = name;
        }

        static ResourceProvisioningState getProvisioningStateByName(String name) {
            for (ResourceProvisioningState provisioningState : ResourceProvisioningState.values()) {
                if (!provisioningState.name.equals(name)) continue;
                return provisioningState;
            }
            logger.errorV("AzureML Resource Provisioning State '%s' cannot be mapped.", new Object[]{name});
            return null;
        }

        public String getName() {
            return this.name;
        }

        public static void registerAdapter() {
            JSON.registerAdapter(ResourceProvisioningState.class, (Object)new ResourceProvisioningStateAdapter());
        }

        static class ResourceProvisioningStateAdapter
        implements JSON.Adapter<ResourceProvisioningState> {
            ResourceProvisioningStateAdapter() {
            }

            public JsonElement serialize(ResourceProvisioningState src, Type typeOfSrc, JsonSerializationContext context) {
                return context.serialize((Object)src.name);
            }

            public ResourceProvisioningState deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
                return ResourceProvisioningState.getProvisioningStateByName(json.getAsString());
            }
        }
    }

    public static class SystemData {
        public String createdAt;
        public String createdBy;
        public String createdByType;
        public String lastModifiedAt;
        public String lastModifiedBy;
        public String lastModifiedByType;
    }
}

