/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.html;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.datasets.ColoringDefinition;
import com.dataiku.dip.formats.TableColoringHelper;
import com.dataiku.dip.input.TableColoring;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.server.TableColoringService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.com.google.common.html.HtmlEscapers;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class HtmlOutputFormatter
implements OutputFormatter,
AutoCloseable {
    private TableColoring coloring;
    private Schema outputSchema;
    private PrintWriter writer;
    private final int border;
    private final String cssClasses;
    private final boolean header;
    private final String indentString;
    private final String nullString;
    private boolean doNotEscapeHtml;
    private final Map<String, ColoringDefinition.ColoringGroup> columnNameToColoringGroups = new HashMap<String, ColoringDefinition.ColoringGroup>();
    private final transient TableColoringService coloringService;
    private MemTable table;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.output.html");

    public HtmlOutputFormatter(int border, String cssClasses, boolean header, String indentString, String nullString, boolean doNotEscapeHtml) {
        this.doNotEscapeHtml = doNotEscapeHtml;
        this.border = border;
        this.cssClasses = this.escape(cssClasses);
        this.header = header;
        this.indentString = this.escape(indentString);
        this.nullString = this.escape(nullString);
        this.coloringService = (TableColoringService)SpringUtils.getBean(TableColoringService.class);
    }

    public void header(ColumnFactory cf, OutputStream os) throws Exception {
        logger.info((Object)"Starting HTML write");
        this.writer = new PrintWriter(os);
        StringBuilder htmlTable = new StringBuilder("<table");
        if (this.border > 0) {
            htmlTable.append(" border=\"").append(this.border).append("\"");
        }
        if (StringUtils.isNotBlank((CharSequence)this.cssClasses)) {
            htmlTable.append(" class=\"").append(this.cssClasses).append("\"");
        }
        htmlTable.append(">");
        this.println(0, htmlTable.toString());
        if (this.header) {
            this.println(1, "<thead>");
            this.println(2, "<tr>");
            for (SchemaColumn column : this.outputSchema.getColumns()) {
                this.println(3, "<th>" + this.escape(column.getName()) + "</th>");
            }
            this.println(2, "</tr>");
            this.println(1, "</thead>");
        }
        this.println(1, "<tbody>");
        if (this.coloring != null && this.coloring.coloringGroups.size() > 0) {
            for (SchemaColumn column : this.outputSchema.getColumns()) {
                this.columnNameToColoringGroups.put(column.getName(), ColoringDefinition.findAppliedColoringGroup((List)this.coloring.coloringGroups, (String)column.getName()));
            }
        }
    }

    public void format(Row row, ColumnFactory cf, OutputStream os) throws Exception {
        if (this.writer == null) {
            throw new IllegalStateException("HTMLOutputFormatter has been closed");
        }
        ColorFormat colorFormat = null;
        if (this.coloring != null && this.coloring.scheme == ColoringDefinition.TableColoringScheme.SINGLE_COLUMN_RULES) {
            colorFormat = this.computeCellColorFormat(row, this.coloring.singleColumn, null, cf);
        }
        HashMap<ColoringDefinition.ColoringGroup, ColorFormat> cachedBasedOnAnotherColumnColorFormats = new HashMap<ColoringDefinition.ColoringGroup, ColorFormat>();
        this.println(2, "<tr>");
        for (SchemaColumn column : this.outputSchema.getColumns()) {
            String value = row.get(cf.column(column.getName()));
            if (this.coloring != null) {
                if (this.coloring.scheme == ColoringDefinition.TableColoringScheme.INDIVIDUAL_COLUMNS_RULES) {
                    colorFormat = this.computeCellColorFormat(row, column.getName(), value, cf);
                } else if (this.coloring.scheme == ColoringDefinition.TableColoringScheme.COLORING_GROUPS) {
                    ColoringDefinition.ColoringGroup coloringGroup = this.columnNameToColoringGroups.get(column.getName());
                    if (coloringGroup != null && (coloringGroup.scheme == ColoringDefinition.ColoringGroupScheme.RULES || coloringGroup.scheme == ColoringDefinition.ColoringGroupScheme.COLOR_SCALE)) {
                        if (coloringGroup.isBasedOnTargetedColumn(column.getName())) {
                            colorFormat = this.computeCellColorFormat(row, column.getName(), value, cf, coloringGroup);
                        } else if (coloringGroup.isBasedOnAnotherColumn(column.getName()) && (colorFormat = (ColorFormat)cachedBasedOnAnotherColumnColorFormats.get(coloringGroup)) == null) {
                            colorFormat = this.computeCellColorFormat(row, coloringGroup.basedOnColumnName, row.get(cf.getColumn(coloringGroup.basedOnColumnName)), cf, coloringGroup);
                            cachedBasedOnAnotherColumnColorFormats.put(coloringGroup, colorFormat);
                        }
                    } else {
                        colorFormat = null;
                    }
                }
            }
            StringBuilder htmlCell = new StringBuilder("<td");
            if (colorFormat != null) {
                htmlCell.append(" style=\"");
                if (colorFormat.textColor != null && !((String)colorFormat.textColor).isEmpty()) {
                    htmlCell.append("color:").append((String)colorFormat.textColor).append(";");
                }
                if (colorFormat.backgroundColor != null && !((String)colorFormat.backgroundColor).isEmpty()) {
                    htmlCell.append("background-color:").append((String)colorFormat.backgroundColor);
                }
                htmlCell.append("\"");
            }
            htmlCell.append(">").append(value == null ? this.nullString : this.escape(value)).append("</td>");
            this.println(3, htmlCell.toString());
        }
        this.println(2, "</tr>");
    }

    public void footer(ColumnFactory cf, OutputStream os) throws Exception {
        if (this.writer == null) {
            throw new IllegalStateException("HTMLOutputFormatter has been closed");
        }
        this.println(1, "</tbody>");
        this.println(0, "</table>");
        this.writer.flush();
    }

    @Override
    public void close() throws Exception {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    public void cancel(OutputStream os) throws Exception {
        this.close();
    }

    public void setOutputSchema(Schema schema) {
        this.outputSchema = schema;
    }

    public void setColoring(TableColoring coloring) {
        this.coloring = coloring;
    }

    public void setMemTable(Object table) {
        if (table instanceof MemTable) {
            this.table = (MemTable)table;
        }
    }

    public void setWarningsContext(WarningsContext warningsContext) {
    }

    private void print(int indentLevel, String str) {
        if (this.indentString != null && this.indentString.length() > 0) {
            for (int i = 0; i < indentLevel; ++i) {
                this.writer.print(this.indentString);
            }
        }
        this.writer.print(str);
    }

    private void println(int indentLevel, String str) {
        this.print(indentLevel, str);
        if (this.indentString != null && this.indentString.length() > 0) {
            this.writer.println();
        }
    }

    private String escape(String str) {
        if (str == null) {
            return null;
        }
        return this.doNotEscapeHtml ? str : HtmlEscapers.htmlEscaper().escape(str);
    }

    private ColorFormat computeCellColorFormat(Row row, String columnName, String value, ColumnFactory cf) {
        return (ColorFormat)TableColoringHelper.computeCellColorFormat(row, columnName, value, cf, this.coloring, ColorFormat::new, null, null, null);
    }

    private ColorFormat computeCellColorFormat(Row row, String columnName, String value, ColumnFactory cf, ColoringDefinition.ColoringGroup coloringGroup) {
        return (ColorFormat)TableColoringHelper.computeCellColorFormat(row, columnName, value, cf, this.coloring, ColorFormat::new, coloringGroup, this.coloringService, this.table);
    }

    private static class ColorFormat
    extends TableColoringHelper.ColorFormat<String> {
        public ColorFormat(@Nullable String textColor, @Nullable String backgroundColor) {
            super(textColor, backgroundColor);
        }
    }
}

