/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.hproxy.model.hive.ColumnSchema;
import com.dataiku.hproxy.model.hive.TableSchema;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DescribeFormattedParser {
    private static DKULogger logger = DKULogger.getLogger((String)"dku.hive.describeparser");

    private static List<ColumnSchema> listColumnsInSection(List<String[]> rows, boolean isPartition) {
        ArrayList<ColumnSchema> schema = new ArrayList<ColumnSchema>();
        for (String[] row : rows) {
            String comment;
            if (row.length == 0) continue;
            String name = row[0] != null ? row[0].trim() : "";
            String value = row[1] != null ? row[1].trim() : "";
            String string = comment = row.length > 2 && row[2] != null ? row[2].trim() : null;
            if (StringUtils.isBlank((String)value) || StringUtils.isBlank((String)name)) continue;
            ColumnSchema cs2 = new ColumnSchema();
            cs2.name = name;
            cs2.type = value;
            cs2.comment = comment;
            cs2.partition = isPartition;
            schema.add(cs2);
        }
        return schema;
    }

    private static String mergeAfter(String[] row, int from) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int i = from; i < row.length; ++i) {
            if (!first) {
                sb.append("\t");
            }
            sb.append(StringUtils.defaultIfBlank((String)row[i], (String)""));
            first = false;
        }
        return sb.toString().trim();
    }

    private static Map<String, Object> listPropertiesInSection(List<String[]> rows) {
        HashMap contents = Maps.newHashMap();
        String lastHeader = null;
        for (String[] row : rows) {
            String value;
            if (row.length == 0) continue;
            String name = StringUtils.defaultIfBlank((String)row[0], (String)"").trim();
            if (StringUtils.isBlank((String)name)) {
                Map<String, String> subProperties;
                value = row.length > 1 ? StringUtils.defaultIfBlank((String)row[1], (String)"").trim() : "";
                if (!StringUtils.isNotBlank((String)value)) continue;
                if (contents.get(lastHeader) instanceof Map) {
                    subProperties = (Map)contents.get(lastHeader);
                } else {
                    subProperties = Maps.newHashMap();
                    contents.put(lastHeader, subProperties);
                }
                String comment = DescribeFormattedParser.mergeAfter(row, 2);
                subProperties.put(value, comment.replace("\\\\", "\\"));
                continue;
            }
            value = DescribeFormattedParser.mergeAfter(row, 1);
            contents.put(name, value);
            lastHeader = name;
        }
        return contents;
    }

    private static Map<String, List<String[]>> splitSections(List<String[]> rows) {
        HashMap sections = Maps.newHashMap();
        String sectionName = null;
        String lastName = "";
        ArrayList sectionContents = Lists.newArrayList();
        for (String[] row : rows) {
            String name;
            String string = name = row.length > 0 ? StringUtils.defaultIfBlank((String)row[0], (String)"").trim() : "";
            if (name.startsWith("#")) {
                if (!lastName.startsWith("#")) {
                    if (sectionContents.size() > 0) {
                        sections.put(StringUtils.defaultIfBlank((String)sectionName, (String)""), sectionContents);
                    }
                    sectionName = name;
                    sectionContents = Lists.newArrayList();
                }
            } else if (row.length > 0) {
                sectionContents.add(row);
            }
            lastName = name;
        }
        if (sectionContents.size() > 0) {
            sections.put(StringUtils.defaultIfBlank(sectionName, (String)""), sectionContents);
        }
        return sections;
    }

    private static Map<String, String> parseFlattenedMap(String str) {
        HashMap translations = Maps.newHashMap();
        translations.put("\r", "\\r");
        translations.put("\t", "\\t");
        translations.put("\n", "\\n");
        translations.put("\u0000", "\\0");
        translations.put("\u0001", "\\1");
        translations.put("\u0002", "\\2");
        translations.put("\u0003", "\\3");
        translations.put("\u0004", "\\4");
        translations.put("\u0005", "\\5");
        translations.put("\u0006", "\\6");
        translations.put("\u0007", "\\7");
        HashMap ret = Maps.newHashMap();
        str = str.trim();
        if (str.startsWith("[") && str.endsWith("]")) {
            for (String chunk : str.substring(1, str.length() - 1).split(",")) {
                int eqPos = chunk.indexOf(61);
                if (eqPos < 0) continue;
                String v = chunk.substring(eqPos + 1);
                if (translations.containsKey(v)) {
                    v = (String)translations.get(v);
                }
                ret.put(chunk.substring(0, eqPos).trim(), v);
            }
        } else {
            throw new IllegalArgumentException("Unexpected string representation of properties map");
        }
        return ret;
    }

    public static TableSchema parseDescribeFormatted(List<String[]> rows) {
        String provider;
        Map<String, List<String[]>> sections = DescribeFormattedParser.splitSections(rows);
        TableSchema ret = new TableSchema();
        if (sections.containsKey("# col name")) {
            ret.columns.addAll(DescribeFormattedParser.listColumnsInSection(sections.get("# col name"), false));
        } else if (sections.containsKey("# col_name")) {
            ret.columns.addAll(DescribeFormattedParser.listColumnsInSection(sections.get("# col_name"), false));
        } else if (sections.containsKey("")) {
            ret.columns.addAll(DescribeFormattedParser.listColumnsInSection(sections.get(""), false));
        }
        if (sections.containsKey("# Partition Information")) {
            ret.partitionColumns.addAll(DescribeFormattedParser.listColumnsInSection(sections.get("# Partition Information"), true));
        }
        HashMap allProperties = Maps.newHashMap();
        if (sections.containsKey("# Detailed Table Information")) {
            allProperties.putAll(DescribeFormattedParser.listPropertiesInSection(sections.get("# Detailed Table Information")));
        }
        if (sections.containsKey("# Storage Information")) {
            allProperties.putAll(DescribeFormattedParser.listPropertiesInSection(sections.get("# Storage Information")));
        }
        if (sections.containsKey("# Detailed Partition Information")) {
            allProperties.putAll(DescribeFormattedParser.listPropertiesInSection(sections.get("# Detailed Partition Information")));
        }
        HashMap allPropertiesClean = Maps.newHashMap();
        for (Map.Entry e : allProperties.entrySet()) {
            if (((String)e.getKey()).endsWith(":")) {
                allPropertiesClean.put(((String)e.getKey()).substring(0, ((String)e.getKey()).length() - 1), e.getValue());
                continue;
            }
            allPropertiesClean.put((String)e.getKey(), e.getValue());
        }
        if (allPropertiesClean.containsKey("Location")) {
            ret.location = (String)allPropertiesClean.get("Location");
        }
        if (allPropertiesClean.containsKey("Table Type")) {
            ret.tableType = (String)allPropertiesClean.get("Table Type");
        } else if (allPropertiesClean.containsKey("Type")) {
            ret.tableType = (String)allPropertiesClean.get("Type");
        }
        if (allPropertiesClean.containsKey("Table Parameters")) {
            ret.parameters = (Map)allPropertiesClean.get("Table Parameters");
        }
        if (allPropertiesClean.containsKey("Table Properties")) {
            ret.parameters = DescribeFormattedParser.parseFlattenedMap((String)allPropertiesClean.get("Table Properties"));
        }
        if (allPropertiesClean.containsKey("SerDe Library")) {
            ret.serde = (String)allPropertiesClean.get("SerDe Library");
        }
        if (allPropertiesClean.containsKey("Serde Library")) {
            ret.serde = (String)allPropertiesClean.get("Serde Library");
        }
        if (allPropertiesClean.containsKey("InputFormat")) {
            ret.inputFormat = (String)allPropertiesClean.get("InputFormat");
        }
        if (allPropertiesClean.containsKey("OutputFormat")) {
            ret.outputFormat = (String)allPropertiesClean.get("OutputFormat");
        }
        if (allPropertiesClean.containsKey("Storage Desc Params")) {
            ret.serdeProps = (Map)allPropertiesClean.get("Storage Desc Params");
        }
        if (allPropertiesClean.containsKey("Storage Properties")) {
            ret.serdeProps = DescribeFormattedParser.parseFlattenedMap((String)allPropertiesClean.get("Storage Properties"));
        }
        if (ret.serde == null || ret.inputFormat == null || ret.location == null) {
            throw new IllegalArgumentException("Failed to gather required information from Hive data ");
        }
        if (StringUtils.isBlank((String)ret.serde) && StringUtils.isBlank((String)ret.inputFormat) && StringUtils.isBlank((String)ret.outputFormat) && allPropertiesClean.containsKey("Provider") && "delta".equals(provider = (String)allPropertiesClean.get("Provider"))) {
            ret.serde = "delta";
        }
        return ret;
    }

    private DescribeFormattedParser() {
    }
}

