/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.cluster.ClusterSettings;
import com.dataiku.dip.cluster.HiveSettings;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.HiveConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.ClustersDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveCodes;
import com.dataiku.dip.hive.HiveConfigurator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.hproxy.utils.HiveUtils;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HiveServer2ConnectionPoolService {
    @Autowired
    private IImpersonationResolverService impersonationService;
    private static final AtomicInteger nextConnectionId = new AtomicInteger();
    private final KeyedPoolableObjectFactory<HiveServer2ConnectionKey, HiveServer2ConnectionWrapper> connectionFactory = new HiveServer2ConnectionFactory();
    private GenericKeyedObjectPool<HiveServer2ConnectionKey, HiveServer2ConnectionWrapper> connectionsPool;
    private int changeVersion = 0;
    private long generalSettingsLastModified = 0L;
    private Map<String, Integer> clusterChangeVersion = Maps.newHashMap();
    private Map<String, Long> clusterLastModified = Maps.newHashMap();
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private ClustersDAO clustersDAO;
    @Autowired
    private TransactionService transactionService;
    private static final Logger logger = Logger.getLogger((String)"dku.hive.hiveserver2.pool");

    @PostConstruct
    private void startPool() {
        this.connectionsPool = new GenericKeyedObjectPool(this.connectionFactory);
        this.connectionsPool.setLifo(false);
        this.connectionsPool.setTestOnBorrow(false);
        this.connectionsPool.setTestOnReturn(false);
        this.connectionsPool.setTestWhileIdle(true);
        this.connectionsPool.setMinEvictableIdleTimeMillis(600000L);
        this.connectionsPool.setTimeBetweenEvictionRunsMillis(180000L);
        this.connectionsPool.setWhenExhaustedAction((byte)2);
    }

    private int getConfigurationChangeVersion() throws IOException {
        long lastModified;
        if (TransactionContext.hasAttachedTransaction()) {
            lastModified = this.generalSettingsDAO.getLastModified();
        } else {
            try (Transaction t = this.transactionService.beginRead();){
                lastModified = this.generalSettingsDAO.getLastModified();
            }
        }
        if (this.generalSettingsLastModified != 0L && this.generalSettingsLastModified != lastModified) {
            ++this.changeVersion;
            logger.info((Object)"Configuration change, clearing the connections pool");
            this.connectionsPool.clear();
        }
        this.generalSettingsLastModified = lastModified;
        return this.changeVersion;
    }

    private int getClusterConfigurationChangeVersion(String clusterId) throws IOException {
        long lastModified;
        Integer result = this.clusterChangeVersion.get(clusterId);
        if (result == null) {
            result = 0;
        }
        if (TransactionContext.hasAttachedTransaction()) {
            lastModified = this.clustersDAO.getLastModifiedOrZero(clusterId);
        } else {
            try (Transaction t = this.transactionService.beginRead();){
                lastModified = this.clustersDAO.getLastModifiedOrZero(clusterId);
            }
        }
        if (this.clusterLastModified.containsKey(clusterId) && this.clusterLastModified.get(clusterId) != lastModified) {
            result = result + 1;
        }
        this.clusterChangeVersion.put(clusterId, result);
        this.clusterLastModified.put(clusterId, lastModified);
        return result;
    }

    public HiveServer2Connection take(String clusterId, AuthCtx authCtx, String database, List<SimpleKeyValue> hiveconf, String projectKey) throws Exception {
        logger.trace((Object)("Acquire HiveServer2 connection active=" + this.connectionsPool.getNumActive() + " idle=" + this.connectionsPool.getNumIdle() + " changeVersion=" + this.changeVersion));
        try {
            String hadoopUser;
            int currentChangeVersion = this.getConfigurationChangeVersion();
            int currentClusterChangeVersion = this.getClusterConfigurationChangeVersion(clusterId);
            if (this.impersonationService.isEnabled()) {
                try {
                    hadoopUser = this.impersonationService.getTargetUser((String)projectKey, (AuthCtx)authCtx).hadoopUser;
                }
                catch (DKUSecurityException e) {
                    throw new SQLException("Impersonation denied", e);
                }
            } else {
                hadoopUser = UserGroupInformation.getLoginUser().getUserName();
            }
            HiveServer2ConnectionKey key = new HiveServer2ConnectionKey(clusterId, authCtx, hadoopUser, database, hiveconf, currentChangeVersion, currentClusterChangeVersion);
            logger.info((Object)("take key " + String.valueOf(key) + " active=" + this.connectionsPool.getNumActive((Object)key) + " idle=" + this.connectionsPool.getNumIdle((Object)key)));
            HiveServer2ConnectionWrapper wrapper = (HiveServer2ConnectionWrapper)this.connectionsPool.borrowObject((Object)key);
            String debugId = key.toString() + "-" + SecretKeyGenerator.generateSmall();
            return new HiveServer2Connection(wrapper, key, this, debugId, true);
        }
        catch (IllegalStateException e) {
            throw new Exception("Pool should not be closed", e);
        }
        catch (NoSuchElementException e) {
            throw new Exception("Pool should not be empty", e);
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)HiveCodes.ERR_HIVE_HS2_CONNECTION_FAILED, "Could not create HiveServer2 connection", (Throwable)e);
        }
    }

    public void give(HiveServer2ConnectionWrapper connection, HiveServer2ConnectionKey key) {
        logger.trace((Object)("Return HiveServer2 connection id=" + connection.connectionId));
        logger.info((Object)("give key " + String.valueOf(key)));
        try {
            int currentChangeVersion = this.getConfigurationChangeVersion();
            int currentClusterChangeVersion = this.getClusterConfigurationChangeVersion(key.getClusterId());
            if (key.getChangeVersion() != currentChangeVersion) {
                logger.info((Object)"Configuration change happened, invalidating it");
                this.connectionsPool.invalidateObject((Object)key, (Object)connection);
            } else if (key.getClusterChangeVersion() != currentClusterChangeVersion) {
                logger.info((Object)"Cluster configuration change happened, invalidating it");
                this.connectionsPool.invalidateObject((Object)key, (Object)connection);
            } else {
                this.connectionsPool.returnObject((Object)key, (Object)connection);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to return a connection", (Throwable)e);
        }
    }

    private class HiveServer2ConnectionFactory
    extends BaseKeyedPoolableObjectFactory<HiveServer2ConnectionKey, HiveServer2ConnectionWrapper> {
        private HiveServer2ConnectionFactory() {
        }

        public HiveServer2ConnectionWrapper makeObject(HiveServer2ConnectionKey key) throws Exception {
            Connection conn;
            Object displayedJdbcUrl;
            Object jdbcUrl;
            logger.info((Object)("Creating a new HiveServer2 connection (db=" + key.getDatabase() + ")"));
            HiveConnection hiveConnection = HiveConfigurator.configureConnectionForDatabase(key.authCtx, key.getDatabase(), key.getHiveconf(), HiveServer2ConnectionPoolService.this);
            ClusterSelector clusterSelector = new ClusterSelector();
            ClusterSettings clusterSettings = StringUtils.isNotBlank((String)key.getClusterId()) ? clusterSelector.selectForCluster(key.authCtx, key.getClusterId(), "__builtin__") : clusterSelector.selectGlobal();
            HiveSettings hiveSettings = clusterSettings.getHiveSettings();
            if (hiveSettings != null) {
                HiveConfigurator.setupFromSettings(key.getClusterId(), hiveConnection.params, hiveSettings);
            }
            String driverClassName = this.getDriverClassName(hiveConnection.params);
            String hadoopUser = key.getHadoopUser();
            if (hiveConnection.params.useUrl) {
                HashMap substitutions = Maps.newHashMap();
                substitutions.put("hadoopUser", hadoopUser);
                substitutions.put("database", key.getDatabase());
                StrSubstitutor substitutor = new StrSubstitutor((Map)substitutions);
                jdbcUrl = substitutor.replace(hiveConnection.params.customUrl);
                displayedJdbcUrl = substitutor.replace(StringUtils.defaultIfBlank((String)hiveConnection.params.customDisplayedUrl, (String)hiveConnection.params.customUrl));
            } else {
                Object auth = "";
                if (StringUtils.isNotBlank((String)hiveConnection.params.principal)) {
                    auth = ";principal=" + hiveConnection.params.principal;
                }
                jdbcUrl = "jdbc:hive2://" + hiveConnection.params.host + ":" + hiveConnection.params.port + "/" + key.getDatabase() + (String)auth;
                jdbcUrl = HiveServer2ConnectionPoolService.this.impersonationService.isEnabled() ? (String)jdbcUrl + ";hive.server2.proxy.user=" + hadoopUser : (String)jdbcUrl + ";user=" + hadoopUser;
                if (StringUtils.isNotBlank((String)hiveConnection.params.extraUrl)) {
                    jdbcUrl = (String)jdbcUrl + ";" + hiveConnection.params.extraUrl;
                }
                displayedJdbcUrl = jdbcUrl;
            }
            logger.info((Object)("Connecting to HiveServer2: " + (String)displayedJdbcUrl));
            try {
                Class.forName(driverClassName);
            }
            catch (ClassNotFoundException e) {
                throw new SQLException("Unable to load driver", e);
            }
            Driver driver = DriverManager.getDriver((String)jdbcUrl);
            assert (driver != null);
            try {
                logger.info((Object)("Driver version " + driver.getMajorVersion() + "." + driver.getMinorVersion()));
            }
            catch (Exception ex) {
                logger.warn((Object)("Failed to get info from driver : " + ExceptionUtils.getMessageWithCauses((Throwable)ex)), (Throwable)ex);
            }
            Properties props = new Properties();
            if (hiveConnection.params.hiveconf != null) {
                for (SimpleKeyValue simpleKeyValue : hiveConnection.params.hiveconf) {
                    props.put("hiveconf:" + simpleKeyValue.key, simpleKeyValue.value);
                }
            }
            if (hiveConnection.params.properties != null) {
                for (AbstractSQLConnection.CustomDatabaseProperty customDatabaseProperty : hiveConnection.params.properties) {
                    props.put(customDatabaseProperty.name, customDatabaseProperty.value);
                }
            }
            if ((conn = driver.connect((String)jdbcUrl, props)) == null) {
                throw new SQLException("Unable to retrieve connection " + (String)displayedJdbcUrl);
            }
            if (StringUtils.isNotBlank((String)hiveConnection.params.auxJarsAndUdfs)) {
                for (String command : HiveUtils.splitCommandsPreserveEscaping((String)hiveConnection.params.auxJarsAndUdfs)) {
                    try (Statement st2 = conn.createStatement();){
                        st2.execute(command);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Failed to add auxiliary jars and UDFs", (Throwable)e);
                    }
                }
            }
            HiveServer2ConnectionWrapper hiveServer2ConnectionWrapper = new HiveServer2ConnectionWrapper(conn, nextConnectionId.getAndIncrement());
            logger.info((Object)("Created HiveServer2 connection id=" + hiveServer2ConnectionWrapper.connectionId));
            return hiveServer2ConnectionWrapper;
        }

        private String getDriverClassName(HiveConnection.Params params) {
            if (params.useUrl && StringUtils.isNotBlank((String)params.customDriver)) {
                return params.customDriver;
            }
            return "org.apache.hive.jdbc.HiveDriver";
        }

        public void activateObject(HiveServer2ConnectionKey key, HiveServer2ConnectionWrapper connection) throws Exception {
            logger.trace((Object)("Activate HiveServer2 connection id=" + connection.connectionId));
        }

        public void destroyObject(HiveServer2ConnectionKey key, HiveServer2ConnectionWrapper connection) throws Exception {
            logger.debug((Object)("Destroy HiveServer2 connection id=" + connection.connectionId));
            connection.connection.close();
        }

        public void passivateObject(HiveServer2ConnectionKey key, HiveServer2ConnectionWrapper connection) throws Exception {
            logger.trace((Object)("Passivate HiveServer2 connection id=" + connection.connectionId));
        }

        public boolean validateObject(HiveServer2ConnectionKey key, HiveServer2ConnectionWrapper connection) {
            boolean bl;
            block8: {
                logger.trace((Object)("Validate HiveServer2 connection id=" + connection.connectionId));
                Statement statement = connection.connection.createStatement();
                try {
                    statement.execute("show tables");
                    bl = true;
                    if (statement == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        logger.warn((Object)("HiveServer2 connection id=" + connection.connectionId + " is not functional anymore, dropping it"), (Throwable)e);
                        return false;
                    }
                }
                statement.close();
            }
            return bl;
        }
    }

    public static class HiveServer2ConnectionKey {
        private final AuthCtx authCtx;
        private final String database;
        private final String clusterId;
        private final String authCtxStr;
        private final int changeVersion;
        private final int clusterChangeVersion;
        private final List<SimpleKeyValue> hiveconf;
        private final String hadoopUser;

        public HiveServer2ConnectionKey(String clusterId, AuthCtx authCtx, String hadoopUser, String database, List<SimpleKeyValue> hiveconf, int changeVersion, int clusterChangeVersion) {
            this.clusterId = clusterId;
            this.authCtx = authCtx;
            this.hadoopUser = hadoopUser;
            this.clusterChangeVersion = clusterChangeVersion;
            this.hiveconf = hiveconf != null ? hiveconf : new ArrayList();
            this.changeVersion = changeVersion;
            this.authCtxStr = authCtx.toString();
            this.database = database;
        }

        public int getChangeVersion() {
            return this.changeVersion;
        }

        public int getClusterChangeVersion() {
            return this.clusterChangeVersion;
        }

        public AuthCtx getAuthCtx() {
            return this.authCtx;
        }

        public String getDatabase() {
            return this.database;
        }

        public String getHadoopUser() {
            return this.hadoopUser;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public List<SimpleKeyValue> getHiveconf() {
            return this.hiveconf;
        }

        public String toString() {
            return "<Key: authCtx=" + this.authCtxStr + " clusterId=" + StringUtils.defaultIfBlank((String)this.clusterId, (String)"") + " hadoopUser=" + StringUtils.defaultIfBlank((String)this.hadoopUser, (String)"") + " db=" + this.database + " hiveConf=" + JSON.json(this.hiveconf) + "/>";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.authCtxStr.hashCode();
            result = 31 * result + (StringUtils.isBlank((String)this.hadoopUser) ? 0 : this.hadoopUser.hashCode());
            result = 31 * result + (StringUtils.isBlank((String)this.clusterId) ? 0 : this.clusterId.hashCode());
            result = 31 * result + (StringUtils.isBlank((String)this.database) ? 0 : this.database.hashCode());
            result = 31 * result + this.hiveconf.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HiveServer2ConnectionKey other = (HiveServer2ConnectionKey)obj;
            if (!this.authCtxStr.equals(other.authCtxStr)) {
                return false;
            }
            if (!StringUtils.equals((String)this.hadoopUser, (String)other.hadoopUser)) {
                return false;
            }
            if (!StringUtils.equals((String)this.clusterId, (String)other.clusterId)) {
                return false;
            }
            if (!StringUtils.equals((String)this.database, (String)other.database)) {
                return false;
            }
            return this.hiveconf.equals(other.hiveconf);
        }
    }

    static class HiveServer2ConnectionWrapper {
        public final Connection connection;
        public final int connectionId;

        HiveServer2ConnectionWrapper(Connection connection, int connectionId) {
            this.connection = connection;
            this.connectionId = connectionId;
        }
    }

    public static class HiveServer2Connection
    extends SQLConnectionProvider.SQLConnectionWrapper {
        public final HiveServer2ConnectionKey key;
        private final HiveServer2ConnectionPoolService service;
        private final HiveServer2ConnectionWrapper wrapper;
        private boolean isClosed = false;

        private HiveServer2Connection(HiveServer2ConnectionWrapper wrapper, HiveServer2ConnectionKey key, HiveServer2ConnectionPoolService service, String debugId, boolean verboseRollback) {
            super(new HiveConnection.HiveSQLConnectionData(new HiveConnection(service), service), wrapper.connection, debugId, verboseRollback);
            this.wrapper = wrapper;
            this.key = key;
            this.service = service;
        }

        @Override
        public void rollbackAndClose() {
            try {
                logger.info((Object)("Closing " + String.valueOf(this)));
                this.close();
                logger.info((Object)("Conn " + String.valueOf(this) + " is now " + this.isClosed()));
            }
            catch (Exception e) {
                logger.warn((Object)("Could not safely close SQL connection " + String.valueOf(this)), (Throwable)e);
            }
        }

        @Override
        public void close() throws SQLException {
            if (!this.isClosed) {
                this.isClosed = true;
                this.service.give(this.wrapper, this.key);
            }
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.isClosed;
        }
    }
}

