/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.hive;

import com.dataiku.dip.connections.ImpalaConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.sql.ImpalaSQLDialect;
import com.dataiku.dip.utils.DKUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class Hiveserver2LogSniffer {
    private final Method getQueryLogMethod;
    private final Statement statement;
    private Thread sniffer;
    public String hiveQueryId;
    public String applicationId;
    public String jobId;
    private final Pattern queryIdPattern = Pattern.compile("^.*Query ID = (.+)$", 2);
    private final Pattern startingJobPattern = Pattern.compile("^.*Starting Job = (.+), Tracking URL = .*/(.+)/?\\s*$", 2);
    private final Pattern statusPattern = Pattern.compile("^.*Status: .* with App id ([^\\)]+)\\s*\\)?\\s*$", 2);
    private static Logger logger = Logger.getLogger((String)"dip.hiveserver2.log.sniffer");

    public Hiveserver2LogSniffer(Statement statement) {
        this.statement = statement;
        this.getQueryLogMethod = this.getGetQueryLogMethod(statement.getClass());
    }

    private Method getGetQueryLogMethod(Class<?> statementClass) {
        try {
            for (Class<?> c2 = statementClass; c2 != null; c2 = c2.getSuperclass()) {
                try {
                    return c2.getDeclaredMethod("getQueryLog", Boolean.TYPE, Integer.TYPE);
                }
                catch (NoSuchMethodException | SecurityException exception) {
                    continue;
                }
            }
        }
        catch (Throwable e) {
            logger.info((Object)"Cannot get getQueryLog from hive statement, API is probably to old");
        }
        return null;
    }

    private void startGettingQueryLog(final LogLinesHandler logLinesHandler) {
        assert (this.sniffer == null);
        if (this.getQueryLogMethod != null) {
            this.sniffer = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (!Thread.currentThread().isInterrupted()) {
                            List lines = (List)Hiveserver2LogSniffer.this.getQueryLogMethod.invoke((Object)Hiveserver2LogSniffer.this.statement, true, 100);
                            logLinesHandler.handle(lines);
                            Thread.sleep(100L);
                        }
                    }
                    catch (InterruptedException e) {
                        logger.info((Object)"Log sniffing interrupted");
                        Thread.currentThread().interrupt();
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        try {
                            if (Hiveserver2LogSniffer.this.statement.isClosed()) {
                                logger.info((Object)"Log sniffing stopped with statement's closing");
                            } else {
                                logger.error((Object)"Failed to get the log from the statement", (Throwable)e);
                            }
                        }
                        catch (SQLException e1) {
                            logger.error((Object)"Failed to get the log from the statement, and to prod statement for state", (Throwable)e);
                        }
                    }
                }
            });
            this.sniffer.start();
        }
    }

    private void sniffIds(String line) {
        Matcher queryIdMatcher = this.queryIdPattern.matcher(line);
        Matcher startingJobMatcher = this.startingJobPattern.matcher(line);
        Matcher statusMatcher = this.statusPattern.matcher(line);
        if (StringUtils.isBlank((String)this.hiveQueryId) && queryIdMatcher.matches()) {
            this.hiveQueryId = queryIdMatcher.group(1);
            logger.info((Object)("sniffed hiveQueryId => " + this.hiveQueryId));
        }
        if ((StringUtils.isBlank((String)this.applicationId) || StringUtils.isBlank((String)this.jobId)) && startingJobMatcher.matches()) {
            this.jobId = startingJobMatcher.group(1);
            logger.info((Object)("sniffed jobId => " + this.jobId));
            this.applicationId = startingJobMatcher.group(2);
            logger.info((Object)("sniffed applicationId => " + this.applicationId));
        }
        if (StringUtils.isBlank((String)this.applicationId) && statusMatcher.matches()) {
            this.applicationId = statusMatcher.group(1);
            logger.info((Object)("sniffed applicationId => " + this.applicationId));
        }
    }

    public void startTailing(final DKUtils.SmartLogTailBuilder tailBuilder) {
        this.startGettingQueryLog(new LogLinesHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(List<String> lines) {
                DKUtils.SmartLogTailBuilder smartLogTailBuilder = tailBuilder;
                synchronized (smartLogTailBuilder) {
                    for (String line : lines) {
                        tailBuilder.appendLine(line);
                        Hiveserver2LogSniffer.this.sniffIds(line);
                    }
                }
            }
        });
    }

    public void startTailingAndRedirecting(final DKUtils.SmartLogTailBuilder tailBuilder, final DKUtils.LineSubscription lineListener) {
        this.startGettingQueryLog(new LogLinesHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(List<String> lines) {
                DKUtils.SmartLogTailBuilder smartLogTailBuilder = tailBuilder;
                synchronized (smartLogTailBuilder) {
                    try {
                        for (String line : lines) {
                            tailBuilder.appendLine(line);
                            lineListener.handle(line, false);
                            Hiveserver2LogSniffer.this.sniffIds(line);
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)"Error while sniffing logs", (Throwable)e);
                    }
                }
            }
        });
    }

    public void startRedirecting(final DKUtils.LineSubscription lineListener) {
        this.startGettingQueryLog(new LogLinesHandler(){

            @Override
            public void handle(List<String> lines) {
                try {
                    for (String line : lines) {
                        lineListener.handle(line, false);
                        Hiveserver2LogSniffer.this.sniffIds(line);
                    }
                }
                catch (IOException e) {
                    logger.error((Object)"Error while sniffing logs", (Throwable)e);
                }
            }
        });
    }

    public void stop() throws InterruptedException {
        if (this.sniffer != null) {
            this.sniffer.interrupt();
            this.sniffer.join(0L);
            this.sniffer = null;
        }
    }

    public static boolean canSniff(Statement s, SQLConnectionProvider.SQLConnectionData connData) {
        if (connData.getConnection() instanceof ImpalaConnection || connData.getDialect() instanceof ImpalaSQLDialect) {
            return false;
        }
        for (Class<?> clazz = s.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (!"org.apache.hive.jdbc.HiveStatement".equals(clazz.getCanonicalName())) continue;
            return true;
        }
        return false;
    }

    private static interface LogLinesHandler {
        public void handle(List<String> var1);
    }
}

