/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.parquet;

import com.dataiku.dip.input.formats.parquet.NanoTime;
import com.dataiku.dip.input.formats.parquet.NanoTimeUtils;
import com.dataiku.dip.input.formats.parquet.ParentValueContainer;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.format.DateTimeFormatter;
import com.dataiku.dss.shadelib.org.joda.time.format.ISODateTimeFormat;
import java.sql.Timestamp;
import java.time.LocalDate;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;

public class HiveDateConverter
extends PrimitiveConverter {
    private final ParentValueContainer parent;
    private final boolean toDSSDate;
    private final boolean micros;
    private static final DateTimeFormatter isoFormatter = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);

    public HiveDateConverter(ParentValueContainer parent, boolean toDSSDate, boolean micros) {
        this.parent = parent;
        this.toDSSDate = toDSSDate;
        this.micros = micros;
    }

    public void addBinary(Binary value) {
        Timestamp sqlTimestamp = NanoTimeUtils.getTimestamp(NanoTime.fromBinary(value));
        this.parent.addString(isoFormatter.print((ReadableInstant)new DateTime((Object)sqlTimestamp)));
    }

    public void addInt(int value) {
        LocalDate date = LocalDate.ofEpochDay(value);
        this.parent.addString(isoFormatter.print((ReadableInstant)new DateTime(date.getYear(), date.getMonthValue(), date.getDayOfMonth(), 0, 0, 0, DateTimeZone.UTC)));
    }

    public void addLong(long value) {
        if (this.micros) {
            value /= 1000L;
        }
        String s = isoFormatter.print((ReadableInstant)new DateTime(value, DateTimeZone.UTC));
        if (this.toDSSDate) {
            this.parent.addString(s);
        } else {
            this.parent.addString(s.substring(0, 23).replace('T', ' '));
        }
    }
}

