/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.analysis.ml.distributed.workers.WorkerPool;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.io.PythonSecretProtectedKernel;
import com.dataiku.dip.io.SecretProtectedKernelLink;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.InsecureProcessesLaunchService;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.utils.Pair;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractImpersonatedSecretProtectedPythonKernel<L extends SecretProtectedKernelLink>
extends PythonSecretProtectedKernel<L> {
    @Autowired
    private InsecureProcessesLaunchService insecureProcessesLaunchService;
    protected boolean createTempDirForImpersonation = false;

    protected AbstractImpersonatedSecretProtectedPythonKernel(L link, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType, AuthCtx authCtx, File workDir, String resourceFolderPath, boolean useProjectLibs, Map<String, String> pythonLibs, String projectKey, String envName) {
        super(authCtx, link, resourceFolderPath, useProjectLibs, pythonLibs, projectKey, envName, true, workDir, cgrouppableProcessType);
    }

    protected AbstractImpersonatedSecretProtectedPythonKernel(L link, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType, AuthCtx authCtx, File workDir, String resourceFolderPath, boolean useProjectLibs, Map<String, String> pythonLibs, String projectKey, String envName, WorkerPool workerPool) {
        super(authCtx, link, resourceFolderPath, useProjectLibs, pythonLibs, projectKey, envName, true, workDir, cgrouppableProcessType, workerPool);
    }

    @Override
    protected IsolableProcess createAndStartProcess(ProcessBuilder pb, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType) throws DKUSecurityException, IOException, InterruptedException {
        if (this.createTempDirForImpersonation) {
            Pair<IsolableProcess, Runnable> isolableProcessWithCleanup = this.insecureProcessesLaunchService.launchWithIntercomDir(this.authCtx, this.projectKey, cgrouppableProcessType, this.workDir, pb, null);
            this.addOnShutdown((Runnable)isolableProcessWithCleanup.second);
            return (IsolableProcess)isolableProcessWithCleanup.first;
        }
        return this.insecureProcessesLaunchService.launch(this.authCtx, this.projectKey, cgrouppableProcessType, this.workDir, pb);
    }
}

