/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LabelingPermissionsService {
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private LabelingTasksDAO labelingTasksDAO;

    public void checkPerm(HttpServletRequest req, String projectKey, String labelingTaskId, Privileges.LabelingLevelPrivilegeType privilege) throws IOException, DKUSecurityException {
        LabelingTask labelingTask = (LabelingTask)this.labelingTasksDAO.getMandatory(projectKey, labelingTaskId);
        this.checkPerm(req, labelingTask, privilege);
    }

    public void checkPerm(HttpServletRequest req, LabelingTask task, Privileges.LabelingLevelPrivilegeType privilege) throws DKUSecurityException, IOException {
        AuthCtx u = this.authService.getMandatoryUser(req);
        this.checkPerm(u, task, privilege);
    }

    public void checkPerm(AuthCtx u, LabelingTask task, Privileges.LabelingLevelPrivilegeType privilege) throws DKUSecurityException {
        if (!this.permissionsService.hasLabelingTaskPrivilege(u, task, privilege)) {
            throw new UnauthorizedException("Action forbidden", "labeling-task-authorization-failure");
        }
    }

    public List<String> getPrivileges(AuthCtx u, LabelingTask labelingTask) throws IOException, DKUSecurityException {
        ArrayList<String> privileges = new ArrayList<String>();
        for (Privileges.LabelingLevelPrivilegeType privilege : Privileges.LabelingLevelPrivilegeType.values()) {
            if (!this.permissionsService.hasLabelingTaskPrivilege(u, labelingTask, privilege)) continue;
            privileges.add(privilege.toString());
        }
        return privileges;
    }

    public boolean canReview(AuthCtx authCtx, LabelingTask labelingTask) throws DKUSecurityException {
        return this.permissionsService.hasLabelingTaskPrivilege(authCtx, labelingTask, Privileges.LabelingLevelPrivilegeType.REVIEW);
    }
}

