/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.labeling.consensus;

import com.dataiku.dip.labeling.Annotation;
import com.dataiku.dip.labeling.Label;
import com.dataiku.dip.labeling.LabelingAnswer;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.VerifiedLabelingAnswer;
import com.dataiku.dip.labeling.consensus.ConsensualCommentComputer;
import com.dataiku.dip.labeling.consensus.ConsensusLabelComputer;
import com.dataiku.dip.labeling.consensus.ConsensusLabelComputerFactory;
import com.dataiku.dip.labeling.consensus.ConsensusLabelingAnswerComputer;
import com.dataiku.dip.labeling.region.LabelingRegionDispatcher;
import com.dataiku.dip.labeling.region.LabelingRegionDispatcherFactory;
import java.util.List;

public class ConsensusLabelingAnswerComputerImpl
implements ConsensusLabelingAnswerComputer {
    private final ConsensusLabelComputer consensusLabelComputer;
    private final ConsensualCommentComputer consensualCommentComputer;
    private final LabelingTask labelingTask;
    private final LabelingRegionDispatcher<? extends Annotation> dispatcher;

    public ConsensusLabelingAnswerComputerImpl(LabelingTask labelingTask) {
        this.consensusLabelComputer = ConsensusLabelComputerFactory.getConsensusComputer(labelingTask.type, labelingTask.getConsensusStrategy());
        this.dispatcher = LabelingRegionDispatcherFactory.getDispatcher(labelingTask);
        this.labelingTask = labelingTask;
        this.consensualCommentComputer = this.labelingTask.hasCommentsEnabled() ? new ConsensualCommentComputer(labelingTask.commentSettings.autoValidateStrategy) : null;
    }

    @Override
    public VerifiedLabelingAnswer compute(String recordId, List<LabelingAnswer> answers) {
        VerifiedLabelingAnswer consensusAnswer = null;
        List regions = this.dispatcher.dispatch(answers);
        if (regions.stream().noneMatch(r -> r.conflicting) && (regions.size() >= 1 || this.labelingTask.type.emptyAnnotationsAllowed)) {
            Label consensusLabel = this.consensusLabelComputer.compute(regions);
            consensusAnswer = new VerifiedLabelingAnswer(this.labelingTask.projectKey, this.labelingTask.id, recordId, consensusLabel);
        }
        if (consensusAnswer != null && this.consensualCommentComputer != null) {
            ConsensualCommentComputer.Result commentConsensus = this.consensualCommentComputer.compute(LabelingAnswer.extractComments(answers));
            if (commentConsensus.conflict) {
                return null;
            }
            consensusAnswer.label.comment = commentConsensus.comment;
        }
        return consensusAnswer;
    }
}

