/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.anthropic;

import com.dataiku.dip.connections.AnthropicConnection;
import com.dataiku.dip.utils.DKULogger;
import org.apache.commons.lang3.StringUtils;

public class AnthropicPricing {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.anthropic.pricing");

    public static double getAnthropicPromptCostPer1KTokens(String model) {
        if (StringUtils.isBlank((CharSequence)model)) {
            return 0.0;
        }
        if (model.equals(AnthropicConnection.HardcodedAnthropicModel.CLAUDE_V3_OPUS.id)) {
            return 0.015;
        }
        if (model.equals(AnthropicConnection.HardcodedAnthropicModel.CLAUDE_V4_OPUS.id)) {
            return 0.015;
        }
        if (model.equals(AnthropicConnection.HardcodedAnthropicModel.CLAUDE_V41_OPUS.id)) {
            return 0.015;
        }
        if (model.equals(AnthropicConnection.HardcodedAnthropicModel.CLAUDE_V35_SONNET.id)) {
            return 0.003;
        }
        if (model.equals(AnthropicConnection.HardcodedAnthropicModel.CLAUDE_V35_SONNET_V2.id)) {
            return 0.003;
        }
        if (model.equals(AnthropicConnection.HardcodedAnthropicModel.CLAUDE_V37_SONNET.id)) {
            return 0.003;
        }
        if (model.equals(AnthropicConnection.HardcodedAnthropicModel.CLAUDE_V4_SONNET.id)) {
            return 0.003;
        }
        if (model.equals(AnthropicConnection.HardcodedAnthropicModel.CLAUDE_V45_SONNET.id)) {
            return 0.003;
        }
        if (model.equals(AnthropicConnection.HardcodedAnthropicModel.CLAUDE_V3_HAIKU.id)) {
            return 2.5E-4;
        }
        if (model.equals(AnthropicConnection.HardcodedAnthropicModel.CLAUDE_V35_HAIKU.id)) {
            return 8.0E-4;
        }
        if (model.equals(AnthropicConnection.HardcodedAnthropicModel.CLAUDE_V45_HAIKU.id)) {
            return 0.001;
        }
        logger.warn((Object)("Anthropic model: " + model + " is unknown to AnthropicPricing"));
        return 0.0;
    }

    public static double getAnthropicCompletionCostPer1KTokens(String model) {
        if (StringUtils.isBlank((CharSequence)model)) {
            return 0.0;
        }
        if (model.equals(AnthropicConnection.HardcodedAnthropicModel.CLAUDE_V3_OPUS.id)) {
            return 0.075;
        }
        if (model.equals(AnthropicConnection.HardcodedAnthropicModel.CLAUDE_V4_OPUS.id)) {
            return 0.075;
        }
        if (model.equals(AnthropicConnection.HardcodedAnthropicModel.CLAUDE_V41_OPUS.id)) {
            return 0.075;
        }
        if (model.equals(AnthropicConnection.HardcodedAnthropicModel.CLAUDE_V35_SONNET.id)) {
            return 0.015;
        }
        if (model.equals(AnthropicConnection.HardcodedAnthropicModel.CLAUDE_V35_SONNET_V2.id)) {
            return 0.015;
        }
        if (model.equals(AnthropicConnection.HardcodedAnthropicModel.CLAUDE_V37_SONNET.id)) {
            return 0.015;
        }
        if (model.equals(AnthropicConnection.HardcodedAnthropicModel.CLAUDE_V4_SONNET.id)) {
            return 0.015;
        }
        if (model.equals(AnthropicConnection.HardcodedAnthropicModel.CLAUDE_V45_SONNET.id)) {
            return 0.015;
        }
        if (model.equals(AnthropicConnection.HardcodedAnthropicModel.CLAUDE_V3_HAIKU.id)) {
            return 0.00125;
        }
        if (model.equals(AnthropicConnection.HardcodedAnthropicModel.CLAUDE_V35_HAIKU.id)) {
            return 0.004;
        }
        if (model.equals(AnthropicConnection.HardcodedAnthropicModel.CLAUDE_V45_HAIKU.id)) {
            return 0.005;
        }
        logger.warn((Object)("Anthropic model: " + model + " is unknown to AnthropicPricing"));
        return 0.0;
    }
}

