/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.anthropic.api;

import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import javax.annotation.Nullable;

public class AnthropicChatQuery {
    public String model;
    public String system;
    public List<Message> messages;
    @Nullable
    public Boolean stream;
    @Nullable
    @SerializedName(value="max_tokens")
    public Integer maxTokens;
    @Nullable
    public Double temperature;
    @Nullable
    @SerializedName(value="top_k")
    public Integer topK;
    @Nullable
    @SerializedName(value="top_p")
    public Double topP;
    @Nullable
    @SerializedName(value="stop_sequences")
    public List<String> stopSequences;
    @Nullable
    @SerializedName(value="tool_choice")
    public ToolChoice toolChoice;
    @Nullable
    public List<Tool> tools;

    public static class Tool {
        public String name;
        @Nullable
        public String description;
        @SerializedName(value="input_schema")
        public JsonObject inputSchema;
    }

    public static class ToolChoice {
        public ToolChoiceType type;
        @Nullable
        public String name;
    }

    public static enum ToolChoiceType {
        auto,
        any,
        tool;

    }

    public static class ToolResultMessagePart
    implements MessagePart {
        public final String type = "tool_result";
        @SerializedName(value="tool_use_id")
        public String toolUseId;
        public String content;
    }

    public static class ToolUseMessagePart
    implements MessagePart {
        public final String type = "tool_use";
        public String id;
        public String name;
        public JsonObject input;
    }

    public static class ImageSource {
        public final String type = "base64";
        @SerializedName(value="media_type")
        public String mediaType;
        public String data;
    }

    public static class ImageMessagePart
    implements MessagePart {
        public final String type = "image";
        public ImageSource source;
    }

    public static class TextMessagePart
    implements MessagePart {
        public final String type = "text";
        public String text;
    }

    public static interface MessagePart {
    }

    public static class Message {
        public MessageRole role;
        public List<MessagePart> content;
    }

    public static enum MessageRole {
        user,
        assistant;

    }
}

