/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.promptstudio;

import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.promptstudio.PromptStudio;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class PromptResponse {
    public String promptId;
    public long runOn;
    public String runBy;
    public String runId;
    public long executionTime;
    public PromptStudio.PromptTemplateQueriesSource querySource;
    public List<PromptStudio.PromptTemplateInput> mainPromptTemplateInputs = new ArrayList<PromptStudio.PromptTemplateInput>();
    public PromptResponseStats stats = new PromptResponseStats();
    public List<SingleInputPromptResponse> responses = new ArrayList<SingleInputPromptResponse>();

    public static class PromptResponseStats {
        public boolean hasNoValidation;
        public double estimatedCostPer1KRecords;
        public long testedRecords;
        public long validRecords;
        public long invalidRecords;
        public long failedRecords;
    }

    public static class SingleInputPromptResponse {
        public List<String> mainInputs;
        public String lastMessageId;
        public Map<String, PromptStudio.ConversationMessage> chatMessages = new HashMap<String, PromptStudio.ConversationMessage>();
        public boolean error;
        public String rawLLMOutput;
        public String llmError;
        public String formattedOutput;
        public ResponseValidationStatus validationStatus = ResponseValidationStatus.NOT_PERFORMED;
        public String validationMessage;
        public ResponseEvaluationStatus evaluationStatus = ResponseEvaluationStatus.UNDECIDED;
        public String evaluationMessage;
        public LLMClient.LLMMeshTraceSpan fullTrace;
        public SmartLogTail log;
        public Integer promptTokens;
        public Integer completionTokens;
        public Integer totalTokens;
        public Boolean tokenCountsAreEstimated;
        @Nullable
        @Deprecated
        public List<LLMClient.Source> sources;
        @Nullable
        public List<LLMClient.Artifact> artifacts;
        public Double estimatedCost;
        public JsonObject additionalInformation;

        public void validate(PromptStudio.ResultValidation resultValidation) {
            this.validateWithoutContentModeration(resultValidation);
        }

        public void validateWithoutContentModeration(PromptStudio.ResultValidation resultValidation) {
            switch (resultValidation.expectedFormat) {
                case JSON_ARRAY: {
                    try {
                        JsonArray arr = (JsonArray)JSON.parse((String)this.rawLLMOutput, JsonArray.class);
                        if (arr == null) {
                            throw new IllegalArgumentException("Cannot parse to JSON array");
                        }
                        this.validationStatus = ResponseValidationStatus.VALID;
                        this.formattedOutput = this.rawLLMOutput;
                        break;
                    }
                    catch (Exception e) {
                        this.validationStatus = ResponseValidationStatus.INVALID;
                        this.validationMessage = "Not valid JSON array";
                        return;
                    }
                }
                case JSON_OBJECT: {
                    try {
                        JsonObject obj = (JsonObject)JSON.parse((String)this.rawLLMOutput, JsonObject.class);
                        if (obj == null) {
                            throw new IllegalArgumentException("Cannot parse to JSON object");
                        }
                        for (String requiredKey : resultValidation.requiredJSONObjectKeys) {
                            if (obj.has(requiredKey)) continue;
                            this.validationStatus = ResponseValidationStatus.INVALID;
                            this.validationMessage = "Required JSON key '" + requiredKey + "' not present";
                            return;
                        }
                        this.validationStatus = ResponseValidationStatus.VALID;
                        this.formattedOutput = this.rawLLMOutput;
                        break;
                    }
                    catch (Exception e) {
                        this.validationStatus = ResponseValidationStatus.INVALID;
                        this.validationMessage = "Not valid JSON object";
                        return;
                    }
                }
                case NONE: {
                    this.formattedOutput = this.rawLLMOutput;
                    break;
                }
                case CSV: 
                case ONE_ITEM_PER_LINE: {
                    throw new IllegalArgumentException("Validation not implemented for this format");
                }
            }
            for (PromptStudio.ResultForbiddenTerm forbiddenTerm : resultValidation.forbiddenTerms) {
                if (forbiddenTerm.regexp) {
                    Pattern p = Pattern.compile(forbiddenTerm.value);
                    if (p.matcher(this.formattedOutput).find()) {
                        this.validationStatus = ResponseValidationStatus.INVALID;
                        this.validationMessage = "Forbidden pattern found: " + forbiddenTerm.value;
                        return;
                    }
                } else if (this.formattedOutput.toLowerCase(Locale.ENGLISH).contains(forbiddenTerm.value.toLowerCase(Locale.ENGLISH))) {
                    this.validationStatus = ResponseValidationStatus.INVALID;
                    this.validationMessage = "Forbidden term found: " + forbiddenTerm.value;
                    return;
                }
                this.validationStatus = ResponseValidationStatus.VALID;
            }
        }
    }

    public static enum ResponseEvaluationStatus {
        CORRECT,
        INCORRECT,
        UNDECIDED;

    }

    public static enum ResponseValidationStatus {
        NOT_PERFORMED,
        VALID,
        INVALID;

    }
}

