/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.mec;

import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.ml.prediction.PredictionResultsReader;
import com.dataiku.dip.analysis.ml.prediction.flow.EvaluationDatasetHelper;
import com.dataiku.dip.analysis.ml.prediction.split.SplitDesc;
import com.dataiku.dip.analysis.ml.shared.EvaluationLabelsHelper;
import com.dataiku.dip.analysis.model.ModelTrainInfo;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.analysis.model.core.BaseCustomEvaluationMetric;
import com.dataiku.dip.analysis.model.core.CustomMetricResult;
import com.dataiku.dip.analysis.model.core.CustomMetricSuccess;
import com.dataiku.dip.analysis.model.core.LLMCustomEvaluationMetric;
import com.dataiku.dip.analysis.model.core.ModelCustomEvaluationMetric;
import com.dataiku.dip.analysis.model.core.ModelUserMeta;
import com.dataiku.dip.analysis.model.prediction.ClassicalPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.MetricParams;
import com.dataiku.dip.analysis.model.prediction.OtherClassificationModelPerf;
import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.analysis.model.prediction.TabularPredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.TimeseriesForecastingModelDetails;
import com.dataiku.dip.analysis.model.preprocessing.FeaturePreprocessingParams;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.AnalysisCoreDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.mec.AbstractModelEvaluation;
import com.dataiku.dip.mec.FullModelEvaluationId;
import com.dataiku.dip.mec.LLMModelEvaluation;
import com.dataiku.dip.mec.MECPaths;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.TabularModelEvaluation;
import com.dataiku.dip.mec.drift.TextDriftParams;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.nlp.common.LLMCompletionSettings;
import com.dataiku.dip.recipes.nlp.common.LLMEmbeddingSettings;
import com.dataiku.dip.recipes.nlp.llm_evaluation.LLMEvaluationRecipePayloadParams;
import com.dataiku.dip.recipes.nlp.llm_evaluation.LLMTaskType;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KernelsModelEvaluationStoresService {
    public static final String ME_DEFAULT_NAME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private AnalysisCoreDAO analysisCoreDAO;
    @Autowired
    private TransactionService transactionService;
    private DKULogger logger = DKULogger.getLogger((String)"dku.services.modelEvaluationStoresKernel");

    public ModelEvaluationStore getOrNull(String projectKey, String id) throws IOException {
        return (ModelEvaluationStore)this.modelEvaluationStoresDAO.getOrNull(projectKey, id);
    }

    public ModelEvaluationStore getOrNullUnsafe(String projectKey, String id) throws IOException {
        return (ModelEvaluationStore)this.modelEvaluationStoresDAO.getOrNullUnsafe(projectKey, id);
    }

    public ModelEvaluationStore getMandatory(String projectKey, String id) throws IOException {
        return (ModelEvaluationStore)this.modelEvaluationStoresDAO.getMandatory(projectKey, id);
    }

    public ModelEvaluationStore getMandatoryUnsafe(String projectKey, String id) throws IOException {
        return (ModelEvaluationStore)this.modelEvaluationStoresDAO.getMandatoryUnsafe(projectKey, id);
    }

    public List<ModelEvaluationStore> list(String projectKey) throws IOException {
        return this.modelEvaluationStoresDAO.list(projectKey);
    }

    public List<ModelEvaluationStore> listUnsafe(String projectKey) throws IOException {
        return this.modelEvaluationStoresDAO.listUnsafe(projectKey);
    }

    public ModelEvaluationStore lookupMandatoryUnsafe(String projectKey, String lookup) throws IOException {
        ModelEvaluationStore ret = (ModelEvaluationStore)this.modelEvaluationStoresDAO.getOrNullUnsafe(projectKey, lookup);
        if (ret != null) {
            return ret;
        }
        for (ModelEvaluationStore mes : this.modelEvaluationStoresDAO.listUnsafe(projectKey)) {
            if (!mes.name.equals(lookup)) continue;
            return mes;
        }
        throw new NotFoundException("Model evaluation store with id/name '" + lookup + "' does not exist in project " + projectKey);
    }

    public AbstractModelEvaluation getEvaluation(ModelEvaluationStore mes, String evaluationId) throws IOException {
        File runFolder = MECPaths.modelEvaluationBaseFolder(mes, evaluationId);
        AbstractModelEvaluation me = (AbstractModelEvaluation)JSON.parseFile((File)new File(runFolder, "evaluation.json"), AbstractModelEvaluation.class);
        me.setTransientReference(new FullModelEvaluationId(mes.projectKey, mes.id, evaluationId));
        return me;
    }

    public ModelTypeAndParams makeModelTypeAndParams(String projectKey, SavedModel sm, FullModelId fmi, @Nullable ModelTrainInfo trainInfo) throws Exception {
        TabularModelEvaluation.EvaluatedDSSModel savedModelParams = new TabularModelEvaluation.EvaluatedDSSModel();
        savedModelParams.ref = sm.getRef().getLoc().getSmartName(projectKey);
        savedModelParams.versionId = fmi.getSavedModelVersionID();
        switch (sm.savedModelType.savedModelHandlingType) {
            case INTERNAL: {
                ModelUserMeta meta = fmi.parseModelFile("user_meta.json", ModelUserMeta.class);
                savedModelParams.name = meta.name;
                savedModelParams.description = meta.description;
                savedModelParams.versionName = meta.name;
                savedModelParams.partitionName = fmi.getPartitionName();
                if (null != trainInfo) {
                    savedModelParams.trainEndTime = trainInfo.endTime;
                }
                TabularPredictionModelDetails modelDetails = (TabularPredictionModelDetails)PredictionResultsReader.makeModelDetails(fmi);
                savedModelParams.isPartitioned = modelDetails.getCoreParams().isPartitioned();
                savedModelParams.isEnsembled = null != modelDetails.modeling.ensemble_params;
                break;
            }
            case EXTERNAL_MLFLOW: {
                savedModelParams.name = sm.name;
                savedModelParams.versionName = fmi.getSavedModelVersionID();
                break;
            }
            case PYTHON_AGENT: 
            case PLUGIN_AGENT: 
            case TOOLS_USING_AGENT: {
                throw new IllegalArgumentException("Agents are not supported in evaluation store");
            }
            case LLM_GENERIC: {
                throw new IllegalArgumentException("Fine-tuned LLMs are not supported in evaluation store");
            }
            case RETRIEVAL_AUGMENTED_LLM: {
                throw new IllegalArgumentException("Retrieval Augmented LLMs are not supported in evaluation store");
            }
        }
        ModelTypeAndParams ret = new ModelTypeAndParams();
        ret.type = TabularModelEvaluation.ModelType.SAVED_MODEL;
        ret.params = JSON.toJsonObject((Object)savedModelParams);
        return ret;
    }

    public static ModelTypeAndParams makeModelTypeAndParams(String projectKey, FullModelId fmi, ModelTrainInfo trainInfo) throws Exception {
        assert (FullModelId.Type.ANALYSIS == fmi.type);
        TabularModelEvaluation.EvaluatedDSSModel modelParams = new TabularModelEvaluation.EvaluatedDSSModel();
        modelParams.ref = fmi.getAnalysisModelLoc().getSmartName(projectKey);
        modelParams.versionId = fmi.getAnalysisModelId();
        ModelUserMeta meta = fmi.parseModelFile("user_meta.json", ModelUserMeta.class);
        modelParams.name = meta.name;
        modelParams.description = meta.description;
        modelParams.versionName = meta.name;
        modelParams.partitionName = fmi.getPartitionName();
        modelParams.trainEndTime = trainInfo.endTime;
        ModelTypeAndParams ret = new ModelTypeAndParams();
        ret.type = TabularModelEvaluation.ModelType.ANALYSIS_MODEL;
        ret.params = JSON.toJsonObject((Object)modelParams);
        return ret;
    }

    public DataTypeAndParams makeDataTypeAndParams(String projectKey, Dataset inputDataset, List<Partition> partitions) throws Exception {
        AbstractModelEvaluation.EvaluatedDataset datasetParams = new AbstractModelEvaluation.EvaluatedDataset();
        datasetParams.ref = inputDataset.getSmartName(projectKey);
        for (Partition p : partitions) {
            datasetParams.partitions.add(p.id());
        }
        DataTypeAndParams ret = new DataTypeAndParams();
        ret.type = AbstractModelEvaluation.DataType.DATASET;
        ret.params = JSON.toJsonObject((Object)datasetParams);
        return ret;
    }

    public DataTypeAndParams makeTrainDataTypeAndParams(SplitDesc splitDesc, String originFmiStr) throws Exception {
        Pattern datasetNamePattern;
        Matcher datasetNameMatcher;
        AbstractModelEvaluation.EvaluatedSplit params = new AbstractModelEvaluation.EvaluatedSplit();
        StreamableDatasetSelection selection = null;
        if (splitDesc != null) {
            params.generationDate = splitDesc.generationDate;
            switch (splitDesc.params.ttPolicy) {
                case EXPLICIT_FILTERING_SINGLE_DATASET: {
                    params.datasetName = splitDesc.params.efsdDatasetSmartName;
                    selection = splitDesc.params.efsdTrain.selection;
                    break;
                }
                case EXPLICIT_FILTERING_TWO_DATASETS: {
                    params.datasetName = splitDesc.params.eftdTest.datasetSmartName;
                    selection = splitDesc.params.eftdTest.selection;
                    break;
                }
                case SPLIT_SINGLE_DATASET: {
                    params.datasetName = splitDesc.params.ssdDatasetSmartName;
                    selection = splitDesc.params.ssdSelection;
                }
            }
        }
        if (StringUtils.isBlank((String)params.datasetName) && StringUtils.isNotBlank((String)originFmiStr)) {
            FullModelId originFmi = FullModelId.parse(originFmiStr);
            MLTaskLoc taskLoc = originFmi.getTaskLoc();
            String analysisProjectKey = taskLoc.analysisProjectKey;
            try (Transaction t = this.transactionService.retrieveOrBeginRead();){
                if (this.analysisCoreDAO.exists(analysisProjectKey, taskLoc.analysisId)) {
                    params.datasetName = ((AnalysisCoreParams)this.analysisCoreDAO.getMandatory((String)analysisProjectKey, (String)taskLoc.analysisId)).inputDatasetSmartName;
                }
            }
        }
        if (splitDesc != null && StringUtils.isBlank((String)params.datasetName) && (datasetNameMatcher = (datasetNamePattern = Pattern.compile("^.*,(dataset|ds|testSet)=([^,]+),.*$")).matcher(StringUtils.defaultIfEmpty((String)splitDesc.policyId, (String)""))).matches()) {
            params.datasetName = datasetNameMatcher.group(2);
        }
        params.partitions = selection != null && selection.partitionSelectionMethod == DatasetSelection.PartitionSelectionMethod.SELECTED ? Lists.newArrayList((Iterable)selection.selectedPartitions) : Lists.newArrayList((Object[])new String[]{"NP"});
        DataTypeAndParams ret = new DataTypeAndParams();
        ret.type = AbstractModelEvaluation.DataType.SPLIT;
        ret.params = JSON.toJsonObject((Object)params);
        return ret;
    }

    public TabularEvaluationModelInfo makeTimeseriesEvaluationInfo(TimeseriesForecastingModelDetails details) {
        TabularEvaluationModelInfo ret = new TabularEvaluationModelInfo();
        ret.predictionType = details.coreParams.prediction_type;
        ret.targetVariable = details.coreParams.target_variable;
        ret.predictionVariable = details.coreParams.target_variable;
        ret.thresholdAutoOptimized = false;
        ret.metricParams = (MetricParams)JSON.deepCopy((Object)details.modeling.metrics);
        return ret;
    }

    public TabularEvaluationModelInfo makeEvaluationInfo(ClassicalPredictionModelDetails details, double referenceClassifierThreshold, double activeClassifierThreshold) {
        TabularEvaluationModelInfo ret = new TabularEvaluationModelInfo();
        ret.predictionType = details.coreParams.prediction_type;
        ret.targetVariable = details.coreParams.target_variable;
        if (details.coreParams.weight != null && details.coreParams.weight.isSampleWeightEnabled()) {
            ret.weightsVariable = details.coreParams.weight.sampleWeightVariable;
        }
        ret.predictionVariable = details.coreParams.target_variable;
        ret.thresholdAutoOptimized = false;
        ret.referenceClassifierThreshold = referenceClassifierThreshold;
        ret.activeClassifierThreshold = activeClassifierThreshold;
        ret.metricParams = (MetricParams)JSON.deepCopy((Object)details.modeling.metrics);
        return ret;
    }

    public TabularModelEvaluation setupTabularRun(ModelEvaluationStore evaluationStore, ModelTypeAndParams model, DataTypeAndParams data, DataTypeAndParams trainData, TabularEvaluationModelInfo info) throws Exception {
        return this.setupTabularRun(evaluationStore, model, data, trainData, info, null);
    }

    public TabularModelEvaluation setupTabularRun(ModelEvaluationStore evaluationStore, ModelTypeAndParams model, DataTypeAndParams data, DataTypeAndParams trainData, TabularEvaluationModelInfo info, String referenceDatasetSmartName) throws Exception {
        TabularModelEvaluation modelEvaluation = new TabularModelEvaluation();
        File evaluationFolder = this.initializeEvaluationSetup(modelEvaluation, evaluationStore, info, data);
        modelEvaluation.modelType = model.type;
        modelEvaluation.modelParams = model.params;
        switch (modelEvaluation.modelType) {
            case SAVED_MODEL: {
                TabularModelEvaluation.EvaluatedDSSModel modelParams = (TabularModelEvaluation.EvaluatedDSSModel)JSON.parse((JsonElement)model.params, TabularModelEvaluation.EvaluatedDSSModel.class);
                modelEvaluation.modelParams = JSON.toJsonObject((Object)modelParams);
                break;
            }
            case EXTERNAL: {
                TabularModelEvaluation.EvaluatedExternalModel modelParams = (TabularModelEvaluation.EvaluatedExternalModel)JSON.parse((JsonElement)model.params, TabularModelEvaluation.EvaluatedExternalModel.class);
                modelEvaluation.modelParams = JSON.toJsonObject((Object)modelParams);
                modelEvaluation.hasDriftReference = referenceDatasetSmartName != null;
                break;
            }
            default: {
                throw new NotImplementedException("Unknown model type in evaluation : " + String.valueOf((Object)modelEvaluation.modelType));
            }
        }
        modelEvaluation.trainDataType = trainData.type;
        modelEvaluation.trainDataParams = trainData.params;
        modelEvaluation.predictionType = info.predictionType;
        modelEvaluation.thresholdAutoOptimized = info.thresholdAutoOptimized;
        modelEvaluation.activeClassifierThreshold = info.activeClassifierThreshold;
        modelEvaluation.referenceClassifierThreshold = info.referenceClassifierThreshold;
        modelEvaluation.metricParams = info.metricParams;
        modelEvaluation.predictionVariable = info.predictionVariable;
        modelEvaluation.targetVariable = info.targetVariable;
        modelEvaluation.weightsVariable = info.weightsVariable;
        modelEvaluation.outputProbabilities = info.outputProbabilities;
        modelEvaluation.probaColumns = info.probaColumns;
        modelEvaluation.evaluateRecipeParams = info.evaluateRecipeParams;
        modelEvaluation.smvToFilterLogsOn = info.smvToFilterLogsOn;
        modelEvaluation.hasModel = info.hasModel;
        modelEvaluation.skipScoring = info.skipScoring;
        modelEvaluation.hasTextDrift = info.hasTextDrift;
        modelEvaluation.textDriftParams = info.textDriftParams;
        JSON.prettyToFile((Object)modelEvaluation, (File)new File(evaluationFolder, "_evaluation.json"));
        return modelEvaluation;
    }

    public LLMModelEvaluation setupLLMRun(ModelEvaluationStore evaluationStore, DataTypeAndParams data, LLMEvaluationModelInfo info) throws IOException, InterruptedException {
        LLMModelEvaluation modelEvaluation = new LLMModelEvaluation();
        File evaluationFolder = this.initializeEvaluationSetup(modelEvaluation, evaluationStore, info, data);
        modelEvaluation.inputFormat = info.inputFormat;
        modelEvaluation.llmTaskType = info.taskType;
        modelEvaluation.inputColumnName = info.inputColumnName;
        modelEvaluation.outputColumnName = info.outputColumnName;
        modelEvaluation.groundTruthColumnName = info.groundTruthColumnName;
        modelEvaluation.contextColumnName = info.contextColumnName;
        modelEvaluation.bertScoreModelType = info.bertScoreModelType;
        modelEvaluation.bleuTokenizer = info.bleuTokenizer;
        modelEvaluation.embeddingLLMId = info.embeddingLLMId;
        modelEvaluation.embeddingSettings = info.embeddingSettings;
        modelEvaluation.completionLLMId = info.completionLLMId;
        modelEvaluation.completionSettings = info.completionSettings;
        modelEvaluation.customMetrics = info.customMetrics;
        modelEvaluation.selection = info.selection;
        modelEvaluation.embeddingLLMFriendlyName = info.embeddingLLMFriendlyName;
        modelEvaluation.completionLLMFriendlyName = info.completionLLMFriendlyName;
        JSON.prettyToFile((Object)modelEvaluation, (File)new File(evaluationFolder, "_evaluation.json"));
        return modelEvaluation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File initializeEvaluationSetup(AbstractModelEvaluation modelEvaluation, ModelEvaluationStore evaluationStore, AbstractEvaluationModelInfo info, DataTypeAndParams data) throws IOException, InterruptedException {
        String evaluationId;
        VariablesContext vc;
        File evaluationStoreFolder = MECPaths.modelEvaluationStoreBaseFolder(evaluationStore.projectKey, evaluationStore.id);
        KernelsModelEvaluationStoresService kernelsModelEvaluationStoresService = this;
        synchronized (kernelsModelEvaluationStoresService) {
            Thread.sleep(1L);
            modelEvaluation.created = System.currentTimeMillis();
        }
        if (StringUtils.isNotBlank((String)info.evaluationId)) {
            this.logger.info((Object)("Creating ME with evaluationId=" + info.evaluationId));
            vc = this.variablesService.getForProject(evaluationStore.projectKey);
            vc.add("createdAt", Long.toString(modelEvaluation.created));
            evaluationId = vc.expand(info.evaluationId);
            if (!Pattern.matches("\\w+", evaluationId)) {
                throw new IllegalArgumentException("Run id '" + evaluationId + "' contains invalid characters");
            }
        } else {
            this.logger.info((Object)"Creating ME with random id");
            evaluationId = SecretKeyGenerator.generate((int)12);
        }
        if (StringUtils.isNotBlank((String)info.name)) {
            this.logger.info((Object)("Naming ME: " + info.name));
            vc = this.variablesService.getForProject(evaluationStore.projectKey);
            vc.add("createdAt", Long.toString(modelEvaluation.created));
            modelEvaluation.userMeta.name = vc.expand(info.name);
        } else {
            modelEvaluation.userMeta.name = new SimpleDateFormat(ME_DEFAULT_NAME_FORMAT).format(modelEvaluation.created);
        }
        File evaluationFolder = new File(evaluationStoreFolder, evaluationId);
        if (evaluationFolder.exists()) {
            this.logger.warn((Object)("A model evaluation with evaluationId '" + evaluationId + "' already exists, overwriting"));
            DKUFileUtils.forceDelete((File)evaluationFolder);
        }
        DKUFileUtils.mkdirs((File)evaluationFolder);
        FilesystemACLUtils.restrictRwxToDSSIfImpersonationEnabled(evaluationFolder);
        modelEvaluation.dataType = data.type;
        modelEvaluation.dataParams = data.params;
        modelEvaluation.userMeta.labels = info.labels;
        modelEvaluation.setTransientReference(new FullModelEvaluationId(evaluationStore.projectKey, evaluationStore.id, evaluationId));
        modelEvaluation.evaluationDatasetType = info.evaluationDatasetType;
        modelEvaluation.limitSampling = info.limitSampling;
        return evaluationFolder;
    }

    public void finaliseRun(AbstractModelEvaluation modelEvaluation) throws IOException {
        if (modelEvaluation.ref.getMainFolder().exists()) {
            FileUtils.moveFile((File)modelEvaluation.ref.getEvaluationFile("_evaluation.json"), (File)modelEvaluation.ref.getEvaluationFile("evaluation.json"));
        }
    }

    public List<AbstractModelEvaluation> listEvaluations(ModelEvaluationStore mes) throws IOException {
        ArrayList list = Lists.newArrayList();
        File storeFolder = MECPaths.modelEvaluationStoreBaseFolder(mes.projectKey, mes.id);
        if (storeFolder != null && storeFolder.exists()) {
            for (File runFolder : storeFolder.listFiles()) {
                File evaluationFile = new File(runFolder, "evaluation.json");
                if (!runFolder.isDirectory() || !evaluationFile.exists() || !evaluationFile.isFile()) continue;
                try {
                    AbstractModelEvaluation evaluation = (AbstractModelEvaluation)JSON.parseFile((File)new File(runFolder, "evaluation.json"), AbstractModelEvaluation.class);
                    evaluation.setTransientReference(new FullModelEvaluationId(mes.projectKey, mes.id, runFolder.getName()));
                    list.add(evaluation);
                }
                catch (Exception e) {
                    this.logger.warn((Object)"Unable to read evaluation, skipping", (Throwable)e);
                }
            }
        }
        Collections.sort(list, new Comparator<AbstractModelEvaluation>(){

            @Override
            public int compare(AbstractModelEvaluation a, AbstractModelEvaluation b) {
                return Long.compare(a.created, b.created);
            }
        });
        return list;
    }

    public Callable<Void> handleDownloadRequest(AbstractModelEvaluation me, String path, final HttpServletResponse resp) throws Exception {
        final File file = DKUFileUtils.getWithin((File)MECPaths.modelEvaluationBaseFolder(me), (String[])new String[]{path});
        this.logger.info((Object)("Download from " + String.valueOf(me) + " -> " + path));
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try (FileInputStream in = new FileInputStream(file);
                     ServletOutputStream os = resp.getOutputStream();){
                    resp.setStatus(200);
                    resp.setContentType(DKUtils.guessMimeTypeFromExtension((String)file.getName()));
                    resp.setHeader("Content-Disposition", "attachment; filename=\"" + file.getName() + "\"");
                    resp.setHeader("Content-Length", "" + file.length());
                    IOUtils.copy((InputStream)in, (OutputStream)os);
                }
                catch (IOException e) {
                    KernelsModelEvaluationStoresService.this.logger.error((Object)"Failed to send file", (Throwable)e);
                    resp.setStatus(404);
                    resp.getWriter().write("No such file in this model evaluation.");
                }
                return null;
            }
        };
    }

    public Callable<Void> handleUploadRequest(AbstractModelEvaluation me, final InputStream is, String path, final boolean forceUpload) throws Exception {
        final File file = DKUFileUtils.getWithin((File)MECPaths.modelEvaluationBaseFolder(me), (String[])new String[]{path});
        this.logger.info((Object)("Upload to" + String.valueOf(me) + " -> " + path));
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (!forceUpload && file.exists()) {
                    throw new IOException("File already exists");
                }
                try (FileOutputStream os = new FileOutputStream(file);){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TabularModelEvaluation createCustomModelEvaluation(AuthCtx authCtx, ModelEvaluationStore evaluationStore, String evaluationId, String name, List<ModelCustomEvaluationMetricWithValue> metrics, List<SimpleKeyValue> labels, PredictionMLTask.PredictionType predictionType, SavedModel sm, FullModelId fmi) throws Exception {
        Object matcher;
        File evaluationStoreFolder = MECPaths.modelEvaluationStoreBaseFolder(evaluationStore.projectKey, evaluationStore.id);
        TabularModelEvaluation modelEvaluation = new TabularModelEvaluation();
        if (StringUtils.isNotBlank((String)evaluationId)) {
            matcher = FullModelEvaluationId.EVALUATION_ID_PATTERN.matcher(evaluationId);
            if (!((Matcher)matcher).find()) {
                throw new IllegalArgumentException("Invalid evaluation id: " + evaluationId);
            }
            this.logger.info((Object)("Creating ME with evaluationId=" + evaluationId));
            VariablesContext vc = this.variablesService.getForProject(evaluationStore.projectKey);
            vc.add("createdAt", Long.toString(modelEvaluation.created));
            if (!Pattern.matches("\\w+", evaluationId)) {
                throw new IllegalArgumentException("Run id '" + evaluationId + "' contains invalid characters");
            }
        } else {
            this.logger.info((Object)"Creating ME with random id");
            evaluationId = SecretKeyGenerator.generate((int)12);
        }
        modelEvaluation.setTransientReference(new FullModelEvaluationId(evaluationStore.projectKey, evaluationStore.id, evaluationId));
        matcher = this;
        synchronized (matcher) {
            Thread.sleep(1L);
            modelEvaluation.created = System.currentTimeMillis();
        }
        if (StringUtils.isNotBlank((String)name)) {
            this.logger.info((Object)("Naming ME: " + name));
            VariablesContext vc = this.variablesService.getForProject(evaluationStore.projectKey);
            vc.add("createdAt", Long.toString(modelEvaluation.created));
            modelEvaluation.userMeta.name = vc.expand(name);
        } else {
            modelEvaluation.userMeta.name = new SimpleDateFormat(ME_DEFAULT_NAME_FORMAT).format(modelEvaluation.created);
        }
        if (CollectionUtils.isNotEmpty(labels)) {
            modelEvaluation.userMeta.labels = labels;
        }
        modelEvaluation.predictionType = predictionType;
        File evaluationFolder = new File(evaluationStoreFolder, evaluationId);
        if (evaluationFolder.exists()) {
            this.logger.warn((Object)("A model evaluation with evaluationId '" + evaluationId + "' already exists, overwriting"));
            DKUFileUtils.forceDelete((File)evaluationFolder);
        }
        if (null != sm && null != fmi) {
            ModelTypeAndParams modelTypeAndParams = this.makeModelTypeAndParams(fmi.getProjectKey(), sm, fmi, null);
            modelEvaluation.modelType = modelTypeAndParams.type;
            modelEvaluation.modelParams = modelTypeAndParams.params;
            ModelUserMeta modelUserMeta = fmi.getUserMeta();
            modelEvaluation.userMeta.labels = EvaluationLabelsHelper.setModelNameToLabels(modelEvaluation.userMeta.labels, modelUserMeta.name);
        } else {
            modelEvaluation.modelType = TabularModelEvaluation.ModelType.EXTERNAL;
            modelEvaluation.modelParams = new JsonObject();
        }
        DKUFileUtils.mkdirs((File)evaluationFolder);
        FilesystemACLUtils.restrictRwxToDSSIfImpersonationEnabled(evaluationFolder);
        modelEvaluation.dataType = AbstractModelEvaluation.DataType.EXTERNAL;
        modelEvaluation.dataParams = new JsonObject();
        JSON.prettyToFile((Object)modelEvaluation.userMeta, (File)new File(evaluationFolder, "user_meta.json"));
        JSON.prettyToFile((Object)modelEvaluation, (File)new File(evaluationFolder, "evaluation.json"));
        OtherClassificationModelPerf predMetrics = new OtherClassificationModelPerf();
        predMetrics.metrics.customMetricsResults = metrics.stream().map(cm -> {
            CustomMetricSuccess ret = new CustomMetricSuccess();
            ret.metric = cm;
            ret.value = cm.value;
            return ret;
        }).collect(Collectors.toList()).toArray(new CustomMetricResult[0]);
        JSON.prettyToFile((Object)predMetrics, (File)new File(evaluationFolder, "perf.json"));
        return modelEvaluation;
    }

    public static class ModelTypeAndParams {
        public TabularModelEvaluation.ModelType type;
        public JsonObject params;
    }

    public static class DataTypeAndParams {
        public AbstractModelEvaluation.DataType type;
        public JsonObject params;
    }

    public static class TabularEvaluationModelInfo
    extends AbstractEvaluationModelInfo {
        public PredictionMLTask.PredictionType predictionType;
        public MetricParams metricParams;
        public boolean thresholdAutoOptimized;
        public double activeClassifierThreshold;
        public double referenceClassifierThreshold;
        public String predictionVariable;
        public String targetVariable;
        public String weightsVariable;
        public List<TabularModelEvaluation.EvaluationModelInfoProba> probaColumns;
        public boolean outputProbabilities;
        public EvaluateRecipeParams evaluateRecipeParams;
        public FullModelId smvToFilterLogsOn;
        public boolean hasModel = true;
        public boolean skipScoring;
        public boolean hasTextDrift = false;
        public TextDriftParams textDriftParams;
    }

    public static class AbstractEvaluationModelInfo {
        public String evaluationId;
        public String name;
        public List<SimpleKeyValue> labels = new ArrayList<SimpleKeyValue>();
        public boolean limitSampling;
        public EvaluationDatasetHelper.EvaluationDatasetType evaluationDatasetType;
    }

    public static class EvaluateRecipeParams {
        public Boolean dontComputePerformance;
        public List<SimpleKeyValue> probas;
        public List<String> classes;
        public List<FeaturePreprocessingParams> features;
        public Boolean isProbaAware;

        public EvaluateRecipeParams(Boolean dontComputePerformance, List<SimpleKeyValue> probas, List<String> classes, List<FeaturePreprocessingParams> features, Boolean isProbaAware) {
            this.dontComputePerformance = dontComputePerformance;
            this.probas = probas;
            this.classes = classes;
            this.features = features;
            this.isProbaAware = isProbaAware;
        }

        public EvaluateRecipeParams(Boolean dontComputePerformance) {
            this.dontComputePerformance = dontComputePerformance;
        }
    }

    public static class LLMEvaluationModelInfo
    extends AbstractEvaluationModelInfo {
        public LLMEvaluationRecipePayloadParams.LLMEvalInputFormat inputFormat;
        public LLMTaskType taskType;
        public String inputColumnName;
        public String outputColumnName;
        public String groundTruthColumnName;
        public String contextColumnName;
        public String bertScoreModelType;
        public String bleuTokenizer;
        public String embeddingLLMId;
        public String embeddingLLMFriendlyName;
        public LLMEmbeddingSettings embeddingSettings;
        public String completionLLMId;
        public String completionLLMFriendlyName;
        public LLMCompletionSettings completionSettings;
        public List<LLMCustomEvaluationMetric> customMetrics = Lists.newArrayList();
        public StreamableDatasetSelection selection;
    }

    public static class ModelCustomEvaluationMetricWithValue
    extends ModelCustomEvaluationMetric {
        public double value;

        public ModelCustomEvaluationMetricWithValue() {
            this.type = BaseCustomEvaluationMetric.CustomEvaluationMetricType.MODEL_WITH_VALUE;
        }
    }
}

