/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.mec;

import com.dataiku.dip.analysis.model.prediction.PredictionMLTask;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.recipes.nlp.llm_evaluation.LLMTaskType;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;

public class ModelComparison
extends TaggableObjectsService.TaggableObject {
    @JSON.FileTransient
    public String projectKey;
    @JSON.FileTransient
    public String id;
    public String displayName;
    @SerializedName(value="modelTaskType", alternate={"predictionType"})
    public ModelTaskType modelTaskType;
    public List<ComparedModel> comparedModels = new ArrayList<ComparedModel>();
    public ModelEvaluationStore.DisplayParams displayParams = new ModelEvaluationStore.DisplayParams();

    public ModelComparison() {
    }

    public ModelComparison(String projectKey) {
        this.projectKey = projectKey;
        this.id = SecretKeyGenerator.generate((int)8);
    }

    @Override
    public ITaggingService.TaggableType getTaggableType() {
        return ITaggingService.TaggableType.MODEL_COMPARISON;
    }

    @Override
    public String getProjectKey() {
        return this.projectKey;
    }

    @Override
    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public static class ComparedModel {
        @JSON.FileTransient
        public String refId;
        public String smartId;
        public boolean isSelected = true;
        public String color;
        public boolean isChampion = false;
    }

    public static class ModelComparisonListItem
    extends TaggableObjectsService.TaggableListItem {
        final long comparedCount;

        public ModelComparisonListItem(ModelComparison modelComparison) {
            super(modelComparison);
            this.comparedCount = null != modelComparison.comparedModels ? (long)modelComparison.comparedModels.size() : 0L;
        }

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.MODEL_COMPARISON;
        }
    }

    public static enum ModelTaskType {
        BINARY_CLASSIFICATION,
        REGRESSION,
        MULTICLASS,
        TIMESERIES_FORECAST,
        CAUSAL_BINARY_CLASSIFICATION,
        CAUSAL_REGRESSION,
        LLM;


        public static ModelTaskType from(PredictionMLTask.PredictionType predictionType) {
            if (predictionType == null) {
                return null;
            }
            switch (predictionType) {
                case BINARY_CLASSIFICATION: {
                    return BINARY_CLASSIFICATION;
                }
                case REGRESSION: {
                    return REGRESSION;
                }
                case MULTICLASS: {
                    return MULTICLASS;
                }
                case TIMESERIES_FORECAST: {
                    return TIMESERIES_FORECAST;
                }
                case CAUSAL_BINARY_CLASSIFICATION: {
                    return CAUSAL_BINARY_CLASSIFICATION;
                }
                case CAUSAL_REGRESSION: {
                    return CAUSAL_REGRESSION;
                }
            }
            throw new IllegalArgumentException("Unknown prediction type '" + String.valueOf((Object)predictionType) + "', please add it to ModelComparison.ModelTaskType");
        }

        public static ModelTaskType from(LLMTaskType llmTaskType) {
            if (llmTaskType == null) {
                throw new IllegalArgumentException("llmTaskType can't be null");
            }
            switch (llmTaskType) {
                case QUESTION_ANSWERING: 
                case SUMMARIZATION: 
                case TRANSLATION: 
                case OTHER_LLM_TASK: {
                    return LLM;
                }
            }
            throw new IllegalArgumentException("Unknown prediction type '" + String.valueOf((Object)llmTaskType) + "', please add it to ModelComparison.ModelTaskType");
        }

        public boolean isPrediction() {
            return !this.isLLM();
        }

        public boolean isLLM() {
            return LLM == this;
        }
    }
}

