/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.engines;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.engines.MetricsEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BasicMetricsEngine
implements MetricsEngine {
    private final Dataset dataset;
    private final Partition partition;
    private final DatasetHandler datasetHandler;
    private final ManagedFolderHandler folderHandler;
    private final ManagedFolder folder;
    private List<Partition> partitions;
    private MetricsEngineDesc.MetricsEngineContext context;

    public BasicMetricsEngine(Dataset dataset, DatasetHandler datasetHandler, Partition partition, BasicMetricsEngineConfig config, MetricsEngineDesc.MetricsEngineContext context) {
        this.context = context;
        this.folder = null;
        this.folderHandler = null;
        this.dataset = dataset;
        this.datasetHandler = datasetHandler;
        this.partition = partition;
        this.partitions = context.partitions;
    }

    public BasicMetricsEngine(ManagedFolder folder, ManagedFolderHandler folderHandler, Partition partition, BasicMetricsEngineConfig config, MetricsEngineDesc.MetricsEngineContext context) {
        this.folder = folder;
        this.folderHandler = folderHandler;
        this.partition = partition;
        this.context = context;
        this.dataset = null;
        this.datasetHandler = null;
        this.partitions = context.partitions;
    }

    @Override
    public Map<Metric, String> compute(List<MetricComputation> computations, MetricsComputationService.MetricsEngineRunReport report, FutureService futureService, AuthCtx authCtx, Map<String, String> alreadyComputed) throws Exception {
        BasicMetricsEngineCallbacks callbacks = new BasicMetricsEngineCallbacks(){

            @Override
            public Dataset getDataset() {
                return BasicMetricsEngine.this.dataset;
            }

            @Override
            public ManagedFolder getFolder() {
                return BasicMetricsEngine.this.folder;
            }

            @Override
            public Partition getPartition() {
                return BasicMetricsEngine.this.partition;
            }

            @Override
            public DatasetHandler getDatasetHandler() {
                return BasicMetricsEngine.this.datasetHandler;
            }

            @Override
            public ManagedFolderHandler getManagedFolderHandler() {
                return BasicMetricsEngine.this.folderHandler;
            }

            @Override
            public List<Partition> getPartitions() throws Exception {
                if (BasicMetricsEngine.this.partitions == null) {
                    if (BasicMetricsEngine.this.datasetHandler != null) {
                        BasicMetricsEngine.this.partitions = BasicMetricsEngine.this.datasetHandler.listPartitions();
                        if (BasicMetricsEngine.this.context != null && BasicMetricsEngine.this.context.partitions == null) {
                            BasicMetricsEngine.this.context.partitions = BasicMetricsEngine.this.partitions;
                        }
                    } else if (BasicMetricsEngine.this.folderHandler != null) {
                        BasicMetricsEngine.this.partitions = BasicMetricsEngine.this.folderHandler.listPartitions();
                        if (BasicMetricsEngine.this.context != null && BasicMetricsEngine.this.context.partitions == null) {
                            BasicMetricsEngine.this.context.partitions = BasicMetricsEngine.this.partitions;
                        }
                    }
                }
                return BasicMetricsEngine.this.partitions;
            }
        };
        HashMap metricsValues = Maps.newHashMap();
        for (MetricComputation computation : computations) {
            BasicMetricsEngineComputer computer = (BasicMetricsEngineComputer)computation.computer;
            if (computer instanceof DangerousBasicMetricsEngineComputer) {
                BasicMetricsEngineComputationThread ft = new BasicMetricsEngineComputationThread((DSSAuthCtx)this.context.user, this.dataset, this.partition, computation);
                FutureResponse fr = futureService.runFuture(ft, 100L, new TypeToken<FutureResponse<MetricsComputationService.ValuedMetric>>(){});
                fr = futureService.waitForFinalResponse(fr);
                metricsValues.put(((MetricsComputationService.ValuedMetric)fr.result).metric, ((MetricsComputationService.ValuedMetric)fr.result).value);
                continue;
            }
            metricsValues.put(computation.metric, computer.getAggregate(callbacks, computation));
        }
        return metricsValues;
    }

    public static FuturePayload buildFuturePayload(Dataset dataset) {
        FuturePayload fp = new FuturePayload();
        fp.action = "metrics_dss_computation";
        fp.targets.add(DSSFuturePayloadUtils.forDataset(dataset).withPart("metrics"));
        fp.displayName = "Compute metrics using DSS engine on " + dataset.getFullName();
        return fp;
    }

    public static abstract class BasicMetricsEngineComputer
    extends MetricComputer.BasicEngineComputer {
        public abstract String getAggregate(BasicMetricsEngineCallbacks var1, MetricComputation var2) throws Exception;
    }

    public static interface DangerousBasicMetricsEngineComputer {
    }

    public static class BasicMetricsEngineComputationThread
    extends SimpleFutureThread<MetricsComputationService.ValuedMetric> {
        private final Dataset dataset;
        private final Partition partition;
        private final MetricComputation computation;
        private final FuturePayload futurePayload;

        public BasicMetricsEngineComputationThread(DSSAuthCtx user, Dataset dataset, Partition partition, MetricComputation computation) {
            super((AuthCtx)user);
            this.dataset = dataset;
            this.partition = partition;
            this.computation = computation;
            this.futurePayload = BasicMetricsEngine.buildFuturePayload(dataset);
        }

        @Override
        public double getDangerosity() {
            return 1.0;
        }

        @Override
        protected MetricsComputationService.ValuedMetric compute() throws Exception {
            try (final DatasetHandler datasetHandler = DatasetHandlerFactory.build(this.owner, this.dataset);){
                final ArrayList partitions = Lists.newArrayList();
                BasicMetricsEngineCallbacks callbacks = new BasicMetricsEngineCallbacks(){

                    @Override
                    public Dataset getDataset() {
                        return dataset;
                    }

                    @Override
                    public ManagedFolder getFolder() {
                        return null;
                    }

                    @Override
                    public Partition getPartition() {
                        return partition;
                    }

                    @Override
                    public DatasetHandler getDatasetHandler() {
                        return datasetHandler;
                    }

                    @Override
                    public ManagedFolderHandler getManagedFolderHandler() {
                        return null;
                    }

                    @Override
                    public List<Partition> getPartitions() throws Exception {
                        if (partitions.size() == 0 && datasetHandler != null) {
                            partitions.addAll(datasetHandler.listPartitions());
                        }
                        return partitions;
                    }
                };
                MetricsComputationService.ValuedMetric valuedMetric = new MetricsComputationService.ValuedMetric(this.computation.metric, ((BasicMetricsEngineComputer)this.computation.computer).getAggregate(callbacks, this.computation));
                return valuedMetric;
            }
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }

        static {
            JSON.registerAdapter(BasicMetricsEngineComputationThread.class, (Object)new JSON.Adapter<BasicMetricsEngineComputationThread>(){

                public BasicMetricsEngineComputationThread deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext ctx) throws JsonParseException {
                    BasicMetricsEngineComputer computer;
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    DSSAuthCtx owner = (DSSAuthCtx)((Object)ctx.deserialize(jsonObj.get("owner"), DSSAuthCtx.class));
                    String datasetFullName = jsonObj.get("datasetFullName").getAsString();
                    SerializedDataset serializedDataset = (SerializedDataset)ctx.deserialize(jsonObj.get("dataset"), SerializedDataset.class);
                    Dataset dataset = Dataset.fromSerialized(datasetFullName, serializedDataset);
                    String partitionId = jsonObj.get("partitionId").getAsString();
                    Partition partition = dataset.getPartitioningSchema() != null ? MetricsComputationService.makePartitionFromId(dataset.getPartitioningSchema(), partitionId) : Partition.newNP();
                    JsonObject computerObj = jsonObj.get("computer").getAsJsonObject();
                    String computerClassName = computerObj.get("computerClassName").getAsString();
                    try {
                        computer = (BasicMetricsEngineComputer)Class.forName(computerClassName).newInstance();
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new JsonParseException("Unknown computer class " + computerClassName, (Throwable)e);
                    }
                    Metric metric = (Metric)ctx.deserialize(jsonObj.get("metric"), Metric.class);
                    Probe probe = (Probe)ctx.deserialize(jsonObj.get("probe"), Probe.class);
                    MetricComputation computation = new MetricComputation(probe, computer, metric, 0.0);
                    BasicMetricsEngineComputationThread ft = new BasicMetricsEngineComputationThread(owner, dataset, partition, computation);
                    return ft;
                }

                public JsonElement serialize(BasicMetricsEngineComputationThread ft, Type type, JsonSerializationContext ctx) {
                    JsonObject ret = new JsonObject();
                    ret.add("owner", ctx.serialize((Object)ft.owner));
                    ret.addProperty("datasetFullName", ft.dataset.getFullName());
                    ret.add("dataset", ctx.serialize((Object)ft.dataset.serialize()));
                    ret.add("partitionId", ctx.serialize((Object)ft.partition.id()));
                    JsonObject computerObj = new JsonObject();
                    computerObj.addProperty("computerClassName", ft.computation.computer.getClass().getName());
                    ret.add("computer", (JsonElement)computerObj);
                    ret.add("metric", ctx.serialize((Object)ft.computation.metric, Metric.class));
                    ret.add("probe", ctx.serialize((Object)ft.computation.probe));
                    return ret;
                }
            });
        }
    }

    public static interface BasicMetricsEngineCallbacks {
        public Dataset getDataset();

        public ManagedFolder getFolder();

        public Partition getPartition();

        public DatasetHandler getDatasetHandler();

        public ManagedFolderHandler getManagedFolderHandler();

        public List<Partition> getPartitions() throws Exception;
    }

    public static class BasicMetricsEngineConfig {
    }

    public static class BasicMetricsEngineRun
    extends MetricsEngineRun {
        boolean unmergeable = false;

        public BasicMetricsEngineRun() {
            super(MetricsEngineDesc.BasicEngine);
        }

        public BasicMetricsEngineRun(double cost, List<MetricComputation> computations, int pass) {
            super(MetricsEngineDesc.BasicEngine, cost, computations, pass);
        }

        public BasicMetricsEngineRun withUnmergeable(boolean unmergeable) {
            this.unmergeable = unmergeable;
            return this;
        }

        @Override
        protected MetricsEngineRun subset(double cost, List<MetricComputation> computations) {
            return new BasicMetricsEngineRun(cost, computations, this.pass);
        }

        @Override
        public boolean canMergeWith(MetricsEngineRun other) {
            if (this.unmergeable || other instanceof BasicMetricsEngineRun && ((BasicMetricsEngineRun)other).unmergeable) {
                return false;
            }
            return super.canMergeWith(other);
        }
    }
}

