/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.engines;

import com.dataiku.dip.connections.ImpalaConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveSchemaHandler;
import com.dataiku.dip.impala.ImpalaConfigurator;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.engines.JdbcEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.engines.ProbeQueryBuilder;
import com.dataiku.dip.metrics.probes.MetricBuilder;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.queries.QueryBunch;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.security.AuthCtx;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ImpalaProbeEngine
extends JdbcEngine
implements ProbeQueryBuilder.ProbeQueryBuilderEngine {
    private final DatasetHandler datasetHandler;
    private static Logger logger = Logger.getLogger((String)"dku.datasets.metrics.impala.probe");

    public ImpalaProbeEngine(Dataset dataset, DatasetHandler datasetHandler, Partition partition, JdbcEngine.ImpalaMetricsEngineConfig config) {
        super(dataset, partition);
        this.datasetHandler = datasetHandler;
    }

    public DatasetHandler getDatasetHandler() {
        return this.datasetHandler;
    }

    @Override
    public void setupConnection(AuthCtx authCtx) throws IOException, DKUSecurityException, SQLException {
        String database = HiveSchemaHandler.getResolvedHiveTableRefFromDataset(this.dataset).getSchemaNullIfBlank();
        logger.info((Object)("Impala probe engine on database : " + database));
        ImpalaConnection datasetConnection = ImpalaConfigurator.configureConnectionForDatabase(authCtx, database == null ? "" : database);
        this.connectionData = datasetConnection.getConnectionData_NT(authCtx, this.dataset.getProjectKey());
        this.dialect = this.connectionData.getDialect();
    }

    @Override
    public QueryBunch buildQuery(AuthCtx authCtx, List<MetricComputation> computations, Map<String, String> alreadyComputed) throws Exception {
        MetricComputation primerComputation = computations.get(0);
        MetricComputer.ImpalaQueryEngineComputer computer = (MetricComputer.ImpalaQueryEngineComputer)primerComputation.computer;
        ProbeQueryBuilder builder = new ProbeQueryBuilder();
        return builder.buildQuery(authCtx, this, computer.getQuery(primerComputation.probe), computer.getVariables(primerComputation.probe, authCtx, this.dataset.getProjectKey()));
    }

    @Override
    public Map<Metric, String> getAggregates(QueryRunResult res, List<MetricComputation> computations) throws Exception {
        Probe sqlProbe = computations.get((int)0).probe;
        MetricBuilder metricBuilder = (MetricBuilder)((Object)ProbeType.getProbeType(sqlProbe.getType()));
        HashMap metricsValues = Maps.newHashMap();
        if (res.rows != null && res.rows.size() > 0) {
            for (int i = 0; i < res.columns.size(); ++i) {
                SchemaColumn column = HiveSchemaHandler.dssColumnFromHiveColumnDef(res.columns.get((int)i).name, res.columns.get((int)i).type, AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING, AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING);
                String v = res.rows.get(0)[i];
                Metric metric = metricBuilder.build(column.getName(), column.getType(), sqlProbe);
                metricsValues.put(metric, v);
            }
        }
        return metricsValues;
    }

    public static class ImpalaProbeEngineRun
    extends MetricsEngineRun {
        public ImpalaProbeEngineRun() {
            super(MetricsEngineDesc.ImpalaQueryEngine);
        }

        public ImpalaProbeEngineRun(double cost, List<MetricComputation> computations, int pass) {
            super(MetricsEngineDesc.ImpalaQueryEngine, cost, computations, pass);
        }

        @Override
        protected MetricsEngineRun subset(double cost, List<MetricComputation> computations) {
            return new ImpalaProbeEngineRun(cost, computations, this.pass);
        }

        @Override
        public boolean canMergeWith(MetricsEngineRun other) {
            return false;
        }
    }
}

