/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.probes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataquality.dqmetrics.ValuesInRangeMetric;
import com.dataiku.dip.dataquality.dqmetrics.ValuesInSetMetric;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.metrics.probes.TemporaryMetricsProbeType;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import java.util.List;
import javax.annotation.Nullable;

@PolyJSON(value={@Mapping(value=ValuesInSetMetric.class, type="ValuesInSetMetric"), @Mapping(value=ValuesInRangeMetric.class, type="ValuesInRangeMetric")}, typeProperty="metricType")
public abstract class TemporaryMetric
extends Metric {
    public static final String PROBE_TYPE = "temporary_metrics_probe";

    protected TemporaryMetric(String id, Type dataType) {
        super(PROBE_TYPE, dataType);
        this.id = id;
    }

    public abstract List<MetricComputer> getComputers();

    public abstract String serialize();

    @Override
    public String getColumnInvariantId(String placeholder) {
        return null;
    }

    @Override
    @Nullable
    public Probe getMatchingProbe(List<Probe> probes) {
        TemporaryMetricsProbeType.Configuration config = new TemporaryMetricsProbeType.Configuration();
        config.metric = this;
        return new Probe(PROBE_TYPE).withMeta(ProbeType.getProbeType(PROBE_TYPE).getMeta()).withConfiguration(config);
    }

    @Override
    public boolean shouldBeSaved() {
        return false;
    }

    public static class TemporaryMetricIdSerializer
    implements Metric.MetricIdSerializer {
        @Override
        public String serializeMetric(Metric rawMetric) {
            if (!(rawMetric instanceof TemporaryMetric)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + TemporaryMetricsProbeType.class.getSimpleName() + " does not handle " + rawMetric.getClass().getSimpleName());
            }
            TemporaryMetric metric = (TemporaryMetric)rawMetric;
            return metric.serialize();
        }

        @Override
        public Metric deserializeMetric(String metricId) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, TemporaryMetric.class.getSimpleName() + " is not deserializable");
        }
    }
}

