/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.cache;

import com.dataiku.dip.pivot.backend.sql.builders.BasicStatsBuilder;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ColumnStatsCache {
    private final LRUMap<String, SoftReference<BasicStatsBuilder.ColStats>> data;

    public ColumnStatsCache(int size) {
        this.data = new LRUMap(size);
    }

    public synchronized void put(BasicStatsBuilder.BasicStats stats) {
        for (Map.Entry<String, BasicStatsBuilder.ColStats> stringColStatsEntry : stats.columnStats.entrySet()) {
            this.data.put(stringColStatsEntry.getKey(), new SoftReference<BasicStatsBuilder.ColStats>(stringColStatsEntry.getValue()));
        }
    }

    public synchronized BasicStatsBuilder.BasicStats get(List<String> columns) {
        BasicStatsBuilder.BasicStats basicStats = new BasicStatsBuilder.BasicStats();
        basicStats.columnStats = new HashMap<String, BasicStatsBuilder.ColStats>();
        for (String column : columns) {
            SoftReference colStatsSoftReference = (SoftReference)this.data.get(column);
            if (colStatsSoftReference == null) {
                return null;
            }
            basicStats.columnStats.put(column, (BasicStatsBuilder.ColStats)colStatsSoftReference.get());
        }
        return basicStats.columnStats.isEmpty() ? null : basicStats;
    }

    private class LRUMap<K, T>
    extends LinkedHashMap<K, T> {
        private static final long serialVersionUID = 1L;
        private final int maxCapacity;

        LRUMap(int maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, T> eldest) {
            return this.size() >= this.maxCapacity;
        }
    }
}

