/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.processes;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.processes.AbstractCGroupHelper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class CGroupHelper
extends AbstractCGroupHelper {
    private final AuthCtx authCtx;
    private final String projectKey;
    private final GeneralSettingsDAO.CGrouppableProcessType type;
    private final GeneralSettingsDAO.GeneralSettings gs;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.processes.cgroups");

    public CGroupHelper(AuthCtx authCtx, String projectKey, GeneralSettingsDAO.CGrouppableProcessType type) {
        this.authCtx = authCtx;
        this.projectKey = projectKey;
        this.type = type;
        this.gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
    }

    @Override
    public boolean isEnabled() {
        return this.gs != null && this.gs.cgroupSettings.enabled;
    }

    @Override
    public String getHierarchiesMountPoint() {
        return this.gs.cgroupSettings.hierarchiesMountPoint;
    }

    @Override
    public GeneralSettingsDAO.LocalProcessesCgroupsSettings.CGroupsVersion getCGroupsVersion() {
        return this.gs.cgroupSettings.cgroupsVersion;
    }

    @Override
    public String getCGroupsV2Controllers() {
        return this.gs.cgroupSettings.cgroupsV2Controllers;
    }

    @Override
    public Set<String> getTargetCGroups() {
        GeneralSettingsDAO.ProcessTypeCGroupSettings ptcgs = null;
        switch (this.type) {
            case ML_KERNEL: {
                ptcgs = this.gs.cgroupSettings.mlKernels;
                break;
            }
            case PYTHON_R_RECIPE: {
                ptcgs = this.gs.cgroupSettings.pythonRRecipes;
                break;
            }
            case PYTHON_R_SPARK_RECIPE: {
                ptcgs = this.gs.cgroupSettings.pythonRSparkRecipes;
                break;
            }
            case PYTHON_SCENARIO: {
                ptcgs = this.gs.cgroupSettings.pythonScenarios;
                break;
            }
            case JUPYTER_KERNEL: {
                ptcgs = this.gs.cgroupSettings.jupyterKernels;
                break;
            }
            case ML_RECIPE: {
                ptcgs = this.gs.cgroupSettings.mlRecipes;
                break;
            }
            case PYTHON_MACRO: {
                ptcgs = this.gs.cgroupSettings.pythonMacros;
                break;
            }
            case RMARKDOWN_BUILDER: {
                ptcgs = this.gs.cgroupSettings.rmarkdownBuilders;
                break;
            }
            case WEBAPP_DEV_BACKEND: {
                ptcgs = this.gs.cgroupSettings.webappDevBackends;
                break;
            }
            case EDA: {
                ptcgs = this.gs.cgroupSettings.eda;
                break;
            }
            case EDA_RECIPE: {
                ptcgs = this.gs.cgroupSettings.edaRecipes;
                break;
            }
            case METRIC_CHECK: {
                ptcgs = this.gs.cgroupSettings.metricsChecks;
                break;
            }
            case DEPLOYMENT_HOOK: {
                ptcgs = this.gs.cgroupSettings.deploymentHooks;
                break;
            }
            case LAMBDA_DEV_SERVER: {
                ptcgs = this.gs.cgroupSettings.devLambdaServer;
                break;
            }
            case CUSTOM_PYTHON_DATA_ACCESS_COMPONENT: {
                ptcgs = this.gs.cgroupSettings.customPythonDataAccessComponents;
                break;
            }
            case JOB_EXECUTION_KERNEL: {
                ptcgs = this.gs.cgroupSettings.jobExecutionKernels;
                break;
            }
            case PROJECT_STANDARDS: {
                ptcgs = this.gs.cgroupSettings.projectStandards;
            }
        }
        if (ptcgs == null) {
            logger.warn((Object)("No PTCGS FOR " + String.valueOf((Object)this.type)));
            return new HashSet<String>();
        }
        VariablesContext vc = this.getVariablesContext();
        HashSet<String> finalPaths = new HashSet<String>();
        for (GeneralSettingsDAO.ProcessTypeCGroupTarget target : ptcgs.targets) {
            String path = vc.expand(target.cgroupPathTemplate);
            logger.info((Object)("  cgroup " + target.cgroupPathTemplate + " expanded to " + path));
            finalPaths.add(path);
        }
        logger.info((Object)("Will use cgroups " + JSON.json(finalPaths)));
        return finalPaths;
    }

    @Override
    public void createCGroups(Set<String> targets) {
        for (String path : targets) {
            File cgroupDir = DKUFileUtils.getWithin((File)new File(this.gs.cgroupSettings.hierarchiesMountPoint), (String[])new String[]{path});
            try {
                DKUFileUtils.mkdirs((File)cgroupDir);
            }
            catch (IOException e) {
                logger.warn((Object)("Failed to create cgroup " + String.valueOf(cgroupDir)), (Throwable)e);
            }
            if (this.getCGroupsVersion() != GeneralSettingsDAO.LocalProcessesCgroupsSettings.CGroupsVersion.CGROUPS_V2) continue;
            this.ensureSubtreeControl(path);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyRulesToUsedCGroups(Set<String> usedCGroups) {
        logger.info((Object)("Applying rules to used cgroups: " + String.valueOf(usedCGroups)));
        VariablesContext vc = this.getVariablesContext();
        for (GeneralSettingsDAO.CGroupSettings cgs : this.gs.cgroupSettings.cgroups) {
            Object expandedPath = vc.expand(cgs.cgroupPathTemplate);
            if (!((String)expandedPath).endsWith("/")) {
                expandedPath = (String)expandedPath + "/";
            }
            logger.trace((Object)("Rule path " + (String)expandedPath));
            for (String string : usedCGroups) {
                void var7_7;
                if (!string.endsWith("/")) {
                    String string2 = string + "/";
                }
                logger.traceV("Checking match of cgroup rule path %s vs used cgroup %s", new Object[]{expandedPath, var7_7});
                if (!var7_7.startsWith((String)expandedPath) && !CGroupHelper.matchesSafe((String)expandedPath, (String)var7_7)) continue;
                File cgroupDir = DKUFileUtils.getWithin((File)new File(this.gs.cgroupSettings.hierarchiesMountPoint, (String)expandedPath), (String[])new String[0]);
                logger.debugV("Used cgroupPath '%s' matches rule for path '%s', applying rules: %s on '%s'", new Object[]{var7_7, cgs.cgroupPathTemplate, JSON.json(cgs.limits), cgroupDir});
                for (SimpleKeyValue skv : cgs.limits) {
                    File ruleFile = new File(cgroupDir, skv.key);
                    if (!ruleFile.isFile()) {
                        logger.warn((Object)("Ignoring set of limit on non-existing limit file: " + String.valueOf(ruleFile)));
                        continue;
                    }
                    try {
                        FileUtils.writeStringToFile((File)new File(cgroupDir, skv.key), (String)skv.value, (Charset)StandardCharsets.UTF_8);
                    }
                    catch (IOException e) {
                        logger.warn((Object)("Failed to apply rule " + JSON.json((Object)skv) + " to cgroup " + String.valueOf(cgroupDir)), (Throwable)e);
                    }
                }
            }
        }
    }

    private VariablesContext getVariablesContext() {
        VariablesContext vc = ((VariablesService)SpringUtils.getBean(VariablesService.class)).getForProject(this.projectKey);
        vc.add("user", this.authCtx.getIdentifier());
        return vc;
    }

    private static boolean matchesSafe(String pattern, String needle) {
        try {
            Pattern p = Pattern.compile(pattern);
            return p.matcher(needle).matches();
        }
        catch (Exception e) {
            return false;
        }
    }
}

