/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport;

import com.dataiku.dip.analysis.coreservices.MLBaseService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.analysis.model.core.ResolvedCoreParams;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.code.CodeEnvUsagesService;
import com.dataiku.dip.code.JupyterCodeEnvUtils;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.externalml.mlflow.MLFlowModelVersionInfo;
import com.dataiku.dip.projects.importexport.BundleCodes;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.projects.importexport.model.ProjectRemappingSettings;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnvContainerPayload;
import com.dataiku.dip.recipes.ParamsWithFixedCodeEnv;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.SelectableCodeEnvContainer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractCodeEnvRemapper {
    @Autowired
    private CodeEnvUsagesService codeEnvUsagesService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private MLBaseService mLBaseService;
    protected final ProjectRemappingSettings settings;
    protected final ExportedProject sourceExportedProject;
    protected final AuthCtx authCtx;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.bundles.codeenvs");

    public AbstractCodeEnvRemapper(AuthCtx authCtx, ProjectRemappingSettings settings, ExportedProject sourceExportedProject) {
        this.authCtx = authCtx;
        this.settings = settings;
        this.sourceExportedProject = sourceExportedProject;
        SpringUtils.getInstance().autowire((Object)this);
    }

    public List<InfoMessage> checkRemap(TaggableObjectsService.TaggableObject input) throws IOException, DKUSecurityException {
        HashSet codeEnvs = Sets.newHashSet();
        try {
            for (CodeEnvModel.CodeEnvUsage usage : this.codeEnvUsagesService.listUsages(input)) {
                codeEnvs.add(new CodeEnvModel.UsedCodeEnvRef(usage.envLang, usage.envName));
            }
            return this.checkRemap(codeEnvs, input.getTaggableType().toHumanReadableString() + " " + input.getDisplayName(), false);
        }
        catch (Exception e) {
            ArrayList<InfoMessage> ret = new ArrayList<InfoMessage>();
            ret.add(InfoMessage.warning((String)("Error while checking if a code environment remapping if needed for " + input.getDisplayName()), (String)ExceptionUtils.getMessageWithCauses((Throwable)e)));
            return ret;
        }
    }

    private boolean shouldSkip(CodeEnvModel.UsedCodeEnvRef codeEnv, String objectDescription, boolean failIfNotFound) {
        if (StringUtils.isBlank((String)codeEnv.envName)) {
            logger.infoV("%s uses builtin %s code env, skipping", new Object[]{objectDescription, codeEnv.envLang.name()});
            return true;
        }
        if (!this.sourceExportedProject.usedCodeEnvRefs.contains(codeEnv)) {
            if (!failIfNotFound) {
                logger.infoV("source %s code env %s is not referenced, skipping check", new Object[]{codeEnv.envLang.name(), codeEnv.envName});
                return true;
            }
            throw ErrorContext.iaef((String)"Inconsistent bundle data: %s code env %s not referenced", (Object)codeEnv.envLang.name(), (Object[])new Object[]{codeEnv.envName});
        }
        return false;
    }

    private boolean isAllowedMissing(CodeEnvModel.UsedCodeEnvRef toCheck) {
        for (CodeEnvModel.UsedCodeEnvRef ignorable : this.sourceExportedProject.allowedMissingCodeEnvs) {
            if (!ignorable.equals(toCheck)) continue;
            return true;
        }
        return false;
    }

    private List<InfoMessage> checkRemap(Set<CodeEnvModel.UsedCodeEnvRef> codeEnvs, String objectDescription, boolean failIfNotFound) throws IOException, DKUSecurityException {
        ArrayList<InfoMessage> ret = new ArrayList<InfoMessage>();
        for (CodeEnvModel.UsedCodeEnvRef codeEnv : codeEnvs) {
            if (this.shouldSkip(codeEnv, objectDescription, failIfNotFound)) continue;
            logger.debugV("checkRemap: %s used code env %s at source", new Object[]{objectDescription, codeEnv});
            ProjectRemappingSettings.CodeEnvRemapping remapping = this.settings.getRemappingForCodeEnv(codeEnv);
            if (remapping == null) {
                logger.debug((Object)" code env is not remapped, checking if it exists");
                if (!this.hasCodeEnv(codeEnv)) {
                    if (this.isAllowedMissing(codeEnv)) {
                        logger.infoV(" code env %s is missing, but allowed to be missing", new Object[]{codeEnv});
                        continue;
                    }
                    logger.warnV(" code env %s is missing", new Object[]{codeEnv});
                    ret.add(InfoMessage.fatalV((InfoMessage.MessageCode)BundleCodes.ERR_BUNDLE_ACTIVATE_MISSING_CODE_ENV, (String)"%s code env missing for %s (not remapped): %s ", (Object[])new Object[]{codeEnv.envLang.name(), objectDescription, codeEnv.envName}));
                    continue;
                }
                if (!this.permissionsService.hasAnyCodeEnvAccess(this.authCtx, codeEnv.envLang, codeEnv.envName)) {
                    if (this.isAllowedMissing(codeEnv)) {
                        logger.infoV(" code env %s is forbidden, but allowed to be missing", new Object[]{codeEnv});
                        continue;
                    }
                    logger.warnV(" code env %s is forbidden", new Object[]{codeEnv});
                    ret.add(InfoMessage.fatalV((InfoMessage.MessageCode)BundleCodes.ERR_BUNDLE_ACTIVATE_CODE_ENV_NOT_USABLE, (String)"%s code env not usable for %s (not remapped): %s ", (Object[])new Object[]{codeEnv.envLang.name(), objectDescription, codeEnv.envName}));
                    continue;
                }
                logger.debugV(" non-remapped code env %s is present", new Object[]{codeEnv});
                continue;
            }
            logger.debugV(" codeEnv is remapped to %s", new Object[]{StringUtils.defaultIfBlank((String)remapping.target, (String)"Built-in")});
            if (!StringUtils.isNotBlank((String)remapping.target)) continue;
            CodeEnvModel.UsedCodeEnvRef remappedEnv = new CodeEnvModel.UsedCodeEnvRef(codeEnv.envLang, remapping.target);
            if (!this.hasCodeEnv(remappedEnv)) {
                logger.warnV(" remapped env %s is missing", new Object[]{remappedEnv});
                ret.add(InfoMessage.fatalV((InfoMessage.MessageCode)BundleCodes.ERR_BUNDLE_ACTIVATE_MISSING_CODE_ENV, (String)"%s code env missing for %s (remapped): %s ", (Object[])new Object[]{codeEnv.envLang.name(), objectDescription, remappedEnv.envName}));
                continue;
            }
            if (!this.permissionsService.hasAnyCodeEnvAccess(this.authCtx, codeEnv.envLang, remapping.target)) {
                logger.warnV(" remapped env %s is forbidden", new Object[]{remappedEnv});
                ret.add(InfoMessage.fatalV((InfoMessage.MessageCode)BundleCodes.ERR_BUNDLE_ACTIVATE_MISSING_CODE_ENV, (String)"%s code env not usable for %s : %s ", (Object[])new Object[]{codeEnv.envLang.name(), objectDescription, remapping.target}));
                continue;
            }
            logger.debugV(" remapped code env %s is present and authorized", new Object[]{remappedEnv});
        }
        return ret;
    }

    public boolean remapProject(SerializedProject input) throws IOException, DKUSecurityException {
        Map<CodeEnvModel.UsedCodeEnvRef, CodeEnvModel.UsedCodeEnvRef> replacements;
        String rProjectDefault;
        CodeEnvModel.UsedCodeEnvRef pythonEnv = null;
        CodeEnvModel.UsedCodeEnvRef rEnv = null;
        HashSet codeEnvs = Sets.newHashSet();
        String pythonProjectDefault = new CodeEnvSelector().getProjectDefault(CodeEnvModel.EnvLang.PYTHON, input.settings.codeEnvs);
        if (pythonProjectDefault != null) {
            pythonEnv = new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.PYTHON, pythonProjectDefault);
            codeEnvs.add(pythonEnv);
        }
        if ((rProjectDefault = new CodeEnvSelector().getProjectDefault(CodeEnvModel.EnvLang.R, input.settings.codeEnvs)) != null) {
            rEnv = new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.R, rProjectDefault);
            codeEnvs.add(rEnv);
        }
        if ((replacements = this.remap(codeEnvs, "project " + input.name, false)).size() > 0) {
            CodeEnvModel.UsedCodeEnvRef rCodeEnvReplacement;
            CodeEnvModel.UsedCodeEnvRef pythonCodeEnvReplacement;
            if (pythonEnv != null && null != (pythonCodeEnvReplacement = replacements.get(pythonEnv))) {
                if (StringUtils.isNotBlank((String)pythonCodeEnvReplacement.envName)) {
                    input.settings.codeEnvs.python.mode = CodeEnvSelection.EnvMode.EXPLICIT_ENV;
                    input.settings.codeEnvs.python.envName = pythonCodeEnvReplacement.envName;
                } else {
                    input.settings.codeEnvs.python.mode = CodeEnvSelection.EnvMode.USE_BUILTIN_MODE;
                }
            }
            if (rEnv != null && null != (rCodeEnvReplacement = replacements.get(rEnv))) {
                if (StringUtils.isNotBlank((String)rCodeEnvReplacement.envName)) {
                    input.settings.codeEnvs.r.mode = CodeEnvSelection.EnvMode.EXPLICIT_ENV;
                    input.settings.codeEnvs.r.envName = rCodeEnvReplacement.envName;
                } else {
                    input.settings.codeEnvs.r.mode = CodeEnvSelection.EnvMode.USE_BUILTIN_MODE;
                }
            }
            return true;
        }
        return false;
    }

    public boolean remap(TaggableObjectsService.TaggableObject input) throws IOException, DKUSecurityException {
        List<ParamsWithSelectableCodeEnv> paramsList = this.codeEnvUsagesService.listParamsWithSelectableCodeEnv(input);
        HashSet codeEnvs = Sets.newHashSet();
        for (ParamsWithSelectableCodeEnv params : paramsList) {
            for (CodeEnvModel.CodeEnvUsage usage : params.collectCodeEnvUsage(input)) {
                codeEnvs.add(new CodeEnvModel.UsedCodeEnvRef(usage.envLang, usage.envName));
            }
        }
        Map<CodeEnvModel.UsedCodeEnvRef, CodeEnvModel.UsedCodeEnvRef> replacements = this.remap(codeEnvs, input.getTaggableType().toHumanReadableString() + " " + input.getDisplayName(), false);
        boolean changed = false;
        if (replacements.size() > 0) {
            for (ParamsWithSelectableCodeEnv params : paramsList) {
                List<CodeEnvModel.CodeEnvUsage> usages = params.collectCodeEnvUsage(input);
                if (usages.isEmpty()) {
                    logger.warn((Object)"Params with selectable code env but has no usage, skipping");
                    continue;
                }
                CodeEnvModel.CodeEnvUsage usage = usages.get(0);
                CodeEnvModel.UsedCodeEnvRef oldEnv = new CodeEnvModel.UsedCodeEnvRef(usage.envLang, usage.envName);
                CodeEnvModel.UsedCodeEnvRef newEnv = replacements.get(oldEnv);
                CodeEnvSelection envSelection = params.getCodeEnvSelection();
                this.changeEnvName(envSelection, newEnv.envName);
                params.setCodeEnvSelection(envSelection);
                changed = true;
            }
        }
        return changed;
    }

    public Object remapPayload(SerializedRecipe input) throws IOException, DKUSecurityException {
        RecipeMeta recipeMeta = RecipeRegistry.getMeta(input);
        if (recipeMeta instanceof MetaWithSelectableCodeEnvContainerPayload) {
            List<SelectableCodeEnvContainer> paramsList = this.codeEnvUsagesService.listParamsWithSelectableCodeEnvContainer(input);
            HashSet codeEnvs = Sets.newHashSet();
            for (SelectableCodeEnvContainer params : paramsList) {
                for (ParamsWithSelectableCodeEnv user : params.collectCodeEnvUsers()) {
                    for (CodeEnvModel.CodeEnvUsage usage : user.collectCodeEnvUsage(input)) {
                        codeEnvs.add(new CodeEnvModel.UsedCodeEnvRef(usage.envLang, usage.envName));
                    }
                }
            }
            Map<CodeEnvModel.UsedCodeEnvRef, CodeEnvModel.UsedCodeEnvRef> replacements = this.remap(codeEnvs, input.getTaggableType().toHumanReadableString() + " " + input.getDisplayName(), false);
            SelectableCodeEnvContainer changed = null;
            if (replacements.size() > 0) {
                for (SelectableCodeEnvContainer params : paramsList) {
                    for (ParamsWithSelectableCodeEnv user : params.collectCodeEnvUsers()) {
                        List<CodeEnvModel.CodeEnvUsage> usages = user.collectCodeEnvUsage(input);
                        if (usages.isEmpty()) {
                            logger.warn((Object)"Params with selectable code env but has no usage, skipping");
                            continue;
                        }
                        CodeEnvModel.CodeEnvUsage usage = usages.get(0);
                        CodeEnvModel.UsedCodeEnvRef oldEnv = new CodeEnvModel.UsedCodeEnvRef(usage.envLang, usage.envName);
                        CodeEnvModel.UsedCodeEnvRef newEnv = replacements.get(oldEnv);
                        CodeEnvSelection envSelection = user.getCodeEnvSelection();
                        this.changeEnvName(envSelection, newEnv.envName);
                        user.setCodeEnvSelection(envSelection);
                    }
                    changed = params;
                }
            }
            return changed;
        }
        List<ParamsWithFixedCodeEnv> paramsList = this.codeEnvUsagesService.listParamsWithFixedCodeEnv(input);
        HashSet codeEnvs = Sets.newHashSet();
        for (ParamsWithFixedCodeEnv params : paramsList) {
            for (CodeEnvModel.CodeEnvUsage usage : params.collectCodeEnvUsage(input)) {
                codeEnvs.add(new CodeEnvModel.UsedCodeEnvRef(usage.envLang, usage.envName));
            }
        }
        Map<CodeEnvModel.UsedCodeEnvRef, CodeEnvModel.UsedCodeEnvRef> replacements = this.remap(codeEnvs, input.getTaggableType().toHumanReadableString() + " " + input.getDisplayName(), false);
        ParamsWithFixedCodeEnv changed = null;
        if (replacements.size() > 0) {
            for (ParamsWithFixedCodeEnv params : paramsList) {
                List<CodeEnvModel.CodeEnvUsage> usages = params.collectCodeEnvUsage(input);
                if (usages.isEmpty()) {
                    logger.warn((Object)"Params with selectable code env but has no usage, skipping");
                    continue;
                }
                CodeEnvModel.CodeEnvUsage usage = usages.get(0);
                CodeEnvModel.UsedCodeEnvRef oldEnv = new CodeEnvModel.UsedCodeEnvRef(usage.envLang, usage.envName);
                CodeEnvModel.UsedCodeEnvRef newEnv = (CodeEnvModel.UsedCodeEnvRef)replacements.get(oldEnv);
                params.setCodeEnvName(newEnv.envName);
                changed = params;
            }
        }
        return changed;
    }

    public boolean remap(AnalysisCoreParams acp, MLTask input) throws IOException, DKUSecurityException {
        List<CodeEnvModel.CodeEnvUsage> usages;
        HashSet codeEnvs = Sets.newHashSet();
        for (CodeEnvModel.CodeEnvUsage usage : input.collectCodeEnvUsage(acp)) {
            codeEnvs.add(new CodeEnvModel.UsedCodeEnvRef(usage.envLang, usage.envName));
        }
        Map<CodeEnvModel.UsedCodeEnvRef, CodeEnvModel.UsedCodeEnvRef> replacements = this.remap(codeEnvs, acp.getTaggableType().toHumanReadableString() + " " + acp.getDisplayName(), false);
        boolean changed = false;
        if (replacements.size() > 0 && !(usages = input.collectCodeEnvUsage(acp)).isEmpty()) {
            CodeEnvModel.CodeEnvUsage usage = usages.get(0);
            CodeEnvModel.UsedCodeEnvRef oldEnv = new CodeEnvModel.UsedCodeEnvRef(usage.envLang, usage.envName);
            CodeEnvModel.UsedCodeEnvRef newEnv = replacements.get(oldEnv);
            CodeEnvSelection envSelection = input.getCodeEnvSelection();
            this.changeEnvName(envSelection, newEnv.envName);
            input.setCodeEnvSelection(envSelection);
            changed = true;
        }
        return changed;
    }

    public boolean remapTrainedModels(AnalysisCoreParams acp, MLTask mlTask) throws IOException, DKUSecurityException {
        MLTaskLoc loc = new MLTaskLoc(acp.projectKey, acp.id, mlTask.id);
        boolean remap = false;
        for (FullModelId fmi : this.mLBaseService.listCompletedModelIds(loc)) {
            if (!this.remapFmi(acp, fmi)) continue;
            remap = true;
        }
        return remap;
    }

    public boolean remapSavedModels(SavedModel sm) throws IOException, DKUSecurityException {
        boolean remap = false;
        for (FullModelId fmi : this.codeEnvUsagesService.listFmisInSavedModel(sm)) {
            if (!this.remapFmi(sm, fmi)) continue;
            remap = true;
        }
        return remap;
    }

    private boolean remapFmi(TaggableObjectsService.TaggableObject object, FullModelId fmi) throws IOException, DKUSecurityException {
        HashSet codeEnvs = Sets.newHashSet();
        for (CodeEnvModel.CodeEnvUsage usage : fmi.collectCodeEnvUsage(CodeEnvModel.EnvUsage.MODEL)) {
            codeEnvs.add(new CodeEnvModel.UsedCodeEnvRef(usage.envLang, usage.envName));
        }
        Map<CodeEnvModel.UsedCodeEnvRef, CodeEnvModel.UsedCodeEnvRef> replacements = this.remap(codeEnvs, object.getTaggableType().toHumanReadableString() + " " + object.getDisplayName(), false);
        boolean changed = false;
        if (replacements.size() > 0) {
            changed = true;
            if (fmi.isExternalMLflowModelVersion()) {
                MLFlowModelVersionInfo mim = fmi.getMLflowImportedModelMetadata();
                CodeEnvModel.UsedCodeEnvRef oldEnv = new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.PYTHON, mim.pythonCodeEnvName);
                CodeEnvModel.UsedCodeEnvRef newEnv = replacements.get(oldEnv);
                mim.pythonCodeEnvName = newEnv.envName;
                fmi.writeMLflowImportedModelMetadata(mim);
            } else {
                ResolvedCoreParams rcp = fmi.getResolvedCoreParams();
                CodeEnvModel.UsedCodeEnvRef oldEnv = new CodeEnvModel.UsedCodeEnvRef(CodeEnvModel.EnvLang.PYTHON, rcp.executionParams.envName);
                CodeEnvModel.UsedCodeEnvRef newEnv = replacements.get(oldEnv);
                rcp.executionParams.envName = newEnv.envName;
                if (CodeEnvSelection.EnvMode.EXPLICIT_ENV.equals(rcp.executionParams.envSelection.envMode)) {
                    rcp.executionParams.envSelection.envName = newEnv.envName;
                }
                JSON.prettyToFile((Object)rcp, (File)fmi.getSessionFile("core_params.json"));
                if (fmi.type == FullModelId.Type.ANALYSIS) {
                    MLTask trainedTask = fmi.parseSessionFile("mltask.json", MLTask.class);
                    if (CodeEnvSelection.EnvMode.EXPLICIT_ENV.equals(trainedTask.envSelection.envMode)) {
                        trainedTask.envSelection.envName = newEnv.envName;
                    }
                    JSON.prettyToFile((Object)trainedTask, (File)fmi.getSessionFile("mltask.json"));
                }
            }
        }
        return changed;
    }

    private void changeEnvName(CodeEnvSelection selection, String envName) {
        if (StringUtils.isNotBlank((String)envName)) {
            selection.envName = envName;
        } else {
            selection.envMode = CodeEnvSelection.EnvMode.USE_BUILTIN_MODE;
        }
    }

    public boolean remapNotebook(String name, JsonObject input) throws IOException, DKUSecurityException {
        Map<CodeEnvModel.UsedCodeEnvRef, CodeEnvModel.UsedCodeEnvRef> replacements;
        CodeEnvModel.UsedCodeEnvRef env = null;
        JupyterCodeEnvUtils.NotebookCodeEnvInfo kernelInfo = JupyterCodeEnvUtils.getCodeEnvInfoFromNotebook(input);
        if (kernelInfo != null && kernelInfo.envLang != null) {
            env = new CodeEnvModel.UsedCodeEnvRef(kernelInfo.envLang, kernelInfo.envName);
        }
        HashSet codeEnvs = Sets.newHashSet();
        if (env != null) {
            codeEnvs.add(env);
        }
        if ((replacements = this.remap(codeEnvs, "notebook " + name, false)).size() > 0) {
            CodeEnvModel.UsedCodeEnvRef nEnv = replacements.get(env);
            if (StringUtils.isNotBlank((String)nEnv.envName)) {
                JupyterCodeEnvUtils.NotebookCodeEnvInfo info = JupyterCodeEnvUtils.getCodeEnvInfoFromNotebook(input);
                info.envLang = nEnv.envLang;
                info.envName = nEnv.envName;
                JupyterCodeEnvUtils.setKernelNameInNotebook(input, JupyterCodeEnvUtils.getKernelName(info.envLang, info.envName, info.projectKey, info.bundleId, info.containerConf));
                JupyterCodeEnvUtils.setDisplayNameInNotebook(input, JupyterCodeEnvUtils.getDisplayName(info.envLang, info.envName, info.projectKey, info.bundleId, info.containerConf));
            } else {
                JupyterCodeEnvUtils.setKernelNameInNotebook(input, "");
                JupyterCodeEnvUtils.setDisplayNameInNotebook(input, "Python 2");
            }
            return true;
        }
        return false;
    }

    private Map<CodeEnvModel.UsedCodeEnvRef, CodeEnvModel.UsedCodeEnvRef> remap(Set<CodeEnvModel.UsedCodeEnvRef> codeEnvs, String objectDescription, boolean failIfNoSource) throws IOException, DKUSecurityException {
        HashMap<CodeEnvModel.UsedCodeEnvRef, CodeEnvModel.UsedCodeEnvRef> replacements = new HashMap<CodeEnvModel.UsedCodeEnvRef, CodeEnvModel.UsedCodeEnvRef>();
        for (CodeEnvModel.UsedCodeEnvRef codeEnv : codeEnvs) {
            CodeEnvModel.UsedCodeEnvRef source;
            if (StringUtils.isBlank((String)codeEnv.envName)) {
                logger.infoV("%s uses builtin %s code env, skipping", new Object[]{objectDescription, codeEnv.envLang.name()});
                continue;
            }
            CodeEnvModel.UsedCodeEnvRef usedCodeEnvRef = source = this.sourceExportedProject.usedCodeEnvRefs.contains(codeEnv) ? codeEnv : null;
            if (source == null && failIfNoSource) {
                throw ErrorContext.iaef((String)"Inconsistent bundle data: %s code env %s not referenced", (Object)codeEnv.envLang.name(), (Object[])new Object[]{codeEnv.envName});
            }
            logger.infoV("%s uses source %s code env %s", new Object[]{objectDescription, codeEnv.envLang.name(), codeEnv.envName});
            ProjectRemappingSettings.CodeEnvRemapping remapping = this.settings.getRemappingForCodeEnv(codeEnv);
            if (remapping == null) {
                logger.infoV("source is not remapped, checking it", new Object[0]);
                if (!this.hasCodeEnv(codeEnv)) {
                    if (this.isAllowedMissing(codeEnv)) {
                        logger.infoV(" code env %s is missing, but allowed to be missing", new Object[]{codeEnv});
                        continue;
                    }
                    logger.warnV(" code env %s is missing", new Object[]{codeEnv});
                    throw ErrorContext.iaef((String)"No %s code env for %s", (Object)((Object)codeEnv.envLang), (Object[])new Object[]{codeEnv.envName});
                }
                if (!this.permissionsService.hasAnyCodeEnvAccess(this.authCtx, codeEnv.envLang, codeEnv.envName)) {
                    if (this.isAllowedMissing(codeEnv)) {
                        logger.infoV(" code env %s is forbidden, but allowed to be missing => remap to non existing", new Object[]{codeEnv});
                        replacements.put(codeEnv, new CodeEnvModel.UsedCodeEnvRef(codeEnv.envLang, "__dku_forbidden__" + codeEnv.envName));
                        continue;
                    }
                    logger.warnV(" code env %s is forbidden", new Object[]{codeEnv});
                    throw ErrorContext.iaef((String)"%s code env %s is not usable", (Object)((Object)codeEnv.envLang), (Object[])new Object[]{codeEnv.envName});
                }
                logger.infoV("Using %s code env %s", new Object[]{codeEnv.envLang, codeEnv.envName});
                continue;
            }
            logger.infoV("Remapped to %s", new Object[]{StringUtils.defaultIfBlank((String)remapping.target, (String)"Built-in")});
            if (StringUtils.isBlank((String)remapping.target)) {
                replacements.put(codeEnv, new CodeEnvModel.UsedCodeEnvRef(codeEnv.envLang, null));
                continue;
            }
            CodeEnvModel.UsedCodeEnvRef remappedEnv = new CodeEnvModel.UsedCodeEnvRef(codeEnv.envLang, remapping.target);
            if (!this.hasCodeEnv(remappedEnv)) {
                throw ErrorContext.iaef((String)"No %s code env %s for remapping %s", (Object)((Object)codeEnv.envLang), (Object[])new Object[]{remapping.target, codeEnv.envName});
            }
            if (!this.permissionsService.hasAnyCodeEnvAccess(this.authCtx, codeEnv.envLang, remapping.target)) {
                throw ErrorContext.iaef((String)"%s code env %s is not usable for remapping %s", (Object)((Object)codeEnv.envLang), (Object[])new Object[]{remapping.target, codeEnv.envName});
            }
            logger.infoV("Remapping %s code env %s to %s", new Object[]{codeEnv.envLang, codeEnv.envName, remapping.target});
            replacements.put(codeEnv, remappedEnv);
        }
        return replacements;
    }

    protected abstract boolean hasCodeEnv(CodeEnvModel.UsedCodeEnvRef var1) throws IOException;
}

