/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport;

import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RetrievableKnowledgeConnectionsUtils {
    private RetrievableKnowledgeConnectionsUtils() {
    }

    public static Set<String> listConnectionNames(RetrievableKnowledge retrievableKnowledge) {
        HashSet<String> connections = new HashSet<String>();
        if (retrievableKnowledge.embeddingLLMId != null) {
            LLMStructuredRef ref = LLMStructuredRef.decodeId(retrievableKnowledge.embeddingLLMId);
            if (ref.connection != null) {
                connections.add(ref.connection);
            }
        }
        if (!Strings.isNullOrEmpty((String)retrievableKnowledge.connection)) {
            connections.add(retrievableKnowledge.connection);
        }
        return connections;
    }

    private static void remapEmbeddingLlm(RetrievableKnowledge retrievableKnowledge, Map<String, String> replacements) {
        if (retrievableKnowledge.embeddingLLMId == null) {
            return;
        }
        LLMStructuredRef ref = LLMStructuredRef.decodeId(retrievableKnowledge.embeddingLLMId);
        if (ref.connection == null) {
            return;
        }
        String newConnection = replacements.get(ref.connection);
        if (newConnection != null) {
            ref.setConnection(newConnection);
            retrievableKnowledge.embeddingLLMId = ref.encodeToId();
        }
    }

    public static void remapMainConnection(RetrievableKnowledge retrievableKnowledge, Map<String, String> replacements) {
        if (retrievableKnowledge.connection == null) {
            return;
        }
        String newConnection = replacements.get(retrievableKnowledge.connection);
        if (newConnection != null) {
            retrievableKnowledge.connection = newConnection;
        }
    }

    public static void remapConnections(RetrievableKnowledge retrievableKnowledge, Map<String, String> replacements) {
        RetrievableKnowledgeConnectionsUtils.remapEmbeddingLlm(retrievableKnowledge, replacements);
        RetrievableKnowledgeConnectionsUtils.remapMainConnection(retrievableKnowledge, replacements);
    }
}

