/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.sql;

import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.connections.SQLDriverLoader;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datalayer.utils.SchemaComparator;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.SchemaUtils;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopConfig;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.queries.QueryRunResult;
import com.dataiku.dip.queries.SQLQueryRuntime;
import com.dataiku.dip.recipes.ParamsWithVariablesExpansionLoopConfig;
import com.dataiku.dip.recipes.code.sql.SQLQueryRecipeUtils;
import com.dataiku.dip.recipes.consistency.BasicRecipeConsistencyChecker;
import com.dataiku.dip.recipes.consistency.MiscStuffChecker;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.recipes.PreprocessedQueryForSubstitution;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.recipes.RecipeVariablesHelper;
import com.dataiku.dip.server.services.SingleWriteTransactionTransactionService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.spark.FlowDatasetRef;
import com.dataiku.dip.spark.SparkJobExecEnv;
import com.dataiku.dip.sql.RedshiftSQLDialect;
import com.dataiku.dip.sql.SchemaReader;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.utils.Params;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSQLQueryRecipeTester {
    @Autowired
    protected DatasetsDAO datasetsDAO;
    @Autowired
    protected DatasetAccessService datasetAccessService;
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    protected GenericRecipesValidationService validationService;
    protected static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.sql");

    protected abstract boolean willRunInFullSQL(AuthCtx var1, String var2, Dataset var3, String var4, SerializedRecipe var5);

    protected abstract String getSQLDatasetConnectionName(AuthCtx var1, Dataset var2);

    protected abstract boolean checkConnectionsMismatch(Set<String> var1, SerializedRecipe var2);

    protected abstract String getMainConnection(SerializedRecipe var1, AuthCtx var2) throws IOException;

    protected abstract SQLConnectionProvider.SQLConnectionData getConnectionDataFromConnection_NT(AuthCtx var1, String var2, String var3) throws IOException, DKUSecurityException, SQLException;

    protected abstract String getRecipeType();

    protected abstract String getRecipeDisplayName();

    protected abstract void validateSourceDatasets(List<Dataset> var1, AuthCtx var2) throws IllegalArgumentException;

    public static RecipeSchemaService.RecipeSchemaAutoupdateResult getSchemaResult_NT(AuthCtx authCtx, Dataset targetDataset, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper jdbcConn, String sqlQuery) throws Exception {
        return AbstractSQLQueryRecipeTester.getSchemaResult_NT(authCtx, targetDataset, connData, jdbcConn, sqlQuery, null);
    }

    public static RecipeSchemaService.RecipeSchemaAutoupdateResult getSchemaResult_NT(AuthCtx authCtx, Dataset targetDataset, SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper jdbcConn, String sqlQuery, String[] sqlStatements) throws Exception {
        AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS;
        AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.AS_IS;
        if (targetDataset.getTypeSystemVersion() == SerializedDataset.TypeSystemVersion.V1) {
            dateonlyReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE;
            datetimenotzReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.AS_STRING;
            if (connData != null && connData.getDialect() instanceof RedshiftSQLDialect) {
                boolean useOldStyle = true;
                if (connData.getConnection() != null) {
                    Params params = connData.getConnection().getDkuPropertiesAsParams();
                    useOldStyle = params.getBoolParam("dku.useTimestampForDatetimeTz", useOldStyle);
                }
                if (useOldStyle = targetDataset.getDkuPropertiesAsParams().getBoolParam("dku.useTimestampForDatetimeTz", useOldStyle)) {
                    datetimenotzReadMode = AbstractSQLDatasetHandler.ReadTemporalMode.AS_DATE;
                }
            }
        }
        Schema querySchema = SchemaReader.getQuerySchema(authCtx, connData, jdbcConn, sqlQuery, sqlStatements, datetimenotzReadMode, dateonlyReadMode, targetDataset.getSchema());
        if (targetDataset.getPartitioningSchema().isPartitioned() && DatasetInspector.isSQLTable(targetDataset)) {
            FatalPartitioningError fpe;
            HashMap partitioningColumnIndicesInDataset = Maps.newHashMap();
            ArrayList missingInDataset = Lists.newArrayList();
            for (String dimensionName : targetDataset.getPartitioningSchema().getDimensionNames()) {
                Integer i = targetDataset.getSchema().getColumnIndex(dimensionName);
                if (i == null) {
                    missingInDataset.add(dimensionName);
                    continue;
                }
                partitioningColumnIndicesInDataset.put(dimensionName, i);
            }
            if (!missingInDataset.isEmpty()) {
                throw ErrorContext.iaef((String)"Dataset '%s' is partitioned on columns '%s' but they don't appear in the schema (it must already be in the schema before validating)", (Object)targetDataset.getFullName(), (Object[])new Object[]{Joiner.on((String)",").join((Iterable)missingInDataset)});
            }
            HashMap partitioningColumnIndicesInQuery = Maps.newHashMap();
            ArrayList missingInQuery = Lists.newArrayList();
            ArrayList differentPositionInQuery = Lists.newArrayList();
            for (String dimensionName : targetDataset.getPartitioningSchema().getDimensionNames()) {
                Integer i = querySchema.getColumnIndex(dimensionName);
                if (i == null) {
                    missingInQuery.add(dimensionName);
                    continue;
                }
                if (!i.equals(partitioningColumnIndicesInDataset.get(dimensionName))) {
                    differentPositionInQuery.add(dimensionName);
                    continue;
                }
                partitioningColumnIndicesInQuery.put(dimensionName, i);
            }
            if (!missingInQuery.isEmpty()) {
                fpe = new FatalPartitioningError();
                for (String dimensionName : missingInQuery) {
                    fpe.columns.add(new FatalPartitioningErrorColumn(dimensionName, (Integer)partitioningColumnIndicesInDataset.get(dimensionName), null));
                }
                throw fpe;
            }
            if (!differentPositionInQuery.isEmpty()) {
                fpe = new FatalPartitioningError();
                for (String dimensionName : differentPositionInQuery) {
                    int idx = (Integer)partitioningColumnIndicesInDataset.get(dimensionName);
                    fpe.columns.add(new FatalPartitioningErrorColumn(dimensionName, idx, ((SchemaColumn)querySchema.getColumns().get(idx)).getName()));
                }
                throw fpe;
            }
        }
        RecipeSchemaService.RecipeSchemaAutoupdateResult ret = new RecipeSchemaService.RecipeSchemaAutoupdateResult();
        SchemaUtils.fixupImplicitColumns(connData.getConnection().type, querySchema);
        List<String> incompatibilities = SchemaComparator.findIncompatibilities(targetDataset.getSchema(), querySchema, true);
        if (!incompatibilities.isEmpty()) {
            RecipeSchemaService.ComputableSchemaAutoupdateResult dsRet = RecipeSchemaService.ComputableSchemaAutoupdateResult.forDataset();
            dsRet.datasetName = targetDataset.getName();
            if (targetDataset.getSchema().columns.isEmpty()) {
                dsRet.previousSchemaWasEmpty = true;
            }
            dsRet.incompatibilities = incompatibilities;
            dsRet.newSchema = querySchema;
            dsRet.isPartitioned = targetDataset.getPartitioningSchema().isPartitioned();
            dsRet.isHDFS = DatasetInspector.canHDFS(targetDataset);
            ++ret.totalIncompatibilities;
            ret.computables.add(dsRet);
        }
        return ret;
    }

    public Collection<String> getInputConnections(AuthCtx authCtx, SerializedRecipe recipe) throws IOException {
        HashSet conns = Sets.newHashSet();
        for (SerializedRecipe.RecipeInput source : recipe.getInputsForRole("main")) {
            String connection;
            Dataset sourceDS = this.datasetAccessService.getOrNull(DatasetLocUtils.resolveSmart(recipe.projectKey, source.ref));
            if (sourceDS == null || (connection = this.getSQLDatasetConnectionName(authCtx, sourceDS)) == null) continue;
            conns.add(connection);
        }
        return conns;
    }

    private Callable<SQLRecipeValidationResult> getNoopCallable(SQLRecipeValidationResult ret) {
        return () -> ret;
    }

    public Callable<SQLRecipeValidationResult> startValidate_NT(SerializedRecipe _recipe, String sqlQuery, boolean run, String targetPartitionSpec, AuthCtx liu) throws Exception {
        Dataset targetDataset;
        SQLConnectionProvider.SQLConnectionData cd;
        SingleWriteTransactionTransactionService.DetransactionalizedCallable<RecipeRunnableSubgraph> subgraphCallable;
        String mainConnection;
        SerializedRecipe recipe = (SerializedRecipe)JSON.deepCopy((Object)_recipe);
        SQLQueryValidationResult ret = new SQLQueryValidationResult();
        assert (recipe.type.equals(this.getRecipeType()));
        try (Transaction t = this.transactionService.beginRead();){
            new BasicRecipeConsistencyChecker(recipe).check(ret.messages);
            new MiscStuffChecker(recipe).check(ret.messages, liu, recipe.projectKey);
            if (ret.messages.anyFatal()) {
                Callable<SQLRecipeValidationResult> callable = this.getNoopCallable(ret);
                return callable;
            }
            try {
                this.validateOutputs(recipe.getOutputsForRole("main"));
                this.validateQuery(sqlQuery);
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                ret.messages.withFatal((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, e.getMessage());
                Callable<SQLRecipeValidationResult> callable = this.getNoopCallable(ret);
                if (t != null) {
                    t.close();
                }
                return callable;
            }
            List<Dataset> sourceDatasets = SQLQueryRecipeUtils.getSourceDatasets(recipe);
            try {
                this.validateSourceDatasets(sourceDatasets, liu);
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                ret.messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, e.getMessage(), new Object[0]);
                Callable<SQLRecipeValidationResult> callable = this.getNoopCallable(ret);
                if (t != null) {
                    t.close();
                }
                return callable;
            }
            SQLQueryRecipeUtils.SQLConnections sourceConnections = new SQLQueryRecipeUtils.SQLConnections();
            for (Dataset dataset : sourceDatasets) {
                String sourceDSConnection = this.getSQLDatasetConnectionName(liu, dataset);
                sourceConnections.add(sourceDSConnection);
            }
            if (this.checkConnectionsMismatch(sourceConnections.connections, recipe)) {
                ret.messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "%s cannot use multiple connections (%s)", new Object[]{this.getRecipeDisplayName(), Joiner.on((String)", ").join(sourceConnections.connections)});
                Callable<SQLRecipeValidationResult> callable = this.getNoopCallable(ret);
                return callable;
            }
            try {
                mainConnection = this.getMainConnection(recipe, liu);
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                ret.messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_RECIPE, e.getMessage(), new Object[0]);
                Callable<SQLRecipeValidationResult> callable = this.getNoopCallable(ret);
                if (t != null) {
                    t.close();
                }
                return callable;
            }
            logger.info((Object)("SQL: mainConnection is " + mainConnection));
            if (mainConnection == null) {
                Callable<SQLRecipeValidationResult> e = this.getNoopCallable(ret);
                return e;
            }
            SQLQueryRecipeUtils.checkConnectionUsability(sourceConnections.connections, liu);
            SQLQueryRecipeUtils.checkConnectionUsability(Collections.singleton(mainConnection), liu);
            if (!ret.messages.anyFatal()) {
                ret.messages.mergeFrom(this.getFullSqlRecommendation(recipe, mainConnection));
            }
            recipe.name = "testRecipe";
            FlowGraph graph = new FlowGraph();
            FlowRecipe flowRecipe = graph.buildSingleRecipe(recipe);
            subgraphCallable = this.validationService.getValidationRunnableSubgraph(liu, flowRecipe, targetPartitionSpec);
        }
        try {
            cd = this.getConnectionDataFromConnection_NT(liu, recipe.projectKey, mainConnection);
        }
        catch (Exception e) {
            ret.messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Connection configuration error: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            return this.getNoopCallable(ret);
        }
        RecipeRunnableSubgraph subgraph = subgraphCallable.call_NT();
        PreprocessedQueryForSubstitution preprocessedQuery = PreprocessedQueryForSubstitution.preprocess_NT(sqlQuery, cd.getDialect());
        RecipeVariablesHelper.RecipeSubstitutionVariablesResult recipeSubstitutionVariablesResult = this.getRecipeVariablesSubstitutes(preprocessedQuery, liu, recipe, cd, subgraph);
        ret.messages.mergeFrom(recipeSubstitutionVariablesResult.messages);
        ret.substitutionVariables = recipeSubstitutionVariablesResult.substitutionVariables;
        if (!recipeSubstitutionVariablesResult.checkSubstitutionError(ret.messages)) {
            return this.getNoopCallable(ret);
        }
        sqlQuery = recipeSubstitutionVariablesResult.substituted;
        String[] sqlStatements = (String[])recipeSubstitutionVariablesResult.substitutedAndSplit.first;
        Transaction t = this.transactionService.beginRead();
        try {
            targetDataset = this.datasetAccessService.getOrNull(DatasetLocUtils.resolveSmart(recipe.projectKey, recipe.getSingleOutput((String)"main").ref));
            try {
                boolean fullSql = this.willRunInFullSQL(liu, mainConnection, targetDataset, sqlQuery, recipe);
                logger.info((Object)("The recipe is expected to run in " + (fullSql ? "full sql" : "stream") + " mode"));
            }
            catch (Exception ex) {
                ret.messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Connection configuration error: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)ex)});
                Callable<SQLRecipeValidationResult> callable = this.getNoopCallable(ret);
                if (t != null) {
                    t.close();
                }
                return callable;
            }
            ret.configOK = true;
        }
        finally {
            if (t != null) {
                try {
                    t.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
        return this.generateConnectionTest(sqlQuery, sqlStatements, run, liu, recipe, ret, cd, mainConnection, targetDataset);
    }

    @VisibleForTesting
    protected RecipeVariablesHelper.RecipeSubstitutionVariablesResult getRecipeVariablesSubstitutes(PreprocessedQueryForSubstitution preprocessedQuery, AuthCtx liu, SerializedRecipe recipe, SQLConnectionProvider.SQLConnectionData cd, RecipeRunnableSubgraph subgraph) throws IOException, CodedException, DKUSecurityException {
        VariablesExpansionLoopConfig veLoopConfig = null;
        if (recipe.params instanceof ParamsWithVariablesExpansionLoopConfig) {
            veLoopConfig = ((ParamsWithVariablesExpansionLoopConfig)((Object)recipe.params)).getVariablesExpansionLoopConfig();
        }
        return new RecipeVariablesHelper().getRecipeVariablesAndSubstitute(liu, recipe.projectKey, subgraph, preprocessedQuery, veLoopConfig);
    }

    @VisibleForTesting
    protected Callable<SQLRecipeValidationResult> generateConnectionTest(String sqlQuery, final String[] sqlStatements, final boolean run, final AuthCtx liu, final SerializedRecipe recipe, final SQLQueryValidationResult ret, SQLConnectionProvider.SQLConnectionData cd, String mainConnection, Dataset targetDataset) {
        SQLConnectionProvider.SQLConnectionWrapper jdbcConn;
        final Dataset fTargetDataset = targetDataset;
        final String fMainConnection = mainConnection;
        final String fSQLQuery = sqlQuery;
        final SQLConnectionProvider.SQLConnectionData fCD = cd;
        try {
            jdbcConn = this.getJdbcConnection(liu, recipe.projectKey, cd);
            ret.driverOK = true;
        }
        catch (CodedSQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            ret.messages.withFatalV(e.getCode(), ExceptionUtils.getMessageWithCauses((Throwable)e), new Object[0]);
            return this.getNoopCallable(ret);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to connect to database", (Throwable)e);
            ret.messages.withFatalV((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_VALIDATION_FAILED, "Failed to connect: %s", new Object[]{ExceptionUtils.getMessageWithCauses((Throwable)e)});
            return this.getNoopCallable(ret);
        }
        final SQLConnectionProvider.SQLConnectionWrapper fJDBCConn = jdbcConn;
        ret.connectionOK = true;
        logger.info((Object)("Substituted query: " + sqlQuery));
        ret.substitutedQuery = sqlQuery;
        return new Callable<SQLRecipeValidationResult>(){

            /*
             * Exception decompiling
             */
            @Override
            public SQLRecipeValidationResult call() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private static /* synthetic */ void lambda$call$0(SQLQueryRuntime sqr) {
                try {
                    sqr.cancel();
                }
                catch (SQLException e) {
                    logger.error((Object)"Failed to cancel a query", (Throwable)e);
                }
            }
        };
    }

    private SQLConnectionProvider.SQLConnectionWrapper getJdbcConnection(AuthCtx liu, String projectKey, SQLConnectionProvider.SQLConnectionData sqlConnectionData) throws SQLException, DKUSecurityException, InterruptedException {
        String driverClass = sqlConnectionData.getDriver(liu, projectKey);
        if (driverClass != null) {
            SQLDriverLoader.loadDriver(driverClass, sqlConnectionData.getJarsDirectory(), sqlConnectionData.getJarsFallThroughPackages(), sqlConnectionData.getJarsNonFallThroughPackages());
        }
        return SQLConnectionProvider.newConnection(sqlConnectionData, liu, projectKey);
    }

    protected abstract InfoMessage.InfoMessages getFullSqlRecommendation(SerializedRecipe var1, String var2) throws IOException;

    protected void validateOutputs(List<SerializedRecipe.RecipeOutput> outputs) throws IllegalArgumentException {
        if (outputs.size() != 1) {
            throw ErrorContext.iaef((String)"Recipe %s must have exactly 1 output", (Object)this.getRecipeDisplayName(), (Object[])new Object[0]);
        }
    }

    protected void validateQuery(String sqlQuery) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)sqlQuery)) {
            throw ErrorContext.iaef((String)"Recipe %s is empty", (Object)this.getRecipeDisplayName(), (Object[])new Object[0]);
        }
    }

    public static class FatalPartitioningError
    extends Exception {
        private static final long serialVersionUID = 1L;
        public final List<FatalPartitioningErrorColumn> columns = Lists.newArrayList();

        public String describe() {
            ArrayList columnDescriptions = Lists.newArrayList();
            for (FatalPartitioningErrorColumn column : this.columns) {
                columnDescriptions.add(column.describe());
            }
            return Joiner.on((String)";").join((Iterable)columnDescriptions);
        }
    }

    public static class FatalPartitioningErrorColumn {
        public final String partitioningColumn;
        public final int expectedPosition;
        public final String foundInstead;

        public FatalPartitioningErrorColumn(String partitioningColumn, int expectedPosition, String foundInstead) {
            this.partitioningColumn = partitioningColumn;
            this.expectedPosition = expectedPosition;
            this.foundInstead = foundInstead;
        }

        public String describe() {
            return String.format("Partitioning column '%s' MUST appear in the query,in position %s , but this column was '%s' instead", this.partitioningColumn, this.expectedPosition + 1, this.foundInstead);
        }
    }

    public static abstract class SQLRecipeValidationResult {
        public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        public LinkedHashMap<String, RecipeVariablesHelper.AvailableVariable> substitutionVariables;
        public String substitutedQuery;
        public boolean configOK;
        public String configErrorMessage;
        public boolean driverOK;
        public String driverErrorMsg;
        public boolean connectionOK;
        public String connectionErrorMsg;
    }

    public static class SQLQueryValidationResult
    extends SQLRecipeValidationResult {
        public RecipeSchemaService.RecipeSchemaAutoupdateResult schemaResult;
        public QueryRunResult runResult;
    }

    public static class SQLRecipeValidationRequest {
        public SerializedRecipe serializedRecipe;
        public Pair<String[], Integer[]> sqlStatementsAndOffsets;
        public String apiTicket;
        public List<FlowDatasetRef> inputRefs = new ArrayList<FlowDatasetRef>();
        public SparkJobExecEnv execEnv = new SparkJobExecEnv();
    }

    public static class SQLQuerySimpleValidationResult
    extends SQLRecipeValidationResult {
        public Schema queryResultSchema;
    }
}

