/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda.stats;

import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.common.MultiComputation;
import com.dataiku.dip.eda.compute.computations.univariate.TTest1Samp;
import com.dataiku.dip.eda.compute.computations.univariate.ZTest1Samp;
import com.dataiku.dip.eda.compute.stats.AlternativeHypothesis;
import com.dataiku.dip.eda.worksheets.cards.fragments.BoxPlotFragment;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParams;
import com.dataiku.dip.recipes.eda.StatsTestRecipePayloadParamsWithAlternativeHypothesis;
import com.dataiku.dip.recipes.eda.stats.AbstractTestStat;
import com.dataiku.dip.recipes.eda.stats.OneSampleTTestRecipePayloadParams;
import com.dataiku.dip.utils.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;

public class OneSampleTTestStat
extends AbstractTestStat {
    private static final String ONE_SAMPLE_T_TEST = "T_TEST_ONE_SAMPLE";
    private static final String ONE_SAMPLE_Z_TEST = "Z_TEST_ONE_SAMPLE";
    public String column;
    public double hypothesizedMean = 0.0;
    @Nullable
    public Double knownStdDev;

    public OneSampleTTestStat(String column, double hypothesizedMean, @Nullable Double knownStdDev) {
        this.column = column;
        this.hypothesizedMean = hypothesizedMean;
        this.knownStdDev = knownStdDev;
    }

    public OneSampleTTestStat() {
    }

    @Override
    public MultiComputation getComputationPlan(StatsTestRecipePayloadParams<?> payloadParams) {
        ArrayList<Computation> tests = new ArrayList<Computation>();
        for (AlternativeHypothesis alternative : payloadParams.as(OneSampleTTestRecipePayloadParams.class).getAlternatives()) {
            Computation.UnivariateComputation test = this.knownStdDev == null ? new TTest1Samp(this.column, this.hypothesizedMean, alternative, payloadParams.confidenceLevel) : new ZTest1Samp(this.column, this.hypothesizedMean, this.knownStdDev, alternative, payloadParams.confidenceLevel);
            tests.add(test);
        }
        return new MultiComputation(BoxPlotFragment.getComputationPlan(this.column), new MultiComputation(tests));
    }

    @Override
    protected void fillTestParams(Row row, ColumnFactory cf) {
        if (this.knownStdDev == null) {
            row.put(cf.column("test"), ONE_SAMPLE_T_TEST);
        } else {
            row.put(cf.column("test"), ONE_SAMPLE_Z_TEST);
            row.put(cf.column("known_std_dev"), this.knownStdDev.doubleValue());
        }
        row.put(cf.column("variable"), this.column);
        row.put(cf.column("hypothesized_mean"), this.hypothesizedMean);
    }

    @Override
    public List<Row> extractRows(ComputationResult result, StatsTestRecipePayloadParams<?> payloadParams, ColumnFactory cf, RowFactory rf) {
        double significanceLevel = payloadParams.significanceLevel();
        List<String> warnings = result.collectWarnings();
        Collection<String> errors = result.collectErrors();
        if (!result.isAvailable()) {
            Row row = this.rowBase(significanceLevel, warnings, errors, cf, rf);
            return Collections.singletonList(row);
        }
        MultiComputation.MultiComputationResult mcr = result.asMulti();
        ComputationResult boxPlotResult = mcr.get(0);
        List<String> boxPlotWarnings = boxPlotResult.collectWarnings();
        Collection<String> boxPlotErrors = boxPlotResult.collectErrors();
        BoxPlotFragment boxPlot = BoxPlotFragment.build(boxPlotResult);
        List<StatsTestRecipePayloadParamsWithAlternativeHypothesis.AlternativeComputationResult> alternativeResults = payloadParams.as(OneSampleTTestRecipePayloadParams.class).buildResultsForAlternatives(mcr.get(1));
        ArrayList<Row> rows = new ArrayList<Row>();
        for (StatsTestRecipePayloadParamsWithAlternativeHypothesis.AlternativeComputationResult alternativeResult : alternativeResults) {
            AlternativeHypothesis alternative = alternativeResult.alternative;
            ComputationResult testResult = alternativeResult.result;
            LinkedHashSet<String> warningsForAlternative = new LinkedHashSet<String>(testResult.collectWarnings());
            warningsForAlternative.addAll(boxPlotWarnings);
            LinkedHashSet<String> errorsForAlternative = new LinkedHashSet<String>(testResult.collectErrors());
            errorsForAlternative.addAll(boxPlotErrors);
            Row row = this.rowBase(significanceLevel, warningsForAlternative, errorsForAlternative, cf, rf);
            row.put(cf.column("sample_statistics"), JSON.json((Object)((Object)boxPlot)));
            row.put(cf.column("alternative_hypothesis"), alternative.name());
            row.put(cf.column("alternative_hypothesis_explanation"), OneSampleTTestStat.getAlternativeExplanation(alternative));
            if (testResult.isAvailable()) {
                if (this.knownStdDev == null) {
                    tr = testResult.as(TTest1Samp.TTest1SampResult.class);
                    sampleMeanCI = new AbstractTestStat.SampleMeanCI(tr.mean, payloadParams.confidenceLevel, tr.ciLower, tr.ciUpper);
                    row.put(cf.column("sample_mean_confidence_interval"), JSON.json((Object)sampleMeanCI));
                    pValue = tr.pvalue;
                    conclusion = OneSampleTTestStat.conclusion(pValue, significanceLevel);
                    row.put(cf.column("t_statistic"), tr.statistic);
                    row.put(cf.column("degrees_of_freedom"), tr.dof);
                    row.put(cf.column("p_value"), pValue);
                    row.put(cf.column("conclusion"), conclusion);
                } else {
                    tr = testResult.as(ZTest1Samp.ZTest1SampResult.class);
                    sampleMeanCI = new AbstractTestStat.SampleMeanCI(((ZTest1Samp.ZTest1SampResult)tr).mean, payloadParams.confidenceLevel, ((ZTest1Samp.ZTest1SampResult)tr).ciLower, ((ZTest1Samp.ZTest1SampResult)tr).ciUpper);
                    row.put(cf.column("sample_mean_confidence_interval"), JSON.json((Object)sampleMeanCI));
                    pValue = ((ZTest1Samp.ZTest1SampResult)tr).pvalue;
                    conclusion = OneSampleTTestStat.conclusion(pValue, significanceLevel);
                    row.put(cf.column("z_statistic"), ((ZTest1Samp.ZTest1SampResult)tr).statistic);
                    row.put(cf.column("p_value"), pValue);
                    row.put(cf.column("conclusion"), conclusion);
                }
            }
            rows.add(row);
        }
        return rows;
    }

    private static String getAlternativeExplanation(AlternativeHypothesis alternative) {
        switch (alternative) {
            case LOWER: {
                return "population mean < hypothesized mean";
            }
            case GREATER: {
                return "population mean > hypothesized mean";
            }
            case TWO_SIDED: {
                return "population mean \u2260 hypothesized mean";
            }
        }
        throw new IllegalArgumentException("Unknown alternative type");
    }
}

