/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.shaker;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.impl.FlowStateInternalDB;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.DatasetReadiness;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.recipes.ShakerRecipeService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.shaker.server.MemScriptRunner;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import org.springframework.beans.factory.annotation.Autowired;

public class ShakerRecipeSchemaComputer
extends RecipeSchemaComputer
implements RecipeSchemaComputer.RecipeSchemaComputerWithPayload {
    private SerializedShakerScript script;
    @Autowired
    private DataService dataService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ShakerRecipeService recipeService;
    @Autowired
    private FlowStateInternalDB flowStateInternalDB;

    public ShakerRecipeSchemaComputer(AuthCtx authCtx, JobActivity activity) {
        super(authCtx, activity);
    }

    @Override
    public boolean computesDiffItself() {
        return true;
    }

    @Override
    public void setPayload(String payload) {
        this.script = (SerializedShakerScript)JSON.parse((String)payload, SerializedShakerScript.class);
    }

    @Override
    public RecipeSchemaService.RecipeSchemaAutoupdateResult getAutoupdateResult_NT() throws Exception {
        Dataset dataset;
        SerializedRecipe.RecipeOutput ro;
        Dataset outputDataset;
        Dataset inputDataset;
        FlowRecipe fr = ((RecipeRunnableSubgraph)this.activity.getSubgraph()).getRecipe();
        AnyLoc mainInputLoc = fr.getModel().getSingleInput("main").getLoc(fr.getProjectKey());
        AnyLoc mainOutputLoc = fr.getModel().getSingleOutput("main").getLoc(fr.getProjectKey());
        try (Transaction t = this.transactionService.beginRead();){
            inputDataset = this.datasetAccessService.getMandatory(mainInputLoc.getProjectKey(), mainInputLoc.getId());
            outputDataset = this.datasetAccessService.getMandatory(mainOutputLoc.getProjectKey(), mainOutputLoc.getId());
        }
        if (!inputDataset.getPartitioningSchema().isPartitioned()) {
            try (DSSDBConnection conn = this.flowStateInternalDB.acquireConnection();){
                DatasetReadiness readiness = new ComputableHashComputer(this.authCtx).getCurrentContentHash(conn, inputDataset, Partition.newNP());
                if (!readiness.isReady()) {
                    throw new RecipeSchemaComputer.DontWantToCompute(RecipeCodes.ERR_RECIPE_CANNOT_CHECK_SCHEMA_CONSISTENCY_NEEDS_BUILD, "Cannot compute output schema with non-ready input dataset. Build first: " + inputDataset.getFullName() + "\nCaused by: " + ExceptionUtils.getMessageWithCauses((Throwable)readiness.error));
                }
            }
        }
        DataService.ShakerRecipeSchema srs = new DataService.ShakerRecipeSchema();
        srs.outputDatasetType = outputDataset.getType();
        for (SchemaColumn col : outputDataset.getSchema().getColumns()) {
            DataService.ShakerRecipeSchemaColumn srsc = new DataService.ShakerRecipeSchemaColumn();
            if (srsc.deleted) continue;
            srsc.column = col;
            srsc.persistent = true;
            srs.columns.put(col.getName(), srsc);
            srs.columnsOrder.add(col.getName());
        }
        SerializedShakerScript dv = this.script.deepCopy();
        dv.recipeSchema = srs;
        dv.origin = SerializedShakerScript.ShakerOrigin.PREPARE_RECIPE;
        dv.contextProjectKey = fr.getProjectKey();
        MemScriptRunner.TableWithReport twr = this.dataService.get_NOTRANSACTION(inputDataset, dv, null, null, false, this.authCtx);
        try (Transaction t = this.transactionService.beginRead();){
            ro = fr.getModel().getSingleOutput("main");
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart(fr.getModel().projectKey, ro.ref);
            dataset = this.datasetAccessService.getMandatory(loc);
        }
        return this.recipeService.getSchemaUpdateResult_NT(this.authCtx, ro.ref, twr.newRecipeSchema, dataset, false, false, inputDataset.getSchema());
    }
}

