/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringSMMgmtService;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSMMgmtService;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.ModelEvaluationStoresDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dataquality.DataQualityRunOrigin;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.mec.ModelEvaluationStore;
import com.dataiku.dip.mec.ModelEvaluationStoresCRUDService;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.MetricsLaunchService;
import com.dataiku.dip.metrics.checks.AbstractCheckContext;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.ScenarioRunContext;
import com.dataiku.dip.scheduler.steps.FlowComputableSpecification;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepParamsWithComputables;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.dataquality.AbstractCheckReport;
import com.dataiku.dip.server.services.dataquality.AbstractValuedCheck;
import com.dataiku.dip.server.services.dataquality.DataQualityRulesLaunchService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.text.StrSubstitutor;
import org.springframework.beans.factory.annotation.Autowired;

public class CheckDatasetStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return CheckDatasetStepParams.class;
        }

        @Override
        public String getType() {
            return "check_dataset";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new CheckDatasetStepRunner(scenario, step, step.getParamsAs(CheckDatasetStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            CheckDatasetStepParams params = step.getParamsAs(CheckDatasetStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("check");
            if (params != null) {
                for (FlowComputableSpecification built : params.getChecks()) {
                    sb.append(" ");
                    sb.append(built.getItemName());
                }
            }
            return sb.toString();
        }

        @Override
        public String buildId(Step step) {
            CheckDatasetStepParams stepParams = step.getParamsAs(CheckDatasetStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("check");
            if (stepParams != null) {
                sb.append("_");
                sb.append((Object)stepParams.handleWarningsAs);
                for (FlowComputableSpecification built : stepParams.getChecks()) {
                    sb.append("_");
                    sb.append(built.getPartitionInvariantId());
                }
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario scenario, Step step, PluginUsagesInspector pluginUsagesInspector) {
            CheckDatasetStepParams stepParams = (CheckDatasetStepParams)step.params;
            if (null != stepParams && null != stepParams.checks) {
                for (FlowComputableSpecification check : stepParams.checks) {
                    try {
                        Object object = pluginUsagesInspector.getFlowComputableSpecObject(scenario, check);
                        if (object instanceof Dataset) {
                            return PluginUsagesInspector.checkChecks(((Dataset)object).getModel().getDataQualityRuleSet().getRules(), step);
                        }
                        if (object instanceof ManagedFolder) {
                            return PluginUsagesInspector.checkChecks(((ManagedFolder)object).checks.checks, step);
                        }
                        if (!(object instanceof SavedModel)) continue;
                        return PluginUsagesInspector.checkChecks(((SavedModel)object).metricsChecks.checks, step);
                    }
                    catch (Exception e) {
                        logger.error((Object)("Error while checking if step " + step.id + " is runnable"), (Throwable)e);
                    }
                }
            }
            return null;
        }
    };
    private final CheckDatasetStepParams params;
    private final Scenario scenario;
    private final Step step;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private ModelEvaluationStoresDAO modelEvaluationStoresDAO;
    @Autowired
    private RetrievableKnowledgeDAO retrievableKnowledgeDAO;
    @Autowired
    private ModelEvaluationStoresCRUDService modelEvaluationStoresCRUDService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private MetricsLaunchService metricsLaunchService;
    @Autowired
    private DataQualityRulesLaunchService dataQualityRulesLaunchService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private PredictionSMMgmtService predictionSMMgmtService;
    @Autowired
    private ClusteringSMMgmtService clusteringSMMgmtService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.checkdataset");

    CheckDatasetStepRunner(Scenario scenario, Step step, CheckDatasetStepParams params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        logger.info((Object)("Start step " + this.step.name));
        String scenarioProjectKey = this.scenario.getProjectKey();
        VariablesContext variablesContext = this.variablesService.getForProject(this.scenario.getProjectKey());
        StrSubstitutor substitutor = new StrSubstitutor(variablesContext.getAllVariables());
        boolean hasCheckInError = false;
        boolean hasCheckInWarning = false;
        HashMap reportsByPartition = Maps.newHashMap();
        MetricsComputationService.MetricsComputationEnvironment environment = new MetricsComputationService.MetricsComputationEnvironment();
        environment.startedFromBuild = false;
        try (Transaction t = this.transactionService.beginRead();){
            GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.read();
            environment.graphiteServerUrl = generalSettings.graphiteServerUrl;
            environment.graphiteMetricPrefix = generalSettings.graphiteMetricPrefix;
        }
        for (FlowComputableSpecification check : this.params.checks) {
            Object object;
            try (Transaction t = this.transactionService.beginRead();){
                object = check.resolveTarget(scenarioProjectKey, this.datasetsDAO, this.managedFolderDAO, this.savedModelsDAO, this.modelEvaluationStoresDAO, this.retrievableKnowledgeDAO);
            }
            List<Partition> toCheck = check.resolvePartitions_NT(object, substitutor, this.predictionSMMgmtService, this.clusteringSMMgmtService, this.modelEvaluationStoresCRUDService);
            logger.info((Object)("Checking " + toCheck.size() + " partitions of " + check.getItemName()));
            for (Partition partition : toCheck) {
                FutureProgressState.checkInterrupt();
                ReportTargetItem datasetItem = check.getTargetItem(this.scenario.getProjectKey(), partition != null ? partition.id() : null);
                ReportItem.CheckedDataset reportItem = (ReportItem.CheckedDataset)new ReportItem.CheckedDataset(datasetItem).withStart(DateTime.now().getMillis());
                DataQualityRunOrigin.ScenarioStep runOrigin = new DataQualityRunOrigin.ScenarioStep(scenarioProjectKey, this.scenario.getId(), stepRun.scenarioRun.runId);
                try {
                    FutureResponse<AbstractCheckReport.DataQualityRulesComputationReport> checkFuture = null;
                    switch (check.type) {
                        case DATASET: {
                            checkFuture = this.dataQualityRulesLaunchService.computeRulesOnSinglePartition(stepRun.getScenarioRun().getRunAsUser(), (Dataset)object, ((Dataset)object).getModel().getDataQualityRuleSet().checks, partition.id(), new DataQualityRulesLaunchService.RunOptions(runOrigin, true, false, this.params.ignorePartitionSelectionMode, this.params.computeAutomaticRules, true, false));
                            break;
                        }
                        case MANAGED_FOLDER: {
                            checkFuture = this.metricsLaunchService.launchRunChecks((AuthCtx)stepRun.getScenarioRun().getRunAsUser(), (ManagedFolder)object, partition, environment, (DataQualityRunOrigin)runOrigin);
                            break;
                        }
                        case SAVED_MODEL: {
                            checkFuture = this.metricsLaunchService.launchRunChecksOnSMVersion(stepRun.getScenarioRun().getRunAsUser(), (SavedModel)object, partition.id(), environment, runOrigin);
                            break;
                        }
                        case MODEL_EVALUATION_STORE: {
                            checkFuture = this.metricsLaunchService.launchRunChecks((AuthCtx)stepRun.getScenarioRun().getRunAsUser(), (ModelEvaluationStore)object, partition.id(), environment, (DataQualityRunOrigin)runOrigin);
                            break;
                        }
                        default: {
                            throw new NotImplementedException("Checks not implemented for type: " + String.valueOf((Object)check.type));
                        }
                    }
                    checkFuture = this.futureService.waitForFinalResponse(checkFuture);
                    List<AbstractValuedCheck> results = ((AbstractCheckReport)checkFuture.result).getResults();
                    JSON.prettyToFile(results, (File)ScenarioRunContext.getScenarioCheckFile(stepRun.scenarioRun));
                    int warningCount = 0;
                    int errorCount = 0;
                    for (AbstractValuedCheck result : results) {
                        AbstractCheckContext.CheckOutcome checkOutcome = result.value.outcome;
                        if (checkOutcome == AbstractCheckContext.CheckOutcome.ERROR) {
                            ++errorCount;
                            continue;
                        }
                        if (checkOutcome == AbstractCheckContext.CheckOutcome.WARNING) {
                            ++warningCount;
                            continue;
                        }
                        if (checkOutcome != AbstractCheckContext.CheckOutcome.EMPTY) continue;
                        ++warningCount;
                    }
                    ReportItem.Outcome partitionOutcome = ReportItem.Outcome.SUCCESS;
                    if (errorCount > 0) {
                        hasCheckInError = true;
                        partitionOutcome = ReportItem.Outcome.FAILED;
                    } else if (warningCount > 0) {
                        hasCheckInWarning = true;
                        partitionOutcome = ReportItem.Outcome.WARNING;
                    }
                    reportItem = (ReportItem.CheckedDataset)reportItem.withHasError(errorCount > 0).withHasWarning(warningCount > 0);
                    reportItem.withEnd(DateTime.now().getMillis()).withOutcome(partitionOutcome);
                    reportsByPartition.put(String.valueOf(check.getLoc(scenarioProjectKey)) + "_" + (partition != null ? partition.id() : ""), (AbstractCheckReport)checkFuture.result);
                    this.jobsDatabaseService.tryRegisterFlowObjectEvent(check.getLoc(scenarioProjectKey), partition != null ? partition.id() : null, null, stepRun.getScenarioRun(), stepRun, reportItem);
                }
                catch (Throwable ex) {
                    try {
                        reportItem.withEnd(DateTime.now().getMillis()).withOutcome(ReportItem.Outcome.FAILED).withThrown(ex);
                        throw ex;
                    }
                    catch (Throwable throwable) {
                        this.jobsDatabaseService.tryRegisterFlowObjectEvent(check.getLoc(scenarioProjectKey), partition != null ? partition.id() : null, null, stepRun.getScenarioRun(), stepRun, reportItem);
                        throw throwable;
                    }
                }
            }
        }
        logger.info((Object)("Done step " + this.step.name));
        stepRun.payload = reportsByPartition;
        stepRun.getScenarioRun().withStepRunOutput(stepRun, reportsByPartition);
        if (hasCheckInError) {
            stepReportItem.withOutcome(ReportItem.Outcome.FAILED);
        } else if (hasCheckInWarning) {
            stepReportItem.withOutcome(this.params.handleWarningsAs);
        } else {
            stepReportItem.withOutcome(ReportItem.Outcome.SUCCESS);
        }
        assert (stepReportItem.getOutcome() != null);
    }

    public static class CheckDatasetStepParams
    extends NonFatalStepParams
    implements StepParams,
    StepParamsWithComputables {
        public List<FlowComputableSpecification> checks = Lists.newArrayList();
        public ReportItem.Outcome handleWarningsAs = ReportItem.Outcome.WARNING;
        public boolean computeAutomaticRules = true;
        public boolean ignorePartitionSelectionMode = false;

        public List<FlowComputableSpecification> getChecks() {
            return Lists.newArrayList(this.checks);
        }

        public CheckDatasetStepParams withChecks(List<FlowComputableSpecification> checks) {
            this.checks = Lists.newArrayList(checks);
            return this;
        }

        public CheckDatasetStepParams withChecks(FlowComputableSpecification ... checks) {
            this.checks = Lists.newArrayList((Object[])checks);
            return this;
        }

        public CheckDatasetStepParams withHandleWarningsAs(ReportItem.Outcome handleWarningsAs) {
            this.handleWarningsAs = handleWarningsAs;
            return this;
        }

        @Override
        public Collection<FlowComputableSpecification> getComputablesSpec() {
            return this.getChecks();
        }
    }
}

