/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.steps;

import com.dataiku.dip.custom.PluginUsagesInspector;
import com.dataiku.dip.dashboards.DashboardsService;
import com.dataiku.dip.dashboards.export.DashboardsExportService;
import com.dataiku.dip.dashboards.export.model.DashboardExport;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.graphicsexport.model.ExportFormat;
import com.dataiku.dip.managedfolder.KernelsManagedFolderService;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.steps.CreateBaseExportStepRunner;
import com.dataiku.dip.scheduler.steps.NonFatalStepParams;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.steps.StepMeta;
import com.dataiku.dip.scheduler.steps.StepParams;
import com.dataiku.dip.scheduler.steps.StepRun;
import com.dataiku.dip.scheduler.steps.StepRunner;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateDashboardExportStepRunner
extends CreateBaseExportStepRunner
implements StepRunner {
    public static final StepMeta META = new StepMeta(){

        @Override
        public Class<? extends StepParams> paramsClass() {
            return CreateDashboardExportStepParams.class;
        }

        @Override
        public String getType() {
            return "create_dashboard_export";
        }

        @Override
        public StepRunner buildRunner(Scenario scenario, Step step) {
            return new CreateDashboardExportStepRunner(scenario, step, step.getParamsAs(CreateDashboardExportStepParams.class));
        }

        @Override
        public String buildName(Step step) {
            CreateDashboardExportStepParams stepParams = step.getParamsAs(CreateDashboardExportStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("export");
            if (stepParams != null) {
                sb.append(" ");
                sb.append(stepParams.dashboardId);
            }
            return sb.toString();
        }

        @Override
        public String buildId(Step step) {
            CreateDashboardExportStepParams stepParams = step.getParamsAs(CreateDashboardExportStepParams.class);
            StringBuilder sb = new StringBuilder();
            sb.append("create_dashboard_export");
            if (stepParams != null) {
                sb.append("_");
                sb.append(stepParams.dashboardId);
            }
            return sb.toString();
        }

        @Override
        public StepMeta.UnavailableStepInfo checkStepForDeletedPluginComponents(Scenario sc, Step step, PluginUsagesInspector pluginUsagesInspector) {
            return null;
        }
    };
    private final CreateDashboardExportStepParams params;
    private final Scenario scenario;
    private final Step step;
    @Autowired
    private DashboardsExportService dashboardsExportService;
    @Autowired
    private DashboardsService dashboardsService;
    @Autowired
    private ManagedFoldersService managedFoldersService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private KernelsManagedFolderService kernelsManagedFolderService;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.scenario.step.dashboardExportStepRunner");

    public CreateDashboardExportStepRunner(Scenario scenario, Step step, CreateDashboardExportStepParams params) {
        this.scenario = scenario;
        this.step = step;
        this.params = params;
    }

    @Override
    public void run(StepRun stepRun, ReportItem.StepDone stepReportItem) throws Exception {
        logger.info((Object)("Start step " + this.step.name));
        String projectKey = this.scenario.getProjectKey();
        String dashboardId = this.params.dashboardId;
        ErrorContext.checkNotNull((Object)dashboardId, (String)"No dashboard selected. Select a dashboard to export or remove the step.");
        String folderId = this.params.folderSmartId;
        ErrorContext.checkNotNull((Object)folderId, (String)"No managed folder selected. Select a managed folder to store the result of the export or remove this step.");
        ManagedFolder mf = this.getManagedFolder(projectKey, folderId);
        ErrorContext.checkNotNull((Object)mf, (String)("Unknown managed folder: " + projectKey + "." + folderId));
        Dashboard dashboard = this.getDashboard(projectKey, dashboardId);
        ErrorContext.checkNotNull((Object)dashboard, (String)("Unknown dashboard: " + projectKey + "." + dashboardId));
        ReportTargetItem.DashboardExportItem target = new ReportTargetItem.DashboardExportItem(projectKey, dashboardId, dashboard.name, folderId, mf.name);
        ReportItem item = new ReportItem.CreatedDashboardExport(target).withStart(System.currentTimeMillis());
        ReportItem.CreatedDashboardExport reportItem = (ReportItem.CreatedDashboardExport)item;
        DashboardExport export = new DashboardExport(projectKey, this.params.exportFormat, new DashboardExport.Target(dashboardId, this.params.filtersBySlide));
        this.exportToManagedFolder(projectKey, dashboardId, folderId, export, this.dashboardsExportService, stepRun, reportItem);
        stepReportItem.outcome = reportItem.getOutcome();
        stepReportItem.thrown = reportItem.getThrown();
        logger.info((Object)("Done step " + this.step.name));
    }

    private Dashboard getDashboard(String projectKey, String dashboardId) throws IOException {
        if (projectKey == null || dashboardId == null) {
            return null;
        }
        try (Transaction t = this.transactionService.beginRead();){
            Dashboard dashboard = this.dashboardsService.getOrNull(projectKey, dashboardId);
            return dashboard;
        }
    }

    public static class CreateDashboardExportStepParams
    extends NonFatalStepParams
    implements StepParams {
        public String dashboardId;
        public ExportFormat exportFormat;
        public String folderSmartId;
        public List<String> filtersBySlide;

        public CreateDashboardExportStepParams withDashboard(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public CreateDashboardExportStepParams withExportFormat(ExportFormat exportFormat) {
            this.exportFormat = exportFormat;
            return this;
        }

        public CreateDashboardExportStepParams withFolderSmartId(String folderSmartId) {
            this.folderSmartId = folderSmartId;
            return this;
        }

        public CreateDashboardExportStepParams withFilter(List<String> filtersBySlide) {
            this.filtersBySlide = filtersBySlide;
            return this;
        }
    }
}

