/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import com.dataiku.dip.security.GroupPermissionsWatcher;
import com.dataiku.dip.security.PermissionsWatcher;
import com.dataiku.dip.security.ProjectPermissionsWatcher;
import com.dataiku.dip.security.UserPermissionsWatcher;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class PermissionsWatchersService {
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.security.permissionswatcher");

    public PermissionsWatcher startProjectWatch(String projectKey) throws IOException {
        logger.info((Object)("Start project permissions watch: " + projectKey));
        ProjectPermissionsWatcher watcher = new ProjectPermissionsWatcher(projectKey);
        watcher.start();
        return watcher;
    }

    public PermissionsWatcher startUserWatch(String login) throws IOException {
        logger.info((Object)("Start single user permissions watch: " + login));
        UserPermissionsWatcher watcher = new UserPermissionsWatcher(login);
        watcher.start();
        return watcher;
    }

    public PermissionsWatcher startUserWatch(List<String> logins) throws IOException {
        logger.info((Object)("Start multiple users permissions watch: " + String.valueOf(logins)));
        UserPermissionsWatcher watcher = new UserPermissionsWatcher(logins);
        watcher.start();
        return watcher;
    }

    public PermissionsWatcher startGroupWatch(String groupName) throws IOException {
        logger.info((Object)("Start group permissions watch: " + groupName));
        GroupPermissionsWatcher watcher = new GroupPermissionsWatcher(groupName);
        watcher.start();
        return watcher;
    }
}

