/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.secretsstorage;

import com.dataiku.dip.security.aws.AWSClientBrokerService;
import com.dataiku.dip.security.secretsstorage.SecretsFetcher;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.secretsmanager.model.GetSecretValueRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.secretsmanager.model.GetSecretValueResponse;
import com.google.gson.JsonObject;
import org.apache.commons.net.util.Base64;

public class AWSSMSecretFetcher
implements SecretsFetcher {
    private SecretsManagerClient client;
    private Settings settings;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.security.encryption.awssecretsmanager");

    @Override
    public void init(String fetcherParams) throws Exception {
        this.settings = (Settings)JSON.parse((String)fetcherParams, Settings.class);
        if (!SpringUtils.getInstance().hasBean(AWSClientBrokerService.class)) {
            logger.info((Object)"Registering AWSClientBrokerService");
            SpringUtils.getInstance().registerAndAutowire(AWSClientBrokerService.class);
        }
        AWSClientBrokerService awsClientBrokerService = (AWSClientBrokerService)SpringUtils.getBean(AWSClientBrokerService.class);
        long before = System.currentTimeMillis();
        this.client = awsClientBrokerService.createSecretsManagerClient();
        long clientInitialized = System.currentTimeMillis();
        logger.infoV("clientInitTime=%s", new Object[]{clientInitialized - before});
    }

    @Override
    public byte[] fetchSecretBytes(String secretName) {
        GetSecretValueRequest gsvr = (GetSecretValueRequest)GetSecretValueRequest.builder().secretId(secretName).build();
        logger.info((Object)("Fetching secret value from ASM for secretId:" + gsvr.secretId() + " with format: " + String.valueOf((Object)this.settings.secretFormat)));
        long before = System.currentTimeMillis();
        GetSecretValueResponse result = this.client.getSecretValue(gsvr);
        long after = System.currentTimeMillis();
        logger.infoV("Acquired secret value secretAcquireTime=%s", new Object[]{after - before});
        switch (this.settings.secretFormat) {
            case B64_JSON_KEY: {
                String secretString = result.secretString();
                JsonObject secretObj = (JsonObject)JSON.parse((String)secretString, JsonObject.class);
                if (!secretObj.has(this.settings.jsonKey)) {
                    throw new IllegalArgumentException("Missing " + this.settings.jsonKey + " key in secret");
                }
                return Base64.decodeBase64((String)secretObj.get(this.settings.jsonKey).getAsString());
            }
            case B64_STRING: {
                return Base64.decodeBase64((String)result.secretString());
            }
            case RAW_BYTES: {
                return result.secretBinary().asByteArray();
            }
        }
        throw new Error("unreachable");
    }

    static class Settings {
        SecretFormat secretFormat = SecretFormat.B64_JSON_KEY;
        String jsonKey = "dss-key";

        Settings() {
        }
    }

    static enum SecretFormat {
        B64_STRING,
        RAW_BYTES,
        B64_JSON_KEY;

    }
}

