/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dashboards.DashboardsService;
import com.dataiku.dip.dashboards.DashboardsUtils;
import com.dataiku.dip.dashboards.export.DashboardsExportService;
import com.dataiku.dip.dashboards.export.DashboardsScreenshotsService;
import com.dataiku.dip.dashboards.export.model.DashboardExport;
import com.dataiku.dip.dashboards.insights.InsightsService;
import com.dataiku.dip.dashboards.model.Dashboard;
import com.dataiku.dip.dashboards.model.DashboardPage;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.dashboards.model.Tile;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.graphicsexport.model.ExportFormat;
import com.dataiku.dip.graphicsexport.model.ExportResult;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.TagFilterUtils;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.NavigatorService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class DashboardsController
extends DIPInternalControllerBase {
    @Autowired
    private DashboardsService dashboardsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    @Autowired
    private NavigatorService navigatorService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private InsightsService insightsService;
    @Autowired
    private DashboardsExportService dashboardsExportService;
    @Autowired
    private DashboardsScreenshotsService dashboardsScreenshotsService;
    private static Logger logger = Logger.getLogger((String)"dku.dashboard.controller");

    @AuditedCall(value={"msgType", "dashboards-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/dashboards/list"})
    public void list(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            DashboardsController.writeJSON((HttpServletResponse)resp, this.dashboardsService.listDashboards(user, projectKey));
        }
    }

    private boolean canEditDashboard(AuthCtx user, String projectKey, SerializedProject.PermissionsVersion permissionsVersion, Dashboard dashboard) throws Exception {
        if (permissionsVersion == SerializedProject.PermissionsVersion.LEGACY) {
            return Objects.equals(dashboard.owner, user.getIdentifier()) || this.permissionsService.hasProjectPrivilege(user, projectKey, Privileges.ProjectLevelPrivilegeType.MODERATE_DASHBOARDS);
        }
        return true;
    }

    private void checkCanEditDashboard(AuthCtx user, String projectKey, SerializedProject.PermissionsVersion permissionsVersion, Dashboard dashboard) throws Exception {
        if (!this.canEditDashboard(user, projectKey, permissionsVersion, dashboard)) {
            throw new UnauthorizedException("You cannot edit dashboard " + dashboard.projectKey + "." + dashboard.id + ".", "cant-edit-dashboard");
        }
    }

    @AuditedCall(value={"msgType", "dashboards-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/dashboards/list-editable"})
    public void listEditable(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            EditableDashboardList ret = new EditableDashboardList();
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            List<Dashboard> allDashboards = this.dashboardsService.listUnsafe(projectKey);
            SerializedProject project = this.projectsService.getMandatoryUnsafe(projectKey);
            ret.allDashboardsCount = allDashboards.size();
            for (Dashboard dashboard : allDashboards) {
                if (!this.canEditDashboard(user, projectKey, project.permissionsVersion, dashboard)) continue;
                ret.dashboards.add(dashboard);
            }
            DashboardsController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditedCall(value={"msgType", "dashboards-read-meta", "projectKey", "${projectKey}", "dashboardId", "${dashboardId}"})
    @RequestMapping(value={"/api/dashboards/get"})
    public void get(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String dashboardId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkReadDashboardPerm(req, projectKey, ITaggingService.TaggableType.DASHBOARD, dashboardId);
            DashboardsController.writeJSON((HttpServletResponse)resp, (Object)this.dashboardsService.getMandatoryUnsafe(projectKey, dashboardId));
        }
    }

    @AuditedCall(value={"msgType", "dashboards-read-meta", "projectKey", "${projectKey}", "dashboardId", "${dashboardId}"})
    @RequestMapping(value={"/api/dashboards/get-full-info"})
    public void getFullInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String dashboardId) throws Exception {
        NavigatorService.DashboardFullInfo info;
        AuthCtx u;
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkReadDashboardPerm(u, projectKey, ITaggingService.TaggableType.DASHBOARD, dashboardId);
            info = this.navigatorService.getDashboardFullInfo(u, projectKey, dashboardId);
        }
        this.navigatorService.addInfo_NT(info, u);
        DashboardsController.writeJSON((HttpServletResponse)resp, (Object)info);
    }

    @AuditedCall(value={"msgType", "dashboards-read-meta", "projectKey", "${projectKey}", "dashboardId", "${dashboardId}"})
    @RequestMapping(value={"/api/dashboards/get-summary"})
    public void getSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String dashboardId) throws Exception {
        AuthCtx authCtx;
        Dashboard.DashboardSummary summary = new Dashboard.DashboardSummary();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkReadDashboardPerm(authCtx, projectKey, ITaggingService.TaggableType.DASHBOARD, dashboardId);
            Dashboard dashboard = this.dashboardsService.getMandatoryUnsafe(projectKey, dashboardId);
            UsersService.UIUser owner = this.usersService.getUserOrNull_NoLeak(dashboard.owner);
            summary.object = dashboard;
            summary.ownerDisplayName = owner == null ? null : owner.displayName;
        }
        summary.timeline = this.timelinesService.getObjectTimeline_NT(summary.object, 0, 100);
        summary.interest = this.interestsService.getObjectAndUserInterest_noFail(authCtx, summary.object);
        DashboardsController.writeJSON((HttpServletResponse)resp, (Object)summary);
    }

    @AuditedCall(value={"msgType", "dashboards-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/dashboards/list-heads"})
    public void listHeads(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(required=false) String tagFilter) throws Exception {
        AuthCtx user;
        TaggableObjectsService.FilteredTaggableItems heads = new TaggableObjectsService.FilteredTaggableItems();
        TagFilterUtils.TagFilter tf = (TagFilterUtils.TagFilter)JSON.parse((String)tagFilter, TagFilterUtils.TagFilter.class);
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            SerializedProject project = this.projectsService.getMandatoryUnsafe(projectKey);
            for (Dashboard dashboard : this.dashboardsService.listUnsafe(projectKey)) {
                if (!this.dashboardsService.isDashboardReturned(dashboard, user, project.permissionsVersion)) continue;
                if (!TagFilterUtils.matches(tf, dashboard)) {
                    ++heads.filteredOut;
                    continue;
                }
                Dashboard.DashboardListItem listItem = new Dashboard.DashboardListItem(dashboard);
                listItem.hasMissingReaderAuthorizations = this.dashboardsService.hasMissingReaderAuthorizations(dashboard);
                UsersService.UIUser owner = this.usersService.getUserOrNull_NoLeak(listItem.owner);
                listItem.ownerDisplayName = owner != null ? owner.displayName : null;
                this.taggableObjectsService.setEditionInfoFromTags(dashboard, listItem);
                heads.items.add(listItem);
            }
        }
        this.interestsService.enrichHeads(user.getAssociatedDSSUser(), projectKey, heads.items);
        DashboardsController.writeJSON((HttpServletResponse)resp, heads);
    }

    @AuditedCall(value={"msgType", "dashboards-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/dashboards/list-summaries"})
    public void listSummaries(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        AuthCtx user;
        ArrayList<TaggableObjectsService.TaggableObjectSummary> summaries = new ArrayList<TaggableObjectsService.TaggableObjectSummary>();
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            SerializedProject project = this.projectsService.getMandatoryUnsafe(projectKey);
            for (Dashboard dashboard : this.dashboardsService.listUnsafe(projectKey)) {
                if (!this.dashboardsService.isDashboardReturned(dashboard, user, project.permissionsVersion)) continue;
                TaggableObjectsService.TaggableObjectSummary summary = new TaggableObjectsService.TaggableObjectSummary();
                summary.object = dashboard;
                summaries.add(summary);
            }
        }
        this.interestsService.enrichSummaries(user.getAssociatedDSSUser(), projectKey, summaries);
        DashboardsController.writeJSON((HttpServletResponse)resp, summaries);
    }

    @AuditInline
    @RequestMapping(value={"/api/dashboards/save"})
    public void save(HttpServletRequest req, HttpServletResponse resp, @RequestParam String dashboardData, @RequestParam(required=false) String commitMessage) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            Dashboard dashboard = (Dashboard)JSON.parse((String)dashboardData, Dashboard.class);
            AuthCtx user = this.authService.getMandatoryUser(req);
            SerializedProject project = this.projectsService.getMandatoryUnsafe(dashboard.projectKey);
            this.projectsService.checkPerm(user, project.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS);
            Dashboard existing = null;
            if (!StringUtils.isBlank((String)dashboard.id)) {
                existing = this.dashboardsService.getMandatoryUnsafe(dashboard.projectKey, dashboard.id);
            }
            if (existing == null) {
                dashboard.owner = t.getUser().getIdentifier();
                dashboard.id = this.dashboardsService.generateUniqueId(dashboard.projectKey);
            } else {
                if (!StringUtils.equals((String)existing.owner, (String)dashboard.owner)) {
                    this.projectsService.checkPerm(user, project.projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
                }
                if (!(project.permissionsVersion != SerializedProject.PermissionsVersion.LEGACY || existing.listed == dashboard.listed && StringUtils.equals((String)existing.owner, (String)user.getIdentifier()))) {
                    this.projectsService.checkPerm(user, project.projectKey, Privileges.ProjectLevelPrivilegeType.MODERATE_DASHBOARDS);
                }
                dashboard.owner = existing.owner;
            }
            this.dashboardsService.save(dashboard, existing == null);
            this.dashboardsScreenshotsService.buildScreenshotIfNeeded(user, dashboard.getRef());
            DashboardsController.writeJSON((HttpServletResponse)resp, (Object)dashboard);
            if (StringUtils.isNotBlank((String)commitMessage)) {
                t.commit(commitMessage, 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
            } else {
                t.commit(String.format("Saved dashboard %s (%s.%s)", dashboard.name, dashboard.projectKey, dashboard.id), 0L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_AUTO);
            }
            if (existing == null) {
                this.auditTrailService.generic("dashboard-create").with("projectKey", dashboard.projectKey).with("dashboardId", dashboard.id).with("dashboardName", dashboard.name).emit();
            } else {
                this.auditTrailService.generic("dashboard-save").with("projectKey", dashboard.projectKey).with("dashboardId", dashboard.id).with("dashboardName", dashboard.name).emit();
            }
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/dashboards/copy"})
    public void copy(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String dashboardId, @RequestParam String name, @RequestParam boolean deepCopy) throws Exception {
        Dashboard dashboardCopy;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS);
            dashboardCopy = this.dashboardsService.copy(projectKey, dashboardId, name, deepCopy);
            t.commitV("Copying dashboard %s.%s into %s (%s.%s)", new Object[]{projectKey, dashboardId, name, projectKey, dashboardCopy.id});
            this.auditTrailService.generic("dashboard-create").with("fromDashboardProjectKey", projectKey).with("fromDashboardId", dashboardId).with("projectKey", dashboardCopy.projectKey).with("dashboardId", dashboardCopy.id).with("dashboardName", dashboardCopy.name).emit();
        }
        DashboardsController.writeJSON((HttpServletResponse)resp, (Object)dashboardCopy);
    }

    @AuditedCall(value={"msgType", "dashboards-export", "projectKey", "${projectKey}", "exportFormat", "${exportFormat}", "dashboards", "${dashboards}"})
    @RequestMapping(value={"/api/dashboards/export"}, method={RequestMethod.POST})
    public void export(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String exportFormat, @RequestParam String dashboards) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
        }
        ExportFormat format = (ExportFormat)JSON.parse((String)exportFormat, ExportFormat.class);
        List dashboardList = (List)JSON.parse((String)dashboards, (TypeToken)new TypeToken<List<DashboardExport.Target>>(){});
        DashboardExport export = new DashboardExport(projectKey, format, dashboardList);
        FutureResponse<ExportResult> futureResponse = this.dashboardsExportService.export(user, export);
        DashboardsController.writeJSON((HttpServletResponse)resp, futureResponse);
    }

    @AuditedCall(value={"msgType", "dashboards-download-export", "projectKey", "${projectKey}", "exportId", "${exportId}"})
    @RequestMapping(value={"/api/dashboards/download-export"}, method={RequestMethod.GET})
    public void downloadExport(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String exportId) throws Exception {
        File file;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getMandatoryUserNoXSRF(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            file = this.dashboardsExportService.getExportFile(user, projectKey, exportId);
        }
        this.auditTrailService.generic("dashboard-export-download").with("ProjectKey", projectKey).with("ExportId", exportId).emit();
        String mimeType = DKUtils.probeContentTypeWithFallback((File)file);
        this.writeFileForDownload(resp, file, mimeType, file.getName());
        this.dashboardsExportService.clean(projectKey, exportId);
    }

    @AuditInline
    @RequestMapping(value={"/api/dashboards/multi-pin"})
    public void multiPin(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String insightId, @RequestParam String tilesData, @RequestParam String pinningOrdersData, @RequestParam boolean pointerMode) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            SerializedProject project = this.projectsService.getMandatoryUnsafe(projectKey);
            this.projectsService.checkPerm(user, project.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS);
            DashboardsUtils.PinningOrder[] pinningOrdersList = (DashboardsUtils.PinningOrder[])JSON.parse((String)pinningOrdersData, DashboardsUtils.PinningOrder[].class);
            Tile[] tileList = (Tile[])JSON.parse((String)tilesData, Tile[].class);
            StringBuilder insightCommitMessage = new StringBuilder();
            StringBuilder tileCommitMessage = new StringBuilder();
            if (project.permissionsVersion == SerializedProject.PermissionsVersion.LEGACY) {
                for (DashboardsUtils.PinningOrder pinningOrder : pinningOrdersList) {
                    Dashboard dashboard = this.dashboardsService.getMandatoryUnsafe(projectKey, pinningOrder.dashboardId);
                    this.checkCanEditDashboard(user, projectKey, project.permissionsVersion, dashboard);
                }
            }
            for (int i = 0; i < pinningOrdersList.length; ++i) {
                if (tileList[i].tileType == Tile.TileType.INSIGHT) {
                    Insight insight = this.insightsService.getMandatory(projectKey, insightId);
                    this.dashboardsService.addToDashboard(insight, pinningOrdersList[i], tileList[i], pointerMode, user);
                    insightCommitMessage.append(String.format("insight %s to dashboard %s, ", projectKey + "." + tileList[i].insightId, pinningOrdersList[i].dashboardId));
                    continue;
                }
                this.dashboardsService.addToDashboard(pinningOrdersList[i], tileList[i], projectKey);
                tileCommitMessage.append(String.format("dashboard %s, ", pinningOrdersList[i].dashboardId));
            }
            StringBuilder finalMessage = new StringBuilder();
            if (!insightCommitMessage.isEmpty()) {
                finalMessage.append(pointerMode ? "Added " : "Duplicated and added ").append(insightCommitMessage, 0, insightCommitMessage.length() - 2);
            }
            if (!tileCommitMessage.isEmpty()) {
                if (!finalMessage.isEmpty()) {
                    finalMessage.append("\n");
                }
                finalMessage.append("Duplicated and added non insight tiles to dashboards").append(tileCommitMessage, 0, tileCommitMessage.length() - 2);
            }
            t.commitV(finalMessage.toString(), new Object[0]);
            for (DashboardsUtils.PinningOrder o : pinningOrdersList) {
                this.auditTrailService.generic("dashboard-publish").with("projectKey", projectKey).with("dashboardId", o.dashboardId).emit();
            }
        }
    }

    @AuditedCall(value={"msgType", "dashboard-set-promoted", "projectKey", "${projectKey}", "dashboardIds", "${dashboardIds}", "promoted", "${listed}"})
    @RequestMapping(value={"/api/dashboards/make-listed"})
    public void makeListed(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String dashboardIds, @RequestParam boolean listed) throws Exception {
        String[] dashboardIdList = (String[])JSON.parse((String)dashboardIds, String[].class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            SerializedProject project = this.projectsService.getMandatoryUnsafe(projectKey);
            if (project.permissionsVersion == SerializedProject.PermissionsVersion.LEGACY) {
                this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.MODERATE_DASHBOARDS);
            } else {
                this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS);
            }
            for (String dashboardId : dashboardIdList) {
                this.dashboardsService.makeListed(projectKey, dashboardId, listed);
            }
            String listedLabel = listed ? "public" : "private";
            String dashboardLabel = dashboardIdList.length > 1 ? "dashboards" : "dashboard";
            t.commitV("Made %d %s %s in project %s: %s", new Object[]{dashboardIdList.length, dashboardLabel, listedLabel, projectKey, dashboardIds});
        }
    }

    @AuditedCall(value={"msgType", "dashboard-read-meta", "projectKey", "${projectKey}", "dashboardId", "${dashboardId}"})
    @RequestMapping(value={"/api/dashboards/get-enriched-page"})
    public void getEnrichedPage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String dashboardId, @RequestParam int pageIdx) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkReadDashboardPerm(user, projectKey, ITaggingService.TaggableType.DASHBOARD, dashboardId);
            this.licenseEnforcementService.checkReadDashboardsAllowed(user);
            DashboardsController.writeJSON((HttpServletResponse)resp, (Object)this.dashboardsService.getEnrichedPageForUser(projectKey, dashboardId, pageIdx, user));
        }
    }

    @AuditedCall(value={"msgType", "dashboard-copy-page", "projectKey", "${projectKey}", "sourceDashboardId", "${sourceDashboardId}", "page", "${page}", "targetedDashboardId", "${targetedDashboardId}", "copyPageName", "${copyPageName}", "pointerMode", "${pointerMode}"})
    @RequestMapping(value={"/api/dashboards/copy-page"})
    public void copyPage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String sourceDashboardId, @RequestParam String pageData, @RequestParam String targetedDashboardId, @RequestParam String copyPageName, @RequestParam boolean pointerMode) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS);
            Dashboard dashboard = this.dashboardsService.getMandatoryUnsafe(projectKey, targetedDashboardId);
            SerializedProject project = this.projectsService.getMandatoryUnsafe(projectKey);
            this.checkCanEditDashboard(user, projectKey, project.permissionsVersion, dashboard);
            DashboardPage page = (DashboardPage)JSON.parse((String)pageData, DashboardPage.class);
            String copyPageId = this.dashboardsService.copyPage(projectKey, page, targetedDashboardId, copyPageName, pointerMode, user.getIdentifier());
            t.commitV("Copying dashboard page %s from dashboard %s.%s to dashboard %s.%s, new page's id is %s", new Object[]{page.id, projectKey, sourceDashboardId, projectKey, targetedDashboardId, copyPageId});
            DashboardsController.writeJSON((HttpServletResponse)resp, (Object)copyPageId);
        }
    }

    @AuditedCall(value={"msgType", "dashboard-get-missing-reader-authorizations", "projectKey", "${projectKey}", "dashboardIds", "${dashboardIds}"})
    @RequestMapping(value={"/api/dashboards/get-missing-reader-authorizations"})
    public void getMissingReaderAuthorizations(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String dashboardIds) throws Exception {
        HashMap<Integer, SerializedProject.ReaderAuthorization> missingReaderAuthorizationsMap = new HashMap<Integer, SerializedProject.ReaderAuthorization>();
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            String[] dashboardIdList;
            AuthCtx user = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS);
            for (String dashboardId : dashboardIdList = (String[])JSON.parse((String)dashboardIds, String[].class)) {
                Dashboard dashboard = this.dashboardsService.getMandatoryUnsafe(projectKey, dashboardId);
                Set<SerializedProject.ReaderAuthorization> missingReaderAuthorizations = this.dashboardsService.getMissingReaderAuthorizations(dashboard);
                for (SerializedProject.ReaderAuthorization mra : missingReaderAuthorizations) {
                    Integer key = mra.objectRef.hashCode();
                    SerializedProject.ReaderAuthorization mergeMra = (SerializedProject.ReaderAuthorization)missingReaderAuthorizationsMap.get(key);
                    if (mergeMra != null) {
                        mergeMra.modes.addAll(mra.modes);
                        continue;
                    }
                    mra.objectRef = this.taggableObjectsReadService.enrichSmartObjectRef(mra.objectRef, projectKey);
                    missingReaderAuthorizationsMap.put(key, mra);
                }
            }
        }
        DashboardsController.writeJSON((HttpServletResponse)resp, missingReaderAuthorizationsMap.values());
    }

    public static class EditableDashboardList {
        public List<Dashboard> dashboards = Lists.newArrayList();
        public int allDashboardsCount = 0;
    }
}

