/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.dataflow.refactoring.FlowCopyService;
import com.dataiku.dip.dataflow.refactoring.FlowRefactoringService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/flow/refactoring"})
public class FlowRefactoringController
extends DIPInternalControllerBase {
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private FlowRefactoringService flowRefactoringService;
    @Autowired
    private FlowCopyService subflowCopyService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.flow.refactoring");

    @AuditNotNeeded
    @RequestMapping(value={"/start-change-connections"})
    public void startChangeConnections(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String items) throws Exception {
        AuthCtx authCtx;
        Set refs = (Set)JSON.parse((String)items, (TypeToken)new TypeToken<HashSet<TaggableObjectsService.TaggableObjectRef>>(){});
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllProjects(authCtx, refs);
        }
        FlowRefactoringController.writeJSON((HttpServletResponse)resp, (Object)this.flowRefactoringService.startChangeConnections_NT(projectKey, refs, authCtx));
    }

    @AuditedCall(value={"msgType", "test-change-connections", "items", "${items}", "options", "${options}"})
    @RequestMapping(value={"/test-change-connections"})
    public void testChangeConnections(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String items, @RequestParam String options) throws Exception {
        AuthCtx authCtx;
        Set refs = (Set)JSON.parse((String)items, (TypeToken)new TypeToken<HashSet<TaggableObjectsService.TaggableObjectRef>>(){});
        FlowRefactoringService.ChangeConnectionsOptions parsedOptions = (FlowRefactoringService.ChangeConnectionsOptions)JSON.parse((String)options, FlowRefactoringService.ChangeConnectionsOptions.class);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllProjects(authCtx, refs);
        }
        FlowRefactoringController.writeJSON((HttpServletResponse)resp, (Object)((Object)this.flowRefactoringService.testChangeConnections_NT(projectKey, refs, parsedOptions, authCtx)));
    }

    @AuditedCall(value={"msgType", "change-connections", "items", "${items}", "options", "${options}"})
    @RequestMapping(value={"/change-connections"})
    public void changeConnections(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String items, @RequestParam String options) throws Exception {
        AuthCtx authCtx;
        List refs = (List)JSON.parse((String)items, (TypeToken)new TypeToken<ArrayList<TaggableObjectsService.TaggableObjectRef>>(){});
        FlowRefactoringService.ChangeConnectionsOptions parsedOptions = (FlowRefactoringService.ChangeConnectionsOptions)JSON.parse((String)options, FlowRefactoringService.ChangeConnectionsOptions.class);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllProjects(authCtx, refs);
        }
        FlowRefactoringController.writeJSON((HttpServletResponse)resp, (Object)this.flowRefactoringService.changeConnections_NT(projectKey, refs, parsedOptions, authCtx));
    }

    @AuditNotNeeded
    @RequestMapping(value={"/start-copy-subflow"})
    public void startCopySubFlow(HttpServletRequest req, HttpServletResponse resp, @RequestParam String items) throws Exception {
        AuthCtx authCtx;
        Set refs = (Set)JSON.parse((String)items, (TypeToken)new TypeToken<HashSet<TaggableObjectsService.TaggableObjectRef>>(){});
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllSourceProjects(authCtx, refs);
        }
        FlowRefactoringController.writeJSON((HttpServletResponse)resp, (Object)((Object)this.subflowCopyService.startCopySubflow(refs, authCtx)));
    }

    @AuditedCall(value={"msgType", "test-copy-subflow", "items", "${items}", "options", "${options}"})
    @RequestMapping(value={"/test-copy-subflow"})
    @ResponseBody
    public FlowCopyService.CopySubflowTestResponse testCopySubFlow(HttpServletRequest req, HttpServletResponse resp, @RequestParam String items, @RequestParam(value="options") FlowCopyService.CopySubflowOptions parsedOptions, @RequestParam(required=false) String contextProjectKey) throws Exception {
        AuthCtx authCtx;
        Set refs = (Set)JSON.parse((String)items, (TypeToken)new TypeToken<HashSet<TaggableObjectsService.TaggableObjectRef>>(){});
        this.checkNotNull(parsedOptions, "No copy options provided", new Object[0]);
        if (parsedOptions.targetMode == FlowCopyService.TargetMode.CURRENT_PROJECT) {
            parsedOptions.targetMode = FlowCopyService.TargetMode.EXISTING_PROJECT;
            parsedOptions.targetProjectKey = contextProjectKey;
            parsedOptions.renaming = true;
        }
        if (parsedOptions.recipeNames == null) {
            parsedOptions.recipeNames = new HashMap<String, String>();
        }
        if (parsedOptions.labelingTaskNames == null) {
            parsedOptions.labelingTaskNames = new HashMap<String, String>();
        }
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllSourceProjects(authCtx, refs);
            if (parsedOptions.targetMode == FlowCopyService.TargetMode.EXISTING_PROJECT) {
                this.projectsService.checkPerm(authCtx, parsedOptions.targetProjectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            }
        }
        return this.subflowCopyService.testCopySubflow_NT(refs, contextProjectKey, parsedOptions, authCtx);
    }

    @AuditedCall(value={"msgType", "copy-subflow", "items", "${items}", "options", "${options}"})
    @RequestMapping(value={"/copy-subflow"})
    public void copySublflow(HttpServletRequest req, HttpServletResponse resp, @RequestParam String items, @RequestParam(value="options") FlowCopyService.CopySubflowOptions parsedOptions, @RequestParam(required=false) String contextProjectKey) throws Exception {
        FlowCopyService.CopySubflowResponse copySubflowResponse;
        DSSAuthCtx authCtx;
        Set refs = (Set)JSON.parse((String)items, (TypeToken)new TypeToken<HashSet<TaggableObjectsService.TaggableObjectRef>>(){});
        this.checkNotNull(parsedOptions, "No copy options provided", new Object[0]);
        if (parsedOptions.targetMode == FlowCopyService.TargetMode.CURRENT_PROJECT) {
            parsedOptions.targetMode = FlowCopyService.TargetMode.EXISTING_PROJECT;
            parsedOptions.targetProjectKey = contextProjectKey;
            parsedOptions.renaming = true;
        }
        if (parsedOptions.recipeNames == null) {
            parsedOptions.recipeNames = new HashMap<String, String>();
        }
        if (parsedOptions.labelingTaskNames == null) {
            parsedOptions.labelingTaskNames = new HashMap<String, String>();
        }
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            authCtx = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            this.checkWriteConfOnAllSourceProjects(authCtx, refs);
            if (parsedOptions.targetMode == FlowCopyService.TargetMode.NEW_PROJECT && !authCtx.getPermissions().mayCreateProjects()) {
                throw new SecurityException("You may not create new projects");
            }
            if (parsedOptions.targetMode == FlowCopyService.TargetMode.EXISTING_PROJECT) {
                this.projectsService.checkPerm(authCtx, parsedOptions.targetProjectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            }
            copySubflowResponse = this.subflowCopyService.copySubflow(refs, parsedOptions, authCtx);
            t.commit("Copy subflow");
        }
        if (parsedOptions.copyData) {
            for (FlowCopyService.CopiedSublowItem copiedElement : copySubflowResponse.createdItems) {
                this.subflowCopyService.copyData_NT(copiedElement.original, copiedElement.copy, authCtx);
            }
        }
    }

    private void checkWriteConfOnAllSourceProjects(AuthCtx authCtx, Collection<TaggableObjectsService.TaggableObjectRef> refs) throws DKUSecurityException {
        this.checkWriteConfOnProjects(authCtx, refs.stream().map(ref -> ref.getLoc().resolved().getProjectKey()).collect(Collectors.toList()));
    }

    private void checkWriteConfOnAllProjects(AuthCtx authCtx, Collection<TaggableObjectsService.TaggableObjectRef> refs) throws DKUSecurityException {
        this.checkWriteConfOnProjects(authCtx, refs.stream().map(ref -> ref.projectKey).collect(Collectors.toList()));
    }

    private void checkWriteConfOnProjects(AuthCtx authCtx, List<String> projectKeys) throws DKUSecurityException {
        HashSet<String> authorizedProjectKeys = new HashSet<String>();
        for (String projectKey : projectKeys) {
            if (authorizedProjectKeys.contains(projectKey)) continue;
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            authorizedProjectKeys.add(projectKey);
        }
    }
}

