/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.controllers;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.AppManifest;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.datasets.fs.hdfs.HDFSPermissionsSynchronizer;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.gh.GovernIntegrationService;
import com.dataiku.dip.integrations.IntegrationHooksRegistry;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.security.PermissionsWatcher;
import com.dataiku.dip.security.PermissionsWatchersService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.api.projects.ProjectPermissions;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.notifications.emails.AbstractInviteEmailSendService;
import com.dataiku.dip.server.notifications.emails.ProjectInviteEmailSendService;
import com.dataiku.dip.server.services.InterestsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.server.services.projects.ProjectFeaturesUsage;
import com.dataiku.dip.server.services.projects.ProjectFeaturesUsageService;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.git.jgit.ProjectsJGitService;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss_gh.api.models.governance_status.DSSItemGovernanceStatusList;
import com.dataiku.dss_gh.api.models.identifiers.DSSItemIdentifierList;
import com.dataiku.dss_gh.api.models.identifiers.DSSProjectIdentifier;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.MalformedParametersException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ProjectsCRUDController
extends DIPInternalControllerBase {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private ProjectsJGitService projectsGitService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    @Autowired
    private PermissionsWatchersService permissionsWatchersService;
    @Autowired
    private InterestsService interestsService;
    @Autowired
    private TimelinesService timelinesService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private IPermissionsService permService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private PasswordEncryptionService symetricCryptoService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private ScenariosService scenariosService;
    @Autowired
    private AppsService appsService;
    @Autowired
    private GovernIntegrationService governIntegrationService;
    @Autowired
    private ProjectFeaturesUsageService projectFeaturesUsageService;
    @Autowired
    private ProjectInviteEmailSendService projectInviteEmailSendService;
    @Autowired
    private TaggingService taggingService;
    static Logger logger = Logger.getLogger((String)"dku.projects.controller");

    @AuditedCall(value={"msgType", "projects-list"})
    @RequestMapping(value={"/api/projects/list"})
    public void list(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) boolean includeLimitedVisibility) throws Exception {
        List<ProjectsService.UIProject> list;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            list = this.projectsService.listAccessibleUnsafe(u, includeLimitedVisibility);
        }
        ProjectsCRUDController.writeJSON((HttpServletResponse)resp, list);
    }

    @AuditedCall(value={"msgType", "projects-list"})
    @RequestMapping(value={"/api/projects/list-heads"})
    public void listHeads(HttpServletRequest req, HttpServletResponse resp, @RequestParam(required=false) String requiredPrivilege) throws Exception {
        List<ProjectsService.UIProject> list;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx u = this.authService.getMandatoryUser(req);
            list = StringUtils.isBlank((String)requiredPrivilege) ? this.projectsService.listAccessibleUnsafe(u) : this.projectsService.listAccessibleUnsafe(u, Privileges.ProjectLevelPrivilegeType.valueOf(requiredPrivilege));
        }
        ArrayList<ProjectHead> ret = new ArrayList<ProjectHead>(list.size());
        for (ProjectsService.UIProject project : list) {
            ret.add(new ProjectHead(project));
        }
        ProjectsCRUDController.writeJSON((HttpServletResponse)resp, ret);
    }

    @AuditedCall(value={"msgType", "projects-list"})
    @RequestMapping(value={"/api/projects/list-extended"})
    public void listExtended(HttpServletRequest req, HttpServletResponse resp, @RequestParam boolean lightMode, @RequestParam(required=false, defaultValue="true") boolean withTagsFile, @RequestParam(required=false, defaultValue="false") boolean withGitInfo) throws Exception {
        List<ProjectsService.HomepageProjectItem> list;
        AuthCtx u;
        HashMap<String, List<Scenario>> scenariosMap = new HashMap<String, List<Scenario>>();
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            list = this.projectsService.listAccessibleUnsafeExtended(u, lightMode, withTagsFile);
            for (ProjectsService.HomepageProjectItem hpi : list) {
                ArrayList scenarios = Lists.newArrayList();
                try {
                    scenarios.addAll(this.scenariosService.listUnsafe(hpi.projectKey));
                }
                catch (Exception e) {
                    logger.warn((Object)"Unable to retrieve scenarios of project", (Throwable)e);
                }
                scenariosMap.put(hpi.projectKey, scenarios);
            }
        }
        logger.info((Object)"Got project list, enriching");
        for (ProjectsService.HomepageProjectItem hpi : list) {
            this.projectsService.enrichHomepageProjectItem_NT(hpi, u, lightMode, withGitInfo, scenariosMap);
        }
        ProjectsCRUDController.writeJSON((HttpServletResponse)resp, list);
    }

    @AuditedCall(value={"msgType", "projects-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/get-extended"})
    @ResponseBody
    public ProjectsService.HomepageProjectItem getExtended(HttpServletRequest req, @RequestParam String projectKey, @RequestParam boolean lightMode, @RequestParam(required=false, defaultValue="true") boolean withTagsFile, @RequestParam(required=false, defaultValue="false") boolean withGitInfo) throws Exception {
        ProjectsService.HomepageProjectItem hpi;
        AuthCtx u;
        HashMap<String, List<Scenario>> scenariosMap = new HashMap<String, List<Scenario>>();
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            SerializedProject prj = this.projectsService.getMandatoryUnsafe(projectKey);
            hpi = this.projectsService.getProjectItemWithPermissionChecksFromProject(u, prj, lightMode, withTagsFile);
            if (hpi == null) {
                throw new UnauthorizedException("Action forbidden", "project-authorization-failure");
            }
            ArrayList scenarios = Lists.newArrayList();
            scenarios.addAll(this.scenariosService.listUnsafe(projectKey));
            scenariosMap.put(projectKey, scenarios);
        }
        this.projectsService.enrichHomepageProjectItem_NT(hpi, u, lightMode, withGitInfo, scenariosMap);
        return hpi;
    }

    @AuditedCall(value={"msgType", "projects-list"})
    @RequestMapping(value={"/api/projects/list-all-keys"})
    public void listAllKeys(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        List<String> keys;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            keys = this.projectsService.listKeys();
        }
        ProjectsCRUDController.writeJSON((HttpServletResponse)resp, keys);
    }

    @AuditedCall(value={"msgType", "projects-list"})
    @RequestMapping(value={"/api/projects/list-all-tags"})
    public void listAllTags(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Set<String> tags;
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getMandatoryUser(req);
            tags = this.projectsService.listTags();
        }
        ProjectsCRUDController.writeJSON((HttpServletResponse)resp, tags);
    }

    @AuditedCall(value={"msgType", "project-create", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/create"})
    public void create(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String name, @RequestParam(required=false) String projectFolderId) throws Exception {
        DSSAuthCtx liu;
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            liu = (DSSAuthCtx)this.authService.getMandatoryUser(req);
            if (!liu.getPermissions().mayCreateProjects()) {
                throw new SecurityException("You may not create new projects");
            }
            this.licenseEnforcementService.checkUsersOverQuota("create project");
            this.projectsService.create(projectKey, name, projectFolderId);
            t.commit("Created a new project: " + name + " (" + projectKey + ")");
        }
        this.projectsGitService.addProjectVersionTag_NT(liu, projectKey);
    }

    @AuditedCall(value={"msgType", "project-get-settings", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/get-settings"})
    public void getSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        SerializedProject sp;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
            sp = this.projectsService.getMandatoryUnsafe(projectKey);
        }
        ProjectsCRUDController.writeJSON((HttpServletResponse)resp, (Object)sp);
    }

    @AuditedCall(value={"msgType", "project-get-permissions", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/get-permissions"})
    public void getPermissions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        SerializedProject sp;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.EDIT_PERMISSIONS);
            sp = this.projectsService.getMandatoryUnsafe(projectKey);
        }
        ProjectPermissions projectPermissions = new ProjectPermissions();
        projectPermissions.permissions = sp.permissions;
        projectPermissions.owner = sp.owner;
        ProjectsCRUDController.writeJSON((HttpServletResponse)resp, (Object)projectPermissions);
    }

    @AuditedCall(value={"msgType", "project-get-dashboard-authorizations", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/get-dashboard-authorizations"})
    public void getDashboardAuthorizations(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(required=false, defaultValue="true") boolean withLicensingCheck) throws Exception {
        SerializedProject.ProjectDashboardAuthorizations ret = null;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permService.checkProjectPrivileges(authCtx, projectKey, withLicensingCheck, Privileges.ProjectLevelPrivilegeType.MANAGE_DASHBOARD_AUTHORIZATIONS);
            SerializedProject sp = this.projectsService.getMandatory(projectKey);
            ret = this.projectsService.getDashboardAuthorizationsWithNames(sp);
        }
        ProjectsCRUDController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "project-get-additional-users", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/get-additional-dashboard-users"})
    public void getAdditionalDashboardUsers(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            SerializedProject sp = this.projectsService.getMandatory(projectKey);
            if (sp.permissionsVersion != SerializedProject.PermissionsVersion.LEGACY) {
                throw new IllegalStateException("Additional dashboard users are no longer supported on projects with new permission scheme");
            }
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.MANAGE_ADDITIONAL_DASHBOARD_USERS);
            ProjectsCRUDController.writeJSON((HttpServletResponse)resp, (Object)sp.additionalDashboardUsers);
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/projects/save-permissions"})
    public void savePermissions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String project) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            SerializedProject sp = (SerializedProject)JSON.parse((String)project, SerializedProject.class);
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
            if (!projectKey.equals(sp.projectKey)) {
                throw new IllegalArgumentException("Invalid supplied projectKey: it does not match the key of the project.");
            }
            PermissionsWatcher pw = this.permissionsWatchersService.startProjectWatch(projectKey);
            ProjectsCRUDController.writeJSON((HttpServletResponse)resp, (Object)this.projectsService.setPermissions(sp));
            pw.stop();
            t.commit("Updated project permissions (project:" + projectKey + ")");
            ProjectPermissions pp = new ProjectPermissions();
            pp.owner = sp.owner;
            pp.permissions = sp.permissions;
            this.auditTrailService.generic("project-save-permissions").with("projectKey", projectKey).with("newPermissions", JSON.toJsonObject((Object)pp)).emit();
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/projects/save-permissions-non-admin"})
    public void savePermissionsNonAdmin(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam List<SerializedProject.PermissionItem> permissions) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.EDIT_PERMISSIONS);
            SerializedProject sp = this.projectsService.getMandatory(projectKey);
            this.projectsService.checkNonAdminCanSavePermissions(u, sp, permissions);
            PermissionsWatcher pw = this.permissionsWatchersService.startProjectWatch(projectKey);
            sp.permissions = permissions;
            ProjectsCRUDController.writeJSON((HttpServletResponse)resp, (Object)this.projectsService.setPermissions(sp));
            pw.stop();
            t.commit("Updated project permissions (project:" + projectKey + ")");
            this.auditTrailService.generic("project-save-permissions-non-admin").with("projectKey", projectKey).with("newPermissions", JSON.json(permissions)).emit();
        }
    }

    @AuditedCall(value={"msgType", "project-resend-invitation-email", "projectKey", "${projectKey}", "email", "${email}"})
    @RequestMapping(value={"/api/projects/resend-project-invitation-email"})
    public void resendProjectInvitationEmail(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String email) throws IOException, DKUSecurityException, CodedException, LimitsStatusComputer.LicenseLimitException {
        GeneralSettingsDAO.GeneralSettings gs;
        AuthCtx u;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)email), (Object)"Missing email address");
        try (Transaction t = this.transactionService.beginRead();){
            u = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(u, projectKey, Privileges.ProjectLevelPrivilegeType.EDIT_PERMISSIONS);
            gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        }
        AbstractInviteEmailSendService.InvitationEmailSendResult result = new AbstractInviteEmailSendService.InvitationEmailSendResult();
        this.projectInviteEmailSendService.sendInviteEmails(result, projectKey, email, u.getIdentifier(), gs);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            SerializedProject sp = this.projectsService.getMandatoryUnsafe(projectKey);
            SerializedProject.PermissionItem matchingPendingEmailPermission = sp.permissions.stream().filter(item -> item != null && email.equalsIgnoreCase(item.pendingUserEmail)).findFirst().orElse(null);
            if (matchingPendingEmailPermission == null) {
                throw new IllegalArgumentException(String.format("No matching pending email permission found on project %s for email %s", projectKey, email));
            }
            this.projectInviteEmailSendService.updateEmailStatusesAndSaveProject(projectKey, u.getIdentifier(), result);
            t.commit("Sent project invitation emails");
        }
        ProjectsCRUDController.writeJSON((HttpServletResponse)resp, (Object)result);
    }

    @AuditInline
    @RequestMapping(value={"/api/projects/save-additional-dashboard-users"})
    public void saveAdditionalDashboardUsers(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String data) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            SerializedProject sp = this.projectsService.getMandatory(projectKey);
            if (sp.permissionsVersion != SerializedProject.PermissionsVersion.LEGACY) {
                throw new IllegalStateException("Additional dashboard users are no longer supported on projects with new permission scheme");
            }
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.MANAGE_ADDITIONAL_DASHBOARD_USERS);
            PermissionsWatcher pw = this.permissionsWatchersService.startProjectWatch(projectKey);
            sp.additionalDashboardUsers = (SerializedProject.AdditionalDashboardUsers)JSON.parse((String)data, SerializedProject.AdditionalDashboardUsers.class);
            this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.PERMISSIONS_ONLY);
            pw.stop();
            t.commit("Updated project additional dashboard users (project:" + projectKey + ")");
            this.auditTrailService.generic("project-save-dashboard-users").with("projectKey", projectKey).with("newUsers", JSON.toJsonObject((Object)sp.additionalDashboardUsers)).emit();
        }
    }

    @AuditedCall(value={"msgType", "project-get-project-access-info", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/get-project-access-info"})
    public void getProjectAccessInfo(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        ProjectAccessInfo projectAccessInfo = new ProjectAccessInfo();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            SerializedProject sp = this.projectsService.getOrNullUnsafe(projectKey);
            if (sp != null) {
                projectAccessInfo.hasAnyProjectAccess = this.permService.hasProjectPrivilege(authCtx, sp, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
                if (!projectAccessInfo.hasAnyProjectAccess) {
                    GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.getUnsafe();
                    projectAccessInfo.isVisible = this.projectsService.isVisible(sp, generalSettings);
                    projectAccessInfo.isAccessRequestsEnabled = this.projectsService.isAccessRequestsEnabled(sp, generalSettings);
                }
            }
        }
        if (!projectAccessInfo.hasAnyProjectAccess && BooleanUtils.isNotTrue((Boolean)projectAccessInfo.isVisible) && BooleanUtils.isNotTrue((Boolean)projectAccessInfo.isAccessRequestsEnabled)) {
            throw new UnauthorizedException("Failed to read project permissions. Project does not exist or you do not have the permission to access it.", "check-failed");
        }
        ProjectsCRUDController.writeJSON((HttpServletResponse)resp, (Object)projectAccessInfo);
    }

    @AuditedCall(value={"msgType", "project-read-meta", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/get-visible-summary"})
    public void getVisibleSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        ProjectsService.VisibleProjectSummary summary;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            boolean isVisible = this.projectsService.isVisible(projectKey);
            if (!isVisible) {
                this.projectsService.checkReadDashboardPerm(authCtx, projectKey, null, null);
            }
            summary = this.projectsService.getVisibleProjectSummary(authCtx, projectKey);
        }
        ProjectsCRUDController.writeJSON((HttpServletResponse)resp, (Object)summary);
    }

    @AuditedCall(value={"msgType", "project-read-meta", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/get-summary"})
    public void getSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam(required=false, defaultValue="true") boolean includeObjectsCounts, @RequestParam(required=false, defaultValue="true") boolean includeTimeline, @RequestParam(required=false, defaultValue="true") boolean includeContributors, @RequestParam(required=false, defaultValue="true") boolean includeInterests, @RequestParam(required=false, defaultValue="true") boolean includeGitInfo) throws Exception {
        boolean canReadContent;
        AuthCtx authCtx;
        ProjectSummary summ;
        block22: {
            summ = new ProjectSummary();
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
                this.projectsService.checkReadDashboardPerm(authCtx, projectKey, null, null);
                ProjectsService.UIProject ps2 = this.projectsService.getSummary(authCtx, projectKey, true);
                summ.object = ps2;
                if (includeContributors) {
                    for (String login : this.timelinesService.getContributors(ps2.projectKey)) {
                        ps2.contributors.add(this.usersService.getPublicUser(login));
                    }
                }
                canReadContent = this.permService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                if (includeObjectsCounts && canReadContent) {
                    summ.objectsCounts = this.projectsService.getProjectObjectsCounts(ps2);
                }
                if (ps2.projectType != SerializedProject.ProjectType.REGULAR && ps2.activeBundleState == null) break block22;
                try {
                    if (ps2.projectAppType == SerializedProject.ProjectAppType.APP_INSTANCE) {
                        assert (ps2.generatingAppId != null);
                        ps2.appManifest = this.appsService.getAppInstanceManifestForProject_T(authCtx, projectKey);
                    } else if (ps2.projectAppType == SerializedProject.ProjectAppType.APP_TEMPLATE) {
                        ps2.appManifest = this.appsService.getAppTemplateManifestForProject_T(projectKey);
                    } else if (ps2.hasSetupSection) {
                        ps2.appManifest = this.appsService.getAppTemplateManifestForProject_T(projectKey);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Unable to load app manifest of " + projectKey), (Throwable)e);
                }
            }
        }
        if (includeTimeline) {
            try {
                summ.timeline = this.timelinesService.getProjectTimeline_NT(projectKey, 0, 100);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to get timeline", (Throwable)e);
            }
        }
        if (includeInterests) {
            summ.interest = this.interestsService.getObjectAndUserInterest_noFail(authCtx, summ.object.getTaggableType(), projectKey, projectKey);
        }
        if (includeGitInfo && canReadContent) {
            summ.projectCurrentBranch = this.projectsGitService.getCurrentBranch_NT(projectKey);
        }
        ProjectsCRUDController.writeJSON((HttpServletResponse)resp, (Object)summ);
    }

    @AuditedCall(value={"msgType", "project-save-meta", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/save-summary"})
    public void saveSummary(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String data) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SerializedProject sp = this.projectsService.getMandatory(projectKey);
            ProjectsService.UIProject ps2 = (ProjectsService.UIProject)JSON.parse((String)data, ProjectsService.UIProject.class);
            sp.name = ps2.name;
            sp.description = ps2.description;
            sp.shortDesc = ps2.shortDesc;
            sp.tags = ps2.tags;
            sp.checklists = ps2.checklists;
            sp.projectStatus = ps2.projectStatus;
            sp.imgColor = ps2.imgColor;
            sp.customFields = ps2.customFields;
            sp.imgPattern = ps2.imgPattern;
            sp.showInitials = ps2.showInitials;
            this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.SUMMARY_ONLY);
            t.commit("Updated summary of project " + projectKey, 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
        }
    }

    @AuditedCall(value={"msgType", "project-save-settings", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/save-settings"})
    public void saveSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String data) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            SerializedProject.ProjectSettings settings;
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
            SerializedProject sp = this.projectsService.getMandatory(projectKey);
            sp.settings = settings = (SerializedProject.ProjectSettings)JSON.parse((String)data, SerializedProject.ProjectSettings.class);
            GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.getUnsafe();
            for (SerializedProject.ProjectIntegration integration : sp.settings.integrations.integrations) {
                if (integration.hook == null || integration.hook.configuration == null) continue;
                IntegrationHooksRegistry.getMeta(integration.hook).prepareForSave(integration.hook, this.symetricCryptoService, generalSettings.security);
            }
            this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.LOCAL_SETTINGS_ONLY);
            t.commit("Updated settings of project " + projectKey);
        }
    }

    @AuditedCall(value={"msgType", "project-save-dashboard-authorizations", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/add-reader-authorizations"})
    public void addReaderAuthorization(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String readerAuthorizations) throws Exception {
        SerializedProject.ReaderAuthorization[] readerAuthorizationsList = (SerializedProject.ReaderAuthorization[])JSON.parse((String)readerAuthorizations, SerializedProject.ReaderAuthorization[].class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getUser(req);
            SerializedProject project = this.projectsService.getMandatory(projectKey);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.MANAGE_DASHBOARD_AUTHORIZATIONS);
            for (SerializedProject.ReaderAuthorization ra : readerAuthorizationsList) {
                SerializedProject.ReaderAuthorization existingReaderAuth = null;
                for (SerializedProject.ReaderAuthorization readerAuthorization : project.dashboardAuthorizations.authorizations) {
                    if (!readerAuthorization.objectRef.equals(ra.objectRef)) continue;
                    existingReaderAuth = readerAuthorization;
                }
                if (existingReaderAuth != null) {
                    existingReaderAuth.modes.addAll(ra.modes);
                    continue;
                }
                project.dashboardAuthorizations.authorizations.add(ra);
            }
            this.projectsService.save(project, TaggableObjectChangedEvent.ProjectEditSubtype.PERMISSIONS_ONLY);
            t.commit("Added " + readerAuthorizationsList.length + " objects to reader authorizations of project " + projectKey);
        }
    }

    @AuditedCall(value={"msgType", "project-read-dashboard-authorizations", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/check-reader-authorizations"}, method={RequestMethod.POST})
    public void checkReaderAuthorization(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String readerAuthorizations) throws Exception {
        SerializedProject.ReaderAuthorization[] readerAuthorizationsList = (SerializedProject.ReaderAuthorization[])JSON.parse((String)readerAuthorizations, SerializedProject.ReaderAuthorization[].class);
        HashMap<Integer, SerializedProject.ReaderAuthorization> missingReaderAuthorizationsMap = new HashMap<Integer, SerializedProject.ReaderAuthorization>();
        ArrayList<SerializedProject.ReaderAuthorization> missingAuthorizations = new ArrayList<SerializedProject.ReaderAuthorization>();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx user = this.authService.getUser(req);
            SerializedProject project = this.projectsService.getMandatoryUnsafe(projectKey);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS);
            for (SerializedProject.ReaderAuthorization ra : readerAuthorizationsList) {
                Integer key;
                SerializedProject.ReaderAuthorization missingReaderAuthorization;
                SerializedProject.ReaderAuthorization existingReaderAuth = null;
                for (SerializedProject.ReaderAuthorization readerAuthorization : project.dashboardAuthorizations.authorizations) {
                    if (!readerAuthorization.objectRef.equals(ra.objectRef)) continue;
                    existingReaderAuth = readerAuthorization;
                }
                if (existingReaderAuth != null) {
                    ra.modes.removeAll(new HashSet<SerializedProject.ReaderAuthorization.Mode>(existingReaderAuth.modes));
                }
                if ((missingReaderAuthorization = (SerializedProject.ReaderAuthorization)missingReaderAuthorizationsMap.get(key = Integer.valueOf(ra.objectRef.hashCode()))) != null) {
                    missingReaderAuthorization.modes.addAll(ra.modes);
                    continue;
                }
                missingReaderAuthorizationsMap.put(key, ra);
            }
            for (SerializedProject.ReaderAuthorization mra : missingReaderAuthorizationsMap.values()) {
                if (mra.modes.isEmpty()) continue;
                missingAuthorizations.add(mra);
            }
        }
        ProjectsCRUDController.writeJSON((HttpServletResponse)resp, missingAuthorizations);
    }

    @AuditedCall(value={"msgType", "project-save-dashboard-authorizations", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/save-dashboard-authorizations"})
    public void saveReaderAuthorizations(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String dashboardAuthorizations) throws Exception {
        SerializedProject.ProjectDashboardAuthorizations authObj = (SerializedProject.ProjectDashboardAuthorizations)JSON.parse((String)dashboardAuthorizations, SerializedProject.ProjectDashboardAuthorizations.class);
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx user = this.authService.getUser(req);
            SerializedProject project = this.projectsService.getMandatory(projectKey);
            this.projectsService.checkPerm(user, projectKey, Privileges.ProjectLevelPrivilegeType.MANAGE_DASHBOARD_AUTHORIZATIONS);
            project.dashboardAuthorizations = authObj;
            this.projectsService.save(project, TaggableObjectChangedEvent.ProjectEditSubtype.PERMISSIONS_ONLY);
            t.commit("Saved reader authorizations of project " + projectKey);
        }
    }

    @AuditedCall(value={"msgType", "project-hdfs-resync-permissions"})
    @RequestMapping(value={"/api/projects/admin/resync-hdfs-permissions"})
    public void resyncHDFSPermissions(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
        }
        HDFSPermissionsSynchronizer sync = new HDFSPermissionsSynchronizer();
        ProjectsCRUDController.writeJSON((HttpServletResponse)resp, sync.startSetPermissionsOnProjectDatasets_NT(authCtx, projectKey));
    }

    @AuditedCall(value={"msgType", "project-governance-status-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/get-governance-status"})
    public void getGovernanceStatus(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.permService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        }
        DSSProjectIdentifier dssProjectIdentifier = this.governIntegrationService.buildDSSProjectIdentifier(projectKey);
        DSSItemIdentifierList dssItemIdentifierList = new DSSItemIdentifierList();
        dssItemIdentifierList.dssItemItentifiers.add(dssProjectIdentifier);
        DSSItemGovernanceStatusList dssItemGovernanceStatusList = this.governIntegrationService.getDSSItemsGovernanceStatus(dssItemIdentifierList);
        if (dssItemGovernanceStatusList.dssItemGovernanceStatuses.isEmpty()) {
            throw new IllegalStateException("Unexpected error: cannot retrieve governance status for project: " + projectKey);
        }
        ProjectsCRUDController.writeJSON((HttpServletResponse)resp, dssItemGovernanceStatusList.dssItemGovernanceStatuses.get(0));
    }

    @AuditInline
    @RequestMapping(value={"/api/projects/admin/govern-integration-sync"})
    public void governIntegrationSync(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
                this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
            }
            ProjectsCRUDController.writeJSON((HttpServletResponse)resp, this.governIntegrationService.checkConcurrentAndFullSync(authCtx, "project-govern-integration-sync", projectKey));
        }
        catch (Exception e) {
            this.auditTrailService.failure("project-govern-integration-sync", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/projects/check-deletability"})
    public void checkDeletability(HttpServletRequest req, HttpServletResponse resp, String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
            ProjectsCRUDController.writeJSON((HttpServletResponse)resp, (Object)((Object)this.projectsService.checkProjectDeletability(projectKey, false)));
        }
    }

    @AuditedCall(value={"msgType", "project-delete", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/delete"})
    public void delete(HttpServletRequest req, HttpServletResponse resp, String projectKey, boolean clearManagedDatasets, boolean clearOutputManagedFolders, boolean clearJobAndScenarioLogs) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        ProjectsCRUDController.writeJSON((HttpServletResponse)resp, (Object)this.projectsService.projectDeletionAttempt(authCtx, projectKey, clearManagedDatasets, clearOutputManagedFolders, clearJobAndScenarioLogs));
    }

    @AuditedCall(value={"msgType", "project-variables-get", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/variables/get"})
    public void getProjectVariables(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            VariablesService.ProjectVariablesWithComments pv = VariablesService.readLocalUnresolvedProjectVariablesWithComments(projectKey, t);
            ProjectsCRUDController.writeJSON((HttpServletResponse)resp, (Object)pv);
        }
    }

    @AuditedCall(value={"msgType", "project-variables-save", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/variables/save"})
    public void saveProjectVariables(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String data) throws Exception {
        VariablesService.ProjectVariablesWithComments pv = (VariablesService.ProjectVariablesWithComments)JSON.parse((String)data, VariablesService.ProjectVariablesWithComments.class);
        try {
            JSON.parse((String)pv.local, JsonObject.class);
            JSON.parse((String)pv.standard, JsonObject.class);
        }
        catch (JsonSyntaxException e) {
            throw new MalformedParametersException("Input project variables JSON is not valid");
        }
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            VariablesService.writeLocalProjectVariables(projectKey, t, pv, true);
        }
    }

    @AuditedCall(value={"msgType", "project-upgrade-permissions-version", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/upgrade-permissions-version"})
    public void upgradePermissionsVersion(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
            SerializedProject sp = this.projectsService.getMandatory(projectKey);
            if (sp.permissionsVersion != SerializedProject.PermissionsVersion.LEGACY) {
                throw new UnsupportedOperationException("Only legacy projects can be upgraded.");
            }
            PermissionsWatcher pw = this.permissionsWatchersService.startProjectWatch(projectKey);
            for (SerializedProject.PermissionItem permission : sp.permissions) {
                if (permission == null || !permission.moderateDashboards) continue;
                permission.moderateDashboards = false;
                permission.readDashboards = true;
                permission.writeDashboards = true;
            }
            SerializedProject.AdditionalDashboardUsers additionalDashboardUsers = sp.additionalDashboardUsers;
            if (additionalDashboardUsers != null && additionalDashboardUsers.users != null) {
                for (SerializedProject.AdditionalDashboardUser user : additionalDashboardUsers.users) {
                    if (user == null || user.login == null) continue;
                    SerializedProject.PermissionItem permission = sp.permissions.stream().filter(p -> p != null && user.login.equals(p.user)).findFirst().orElse(null);
                    if (permission == null) {
                        permission = ProjectsCRUDController.newPermissionItem(user);
                        sp.permissions.add(permission);
                    }
                    permission.readDashboards = true;
                }
            }
            sp.additionalDashboardUsers = new SerializedProject.AdditionalDashboardUsers();
            sp.permissionsVersion = SerializedProject.PermissionsVersion.V2;
            this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.PERMISSIONS_ONLY);
            pw.stop();
            t.commit("Upgraded permissions version to V2 on project " + projectKey);
        }
    }

    private static SerializedProject.PermissionItem newPermissionItem(SerializedProject.AdditionalDashboardUser user) {
        SerializedProject.PermissionItem permissionItem = new SerializedProject.PermissionItem();
        permissionItem.user = user.login;
        return permissionItem;
    }

    @AuditedCall(value={"msgType", "project-metadata", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/projects/get-project-features-usage"})
    public void getProjectFeaturesUsage(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        ProjectFeaturesUsage data;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            data = this.projectFeaturesUsageService.get(projectKey);
        }
        ProjectsCRUDController.writeJSON((HttpServletResponse)resp, (Object)data);
    }

    @AuditedCall(value={"msgType", "set-project-statuses", "projectKeys", "${projectKeys}", "status", "${status}"})
    @RequestMapping(value={"/api/projects/set-project-statuses"}, method={RequestMethod.POST})
    public void setProjectStatuses(HttpServletRequest req, HttpServletResponse resp, @RequestParam Set<String> projectKeys, String status) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            GeneralSettingsDAO.GeneralSettings gs = this.generalSettingsDAO.getUnsafe();
            if (gs.projectStatusList.stream().noneMatch(st2 -> StringUtils.equals((String)status, (String)st2.name))) {
                throw new UnauthorizedException("Unknown project status", "forbidden");
            }
            for (String projectKey : projectKeys) {
                this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            }
            boolean anyChanged = false;
            for (String projectKey : projectKeys) {
                SerializedProject sp = this.projectsService.getMandatory(projectKey);
                if (StringUtils.equals((String)sp.projectStatus, (String)status)) continue;
                anyChanged = true;
                sp.projectStatus = status;
                this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.SUMMARY_ONLY);
            }
            if (anyChanged) {
                t.commit("Updated statuses for projects " + String.join((CharSequence)", ", projectKeys));
            }
        }
    }

    @AuditedCall(value={"msgType", "projects-apply-tags", "projectKeys", "${projectKeys}"})
    @RequestMapping(value={"/api/projects/apply-tags"}, method={RequestMethod.POST})
    public void applyTagsOnProjects(HttpServletRequest req, HttpServletResponse resp, @RequestParam Set<String> projectKeys, TaggingService.TaggingRequest taggingRequest) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            for (String projectKey : projectKeys) {
                this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            }
            for (String projectKey : projectKeys) {
                SerializedProject sp = this.projectsService.getMandatory(projectKey);
                for (TaggingService.TaggingOperation taggingOperation : taggingRequest.operations) {
                    sp.tags = this.taggingService.execMerge(sp.tags, taggingOperation.tags, taggingOperation.mode);
                }
                this.projectsService.save(sp, TaggableObjectChangedEvent.ProjectEditSubtype.SUMMARY_ONLY);
            }
            t.commit("Applied tags on projects " + String.join((CharSequence)", ", projectKeys));
        }
    }

    @UIModel
    static class ProjectHead {
        public String name;
        public String projectKey;

        ProjectHead(ProjectsService.UIProject project) {
            this.projectKey = project.projectKey;
            this.name = project.name;
        }
    }

    static class ProjectAccessInfo {
        public Boolean isVisible;
        public Boolean isAccessRequestsEnabled;
        public boolean hasAnyProjectAccess = false;

        ProjectAccessInfo() {
        }
    }

    public static class ProjectSummary
    extends TaggableObjectsService.TaggableObjectSummary {
        public String projectCurrentBranch;
        public ProjectsService.ProjectObjectsCounts objectsCounts;
        public SerializedProject.ProjectAppType projectAppType;
        public AppManifest appManifest;
    }
}

