/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.model.core.AnalysisCoreParams;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dashboards.insights.InsightsService;
import com.dataiku.dip.datacollections.AbstractDataCollectionItemRef;
import com.dataiku.dip.datacollections.DataCollectionsService;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowImplicitRecipe;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.DatasetInspector;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.eda.compute.sampling.SampleMappingService;
import com.dataiku.dip.eda.worksheets.WorksheetsService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.hive.HiveMetastoreSynchronizer;
import com.dataiku.dip.hive.HiveMetastoreSynchronizerFactory;
import com.dataiku.dip.hive.MetastoreInspectionService;
import com.dataiku.dip.hive.MetastoreSynchronizationUtils;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.LabelingTasksCRUDService;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.pivot.backend.PivotTablesService;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.notifications.backend.DatasetChangedEvent;
import com.dataiku.dip.server.recipes.RecipeSaveService;
import com.dataiku.dip.server.services.ExploresService;
import com.dataiku.dip.server.services.ExposedObjectsService;
import com.dataiku.dip.server.services.FlowExecutionService2;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.NeverBuiltComputablesCacheService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.TwitterConnectorsService;
import com.dataiku.dip.server.services.dataquality.DataQualityService;
import com.dataiku.dip.shaker.SampleBuilder;
import com.dataiku.dip.shaker.server.DataService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatasetDeletionService
implements DSSEventListener<DatasetChangedEvent> {
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private LabelingTasksDAO labelingTasksDAO;
    @Autowired
    private RecipeSaveService recipesSaveService;
    @Autowired
    private LabelingTasksCRUDService labelingTasksCRUDService;
    @Autowired
    private PivotTablesService pivotTablesService;
    @Autowired
    private ExploresService exploresService;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private TwitterConnectorsService twitterConnectorsService;
    @Autowired
    private DataService dataService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private FlowExecutionService2 flowExecService;
    @Autowired
    private FlowGraphService graphService;
    @Autowired
    private InsightsService insightsService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private ScenariosService scenariosService;
    @Autowired
    private WorksheetsService worksheetsService;
    @Autowired
    private NeverBuiltComputablesCacheService neverBuiltComputablesCacheService;
    @Autowired
    private MetastoreInspectionService metastoreInspectionService;
    @Autowired
    private SampleMappingService sampleMappingService;
    @Autowired
    private ExposedObjectsService exposedObjectsService;
    @Autowired
    private DataCollectionsService dataCollectionService;
    @Autowired
    private DataQualityService dataQualityService;
    @Autowired
    protected PermissionsService permissionsService;
    @Autowired
    protected ProjectsService projectsService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.server.datasets");

    public static TaggableObjectsDeletionService.DeletionImpact merge(List<TaggableObjectsDeletionService.DeletionImpact> impacts) {
        TaggableObjectsDeletionService.DeletionImpact global = new TaggableObjectsDeletionService.DeletionImpact();
        for (TaggableObjectsDeletionService.DeletionImpact i : impacts) {
            global.merge(i);
        }
        return global;
    }

    @PostConstruct
    public void installListener() {
        this.pubSub.subscribe("dataset-change", this);
    }

    public InfoMessage.InfoMessages clearCache_NT(Dataset dataset) {
        TransactionContext.assertNoAttachedTransaction();
        logger.info((Object)("Clearing all caches for " + dataset.getFullName()));
        InfoMessage.InfoMessages dr = new InfoMessage.InfoMessages();
        try {
            this.dataService.invalidateCache(DatasetLocUtils.resolveFull(dataset.getFullName()));
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to clear RAM cache", (Throwable)e);
            dr.withWarningV((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_DELETION_INTERNAL_ERROR, "Unable to clear RAM cache for dataset %s: %s", new Object[]{dataset.getFullName(), ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
        try {
            SampleBuilder.clearSamplesWithLock(dataset);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to clear disk cache", (Throwable)e);
            dr.withWarningV((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_DELETION_INTERNAL_ERROR, "Unable to clear disk cache for dataset %s: %s", new Object[]{dataset.getFullName(), ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
        try {
            this.pivotTablesService.invalidateCache(dataset);
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to clear chart cache", (Throwable)e);
            dr.withWarningV((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_DELETION_INTERNAL_ERROR, "Unable to clear chart cache for dataset %s: %s", new Object[]{dataset.getFullName(), ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
        try {
            this.sampleMappingService.removeDatasetSamples(dataset.getLoc());
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to clear statistics cache", (Throwable)e);
            dr.withWarningV((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_DELETION_INTERNAL_ERROR, "Unable to clear statistics cache for dataset %s: %s", new Object[]{dataset.getFullName(), ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
        return dr;
    }

    public InfoMessage.InfoMessages clearCacheAndStatus_NT(Dataset dataset) {
        TransactionContext.assertNoAttachedTransaction();
        InfoMessage.InfoMessages ret = this.clearCache_NT(dataset);
        try {
            this.flowExecService.clearTimestampsForDataset(DatasetLocUtils.resolveFull(dataset.getFullName()));
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to clear timestamps", (Throwable)e);
            ret.withWarningV((InfoMessage.MessageCode)DatasetCodes.WARN_DATASET_DELETION_INTERNAL_ERROR, "Unable to clear flow state for dataset %s: %s", new Object[]{dataset.getFullName(), ExceptionUtils.getMessageWithCauses((Throwable)e)});
        }
        return ret;
    }

    public InfoMessage.InfoMessages clearDatasetData_NT(AuthCtx authCtx, Dataset dataset, boolean evenIfNotManaged, boolean withStructure) throws IOException {
        InfoMessage.InfoMessages infoMessages;
        block23: {
            logger.infoV("Clearing dataset data  dataset=%s type=%s managed=%s evenIfNotManaged=%s withStructure=%s", new Object[]{dataset.getFullName(), dataset.getType(), dataset.isManaged(), evenIfNotManaged, withStructure});
            TransactionContext.assertNoAttachedTransaction();
            InfoMessage.InfoMessages ret = this.clearCacheAndStatus_NT(dataset);
            CurrentComputeResourceUsageContext.setInCurrentThreadIfNull((ComputeResourceUsageContext)ComputeResourceUsageContext.forDatasetClearing((AuthCtx)authCtx, (String)dataset.getProjectKey(), (String)dataset.getName()));
            DatasetHandler datasetHandler = DatasetHandlerFactory.build(authCtx, dataset);
            try {
                if (evenIfNotManaged || dataset.isManaged() || datasetHandler.getMeta() == BuiltinFSDatasets.UPLOADED_FILES_META) {
                    block22: {
                        try {
                            if (!DatasetInspector.isMetastoreAssociatedType(dataset) || !MetastoreSynchronizationUtils.synchronizationRequested((AuthCtx)authCtx, (Dataset)dataset).requested || !this.metastoreInspectionService.metastoreSupportEnabled(authCtx, dataset.getProjectKey())) break block22;
                            try (HiveMetastoreSynchronizer synchronizer = HiveMetastoreSynchronizerFactory.getSynchronizer(authCtx);){
                                synchronizer.dropExternalTable(dataset);
                            }
                        }
                        catch (Exception e) {
                            logger.warn((Object)"Failed to drop Hive table", (Throwable)e);
                            ret.withFatalV((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_DELETION_HIVE_FAILED, "Unable to drop Hive table corresponding to dataset %s: %s", new Object[]{dataset.getFullName(), ExceptionUtils.getMessageWithCauses((Throwable)e)});
                        }
                    }
                    try {
                        this.jobsDatabaseService.clearForDataset(dataset.getLoc());
                        if (withStructure) {
                            datasetHandler.clearAllDataAndStructure();
                        } else {
                            datasetHandler.clearAllData();
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Failed to drop data", (Throwable)e);
                        ret.withFatalV((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_DELETION_DATA_FAILED, "Unable to clear data for dataset %s: %s", new Object[]{dataset.getFullName(), ExceptionUtils.getMessageWithCauses((Throwable)e)});
                    }
                    if (this.neverBuiltComputablesCacheService.canBeAdded(dataset)) {
                        this.neverBuiltComputablesCacheService.add(new TaggableObjectsService.TaggableObjectRef(dataset.serialize()));
                    }
                }
                infoMessages = ret;
                if (datasetHandler == null) break block23;
            }
            catch (Throwable throwable) {
                try {
                    if (datasetHandler != null) {
                        try {
                            datasetHandler.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    logger.warn((Object)("Failed to delete dataset " + dataset.getFullName()), e);
                    return ret;
                }
            }
            datasetHandler.close();
        }
        return infoMessages;
    }

    public void clearPartitions_NT(AuthCtx authCtx, Dataset ds, List<String> partitionIds) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        CurrentComputeResourceUsageContext.setInCurrentThreadIfNull((ComputeResourceUsageContext)ComputeResourceUsageContext.forDatasetClearing((AuthCtx)authCtx, (String)ds.getProjectKey(), (String)ds.getName()));
        try (DatasetHandler dih = DatasetHandlerFactory.build(authCtx, ds);){
            ArrayList<Partition> parts = new ArrayList<Partition>();
            for (String pid : partitionIds) {
                Partition p = PartitionFactory.fromIdentifier(ds.getPartitioningSchema(), pid);
                parts.add(p);
                this.jobsDatabaseService.clearForDataset(ds.getLoc(), pid);
            }
            dih.clearPartitions(parts);
            this.clearCache_NT(ds);
            this.flowExecService.clearTimestampsForDatasetPartitions(DatasetLocUtils.resolveFull(ds.getFullName()), partitionIds);
        }
    }

    public void performDeletion(Dataset dataset, Set<TaggableObjectsService.TaggableObjectRef> ignored, AuthCtx authCtx, boolean deleteAndReconnect) throws Exception {
        this.performDeletion(dataset, ignored, authCtx, false, deleteAndReconnect);
    }

    public void performDeletion(Dataset dataset, @Nullable Set<TaggableObjectsService.TaggableObjectRef> ignored, AuthCtx authCtx, boolean inProjectDeletion, boolean deleteAndReconnect) throws Exception {
        logger.info((Object)("Deleting dataset " + dataset.getFullName()));
        if ("Twitter".equals(dataset.getType()) && this.twitterConnectorsService.isStarted(dataset.getFullName())) {
            throw ErrorContext.iaef((String)"Stop streaming before deleting Twitter dataset %s", (Object)dataset.getFullName(), (Object[])new Object[0]);
        }
        if (!inProjectDeletion) {
            TaggableObjectsDeletionService.DeletionImpact di = this.computeDeletionImpact(authCtx, dataset, ignored, deleteAndReconnect);
            for (TaggableObjectsDeletionService.ImpactedDataset impactedDataset2 : di.deletedDatasets) {
                this.datasetSaveService.delete(impactedDataset2.projectKey, impactedDataset2.name);
            }
            HashSet<TaggableObjectsService.TaggableObjectRef> ignoredWithDeletedDatasets = ignored == null ? new HashSet<TaggableObjectsService.TaggableObjectRef>() : new HashSet<TaggableObjectsService.TaggableObjectRef>(ignored);
            ignoredWithDeletedDatasets.addAll(di.deletedDatasets.stream().map(impactedDataset -> new TaggableObjectsService.TaggableObjectRef(impactedDataset.projectKey, ITaggingService.TaggableType.DATASET, impactedDataset.name)).collect(Collectors.toList()));
            for (TaggableObjectsDeletionService.ImpactedRecipe recipe : di.deletedRecipes) {
                this.recipesSaveService.delete(recipe.projectKey, recipe.name);
            }
            for (TaggableObjectsDeletionService.ImpactedLabelingTask labelingTask : di.deletedLabelingTasks) {
                this.labelingTasksCRUDService.delete(authCtx, labelingTask.projectKey, labelingTask.id, ignoredWithDeletedDatasets);
            }
            this.labelingTasksCRUDService.deleteLabelingTaskReference(dataset);
            this.exploresService.delete(dataset.getProjectKey(), dataset.getName());
            this.scenariosService.deleteStepsForSource(dataset.getProjectKey(), ITaggingService.TaggableType.DATASET, dataset.getName());
            try {
                this.exposedObjectsService.removeExposedObject(dataset.getProjectKey(), ITaggingService.TaggableType.DATASET, dataset.getName());
            }
            catch (Exception exception) {
                logger.warnV((Throwable)exception, "Unable to remove objet sharing for %s(%s) on project %s.", new Object[]{ITaggingService.TaggableType.DATASET, dataset.getName(), dataset.getProjectKey()});
            }
        }
        this.dataCollectionService.removeItemFromAllCollections(new AbstractDataCollectionItemRef.DatasetRef(dataset.getProjectKey(), dataset.getName()));
        this.analysisCRUDService.deleteAllAnalysisForDataset(dataset.getProjectKey(), dataset.getName());
        this.worksheetsService.deleteAllForDataset(dataset.getProjectKey(), dataset.getName());
        this.insightsService.deleteForSource(dataset.getProjectKey(), ITaggingService.TaggableType.DATASET, dataset.getName());
    }

    public InfoMessage.InfoMessages clearDatasetForDeletion_NT(AuthCtx user, Dataset dataset, TaggableObjectsDeletionService.DeletionOptions options) throws Exception {
        TaggableObjectsDeletionService.PreDeletionContext preDeletionContext = new TaggableObjectsDeletionService.PreDeletionContext();
        preDeletionContext.inProjectDeletion = false;
        preDeletionContext.lastItemWithDQStatusFromThisProject = true;
        return this.clearDatasetForDeletion_NT(user, dataset, options, preDeletionContext);
    }

    public InfoMessage.InfoMessages clearDatasetForDeletion_NT(AuthCtx user, Dataset dataset, TaggableObjectsDeletionService.DeletionOptions options, TaggableObjectsDeletionService.PreDeletionContext preDeletionContext) throws Exception {
        Preconditions.checkNotNull((Object)options, (Object)"Deletion options not provided");
        logger.info((Object)("Pre-deletion cleanup of dataset " + dataset.getFullName() + " with opts: " + JSON.json((Object)options)));
        if (!preDeletionContext.inProjectDeletion) {
            DatasetLocUtils.DatasetLoc datasetLoc = dataset.getLoc();
            if (preDeletionContext.lastItemWithDQStatusFromThisProject) {
                this.dataQualityService.updateObjectStatusCascade_NT(datasetLoc.getProjectKey(), datasetLoc.getName(), System.currentTimeMillis(), dataset.getName(), false, true);
            } else {
                this.dataQualityService.updateObjectStatusNoCascade_NT(datasetLoc.getProjectKey(), datasetLoc.getName(), System.currentTimeMillis(), dataset.getName(), false, true);
            }
            this.jobsDatabaseService.clearDataQualityForDataset(dataset.getProjectKey(), dataset.getName());
        }
        if (options.dropData || DatasetDeletionService.shouldAlwaysDropDataOnDatasetDelete(dataset.getType())) {
            return this.clearDatasetData_NT(user, dataset, false, true);
        }
        if (options.dropMetastoreTable) {
            InfoMessage.InfoMessages ret;
            block13: {
                ret = this.clearCacheAndStatus_NT(dataset);
                try {
                    if (!dataset.isManaged() || !DatasetInspector.isMetastoreAssociatedType(dataset) || !MetastoreSynchronizationUtils.synchronizationRequested((AuthCtx)user, (Dataset)dataset).requested || !this.metastoreInspectionService.metastoreSupportEnabled(user, dataset.getProjectKey())) break block13;
                    try (HiveMetastoreSynchronizer synchronizer = HiveMetastoreSynchronizerFactory.getSynchronizer(user);){
                        synchronizer.dropExternalTable(dataset);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Hive drop failed", (Throwable)e);
                    ret.withFatalV((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_DELETION_HIVE_FAILED, "Unable to drop Hive table corresponding to dataset %s: %s", new Object[]{dataset.getFullName(), ExceptionUtils.getMessageWithCauses((Throwable)e)});
                }
            }
            return ret;
        }
        return this.clearCacheAndStatus_NT(dataset);
    }

    public static boolean shouldAlwaysDropDataOnDatasetDelete(String datasetType) {
        return "UploadedFiles".equals(datasetType) || "Inline".equals(datasetType);
    }

    public TaggableObjectsDeletionService.DeletionImpact computeDeletionImpact(AuthCtx authCtx, Dataset dataset, Set<TaggableObjectsService.TaggableObjectRef> ignored, boolean deleteAndReconnect) throws IOException, DKUSecurityException {
        return this.computeDeletionImpact(authCtx, dataset.getProjectKey(), dataset, ignored, deleteAndReconnect);
    }

    public TaggableObjectsDeletionService.DeletionImpact computeDeletionImpact(AuthCtx authCtx, @Nonnull String contextProjectKey, Dataset dataset, Set<TaggableObjectsService.TaggableObjectRef> ignored, boolean deleteAndReconnect) throws IOException, DKUSecurityException {
        TaggableObjectsDeletionService.DeletionImpact di = new TaggableObjectsDeletionService.DeletionImpact();
        String projectKey = dataset.getProjectKey();
        AnyLoc datasetLoc = AnyLoc.resolveFull(dataset.getFullName());
        List<Object> connectedRecipesToDelete = deleteAndReconnect ? Collections.emptyList() : this.graphService.getSuccessorAndPredecessorRecipesAcrossProjectsUnsafe(datasetLoc);
        for (Object sr : connectedRecipesToDelete) {
            this.addRecipeToDeletionImpact(authCtx, (SerializedRecipe)sr, di, contextProjectKey, ignored);
        }
        if (!deleteAndReconnect && !contextProjectKey.equals(projectKey)) {
            for (Object sr : this.recipesDAO.listUnsafe(contextProjectKey)) {
                if (!((SerializedRecipe)sr).getFlatInputs().stream().map(input -> input.getLoc(contextProjectKey)).anyMatch(loc -> loc.equals(datasetLoc)) && !((SerializedRecipe)sr).getFlatOutputs().stream().map(output -> output.getLoc(contextProjectKey)).anyMatch(loc -> loc.equals(datasetLoc))) continue;
                this.addRecipeToDeletionImpact(authCtx, (SerializedRecipe)sr, di, contextProjectKey, ignored);
            }
        }
        List<LabelingTask> successorLabelingTask = this.graphService.getSuccessorLabelingTasksAcrossProjectsUnsafe(datasetLoc);
        for (LabelingTask labelingTask : successorLabelingTask) {
            this.addLabelingTaskToDeletionImpact(authCtx, labelingTask, di, contextProjectKey, ignored);
        }
        if (!contextProjectKey.equals(dataset.getProjectKey())) {
            for (LabelingTask sr : this.labelingTasksDAO.listUnsafe(contextProjectKey)) {
                if (!sr.getFlatInputs().stream().map(input -> input.getLoc(contextProjectKey)).anyMatch(loc -> loc.equals(datasetLoc))) continue;
                this.addLabelingTaskToDeletionImpact(authCtx, sr, di, contextProjectKey, ignored);
            }
        }
        if (!contextProjectKey.equals(dataset.getProjectKey()) && !this.exploresService.listExploresForProjectUnsafe(contextProjectKey).isEmpty()) {
            di.deletedExploreSettings.add(new TaggableObjectsDeletionService.ImpactedExploreSettings(contextProjectKey, dataset.getSmartName(contextProjectKey)));
        }
        ProjectFlowGraph graphUnsafe = this.graphService.getProjectGraphUnsafe(projectKey);
        FlowDataset fdsUnsafe = graphUnsafe.datasets.get(dataset.getFullName());
        if (fdsUnsafe != null) {
            this.addImplicitRecipesToDeletionImpact(authCtx, fdsUnsafe.getSuccessors(), di, ignored);
        }
        Set<String> datasetExpositionTargetProjects = this.projectsService.getObjectExpositionTargetProjects(dataset.getProjectKey(), dataset.getName());
        HashSet<String> readableTargetProjects = new HashSet<String>();
        for (String string : datasetExpositionTargetProjects) {
            if (!this.permissionsService.hasProjectPrivilege(authCtx, string, Privileges.ProjectLevelPrivilegeType.READ_CONF)) continue;
            readableTargetProjects.add(string);
        }
        for (String string : readableTargetProjects) {
            ProjectFlowGraph foreignGraphUnsafe = this.graphService.getProjectGraphUnsafe(string);
            FlowDataset foreignFdsUnsafe = foreignGraphUnsafe.datasets.get(dataset.getFullName());
            if (foreignFdsUnsafe == null) continue;
            this.addForeignImplicitRecipesToDeletionImpact(foreignFdsUnsafe.getSuccessors(), di, ignored);
        }
        for (AnalysisCoreParams.AnalysisListItem analysisListItem : this.analysisCRUDService.listHeadsUnsafe(projectKey, dataset.getName())) {
            if (ignored != null && ignored.contains(new TaggableObjectsService.TaggableObjectRef(analysisListItem))) continue;
            di.deletedAnalyses.add(new TaggableObjectsDeletionService.ImpactedAnalysis(projectKey, dataset.getName(), analysisListItem.id, analysisListItem.name));
        }
        for (String string : readableTargetProjects) {
            for (AnalysisCoreParams.AnalysisListItem head : this.analysisCRUDService.listHeadsUnsafe(string, dataset.getFullName())) {
                if (ignored != null && ignored.contains(new TaggableObjectsService.TaggableObjectRef(head))) continue;
                di.foreignReadableAnalyses.add(new TaggableObjectsDeletionService.ImpactedAnalysis(string, dataset.getFullName(), head.id, head.name));
            }
        }
        for (WorksheetsService.WorksheetHead worksheetHead : this.worksheetsService.listWorksheetHeads(projectKey, dataset.getName())) {
            if (ignored != null && ignored.contains(new TaggableObjectsService.TaggableObjectRef(worksheetHead))) continue;
            di.deletedWorksheets.add(new TaggableObjectsDeletionService.ImpactedWorksheet(projectKey, worksheetHead.id, worksheetHead.name));
        }
        TaggableObjectsDeletionService.AvailableDeletionOptions availableOptions = new TaggableObjectsDeletionService.AvailableDeletionOptions();
        if (dataset.isManaged() && !dataset.getType().equals("JobsDB") && !dataset.getType().equals("ExperimentsDB") || dataset.getType().equals(BuiltinFSDatasets.UPLOADED_FILES_META.getType())) {
            if (DatasetInspector.isMetastoreAssociatedType(dataset) && MetastoreSynchronizationUtils.synchronizationRequested((AuthCtx)authCtx, (Dataset)dataset).requested) {
                availableOptions.canDropMetastoreTable = true;
            }
            boolean bl = availableOptions.shouldGiveOptionToDropData = !DatasetDeletionService.shouldAlwaysDropDataOnDatasetDelete(dataset.getType());
            if (dataset.getParams() instanceof AbstractFSDatasetHandler.AbstractFSConfig) {
                AbstractFSDatasetHandler.AbstractFSConfig abstractFSConfig = (AbstractFSDatasetHandler.AbstractFSConfig)dataset.getParams();
                boolean bl2 = availableOptions.isDropDataDangerous = StringUtils.isBlank((String)abstractFSConfig.path) || "/".equals(abstractFSConfig.path);
                if (availableOptions.isDropDataDangerous) {
                    String connectionName = StringUtils.defaultIfBlank((String)abstractFSConfig.connection, (String)"no_connection");
                    boolean allowed = ApplicationConfigurator.getParams().getBoolParam("dku.datasets.managed." + connectionName + ".allowClearRoot", false);
                    if (!allowed) {
                        availableOptions.shouldGiveOptionToDropData = false;
                    }
                }
            }
        }
        this.dataCollectionService.computeDeletionImpact(di, new AbstractDataCollectionItemRef.DatasetRef(dataset.getProjectKey(), dataset.getName()), authCtx);
        di.availableOptions.put(dataset.getProjectKey() + "." + dataset.getName(), availableOptions);
        return di;
    }

    private void addLabelingTaskToDeletionImpact(AuthCtx authCtx, LabelingTask labelingTask, TaggableObjectsDeletionService.DeletionImpact di, @Nonnull String contextProjectKey, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws DKUSecurityException {
        String labelingTaskProjectKey = labelingTask.getProjectKey();
        if (ignored == null || !ignored.contains(new TaggableObjectsService.TaggableObjectRef(labelingTaskProjectKey, ITaggingService.TaggableType.LABELING_TASK, labelingTask.id))) {
            TaggableObjectsDeletionService.ImpactedLabelingTask impactedLabelingTask = new TaggableObjectsDeletionService.ImpactedLabelingTask(labelingTaskProjectKey, labelingTask.id, labelingTask.name);
            if (contextProjectKey.equals(labelingTaskProjectKey)) {
                di.deletedLabelingTasks.add(impactedLabelingTask);
                try {
                    di.merge(this.labelingTasksCRUDService.computeDeletionImpact(authCtx, labelingTaskProjectKey, labelingTask.id, ignored));
                }
                catch (Exception e) {
                    logger.info((Object)"Failed to compute labeling task deletion impact: ", (Throwable)e);
                }
            } else if (this.permissionsService.hasProjectPrivilege(authCtx, labelingTaskProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) {
                di.foreignReadableLabelingTasks.add(impactedLabelingTask);
            }
        }
    }

    private void addRecipeToDeletionImpact(AuthCtx authCtx, SerializedRecipe sr, TaggableObjectsDeletionService.DeletionImpact di, @Nonnull String contextProjectKey, Set<TaggableObjectsService.TaggableObjectRef> ignored) throws DKUSecurityException {
        String recipeProjectKey = sr.getProjectKey();
        if (ignored == null || !ignored.contains(new TaggableObjectsService.TaggableObjectRef(recipeProjectKey, ITaggingService.TaggableType.RECIPE, sr.name))) {
            TaggableObjectsDeletionService.ImpactedRecipe impactedRecipe = new TaggableObjectsDeletionService.ImpactedRecipe(recipeProjectKey, sr.name, sr.type);
            if (contextProjectKey.equals(recipeProjectKey)) {
                di.deletedRecipes.add(impactedRecipe);
            } else if (this.permissionsService.hasProjectPrivilege(authCtx, recipeProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) {
                di.foreignReadableRecipes.add(impactedRecipe);
            }
        }
    }

    private void addImplicitRecipesToDeletionImpact(AuthCtx authCtx, List<? extends GraphNode> nodes, TaggableObjectsDeletionService.DeletionImpact di, Set<TaggableObjectsService.TaggableObjectRef> ignored) {
        for (GraphNode graphNode : nodes) {
            try {
                if (!(graphNode instanceof FlowImplicitRecipe)) continue;
                for (GraphNode graphNode2 : graphNode.getSuccessors()) {
                    if (!(graphNode2 instanceof FlowDataset)) continue;
                    FlowDataset fd = (FlowDataset)graphNode2;
                    SerializedDataset sds = fd.getSerializedMandatoryUnsafe(this.datasetsDAO);
                    di.deletedDatasets.add(new TaggableObjectsDeletionService.ImpactedDataset(sds.projectKey, sds.name, sds.type));
                    di.merge(this.computeDeletionImpact(authCtx, Dataset.fromSerialized(sds), ignored, false));
                }
            }
            catch (Exception e) {
                logger.info((Object)"Failed to get dataset info: ", (Throwable)e);
            }
        }
    }

    private void addForeignImplicitRecipesToDeletionImpact(List<? extends GraphNode> nodes, TaggableObjectsDeletionService.DeletionImpact di, Set<TaggableObjectsService.TaggableObjectRef> ignored) {
        for (GraphNode graphNode : nodes) {
            try {
                if (!(graphNode instanceof FlowImplicitRecipe)) continue;
                for (GraphNode graphNode2 : graphNode.getSuccessors()) {
                    if (!(graphNode2 instanceof FlowDataset)) continue;
                    FlowDataset fd = (FlowDataset)graphNode2;
                    SerializedDataset sds = fd.getSerializedMandatoryUnsafe(this.datasetsDAO);
                    di.foreignReadableDatasets.add(new TaggableObjectsDeletionService.ImpactedDataset(sds.projectKey, sds.name, sds.type));
                }
            }
            catch (Exception e) {
                logger.info((Object)"Failed to get dataset info: ", (Throwable)e);
            }
        }
    }

    public void on(final DatasetChangedEvent dce) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Dataset ds;
                    try (Transaction t = DatasetDeletionService.this.transactionService.beginRead();){
                        ds = DatasetDeletionService.this.datasetAccessService.getOrNull(dce.fullDatasetName);
                    }
                    if (ds != null) {
                        DatasetDeletionService.this.clearCache_NT(ds);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Error when clearing caches", (Throwable)e);
                }
            }
        };
        t.start();
    }
}

