/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.p;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.AuthCtxCreationService;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.SharedSecretAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.InternalAPIKeysService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class InternalApiKeysPrivilegedIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private AuditTrailService auditService;
    @Autowired
    private AuthCtxCreationService authCtxCreationService;
    @Autowired
    private InternalAPIKeysService internalAPIKeysService;
    @Autowired
    private SharedSecretAuthService authService;
    @Autowired
    private TransactionService transactionService;

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/api/pintercom/api-keys/get-temporary-internal-key"})
    public InternalAPIKeysService.APIKey requestApiKey(HttpServletRequest req, HttpServletResponse resp, @RequestParam String associatedUser) throws Exception {
        this.authService.failIfNoSharedSecret(req);
        String identifier = associatedUser.trim();
        AuthCtx authCtx = this.authCtxCreationService.create_autoTxn(identifier);
        InternalAPIKeysService.APIKey apiKey = this.internalAPIKeysService.createTmpKey(authCtx);
        this.auditService.generic("internal-api-key-creation").with("associatedUser", identifier).emit();
        return apiKey;
    }

    @AuditInline
    @RequestMapping(value={"/api/pintercom/api-keys/delete-temporary-internal-key"})
    public void deleteApiKey(HttpServletRequest req, HttpServletResponse resp, @RequestParam String key) throws Exception {
        InternalAPIKeysService.APIKey apiKey;
        this.authService.failIfNoSharedSecret(req);
        try (Transaction t = this.transactionService.beginRead();){
            apiKey = this.internalAPIKeysService.get(key);
        }
        this.internalAPIKeysService.deleteTmpKey(apiKey);
        this.auditService.generic("internal-api-key-deletion").emit();
    }
}

