/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.docextraction.DocExtractionService;
import com.dataiku.dip.docextraction.Screenshotter;
import com.dataiku.dip.docextraction.StructuredExtractor;
import com.dataiku.dip.docextraction.VLMExtractor;
import com.dataiku.dip.docextraction.common.InputRefs;
import com.dataiku.dip.docextraction.common.TextChunk;
import com.dataiku.dip.docextraction.common.TextExtractionResponseOrError;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class DocExtractionIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private DocExtractionService docExtractionService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;

    @AuditNotNeeded
    @ResponseBody
    @RequestMapping(value={"/api/tintercom/docextraction/screenshotter"})
    public Screenshotter.ScreenshotterResponseOrError runScreenshotter(HttpServletRequest req, HttpServletResponse resp, @RequestParam DSSAuthCtx authCtx, @RequestParam String projectKey, @RequestParam InputRefs.ManagedFolderDocumentRef document, @RequestParam Screenshotter.ScreenshotterSettings screenshotterSettings) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkAnyProjectAccess(authCtx, projectKey);
            if (screenshotterSettings.outputManagedFolderId != null) {
                String folderProjectKey = AnyLoc.resolveFull(screenshotterSettings.outputManagedFolderId).getProjectKey();
                this.permissionsService.hasProjectPrivilege((AuthCtx)authCtx, folderProjectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            }
        }
        try {
            return this.docExtractionService.extractScreenshotsFromManagedFolderDocumentRef(authCtx, projectKey, document, screenshotterSettings);
        }
        catch (Exception e) {
            return Screenshotter.ScreenshotterResponseOrError.fromError(e);
        }
    }

    @AuditNotNeeded
    @ResponseBody
    @RequestMapping(value={"/api/tintercom/docextraction/vlm"})
    public TextExtractionResponseOrError runVLM(HttpServletRequest req, HttpServletResponse resp, @RequestParam DSSAuthCtx authCtx, @RequestParam String projectKey, @RequestParam VLMExtractor.VLMExtractorRequest vlmRequest) throws DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkAnyProjectAccess(authCtx, projectKey);
        }
        try {
            List<TextChunk> textChunks = this.docExtractionService.runVLMextractor(authCtx, projectKey, vlmRequest);
            return TextExtractionResponseOrError.fromSuccess(textChunks);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return TextExtractionResponseOrError.fromError(e);
        }
    }

    @AuditNotNeeded
    @ResponseBody
    @RequestMapping(value={"/api/tintercom/docextraction/structured-flatten"})
    public TextExtractionResponseOrError runStructuredFlatten(HttpServletRequest req, HttpServletResponse resp, @RequestParam DSSAuthCtx authCtx, @RequestParam String projectKey, @RequestParam StructuredExtractor.StructuredExtractorSettings settings, @RequestParam InputRefs.ManagedFolderDocumentRef documentRef) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkAnyProjectAccess(authCtx, projectKey);
        }
        try {
            return this.docExtractionService.runStructuredExtractionFromManagedFolderAndFlattenToTextChunks(authCtx, projectKey, documentRef, settings);
        }
        catch (Exception e) {
            return TextExtractionResponseOrError.fromError(e);
        }
    }
}

