/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.intercom.t;

import com.dataiku.dip.hive.catalog.DSSHiveCatalogInternalDB;
import com.dataiku.dip.hive.catalog.DSSHiveCatalogTable;
import com.dataiku.dip.hive.catalog.IntercomAPIModel;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.TicketAuthService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.controllers.AuditNotNeeded;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class HiveCatalogIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private TicketAuthService ticketAuthService;
    @Autowired
    private DSSHiveCatalogInternalDB db;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.controller.intercom.hive.catalog");

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/hive/catalog/list-databases"})
    public void listDatabases(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (APITicketService.TicketUsage tu = this.ticketAuthService.getAndUseMandTicket(req);){
            IntercomAPIModel.ListDatabasesResponse ldr = new IntercomAPIModel.ListDatabasesResponse();
            ldr.databases = this.db.listDatabases();
            HiveCatalogIntercomController.writeJSON((HttpServletResponse)resp, (Object)ldr);
        }
    }

    @AuditNotNeeded
    @RequestMapping(value={"/api/tintercom/hive/catalog/get-table"})
    public void getTable(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        IntercomAPIModel.GetTableQuery gtq = (IntercomAPIModel.GetTableQuery)this.getRequestBodyAs(req, IntercomAPIModel.GetTableQuery.class);
        try (APITicketService.TicketUsage tu = this.ticketAuthService.getAndUseMandTicket(req);){
            IntercomAPIModel.GetTableResponse gtr = new IntercomAPIModel.GetTableResponse();
            try {
                gtr.table = this.db.getTable(gtq.dbName, gtq.tableName);
                gtr.found = true;
            }
            catch (NotFoundException e) {
                logger.warn((Object)("Table was not found: " + JSON.json((Object)gtq)));
            }
            if (gtr.found) {
                try (Transaction t = this.transactionService.beginRead();){
                    this.permissionsService.checkProjectPrivileges(tu.getAuthCtx(), gtr.table.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                }
            }
            HiveCatalogIntercomController.writeJSON((HttpServletResponse)resp, (Object)gtr);
        }
    }

    @RequestMapping(value={"/api/tintercom/hive/catalog/list-tables"})
    public void listTables(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        IntercomAPIModel.ListTablesQuery ltq = (IntercomAPIModel.ListTablesQuery)this.getRequestBodyAs(req, IntercomAPIModel.ListTablesQuery.class);
        try (APITicketService.TicketUsage tu = this.ticketAuthService.getAndUseMandTicket(req);){
            List<DSSHiveCatalogTable> ts = this.db.listTables(ltq.dbName);
            IntercomAPIModel.ListTablesResponse ltr = new IntercomAPIModel.ListTablesResponse();
            ltr.tables = Lists.newArrayList();
            try (Transaction t = this.transactionService.beginRead();){
                HashMap accessibleProjects = Maps.newHashMap();
                for (DSSHiveCatalogTable table : ts) {
                    Boolean accessible = (Boolean)accessibleProjects.get(table.projectKey);
                    if (accessible == null) {
                        accessible = this.permissionsService.hasProjectPrivilege(tu.getAuthCtx(), table.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                        accessibleProjects.put(table.projectKey, accessible);
                    }
                    if (!accessible.booleanValue()) continue;
                    ltr.tables.add(table);
                }
            }
            HiveCatalogIntercomController.writeJSON((HttpServletResponse)resp, (Object)ltr);
        }
    }

    @RequestMapping(value={"/api/tintercom/hive/catalog/list-partitions"})
    public void listPartitions(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        IntercomAPIModel.ListPartitionsQuery ltq = (IntercomAPIModel.ListPartitionsQuery)this.getRequestBodyAs(req, IntercomAPIModel.ListPartitionsQuery.class);
        try (APITicketService.TicketUsage tu = this.ticketAuthService.getAndUseMandTicket(req);){
            IntercomAPIModel.ListPartitionsResponse ltr = new IntercomAPIModel.ListPartitionsResponse();
            ltr.table = this.db.getTable(ltq.dbName, ltq.tableName);
            ltr.partitions = this.db.listPartitions(ltq.dbName, ltq.tableName);
            try (Transaction t = this.transactionService.beginRead();){
                this.permissionsService.checkProjectPrivileges(tu.getAuthCtx(), ltr.table.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
            HiveCatalogIntercomController.writeJSON((HttpServletResponse)resp, (Object)ltr);
        }
    }

    @RequestMapping(value={"/api/tintercom/hive/catalog/get-partition"})
    public void getPartition(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        IntercomAPIModel.GetPartitionQuery ltq = (IntercomAPIModel.GetPartitionQuery)this.getRequestBodyAs(req, IntercomAPIModel.GetPartitionQuery.class);
        try (APITicketService.TicketUsage tu = this.ticketAuthService.getAndUseMandTicket(req);){
            IntercomAPIModel.GetPartitionResponse ltr = new IntercomAPIModel.GetPartitionResponse();
            ltr.table = this.db.getTable(ltq.dbName, ltq.tableName);
            ltr.partition = this.db.getPartitionByHivePartitionName(ltq.dbName, ltq.tableName, ltq.hivePartitionName);
            try (Transaction t = this.transactionService.beginRead();){
                this.permissionsService.checkProjectPrivileges(tu.getAuthCtx(), ltr.table.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            }
            HiveCatalogIntercomController.writeJSON((HttpServletResponse)resp, (Object)ltr);
        }
    }
}

