/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.recipes;

import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.docextraction.StructuredExtractor;
import com.dataiku.dip.llm.PretrainedModelsService;
import com.dataiku.dip.llm.PromptDef;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRecipeParams;
import com.dataiku.dip.recipes.nlp.embed_documents.EmbedDocumentsRule;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.recipes.NLPRecipesService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class NLPRecipesController
extends DIPInternalControllerBase {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private NLPRecipesService nlpRecipesService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private GeneralSettingsDAO generalSettingsService;
    @Autowired
    private PretrainedModelsService pretrainedModelsService;

    @AuditedCall(value={"msgType", "convert-to-prompt-recipe", "projectKey", "${projectKey}", "recipeName", "${recipeName}"})
    @RequestMapping(value={"/api/flow/recipes/nlp/get-prompt-for-nlp-recipe"}, method={RequestMethod.GET})
    @ResponseBody
    public PromptDef getPromptForSpecificNLPRecipe(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeName) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getMandatoryUnsafe(projectKey, recipeName);
            String payload = this.recipesDAO.getPayloadOrNull(projectKey, recipeName);
            t.commit("Get prompt for NLP recipes conversion: " + recipe.getFullId());
            PromptDef promptDef = this.nlpRecipesService.getRecipePrompt(authCtx, recipe, payload);
            return promptDef;
        }
    }

    @AuditedCall(value={"msgType", "convert-to-prompt-recipe", "projectKey", "${projectKey}", "recipeName", "${recipeName}"})
    @RequestMapping(value={"/api/flow/recipes/nlp/convert-to-prompt-recipe"}, method={RequestMethod.POST})
    public void convertSpecificNLPRecipeToPromptRecipe(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey, @RequestParam String recipeName) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            this.projectsService.checkPerm(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
            SerializedRecipe recipe = (SerializedRecipe)this.recipesDAO.getMandatoryUnsafe(projectKey, recipeName);
            String payload = this.recipesDAO.getPayloadOrNull(projectKey, recipeName);
            this.nlpRecipesService.convertNLPRecipeToPromptRecipe(authCtx, recipe, payload);
            t.commit("Convert recipe to Prompt recipe: " + recipe.getFullId());
        }
    }

    @AuditedCall(value={"msgType", "embed-documents-settings", "extractionMode", "${extractionMode}"})
    @RequestMapping(value={"/api/flow/recipes/nlp/get-default-embed-documents-rules"}, method={RequestMethod.GET})
    @ResponseBody
    public EmbedDocumentsRules getDefaultEmbedDocumentRecipeRules(HttpServletRequest req, HttpServletResponse resp, @RequestParam EmbedDocumentsRecipeParams.ExtractionMode extractionMode, @RequestParam String embeddingLLMId, @Nullable String defaultVlmId, @RequestParam String projectKey, @Nullable StructuredExtractor.ImageHandlingMode defaultImageHandlingMode) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            authCtx = this.authService.getMandatoryUser(req);
        }
        EmbedDocumentsRules allRules = new EmbedDocumentsRules();
        Optional<Object> embeddingModelRef = Optional.empty();
        if (!Strings.isNullOrEmpty((String)embeddingLLMId)) {
            embeddingModelRef = this.pretrainedModelsService.listAvailableLLMs((AuthCtx)authCtx, (String)projectKey, (AbstractLLMConnection.LLMUsagePurpose)AbstractLLMConnection.LLMUsagePurpose.TEXT_EMBEDDING_EXTRACTION).identifiers.stream().filter(enrichedLLM -> embeddingLLMId.equals(enrichedLLM.id)).findFirst();
        }
        allRules.rules = EmbedDocumentsRecipeParams.getDefaultRulesFrom(extractionMode, true, embeddingModelRef.orElse(null), defaultVlmId, defaultImageHandlingMode);
        allRules.allOtherRule = EmbedDocumentsRecipeParams.getDefaultAllOtherRule(embeddingModelRef.orElse(null), defaultVlmId, defaultImageHandlingMode);
        return allRules;
    }

    @AuditedCall(value={"msgType", "embed-documents-settings", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/api/flow/recipes/nlp/get-default-embed-documents-settings"}, method={RequestMethod.GET})
    @ResponseBody
    public SanitizedEmbedDocumentsSettings getDefaultEmbedDocumentRecipeSettings(HttpServletRequest req, HttpServletResponse resp, @RequestParam String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.projectsService.checkPerm(req, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
            AuthCtx authCtx = this.authService.getMandatoryUser(req);
            GeneralSettingsDAO.EmbedDocumentsRecipeSettings embedDocumentsRecipeSettings = this.generalSettingsService.getUnsafeAutoTXN().generativeAISettings.embedDocumentsRecipeSettings;
            SanitizedEmbedDocumentsSettings settings = new SanitizedEmbedDocumentsSettings();
            settings.defaultVLMId = null;
            if (!Strings.isNullOrEmpty((String)embedDocumentsRecipeSettings.defaultVLMId) && this.pretrainedModelsService.listAvailableLLMs((AuthCtx)authCtx, (String)projectKey, (AbstractLLMConnection.LLMUsagePurpose)AbstractLLMConnection.LLMUsagePurpose.IMAGE_INPUT).identifiers.stream().anyMatch(enrichedLLM -> embedDocumentsRecipeSettings.defaultVLMId.equals(enrichedLLM.id))) {
                settings.defaultVLMId = embedDocumentsRecipeSettings.defaultVLMId;
            }
            SanitizedEmbedDocumentsSettings sanitizedEmbedDocumentsSettings = settings;
            return sanitizedEmbedDocumentsSettings;
        }
    }

    public static class EmbedDocumentsRules {
        private List<EmbedDocumentsRule> rules = new ArrayList<EmbedDocumentsRule>();
        private EmbedDocumentsRule allOtherRule;
    }

    public static class SanitizedEmbedDocumentsSettings {
        public String defaultVLMId;
    }
}

