/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.activity.GitCommitsAnalyzer;
import com.dataiku.dip.activity.IDSSUsageStatsInternalDB;
import com.dataiku.dip.activity.ProjectActivitySummaryBuilder;
import com.dataiku.dip.badges.ProjectTypeBadgesService;
import com.dataiku.dip.badges.TypeBadge;
import com.dataiku.dip.code.ProjectLibrariesEditionService;
import com.dataiku.dip.codestudio.runtime.CodeStudioRuntimeManager;
import com.dataiku.dip.coremodel.AppManifest;
import com.dataiku.dip.coremodel.Checklist;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.ExposedObject;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.ObjectCompleteMetadata;
import com.dataiku.dip.coremodel.ProjectFolder;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.dao.impl.FilesBasedGitInfoDAO;
import com.dataiku.dip.dashboards.DashboardsDAO;
import com.dataiku.dip.dashboards.DashboardsService;
import com.dataiku.dip.dashboards.insights.InsightsService;
import com.dataiku.dip.dashboards.model.Insight;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.streaming.ContinuousActivitiesManager;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.discussions.DiscussionsService;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.CodedSQLException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.ForbiddenObjectException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.experimenttracking.ExperimentTrackingService;
import com.dataiku.dip.git.GitInfo;
import com.dataiku.dip.git.IProjectCommitModeService;
import com.dataiku.dip.labeling.LabelingTask;
import com.dataiku.dip.labeling.LabelingTasksCRUDService;
import com.dataiku.dip.labeling.LabelingTasksDAO;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.metrics.ChecksSet;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.projects.ProjectCodes;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.projects.importexport.AutomationBundlesService;
import com.dataiku.dip.projects.importexport.DesignBundlesService;
import com.dataiku.dip.projects.importexport.model.ActiveBundleState;
import com.dataiku.dip.recipes.fromapp.AppRecipeMeta;
import com.dataiku.dip.reports.ReportsService;
import com.dataiku.dip.requestcenter.RequestsService;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IDataCollectionPermissionsService;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.IWorkspacePermissionsService;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.UIAuthService;
import com.dataiku.dip.security.impersonation.ImpersonationResolverService;
import com.dataiku.dip.security.model.PublicUser;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetDeletionService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.notifications.backend.ProjectPermissionsChangedEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.notifications.emails.AbstractInviteEmailSendService;
import com.dataiku.dip.server.services.AccessibleObjectsService;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.IProjectsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ImageService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.JupyterUtils;
import com.dataiku.dip.server.services.ProjectFoldersService;
import com.dataiku.dip.server.services.ProjectsDAO;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.ScenarioReportsService;
import com.dataiku.dip.server.services.ScenariosService;
import com.dataiku.dip.server.services.TaggableObjectDiffService;
import com.dataiku.dip.server.services.TaggableObjectsDeletionService;
import com.dataiku.dip.server.services.TaggableObjectsReadService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UserCodes;
import com.dataiku.dip.server.services.UserSettingsService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.server.services.licensing.LicenseEnforcementService;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.timelines.TimelineItem;
import com.dataiku.dip.timelines.TimelinesService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.exceptions.TransactionContextError;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.utils.DirectoryFilter;
import com.dataiku.dip.transactions.fs.utils.RelFileFilter;
import com.dataiku.dip.transactions.git.jgit.ProjectsJGitService;
import com.dataiku.dip.transactions.ifaces.MinimalRWTransaction;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.webapps.WebAppsService;
import com.dataiku.dip.webapps.backend.WebAppBackendRestartThread;
import com.dataiku.dip.wikis.ArticlesCacheService;
import com.dataiku.dip.wikis.WikisService;
import com.dataiku.dip.workspaces.WorkspacesService;
import com.dataiku.dss.shadelib.com.google.common.collect.Multimap;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class ProjectsService
implements IProjectsService {
    private static final RelFile projectsFolder = RelFile.global((String)"projects");
    @Autowired
    private UIAuthService authService;
    @Autowired
    private TimelinesService timelineService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private UserSettingsService userSettingsService;
    @Autowired
    private LicenseEnforcementService limitsEnforcementService;
    @Autowired
    private PubSubService pubSub;
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    private AutomationBundlesService automationBundlesService;
    @Autowired
    private DesignBundlesService designBundlesService;
    @Autowired
    private ITaggingService taggingService;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private TaggableObjectDiffService colaborativeMetadataDiffService;
    @Autowired
    private ImpersonationResolverService impersonationResolverService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private IWorkspacePermissionsService workspacePermissionsService;
    @Autowired
    private ImageService imageService;
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private CodeStudioRuntimeManager codeStudioRuntimeManager;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetDeletionService datasetDeletionService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private InsightsService insightsService;
    @Autowired
    private DashboardsService dashboardsService;
    @Autowired
    private ScenariosService scenariosService;
    @Autowired
    private SavedModelsDAO savedModelsDAO;
    @Autowired
    private ReportsService reportsService;
    @Autowired
    private WikisService wikisService;
    @Autowired
    private JupyterService jupyterService;
    @Autowired
    private ArticlesCacheService articlesCacheService;
    @Autowired
    private AccessibleObjectsService accessibleObjectsService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private ManagedFoldersService managedFoldersService;
    @Autowired
    private TaggableObjectsService taggableObjectsService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private DashboardsDAO dashboardsDAO;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    @Autowired
    private ProjectsDAO projectsDAO;
    @Autowired
    private LabelingTasksDAO labelingTasksDAO;
    @Autowired
    private ScenarioReportsService scenarioReportsService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private ProjectFoldersService projectFoldersService;
    @Autowired
    private ProjectLibrariesEditionService projectLibrariesEditionService;
    @Autowired
    private ContinuousActivitiesManager continuousActivitiesManager;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private DiscussionsService discussionsService;
    @Autowired
    private ExperimentTrackingService experimentTrackingService;
    @Autowired
    private LabelingTasksCRUDService labelingTasksCRUDService;
    @Autowired
    private RequestsService requestsService;
    @Autowired
    private WorkspacesService workspacesService;
    @Autowired
    private IDataCollectionPermissionsService dataCollectionPermissionsService;
    @Autowired
    private TaggableObjectsReadService taggableObjectsReadService;
    @Autowired
    private ReadWriteJobsInternalDB jobsDatabaseService;
    @Autowired
    private FilesBasedGitInfoDAO gitInfoDAO;
    @Autowired
    private ProjectsJGitService projectsJGitService;
    @Autowired
    private ProjectTypeBadgesService projectTypeBadgesService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.projects");

    public static boolean isValidProjectKey(String projectKey) {
        return projectKey.matches("^[A-Za-z0-9_]+$");
    }

    @Override
    public List<String> listProjectKeys() throws IOException {
        return this.projectsDAO.listProjectKeys();
    }

    public boolean projectExists(String projectKey) throws TransactionContextError, IOException {
        return this.projectsDAO.projectExists(projectKey);
    }

    @Override
    public List<String> listKeys() throws IOException {
        return this.projectsDAO.listKeys();
    }

    public Set<String> listTags() throws IOException {
        try (DSSMetrics.TimeCtx c2 = DSSMetrics.timeCtx((String)"services.projects.listNames");){
            TransactionRef t = TransactionContext.retrieveRead();
            HashSet ret = new HashSet();
            for (RelFile projectFolder : t.listFiles(projectsFolder, (RelFileFilter)DirectoryFilter.containingFile((String)"./params.json"))) {
                String projectKey = projectFolder.getLeafName();
                try {
                    SerializedProject sp = (SerializedProject)t.readObjectUnsafe(this.getProjectFile(projectKey), SerializedProject.class);
                    ret.addAll(sp.tags);
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to read params.json file for project " + projectKey), (Throwable)e);
                }
            }
            HashSet hashSet = ret;
            return hashSet;
        }
    }

    public List<SerializedProject> listAll() throws IOException {
        return this.projectsDAO.listAll();
    }

    public List<SerializedProject> listAllUnsafe() throws IOException {
        return this.projectsDAO.listAllUnsafe();
    }

    private HomepageProjectItem summarizeExtended(SerializedProject sp, AuthCtx u, boolean lightMode, boolean withTagsFile, boolean anyProjectAccess) throws Exception {
        UIProject ps2 = this.summarizeProject(u, sp, false);
        HomepageProjectItem hpi = new HomepageProjectItem(ps2);
        if (withTagsFile) {
            hpi.tagsFile = this.taggingService.listTagsUnsafe(ps2.projectKey);
        }
        hpi.isAppAsRecipe = AppRecipeMeta.isAppAsRecipeTemplate(sp.projectKey, hpi.projectAppType);
        if (anyProjectAccess && !lightMode) {
            hpi.projectSummaryStatus = this.getProjectObjectsCounts(ps2);
        }
        hpi.onlyLimitedVisibility = !anyProjectAccess;
        hpi.canRequestAccess = this.isAccessRequestsEnabled(sp, ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN());
        return hpi;
    }

    private UIProject summarize(SerializedProject sp, List<ProjectFolder> projectLocation, boolean isProjectAdmin, boolean canEditPermissions, boolean canReadProjectContent, boolean canWriteProjectContent, boolean canPublishToDataCollections, boolean canShareToWorkspaces, boolean canReadDashboards, boolean canWriteDashboards, boolean canModerateDashboards, boolean canManageDashboardAuthorizations, boolean canManageExposedElements, boolean canExportDatasetsData, boolean canRunScenarios, boolean canManageAdditionalDashboardUsers, boolean canExecuteApp, boolean canExportGitRepository) throws IOException {
        UIProject ps2 = new UIProject(sp);
        if (projectLocation != null) {
            ps2.projectLocation = projectLocation.stream().map(UIProjectFolder::fromFolder).toList();
        }
        ps2.isProjectAdmin = isProjectAdmin;
        ps2.canEditPermissions = canEditPermissions;
        ps2.canExportDatasetsData = canExportDatasetsData;
        ps2.canReadProjectContent = canReadProjectContent;
        ps2.canWriteProjectContent = canWriteProjectContent;
        ps2.canShareToWorkspaces = canShareToWorkspaces;
        ps2.canPublishToDataCollections = canPublishToDataCollections;
        ps2.canReadDashboards = canReadDashboards;
        ps2.canWriteDashboards = canWriteDashboards;
        ps2.canModerateDashboards = canModerateDashboards;
        ps2.canExecuteApp = canExecuteApp;
        ps2.canRunScenarios = canRunScenarios;
        ps2.canManageDashboardAuthorizations = canManageDashboardAuthorizations;
        ps2.canManageExposedElements = canManageExposedElements;
        ps2.canManageAdditionalDashboardUsers = canManageAdditionalDashboardUsers && ps2.permissionsVersion == SerializedProject.PermissionsVersion.LEGACY;
        ps2.canExportGitRepository = canExportGitRepository;
        try {
            ProjectImageInfo projectImageInfo = this.getProjectImageInfo(sp);
            ps2.objectImgHash = projectImageInfo.objectImgHash;
            ps2.isProjectImg = projectImageInfo.isProjectImg;
            ps2.defaultImgColor = projectImageInfo.defaultImgColor;
            ps2.imgPattern = projectImageInfo.imgPattern;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get project image hash", (Throwable)e);
        }
        if (ps2.projectType != SerializedProject.ProjectType.REGULAR) {
            try {
                TransactionRef t = TransactionContext.retrieveRead();
                RelFile rf = new RelFile(new String[]{"projects", sp.projectKey, "active-bundle.json"});
                if (t.isFile(rf)) {
                    ps2.activeBundleState = (ActiveBundleState)t.readObjectUnsafe(rf, ActiveBundleState.class);
                } else {
                    logger.warn((Object)("Bundle state not found for project " + sp.projectKey + " rf" + String.valueOf(rf)));
                }
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to read bundle state for project " + sp.projectKey), (Throwable)e);
            }
        }
        ps2.ownerDisplayName = this.getOwnerDisplayName(ps2.ownerLogin);
        try {
            ps2.typeBadges = this.projectTypeBadgesService.listBadges(ps2.projectKey);
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to read the Type Badges for project " + sp.projectKey), (Throwable)e);
        }
        return ps2;
    }

    private String getOwnerDisplayName(String ownerLogin) throws IOException {
        UsersDAO.User ud;
        if (ownerLogin != null && (ud = this.usersService.getInternalUserOrNullUnsafe(ownerLogin)) != null) {
            return ud.displayName;
        }
        return null;
    }

    public ProjectImageInfo getProjectImageInfo(SerializedProject sp) throws IOException {
        ProjectImageInfo projectImageInfo = new ProjectImageInfo();
        projectImageInfo.objectImgHash = this.imageService.getOriginalImgHash(sp.projectKey, "PROJECT", null);
        boolean bl = projectImageInfo.isProjectImg = projectImageInfo.objectImgHash != 0L;
        if (!projectImageInfo.isProjectImg) {
            projectImageInfo.objectImgHash = this.imageService.generateNewImgHash(sp.projectKey, "PROJECT", null);
        }
        projectImageInfo.defaultImgColor = this.imageService.generateProjectColorAsHex(sp.projectKey);
        projectImageInfo.imgColor = sp.imgColor;
        projectImageInfo.imgPattern = sp.imgPattern != null ? sp.imgPattern : this.imageService.generateProjectPattern(sp.projectKey);
        projectImageInfo.showInitials = sp.showInitials;
        return projectImageInfo;
    }

    @Override
    public void enrichHomepageProjectItem_NT(HomepageProjectItem hpi, AuthCtx u, boolean lightMode, boolean withGitInfo, Map<String, List<Scenario>> scenariosMap) {
        if (hpi.onlyLimitedVisibility) {
            return;
        }
        try {
            if (ApplicationConfigurator.getNodeType() != ApplicationConfigurator.DSSNodeType.API) {
                this.enrichWithCommitsAndGitInfo_NT(hpi, u, lightMode, withGitInfo);
            }
            if (ApplicationConfigurator.getNodeType() != ApplicationConfigurator.DSSNodeType.DESIGN && !lightMode) {
                this.ennrichWithScenariosReports_NT(hpi, scenariosMap.get(hpi.projectKey));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failed to get users contributors" + hpi.projectKey), (Throwable)e);
        }
    }

    private void enrichWithCommitsAndGitInfo_NT(HomepageProjectItem hpi, AuthCtx u, boolean lightMode, boolean withGitInfo) throws Exception {
        List<String> contributors = this.timelineService.getContributors(hpi.projectKey);
        try (Transaction ignored = this.transactionService.beginRead();){
            GitInfo gitInfo;
            for (String contributor : contributors) {
                hpi.contributors.add(this.usersService.getPublicUser(contributor));
            }
            if (withGitInfo && (gitInfo = this.gitInfoDAO.getOrNull(hpi.projectKey, true)) != null) {
                hpi.gitInfo = gitInfo;
            }
        }
        Pair<TimelineItem, TimelineItem> lastCommitInfo = this.timelineService.getLatestForProjectAndLatestForProjectAndUser(hpi.projectKey, u.getIdentifier());
        if (lastCommitInfo.first != null) {
            hpi.lastCommitTime = ((TimelineItem)lastCommitInfo.first).time;
        }
        if (lastCommitInfo.second != null) {
            hpi.lastCommitTimeForUser = ((TimelineItem)lastCommitInfo.second).time;
        }
        if (!lightMode) {
            hpi.totalCommits = this.getProjectActivitySummary((String)hpi.projectKey, (int)3, (int)8, (boolean)true).totalCommits;
        }
    }

    private void ennrichWithScenariosReports_NT(HomepageProjectItem hpi, List<Scenario> scenarios) throws Exception {
        ScenarioReportsService.ScenarioDays scenarioDays;
        DateTime now = DateTime.now();
        DateTime twoWeeksAgo = DateTime.now().minusWeeks(2);
        hpi.scenariosDays = scenarioDays = this.scenarioReportsService.getDayReport_NT(twoWeeksAgo, now, scenarios, false);
    }

    public List<UIProject> listAccessibleUnsafe(AuthCtx u) throws Exception {
        return this.listAccessibleUnsafe(u, false);
    }

    public List<UIProject> listAccessibleUnsafe(AuthCtx u, boolean includeLimitedVisibility) throws Exception {
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        ArrayList<UIProject> ret = new ArrayList<UIProject>();
        for (SerializedProject sp : this.listAllUnsafe()) {
            if (!this.permissionsService.hasAnyProjectAccess(u, sp.projectKey) && (!includeLimitedVisibility || !this.isVisible(sp, generalSettings))) continue;
            ret.add(this.summarizeProject(u, sp, false));
        }
        return ret;
    }

    public List<UIProject> listAccessibleUnsafe(AuthCtx u, Privileges.ProjectLevelPrivilegeType requiredPrivilege) throws Exception {
        ArrayList<UIProject> ret = new ArrayList<UIProject>();
        for (SerializedProject sp : this.listAllUnsafe()) {
            if (!this.permissionsService.hasProjectPrivilege(u, sp.projectKey, requiredPrivilege)) continue;
            UIProject summarize = this.summarizeProject(u, sp, false);
            ret.add(summarize);
        }
        return ret;
    }

    public boolean anyAccessibleUnsafe(AuthCtx u, Privileges.ProjectLevelPrivilegeType requiredPrivilege) throws Exception {
        return this.projectsDAO.streamAllUnsafe().anyMatch(sp -> {
            try {
                return this.permissionsService.hasProjectPrivilege(u, sp.projectKey, requiredPrivilege);
            }
            catch (DKUSecurityException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public List<HomepageProjectItem> listAccessibleUnsafeExtended(AuthCtx u, boolean lightMode, boolean withTagsFile) throws Exception {
        return this.listAccessibleUnsafeExtended(u, lightMode, withTagsFile, false);
    }

    public List<HomepageProjectItem> listAccessibleUnsafeExtended(AuthCtx u, boolean lightMode, boolean withTagsFile, boolean includeLimitedVisibility) throws Exception {
        ArrayList<HomepageProjectItem> ret = new ArrayList<HomepageProjectItem>();
        UserSettingsService.UserSettings userSettings = this.userSettingsService.getForUser(u.getIdentifier());
        for (SerializedProject sp : this.listAllUnsafe()) {
            HomepageProjectItem project = this.internalGetProjectItemWithPermissionChecksFromProject(u, sp, lightMode, withTagsFile, includeLimitedVisibility);
            if (project == null || project.projectAppType == SerializedProject.ProjectAppType.APP_INSTANCE && !userSettings.showAppInstances) continue;
            ret.add(project);
        }
        return ret;
    }

    @Override
    public HomepageProjectItem getProjectItemWithPermissionChecksFromProject(AuthCtx authCtx, SerializedProject project, boolean lightMode, boolean withTagsFile) throws Exception {
        return this.internalGetProjectItemWithPermissionChecksFromProject(authCtx, project, lightMode, withTagsFile, false);
    }

    public List<HomepageProjectItem> getProjectItemsWithPermissionChecksFromProjectKeys(AuthCtx authCtx, Iterable<String> projectKeys, boolean lightMode, boolean withTagsFile, boolean includeLimitedVisibility) throws Exception {
        ArrayList<HomepageProjectItem> ret = new ArrayList<HomepageProjectItem>();
        for (String pkey : projectKeys) {
            HomepageProjectItem project = this.internalGetProjectItemWithPermissionChecksFromProject(authCtx, this.getMandatoryUnsafe(pkey), lightMode, withTagsFile, includeLimitedVisibility);
            if (project == null) continue;
            ret.add(project);
        }
        return ret;
    }

    private HomepageProjectItem internalGetProjectItemWithPermissionChecksFromProject(AuthCtx authCtx, SerializedProject project, boolean lightMode, boolean withTagsFile, boolean allowLimitedVisibility) throws Exception {
        boolean anyProjectAccess = this.permissionsService.hasAnyProjectAccess(authCtx, project.projectKey);
        if (anyProjectAccess || allowLimitedVisibility && this.isVisible(project, ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN())) {
            return this.summarizeExtended(project, authCtx, lightMode, withTagsFile, anyProjectAccess);
        }
        return null;
    }

    public HomepageProjectItem getProjectItemWithReadPermissionCheckFromProject(AuthCtx authCtx, SerializedProject project, boolean lightMode, boolean withTagsFile) throws Exception {
        if (this.permissionsService.hasProjectPrivilege(authCtx, project, Privileges.ProjectLevelPrivilegeType.READ_CONF)) {
            return this.summarizeExtended(project, authCtx, lightMode, withTagsFile, true);
        }
        return null;
    }

    public ProjectObjectsCounts getProjectObjectsCounts(UIProject project) throws Exception {
        ProjectObjectsCounts status = new ProjectObjectsCounts();
        String projectKey = project.projectKey;
        status.totalTasks = 0;
        status.checkedTasks = 0;
        SerializedProject sp = this.getMandatoryUnsafe(projectKey);
        for (Checklist cl : sp.checklists.checklists) {
            for (Checklist.ChecklistItem i : cl.items) {
                ++status.totalTasks;
                if (!i.done) continue;
                ++status.checkedTasks;
            }
        }
        Map<ITaggingService.TaggableType, Integer> counts = this.accessibleObjectsService.countAccessibleObjects(projectKey);
        status.datasets = counts.get((Object)ITaggingService.TaggableType.DATASET);
        status.managedFolders = counts.get((Object)ITaggingService.TaggableType.MANAGED_FOLDER);
        status.recipes = counts.get((Object)ITaggingService.TaggableType.RECIPE);
        status.flowLabelingTasks = counts.get((Object)ITaggingService.TaggableType.LABELING_TASK);
        status.analyses = counts.get((Object)ITaggingService.TaggableType.ANALYSIS);
        status.flowModels = counts.get((Object)ITaggingService.TaggableType.SAVED_MODEL);
        status.flowEvaluationStores = counts.get((Object)ITaggingService.TaggableType.MODEL_EVALUATION_STORE);
        status.flowStreamingEndpoints = counts.get((Object)ITaggingService.TaggableType.STREAMING_ENDPOINT);
        status.jupyterNotebooks = counts.get((Object)ITaggingService.TaggableType.JUPYTER_NOTEBOOK);
        status.sqlNotebooks = counts.get((Object)ITaggingService.TaggableType.SQL_NOTEBOOK);
        status.searchNotebooks = counts.get((Object)ITaggingService.TaggableType.SEARCH_NOTEBOOK);
        status.wikiArticles = counts.get((Object)ITaggingService.TaggableType.ARTICLE);
        status.codeStudios = counts.get((Object)ITaggingService.TaggableType.CODE_STUDIO);
        status.flowZones = counts.get((Object)ITaggingService.TaggableType.FLOW_ZONE);
        status.retrievableKnowledge = counts.get((Object)ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE);
        List<Scenario> scenarios = this.scenariosService.listUnsafe(projectKey);
        status.totalScenarios = scenarios.size();
        for (Scenario s : scenarios) {
            if (!s.active) continue;
            ++status.activeScenarios;
        }
        for (SavedModel sm : this.savedModelsDAO.listUnsafe(projectKey)) {
            if (sm.savedModelType == null || sm.savedModelType.savedModelHandlingType == null) continue;
            switch (sm.savedModelType.savedModelHandlingType) {
                case INTERNAL: 
                case EXTERNAL_MLFLOW: {
                    ++status.mlSavedModels;
                    break;
                }
                case LLM_GENERIC: {
                    ++status.llmSavedModels;
                    ++status.llmFineTunedModels;
                    break;
                }
                case RETRIEVAL_AUGMENTED_LLM: {
                    ++status.llmSavedModels;
                    ++status.llmRagModels;
                    break;
                }
                case PLUGIN_AGENT: 
                case PYTHON_AGENT: 
                case TOOLS_USING_AGENT: {
                    ++status.agents;
                }
            }
        }
        status.dashboards = this.dashboardsDAO.countListed(projectKey);
        return status;
    }

    public SerializedProject getOrNull(String projectKey) throws IOException {
        return this.projectsDAO.getOrNull(projectKey);
    }

    @Override
    public SerializedProject getOrNullUnsafe(String projectKey) throws IOException {
        return this.projectsDAO.getOrNullUnsafe(projectKey);
    }

    @Override
    public SerializedProject getMandatory(String projectKey) throws IOException {
        return this.projectsDAO.getMandatory(projectKey);
    }

    @Override
    public SerializedProject getMandatoryUnsafe(String projectKey) throws IOException {
        return this.projectsDAO.getMandatoryUnsafe(projectKey);
    }

    public SerializedProject getMandatoryUnsafe_AutoTXN(String projectKey) throws IOException {
        try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).retrieveOrBeginRead();){
            SerializedProject serializedProject = this.projectsDAO.getMandatoryUnsafe(projectKey);
            return serializedProject;
        }
    }

    public VisibleProjectSummary getVisibleProjectSummary(AuthCtx u, String projectKey) throws IOException {
        assert (u != null);
        SerializedProject sp = this.getOrNullUnsafe(projectKey);
        if (sp == null) {
            return null;
        }
        ProjectImageInfo projectImageInfo = null;
        try {
            projectImageInfo = this.getProjectImageInfo(sp);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get project image hash", (Throwable)e);
        }
        String ownerDisplayName = this.getOwnerDisplayName(sp.owner);
        return new VisibleProjectSummary(sp, projectImageInfo, ownerDisplayName);
    }

    public UIProject getSummary(AuthCtx u, String projectKey, boolean includeLocation) throws Exception {
        UIProject summary = this.getSummaryOrNull(u, projectKey, includeLocation);
        if (summary == null) {
            throw new NotFoundException("Project does not exist: " + projectKey);
        }
        return summary;
    }

    public UIProject getSummaryOrNull(AuthCtx u, String projectKey, boolean includeLocation) throws Exception {
        assert (u != null);
        SerializedProject sp = this.getOrNullUnsafe(projectKey);
        if (sp == null) {
            return null;
        }
        return this.summarizeProject(u, sp, includeLocation);
    }

    private UIProject summarizeProject(AuthCtx u, SerializedProject sp, boolean includeLocation) throws DKUSecurityException, IOException, GitAPIException, URISyntaxException {
        boolean isProjectAdmin = this.permissionsService.hasProjectPrivilege(u, sp, Privileges.ProjectLevelPrivilegeType.ADMIN);
        boolean canEditPermissions = this.permissionsService.hasProjectPrivilege(u, sp, Privileges.ProjectLevelPrivilegeType.EDIT_PERMISSIONS);
        boolean canWriteDashboards = this.permissionsService.hasProjectPrivilege(u, sp, Privileges.ProjectLevelPrivilegeType.WRITE_DASHBOARDS);
        boolean canModerateDashboards = sp.permissionsVersion == SerializedProject.PermissionsVersion.LEGACY ? this.permissionsService.hasProjectPrivilege(u, sp, Privileges.ProjectLevelPrivilegeType.MODERATE_DASHBOARDS) : canWriteDashboards;
        boolean canManageAdditionalDashboardUsers = sp.permissionsVersion == SerializedProject.PermissionsVersion.LEGACY ? this.permissionsService.hasProjectPrivilege(u, sp, Privileges.ProjectLevelPrivilegeType.MANAGE_ADDITIONAL_DASHBOARD_USERS) : isProjectAdmin;
        boolean canExportGitRepository = isProjectAdmin || !this.projectsJGitService.hasRemoteWithAuth(sp.projectKey);
        List<ProjectFolder> projectLocation = null;
        if (includeLocation) {
            projectLocation = this.projectFoldersService.getProjectLocation_Uncheck(sp.projectKey);
        }
        return this.summarize(sp, projectLocation, isProjectAdmin, canEditPermissions, this.permissionsService.hasProjectPrivilege(u, sp, Privileges.ProjectLevelPrivilegeType.READ_CONF), this.permissionsService.hasProjectPrivilege(u, sp, Privileges.ProjectLevelPrivilegeType.WRITE_CONF), this.permissionsService.hasProjectPrivilege(u, sp, Privileges.ProjectLevelPrivilegeType.PUBLISH_TO_DATA_COLLECTIONS), this.permissionsService.hasProjectPrivilege(u, sp, Privileges.ProjectLevelPrivilegeType.SHARE_TO_WORKSPACES), this.permissionsService.hasProjectPrivilege(u, sp, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS), canWriteDashboards, canModerateDashboards, this.permissionsService.hasProjectPrivilege(u, sp, Privileges.ProjectLevelPrivilegeType.MANAGE_DASHBOARD_AUTHORIZATIONS), this.permissionsService.hasProjectPrivilege(u, sp, Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS), this.permissionsService.hasProjectPrivilege(u, sp, Privileges.ProjectLevelPrivilegeType.EXPORT_DATASETS_DATA), this.permissionsService.hasProjectPrivilege(u, sp, Privileges.ProjectLevelPrivilegeType.RUN_SCENARIOS), canManageAdditionalDashboardUsers, this.permissionsService.hasProjectPrivilege(u, sp, Privileges.ProjectLevelPrivilegeType.EXECUTE_APP), canExportGitRepository);
    }

    public static String getDayOfMonthSuffix(int n) {
        if (n >= 11 && n <= 13) {
            return "th";
        }
        switch (n % 10) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }

    public static String getDateForShortDesc() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("MMM dd'" + ProjectsService.getDayOfMonthSuffix(cal.get(5)) + "' yyyy");
        sdf.setDateFormatSymbols(DateFormatSymbols.getInstance(Locale.ENGLISH));
        return sdf.format(cal.getTime());
    }

    public SerializedProject create(String projectKey, String name, String projectFolderId) throws Exception {
        this.limitsEnforcementService.checkUsersOverQuota("create project");
        RWTransactionRef t = TransactionContext.retrieveWrite();
        AuthCtx user = t.getUser();
        RelFile projectFile = this.getProjectFile(projectKey);
        if (t.exists(projectFile)) {
            throw new IOException("Project " + projectKey + " already exists");
        }
        SerializedProject sp = new SerializedProject();
        sp.permissionsVersion = SerializedProject.PermissionsVersion.V2;
        sp.name = name;
        sp.projectKey = projectKey;
        sp.owner = user.getIdentifier();
        sp.creationTag = new VersionTag(user.getIdentifier());
        this.customFieldsService.enrichWithDefaultCustomFieldsForTaggableObject(sp);
        sp.shortDesc = user.getAssociatedDSSUser() != null ? "The project *" + sp.name.replace("*", "") + "* was created by " + this.usersService.getPublicUser((String)user.getAssociatedDSSUser()).displayName + " on " + ProjectsService.getDateForShortDesc() : "The project *" + sp.name.replace("*", "") + "* was created by " + user.getIdentifier() + " on " + ProjectsService.getDateForShortDesc();
        Checklist chklist = new Checklist();
        chklist.title = "Your new project's Todo";
        chklist.items.add(new Checklist.ChecklistItem("Create the project", user.getIdentifier()).withDone(true));
        chklist.items.add(new Checklist.ChecklistItem("Set a project image (click on the color next to the project title)", user.getIdentifier()));
        chklist.items.add(new Checklist.ChecklistItem("Import your [first dataset](projects/" + projectKey + "/datasets/new/)", user.getIdentifier()));
        chklist.items.add(new Checklist.ChecklistItem("Organize your work by replacing this with a real todo", user.getIdentifier()));
        sp.checklists.checklists.add(chklist);
        GeneralSettingsDAO.ProjectStatus defaultProjectStatus = this.generalSettingsService.getDefaultProjectStatus();
        if (defaultProjectStatus != null) {
            sp.projectStatus = defaultProjectStatus.name;
        }
        this.customPolicyHooksRegistry.onPreObjectSave(user, null, sp);
        t.writeObject(projectFile, (Object)sp);
        this.flowGraphService.invalidateCache();
        this.pubSub.publishAfterTransaction(new TaggableObjectChangedEvent(ITaggingService.TaggableType.PROJECT, projectKey, projectKey, t.getUser(), TaggableObjectChangedEvent.ActionType.PROJECT_CREATE));
        this.dashboardsService.createDefaultDashboardForProject(sp);
        this.projectFoldersService.addProject_Check(user, projectFolderId, sp.projectKey);
        this.projectLibrariesEditionService.generateProjectLibrariesContent(t, sp.projectKey);
        return sp;
    }

    public Set<String> getExpositionTargetProjects(String projectKey) throws IOException {
        HashSet<String> ret = new HashSet<String>();
        SerializedProject sp = this.getMandatoryUnsafe(projectKey);
        for (ExposedObject dp : sp.exposedObjects.objects) {
            if (dp == null || StringUtils.isBlank((String)dp.localName)) {
                logger.warn((Object)("Invalid shared object in " + projectKey));
                continue;
            }
            for (ExposedObject.Rule r : dp.rules) {
                if (r.targetProject == null) continue;
                ret.add(r.targetProject);
            }
        }
        return ret;
    }

    public Set<String> getObjectExpositionTargetProjects(String projectKey, String objectLocalName) throws IOException {
        HashSet<String> ret = new HashSet<String>();
        SerializedProject sp = this.getMandatoryUnsafe(projectKey);
        for (ExposedObject dp : sp.exposedObjects.objects) {
            if (dp == null || StringUtils.isBlank((String)dp.localName)) {
                logger.warn((Object)("Invalid shared object in " + projectKey));
                continue;
            }
            if (!dp.localName.equals(objectLocalName)) continue;
            for (ExposedObject.Rule r : dp.rules) {
                if (r.targetProject == null || !this.projectExists(r.targetProject)) continue;
                ret.add(r.targetProject);
            }
        }
        return ret;
    }

    public List<? extends DatasetLocUtils.DatasetLoc> getExposedDatasets(String projectKey) throws IOException {
        return this.projectsDAO.getExposedObjects(projectKey, ITaggingService.TaggableType.DATASET);
    }

    public List<? extends DatasetLocUtils.DatasetLoc> getExposedSavedModels(String projectKey) throws IOException {
        return this.projectsDAO.getExposedObjects(projectKey, ITaggingService.TaggableType.SAVED_MODEL);
    }

    public List<? extends DatasetLocUtils.DatasetLoc> getExposedModelEvaluationStores(String projectKey) throws IOException {
        return this.getExposedObjects(projectKey, ITaggingService.TaggableType.MODEL_EVALUATION_STORE);
    }

    public List<? extends DatasetLocUtils.DatasetLoc> getExposedRetrievableKnowledges(String projectKey) throws IOException {
        return this.getExposedObjects(projectKey, ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE);
    }

    public List<? extends DatasetLocUtils.DatasetLoc> getExposedManagedFolders(String projectKey) throws IOException {
        return this.getExposedObjects(projectKey, ITaggingService.TaggableType.MANAGED_FOLDER);
    }

    public List<? extends DatasetLocUtils.DatasetLoc> getExposedStreamingEndpoints(String projectKey) throws IOException {
        return this.getExposedObjects(projectKey, ITaggingService.TaggableType.STREAMING_ENDPOINT);
    }

    public List<AnyLocWithType> getAllExposedObjects(String projectKey) throws IOException {
        return this.projectsDAO.getExposedObjects(projectKey, null);
    }

    private List<AnyLocWithType> getExposedObjects(String projectKey, ITaggingService.TaggableType type) throws IOException {
        return this.projectsDAO.getExposedObjects(projectKey, type);
    }

    public boolean disableAutomaticTriggers(String projectKey) throws IOException {
        SerializedProject sp = this.getOrNullUnsafe(projectKey);
        if (sp == null) {
            logger.error((Object)("Failed to read params.json file for project " + projectKey));
            return true;
        }
        return sp.settings == null || sp.settings.disableAutomaticTriggers;
    }

    public void failIfNoDatasetReadUseAccess(AuthCtx user, AnyLoc loc, String contextProjectKey) throws IOException, DKUSecurityException {
        this.failIfNoTaggableObjectReadUseAccess(user, ITaggingService.TaggableType.DATASET, loc, contextProjectKey);
    }

    public void failIfNoSavedModelReadUseAccess(AuthCtx user, AnyLoc loc, String contextProjectKey) throws IOException, DKUSecurityException {
        this.failIfNoTaggableObjectReadUseAccess(user, ITaggingService.TaggableType.SAVED_MODEL, loc, contextProjectKey);
    }

    public void failIfNoModelEvaluationStoreReadUseAccess(AuthCtx user, AnyLoc loc, String contextProjectKey) throws IOException, DKUSecurityException {
        this.failIfNoTaggableObjectReadUseAccess(user, ITaggingService.TaggableType.MODEL_EVALUATION_STORE, loc, contextProjectKey);
    }

    public void failIfNoRetrievableKnowledgeReadUseAccess(AuthCtx user, AnyLoc loc, String contextProjectKey) throws IOException, DKUSecurityException {
        this.failIfNoTaggableObjectReadUseAccess(user, ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE, loc, contextProjectKey);
    }

    public void failIfNoManagedFolderReadUseAccess(AuthCtx user, AnyLoc loc, String contextProjectKey) throws IOException, DKUSecurityException {
        this.failIfNoTaggableObjectReadUseAccess(user, ITaggingService.TaggableType.MANAGED_FOLDER, loc, contextProjectKey);
    }

    public void failIfNoTaggableObjectReadUseAccess(AuthCtx user, ITaggingService.TaggableType tt, AnyLoc loc, String contextProjectKey) throws IOException, DKUSecurityException {
        if (loc.getProjectKey().equals(contextProjectKey)) {
            this.checkPerm(user, contextProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        } else if (!this.hasExposedObjectAccess(tt, user, loc, contextProjectKey)) {
            throw new ForbiddenObjectException(StringUtils.capitalize((String)tt.toHumanReadableString()) + " " + loc.getId() + " from project " + loc.getProjectKey() + " is no longer shared with this project. Please have it shared again or remove it from this project.");
        }
    }

    public void failIfNoTaggableTypeReadUseAccessWithUnknownType(AuthCtx user, AnyLoc loc, String contextProjectKey) throws IOException, DKUSecurityException {
        if (loc.getProjectKey().equals(contextProjectKey)) {
            this.checkPerm(user, contextProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF);
        } else if (!this.hasExposedObjectAccessWithUnknownType(user, loc, contextProjectKey)) {
            throw new ForbiddenObjectException(loc.getId() + " from project " + loc.getProjectKey() + " is no longer shared with this project. Please have it shared again or remove it from this project.");
        }
    }

    public void failIfNoReadAccess(AuthCtx user, TaggableObjectsService.TaggableObjectRef taggableObjectRef, String contextProjectKey) throws IOException, DKUSecurityException {
        this.failIfNoTaggableObjectReadUseAccess(user, taggableObjectRef.type, taggableObjectRef.getLoc(), contextProjectKey);
    }

    public void checkDatasetReadAccessRegardlessOfContext(AuthCtx authCtx, AnyLoc loc) throws DKUSecurityException, IOException {
        if (!this.hasDatasetReadAccessRegardlessOfContext(authCtx, loc)) {
            throw new SecurityException("You don't have permission to access dataset " + String.valueOf(loc) + " (context-less)");
        }
    }

    public boolean hasDatasetReadAccessRegardlessOfContext(AuthCtx authCtx, AnyLoc loc) throws DKUSecurityException, IOException {
        return this.hasReadAccessThroughProjectOrSharingMechanism(authCtx, ITaggingService.TaggableType.DATASET, loc);
    }

    boolean hasReadAccessThroughProjectOrSharingMechanism(AuthCtx authCtx, ITaggingService.TaggableType objectType, AnyLoc loc) throws DKUSecurityException, IOException {
        if (this.permissionsService.hasProjectPrivilege(authCtx, loc.getProjectKey(), Privileges.ProjectLevelPrivilegeType.READ_CONF)) {
            return true;
        }
        SerializedProject sp = this.getMandatoryUnsafe(loc.getProjectKey());
        for (ExposedObject dp : sp.exposedObjects.objects) {
            if (dp == null || StringUtils.isBlank((String)dp.localName)) {
                logger.warn((Object)("Invalid shared object in " + loc.getProjectKey()));
                continue;
            }
            if (dp.type != objectType || !dp.localName.equals(loc.getId())) continue;
            for (ExposedObject.Rule rule : dp.rules) {
                if (StringUtils.isBlank((String)rule.targetProject)) continue;
                try {
                    if (!this.permissionsService.hasProjectPrivilege(authCtx, rule.targetProject, Privileges.ProjectLevelPrivilegeType.READ_CONF)) continue;
                    logger.info((Object)("Permission on " + String.valueOf(loc) + " granted through rule exposing to " + rule.targetProject));
                    return true;
                }
                catch (DKUSecurityException e) {
                    logger.warnV((Throwable)e, "Permissions for %s exposed in project %s could not be validated.", new Object[]{loc.toString(), rule.targetProject});
                }
            }
            return false;
        }
        return false;
    }

    public boolean hasAnyReadPermissionRegardlessOfContext(AuthCtx authCtx, String projectKey, ITaggingService.TaggableType objectType, String objectId) throws DKUSecurityException, IOException {
        return this.hasDashboardReadPermission(authCtx, SmartObjectRef.localRef(objectType, objectId), projectKey) || this.hasReadAccessThroughProjectOrSharingMechanism(authCtx, objectType, new AnyLoc(projectKey, objectId));
    }

    public boolean hasPermissionRegardlessOfContext(AuthCtx authCtx, String projectKey, ITaggingService.TaggableType objectType, String objectId, SerializedProject.ReaderAuthorization.Mode mode) throws DKUSecurityException, IOException {
        SmartObjectRef objectRef = SmartObjectRef.localRef(objectType, objectId);
        SerializedProject sourceProject = this.getOrNullUnsafe(objectRef.getProjectKey(projectKey));
        if (sourceProject == null) {
            return false;
        }
        boolean hasAccessThroughProjectOrSharing = false;
        switch (mode) {
            case DISCOVER: 
            case READ: {
                hasAccessThroughProjectOrSharing = this.hasReadAccessThroughProjectOrSharingMechanism(authCtx, objectType, new AnyLoc(projectKey, objectId));
                break;
            }
            case WRITE: {
                hasAccessThroughProjectOrSharing = this.permissionsService.hasProjectPrivilege(authCtx, sourceProject, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                break;
            }
            case RUN: {
                hasAccessThroughProjectOrSharing = this.permissionsService.hasProjectPrivilege(authCtx, sourceProject, Privileges.ProjectLevelPrivilegeType.RUN_SCENARIOS);
            }
        }
        return hasAccessThroughProjectOrSharing || this.isObjectAccessibleViaSomeDashboardAuth(authCtx, projectKey, objectType, objectId, mode) || this.hasDashboardPermission(authCtx, objectRef, projectKey, mode);
    }

    public boolean hasPermissionRegardlessOfContext(AuthCtx authCtx, TaggableObjectsService.TaggableObjectRef object, SerializedProject.ReaderAuthorization.Mode mode) throws DKUSecurityException, IOException {
        return this.hasPermissionRegardlessOfContext(authCtx, object.projectKey, object.type, object.id, mode);
    }

    private void failBecauseOfPermissionRegardlessOfContext(String projectKey, ITaggingService.TaggableType type, String id, SerializedProject.ReaderAuthorization.Mode mode) throws UnauthorizedException {
        throw new UnauthorizedException("You do not have permission to " + String.valueOf((Object)mode) + " object {projectKey:" + projectKey + ", type:" + String.valueOf((Object)type) + ", id:" + id + "}", "object-access-denied");
    }

    public void checkPermissionRegardlessOfContext(AuthCtx authCtx, String projectKey, ITaggingService.TaggableType objectType, String objectId, SerializedProject.ReaderAuthorization.Mode mode) throws IOException, DKUSecurityException {
        if (!this.hasPermissionRegardlessOfContext(authCtx, projectKey, objectType, objectId, mode)) {
            this.failBecauseOfPermissionRegardlessOfContext(projectKey, objectType, objectId, mode);
        }
    }

    public ObjectVisibility getDataCollectionObjectVisibility(AuthCtx authCtx, String projectKey, ITaggingService.TaggableType type, String id) throws IOException, DKUSecurityException {
        return this.getDataCollectionObjectVisibility(authCtx, projectKey, type, id, false, false);
    }

    public ObjectVisibility getDataCollectionObjectVisibility(AuthCtx authCtx, String projectKey, ITaggingService.TaggableType type, String id, boolean stopIfAnyVisibility, boolean ignoreAccessThroughWorkspace) throws DKUSecurityException, IOException {
        SerializedProject project = this.getOrNullUnsafe(projectKey);
        if (project == null) {
            return ObjectVisibility.NONE;
        }
        if (this.hasReadAccessThroughProjectOrSharingMechanism(authCtx, type, new AnyLoc(projectKey, id))) {
            return ObjectVisibility.READ;
        }
        ObjectVisibility visibilityFromDashboardAuth = this.getVisibilityFromDashboardAuthorizations(authCtx, project, type, id, stopIfAnyVisibility);
        if (visibilityFromDashboardAuth == ObjectVisibility.READ || stopIfAnyVisibility && visibilityFromDashboardAuth != ObjectVisibility.NONE) {
            return visibilityFromDashboardAuth;
        }
        if (!ignoreAccessThroughWorkspace && this.workspacePermissionsService.isObjectReadableViaSomeWorkspace(authCtx, projectKey, type, id)) {
            return ObjectVisibility.READ;
        }
        return visibilityFromDashboardAuth;
    }

    private ObjectVisibility getVisibilityFromDashboardAuthorizations(AuthCtx authCtx, SerializedProject project, ITaggingService.TaggableType type, String id, boolean stopIfAnyVisibility) throws IOException, DKUSecurityException {
        SmartObjectRef objectRef = SmartObjectRef.localRef(type, id);
        ObjectVisibility visibilityFromSourceDashboardAuth = project.dashboardAuthorizations.getObjectVisibility(objectRef);
        if (visibilityFromSourceDashboardAuth == ObjectVisibility.READ || stopIfAnyVisibility && visibilityFromSourceDashboardAuth != ObjectVisibility.NONE) {
            return visibilityFromSourceDashboardAuth;
        }
        ObjectVisibility visibilityFromForeignDashboardAuth = this.getVisibilityFromForeignDashboardAuthorizations(authCtx, project, type, id, stopIfAnyVisibility);
        if (visibilityFromForeignDashboardAuth == ObjectVisibility.READ) {
            return ObjectVisibility.READ;
        }
        if (visibilityFromSourceDashboardAuth == ObjectVisibility.DISCOVER || visibilityFromForeignDashboardAuth == ObjectVisibility.DISCOVER) {
            return ObjectVisibility.DISCOVER;
        }
        return ObjectVisibility.NONE;
    }

    private ObjectVisibility getVisibilityFromForeignDashboardAuthorizations(AuthCtx authCtx, SerializedProject project, ITaggingService.TaggableType type, String id, boolean stopIfAnyVisibility) throws IOException, DKUSecurityException {
        ObjectVisibility visibility = ObjectVisibility.NONE;
        for (String targetProjectKey : project.exposedObjects.getProjectsExposedTo(type, id)) {
            SerializedProject targetProject = this.getOrNullUnsafe(targetProjectKey);
            if (targetProject == null || !this.permissionsService.hasProjectPrivilege(authCtx, targetProject, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS)) continue;
            SmartObjectRef refFromTarget = SmartObjectRef.fromResolved(type, project.projectKey, id, targetProjectKey);
            ObjectVisibility targetProjectVisibility = targetProject.dashboardAuthorizations.getObjectVisibility(refFromTarget);
            if (targetProjectVisibility == ObjectVisibility.READ || stopIfAnyVisibility && targetProjectVisibility != ObjectVisibility.NONE) {
                return targetProjectVisibility;
            }
            if (targetProjectVisibility != ObjectVisibility.DISCOVER) continue;
            visibility = ObjectVisibility.DISCOVER;
        }
        return visibility;
    }

    public ObjectVisibility getObjectVisibility(AuthCtx authCtx, SerializedProject project, ITaggingService.TaggableType type, String id) throws DKUSecurityException, IOException {
        if (project == null) {
            return ObjectVisibility.NONE;
        }
        if (this.hasReadAccessThroughProjectOrSharingMechanism(authCtx, type, AnyLoc.resolveSmart(project.projectKey, id))) {
            return ObjectVisibility.READ;
        }
        SmartObjectRef objectRef = SmartObjectRef.localRef(type, id);
        boolean hasReadDashboardPermission = this.permissionsService.hasProjectPrivilege(authCtx, project.projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
        boolean isReaderAuthorized = project.dashboardAuthorizations.hasObjectAuthorization(objectRef, SerializedProject.ReaderAuthorization.Mode.READ);
        if (hasReadDashboardPermission && isReaderAuthorized) {
            return ObjectVisibility.READ;
        }
        if (this.workspacePermissionsService.isObjectReadableViaSomeWorkspace(authCtx, project.projectKey, type, id)) {
            return ObjectVisibility.READ;
        }
        boolean isObjectInAnyReadableDataCollection = this.dataCollectionPermissionsService.isObjectContainedInAnyReadableDataCollection(authCtx, project.projectKey, type, id);
        if (isReaderAuthorized && isObjectInAnyReadableDataCollection) {
            return ObjectVisibility.READ;
        }
        ObjectVisibility visibilityFromForeignDashboardAuth = this.getVisibilityFromForeignDashboardAuthorizations(authCtx, project, type, id, false);
        if (visibilityFromForeignDashboardAuth != ObjectVisibility.NONE) {
            return visibilityFromForeignDashboardAuth;
        }
        boolean isDiscoverAuthorized = project.dashboardAuthorizations.hasObjectAuthorization(objectRef, SerializedProject.ReaderAuthorization.Mode.DISCOVER);
        if (isDiscoverAuthorized && (hasReadDashboardPermission || isObjectInAnyReadableDataCollection)) {
            return ObjectVisibility.DISCOVER;
        }
        return ObjectVisibility.NONE;
    }

    public boolean hasPermissionViaSomeDataCollection(AuthCtx user, String objectProjectKey, ITaggingService.TaggableType objectType, String objectId, SerializedProject.ReaderAuthorization.Mode mode) throws IOException, DKUSecurityException {
        SerializedProject sourceProject = this.projectsDAO.getOrNullUnsafe(objectProjectKey);
        SmartObjectRef objectRef = SmartObjectRef.localRef(objectType, objectId);
        return sourceProject != null && sourceProject.dashboardAuthorizations.hasObjectAuthorization(objectRef, mode) && this.dataCollectionPermissionsService.isObjectContainedInAnyReadableDataCollection(user, sourceProject.projectKey, objectType, objectId);
    }

    public boolean hasExposedObjectAccess(ITaggingService.TaggableType type, AuthCtx u, AnyLoc loc, String projectKey) throws IOException, DKUSecurityException {
        if (!this.permissionsService.hasProjectPrivilege(u, projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) {
            return false;
        }
        SerializedProject sp = this.getOrNullUnsafe(loc.getProjectKey());
        if (sp != null) {
            for (ExposedObject exposedObject : sp.exposedObjects.objects) {
                logger.info((Object)("Check a rule " + JSON.json((Object)exposedObject) + " for " + loc.getId() + " from " + projectKey));
                if (exposedObject.type != type || !exposedObject.localName.equals(loc.getId()) || !exposedObject.canAccess(projectKey)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasExposedObjectAccessWithUnknownType(AuthCtx u, AnyLoc loc, String contextProjectKey) throws IOException, DKUSecurityException {
        if (!this.permissionsService.hasProjectPrivilege(u, contextProjectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF)) {
            return false;
        }
        SerializedProject sp = this.getOrNullUnsafe(loc.getProjectKey());
        if (sp != null) {
            for (ExposedObject dp : sp.exposedObjects.objects) {
                logger.info((Object)("Check a rule " + JSON.json((Object)dp) + " for " + loc.getId() + " from " + contextProjectKey));
                if (!dp.localName.equals(loc.getId()) || !dp.canAccess(contextProjectKey)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isObjectAvailableInProject(SmartObjectRef objectRef, String contextProjectKey) throws IOException {
        if (!objectRef.isForeign() || contextProjectKey.equals(objectRef.projectKey)) {
            return true;
        }
        SerializedProject sp = this.getOrNullUnsafe(objectRef.projectKey);
        if (sp != null) {
            for (ExposedObject dp : sp.exposedObjects.objects) {
                if (dp.type != objectRef.objectType || !dp.localName.equals(objectRef.objectId) || !dp.canAccess(contextProjectKey)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasDashboardReadPermission(AuthCtx authCtx, SmartObjectRef objectRef, String contextProjectKey) throws IOException, DKUSecurityException {
        return this.hasDashboardReadPermission(authCtx, objectRef, this.getMandatoryUnsafe(contextProjectKey));
    }

    public boolean hasDashboardReadPermission(AuthCtx authCtx, SmartObjectRef objectRef, SerializedProject contextProject) throws IOException, DKUSecurityException {
        return this.hasDashboardPermission(authCtx, objectRef, contextProject, SerializedProject.ReaderAuthorization.Mode.READ);
    }

    public boolean hasDashboardPermission(AuthCtx user, SmartObjectRef objectRef, String contextProjectKey, SerializedProject.ReaderAuthorization.Mode mode) throws IOException, DKUSecurityException {
        return this.hasDashboardPermission(user, objectRef, this.getMandatoryUnsafe(contextProjectKey), mode);
    }

    public boolean hasDashboardPermission(AuthCtx user, SmartObjectRef objectRef, SerializedProject contextProject, SerializedProject.ReaderAuthorization.Mode mode) throws IOException, DKUSecurityException {
        boolean isReadOrDiscover = mode == SerializedProject.ReaderAuthorization.Mode.READ || mode == SerializedProject.ReaderAuthorization.Mode.DISCOVER;
        boolean isObjectAvailableInProject = this.isObjectAvailableInProject(objectRef, contextProject.projectKey);
        if (isObjectAvailableInProject && (isReadOrDiscover && this.permissionsService.hasProjectPrivilege(user, contextProject.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF) || this.permissionsService.hasProjectPrivilege(user, contextProject.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF))) {
            return true;
        }
        boolean hasReadDashboardPermission = this.permissionsService.hasProjectPrivilege(user, contextProject.projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
        if (hasReadDashboardPermission) {
            boolean isDashboardOrInsight;
            boolean bl = isDashboardOrInsight = objectRef.objectType == ITaggingService.TaggableType.DASHBOARD || objectRef.objectType == ITaggingService.TaggableType.INSIGHT;
            if (isReadOrDiscover && isDashboardOrInsight) {
                return true;
            }
            if (objectRef.objectType == ITaggingService.TaggableType.LABELING_TASK && isReadOrDiscover) {
                return this.permissionsService.hasLabelingTaskPrivilege(user, contextProject.projectKey, objectRef.objectId, Privileges.LabelingLevelPrivilegeType.READ);
            }
            if (isObjectAvailableInProject && contextProject.dashboardAuthorizations.hasObjectAuthorization(objectRef, mode)) {
                return true;
            }
        }
        String objectProjectKey = objectRef.getProjectKey(contextProject.projectKey);
        return isReadOrDiscover && (this.hasPermissionViaSomeDataCollection(user, objectProjectKey, objectRef.objectType, objectRef.objectId, mode) || this.workspacePermissionsService.isObjectReadableViaSomeWorkspace(user, objectProjectKey, objectRef.objectType, objectRef.objectId));
    }

    public boolean isObjectAccessibleViaSomeDashboardAuth(AuthCtx user, String projectKey, ITaggingService.TaggableType type, String id, SerializedProject.ReaderAuthorization.Mode mode) throws IOException, DKUSecurityException {
        SerializedProject sourceProject = this.getOrNullUnsafe(projectKey);
        if (sourceProject == null) {
            return false;
        }
        if (this.permissionsService.hasProjectPrivilege(user, sourceProject, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS) && sourceProject.dashboardAuthorizations.hasObjectAuthorization(SmartObjectRef.localRef(type, id), mode)) {
            return true;
        }
        if (mode == SerializedProject.ReaderAuthorization.Mode.READ || mode == SerializedProject.ReaderAuthorization.Mode.DISCOVER || mode == SerializedProject.ReaderAuthorization.Mode.RUN) {
            for (String targetProjectKey : sourceProject.exposedObjects.getProjectsExposedTo(type, id)) {
                SmartObjectRef refFromTarget = SmartObjectRef.fromResolved(type, projectKey, id, targetProjectKey);
                SerializedProject targetProject = this.getOrNullUnsafe(targetProjectKey);
                if (targetProject == null || !this.permissionsService.hasProjectPrivilege(user, targetProject, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS) || !targetProject.dashboardAuthorizations.hasObjectAuthorization(refFromTarget, mode)) continue;
                return true;
            }
        }
        return false;
    }

    public void failIfNoDashboardPermission(HttpServletRequest req, SmartObjectRef objectRef, String contextProjectKey, SerializedProject.ReaderAuthorization.Mode mode) throws IOException, DKUSecurityException {
        this.failIfNoDashboardPermission(this.authService.getMandatoryUser(req), objectRef, contextProjectKey, mode);
    }

    public void failIfNoDashboardPermission(AuthCtx authCtx, SmartObjectRef objectRef, String contextProjectKey, SerializedProject.ReaderAuthorization.Mode mode) throws IOException, DKUSecurityException {
        if (!this.hasDashboardPermission(authCtx, objectRef, contextProjectKey, mode)) {
            throw new UnauthorizedException("You do not have permission to use for dashboard " + String.valueOf(objectRef) + " within " + contextProjectKey, "dashboard-use-denied");
        }
    }

    public void failIfNoDashboardReadPermission(AuthCtx authCtx, SmartObjectRef objectRef, String contextProjectKey) throws IOException, DKUSecurityException {
        if (!this.hasDashboardReadPermission(authCtx, objectRef, contextProjectKey)) {
            throw new UnauthorizedException("You do not have permission to read-use for dashboard " + String.valueOf(objectRef) + " within " + contextProjectKey, "dashboard-use-denied");
        }
    }

    public void failIfNoDashboardReadPermission(HttpServletRequest req, SmartObjectRef objectRef, String contextProjectKey) throws IOException, DKUSecurityException {
        this.failIfNoDashboardReadPermission(this.authService.getMandatoryUser(req), objectRef, contextProjectKey);
    }

    public boolean hasObjectLocalPermission(AuthCtx user, SmartObjectRef objectRef, SerializedProject contextProject, SerializedProject.ReaderAuthorization.Mode mode) throws DKUSecurityException, IOException {
        if (this.permissionsService.hasProjectPrivilege(user, contextProject.projectKey, Privileges.ProjectLevelPrivilegeType.READ_CONF) && (mode == SerializedProject.ReaderAuthorization.Mode.READ || mode == SerializedProject.ReaderAuthorization.Mode.DISCOVER || this.permissionsService.hasProjectPrivilege(user, contextProject.projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF))) {
            return true;
        }
        if (!this.permissionsService.hasAnyProjectAccess(user, contextProject.projectKey)) {
            return false;
        }
        if (objectRef.objectType == ITaggingService.TaggableType.DASHBOARD) {
            return true;
        }
        if (objectRef.objectType == ITaggingService.TaggableType.INSIGHT) {
            Insight insight = this.insightsService.getMandatoryUnsafe(objectRef.getProjectKey(contextProject.projectKey), objectRef.objectId);
            return this.insightsService.hasInsightReadPermission(user, insight);
        }
        return contextProject.dashboardAuthorizations.hasObjectAuthorization(objectRef, mode);
    }

    public SerializedProject.ProjectDashboardAuthorizations getDashboardAuthorizationsWithNames(SerializedProject sp) throws Exception {
        SerializedProject.ProjectDashboardAuthorizations ret = (SerializedProject.ProjectDashboardAuthorizations)JSON.deepCopy((Object)sp.dashboardAuthorizations);
        ret.authorizations = new ArrayList<SerializedProject.ReaderAuthorization>();
        for (SerializedProject.ReaderAuthorization readerAuth : sp.dashboardAuthorizations.authorizations) {
            try {
                readerAuth.objectRef = this.taggableObjectsReadService.enrichSmartObjectRef(readerAuth.objectRef, sp.projectKey);
                ret.authorizations.add(readerAuth);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to enrich object ref", (Throwable)e);
            }
        }
        return ret;
    }

    public boolean isVisible(SerializedProject sp, GeneralSettingsDAO.GeneralSettings generalSettings) {
        return generalSettings.projectVisibility.visibilityMode.resolveLocalSetting(sp.settings.limitedVisibilityEnabled);
    }

    public boolean isVisible(String projectKey) throws UnauthorizedException {
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        return this.isVisible(this.getMandatoryUnsafe_RethrowException(projectKey), gs);
    }

    public SerializedProject getMandatoryUnsafe_RethrowException(String projectKey) throws UnauthorizedException {
        SerializedProject sp;
        try {
            sp = this.getMandatoryUnsafe(projectKey);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to read project permissions", (Throwable)e);
            throw new UnauthorizedException("Failed to read project permissions", "check-failed", (Throwable)e);
        }
        return sp;
    }

    public boolean isAccessRequestsEnabled(SerializedProject sp, GeneralSettingsDAO.GeneralSettings generalSettings) {
        return generalSettings.projectVisibility.accessRequestsMode.resolveLocalSetting(sp.settings.accessRequestsEnabled);
    }

    public boolean isObjectSharingRequestEnabled(SerializedProject sp) throws IOException {
        return ProjectsService.isObjectSharingRequestEnabled(sp, ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN());
    }

    public static boolean isObjectSharingRequestEnabled(SerializedProject sp, GeneralSettingsDAO.GeneralSettings generalSettings) {
        return generalSettings.objectSharingRequestsMode.resolveLocalSetting(sp.settings.sharingRequestsEnabled);
    }

    public boolean hasCustomProjectAccess(AuthCtx authCtx, JsonObject searchResponse) throws DKUSecurityException {
        if (!searchResponse.has("projectKey")) {
            return true;
        }
        String projectKey = searchResponse.get("projectKey").getAsString();
        if (StringUtils.isBlank((String)projectKey)) {
            return true;
        }
        try (Transaction t = this.transactionService.beginRead();){
            boolean bl = this.permissionsService.hasCustomProjectAccess(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS);
            return bl;
        }
    }

    public void searchResultPostTreatment(AuthCtx authCtx, JsonObject projectSearchResponse) throws DKUSecurityException, IOException {
        String projectKey = projectSearchResponse.get("projectKey").getAsString();
        try (Transaction t = this.transactionService.beginRead();){
            if (!this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.READ_DASHBOARDS)) {
                projectSearchResponse.keySet().retainAll(Lists.newArrayList((Object[])new String[]{"type", "projectKey", "id", "name", "projectName", "description", "shortDesc", "createdOn", "createdBy", "tag", "owner"}));
                projectSearchResponse.addProperty("onlyLimitedVisibility", Boolean.valueOf(true));
                projectSearchResponse.addProperty("isAccessRequestsEnabled", Boolean.valueOf(this.isAccessRequestsEnabled(this.getMandatory(projectKey), ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN())));
            }
        }
    }

    public void checkReadDashboardPerm(HttpServletRequest req, String projectKey, @Nullable ITaggingService.TaggableType objectType, @Nullable String objectId) throws IOException, DKUSecurityException {
        this.checkReadDashboardPerm(this.authService.getMandatoryUser(req), projectKey, objectType, objectId);
    }

    public void checkReadDashboardPerm(AuthCtx authCtx, String projectKey, @Nullable ITaggingService.TaggableType objectType, @Nullable String objectId) throws DKUSecurityException {
        this.permissionsService.checkReadDashboardPermission(authCtx, projectKey, objectType, objectId);
    }

    public void checkPerm(HttpServletRequest req, String projectKey, Privileges.ProjectLevelPrivilegeType ... privileges) throws DKUSecurityException, IOException {
        AuthCtx u = this.authService.getMandatoryUser(req);
        this.permissionsService.checkProjectPrivileges(u, projectKey, privileges);
    }

    public void checkPermNoXSRF(HttpServletRequest req, String projectKey, Privileges.ProjectLevelPrivilegeType ... privileges) throws IOException, DKUSecurityException {
        AuthCtx u = this.authService.getMandatoryUserNoXSRF(req);
        this.permissionsService.checkProjectPrivileges(u, projectKey, privileges);
    }

    @Override
    public void checkPerm(AuthCtx authCtx, String projectKey, Privileges.ProjectLevelPrivilegeType ... privileges) throws DKUSecurityException {
        this.permissionsService.checkProjectPrivileges(authCtx, projectKey, privileges);
    }

    public boolean hasPerm(AuthCtx authCtx, String projectKey, Privileges.ProjectLevelPrivilegeType privilege) throws DKUSecurityException {
        return this.permissionsService.hasProjectPrivilege(authCtx, projectKey, privilege);
    }

    public void checkPermAndCanCreateWebContent(AuthCtx authCtx, String projectKey, Privileges.ProjectLevelPrivilegeType ... privileges) throws DKUSecurityException {
        this.permissionsService.checkProjectPrivileges(authCtx, projectKey, privileges);
        this.permissionsService.checkCanCreateActiveWebContent(authCtx);
    }

    public void checkNonAdminCanSavePermissions(AuthCtx user, SerializedProject projectBefore, List<SerializedProject.PermissionItem> newPermissions) throws IOException, DKUSecurityException {
        if (this.permissionsService.hasProjectPrivilege(user, projectBefore, Privileges.ProjectLevelPrivilegeType.ADMIN)) {
            return;
        }
        if (!this.permissionsService.hasProjectPrivilege(user, projectBefore, Privileges.ProjectLevelPrivilegeType.EDIT_PERMISSIONS)) {
            throw new UnauthorizedException("Action forbidden", "project-authorization-failure").with("requiredPrivileges", Privileges.ProjectLevelPrivilegeType.EDIT_PERMISSIONS.toString());
        }
        this.checkCanSaveNewPermissions(user, projectBefore, newPermissions);
    }

    private void checkCanSaveNewPermissions(AuthCtx user, SerializedProject projectBefore, List<SerializedProject.PermissionItem> newPermissions) throws DKUSecurityException {
        HashSet<SerializedProject.PermissionItem> deletedPermissions = new HashSet<SerializedProject.PermissionItem>(projectBefore.permissions);
        for (SerializedProject.PermissionItem newPermission : newPermissions) {
            if (newPermission == null) continue;
            SerializedProject.PermissionItem existingPermission = projectBefore.permissions.stream().filter(oldPerm -> oldPerm != null && (StringUtils.isNotBlank((String)newPermission.user) && Objects.equals(oldPerm.user, newPermission.user) || StringUtils.isNotBlank((String)newPermission.group) && Objects.equals(oldPerm.group, newPermission.group) || StringUtils.isNotBlank((String)newPermission.pendingUserEmail) && StringUtils.equalsIgnoreCase((String)newPermission.pendingUserEmail, (String)oldPerm.pendingUserEmail))).findFirst().orElse(null);
            if (existingPermission != null) {
                deletedPermissions.remove(existingPermission);
            }
            this.checkCanSaveOrDeletePermission(user, projectBefore, existingPermission, newPermission);
        }
        for (SerializedProject.PermissionItem deletedPermission : deletedPermissions) {
            this.checkCanSaveOrDeletePermission(user, projectBefore, deletedPermission, null);
        }
    }

    private void checkCanSaveOrDeletePermission(AuthCtx user, SerializedProject projectBefore, @Nullable SerializedProject.PermissionItem existingPermission, @Nullable SerializedProject.PermissionItem newPermission) throws DKUSecurityException {
        boolean modifiesEditPermissions = PermissionsService.permissionItemIncludes(existingPermission, Privileges.ProjectLevelPrivilegeType.EDIT_PERMISSIONS) != PermissionsService.permissionItemIncludes(newPermission, Privileges.ProjectLevelPrivilegeType.EDIT_PERMISSIONS);
        for (Privileges.ProjectLevelPrivilegeType privilege : Privileges.ProjectLevelPrivilegeType.values()) {
            boolean needsPermission;
            boolean includesPermissionBefore = PermissionsService.permissionItemIncludes(existingPermission, privilege);
            boolean includesPermissionAfter = PermissionsService.permissionItemIncludes(newPermission, privilege);
            boolean bl = needsPermission = modifiesEditPermissions && includesPermissionBefore || includesPermissionBefore != includesPermissionAfter;
            if (!needsPermission || this.permissionsService.hasProjectPrivilege(user, projectBefore, privilege)) continue;
            String errorMessage = modifiesEditPermissions && includesPermissionBefore ? "You cannot add or remove EDIT_PERMISSIONS right of a user with more rights than yourself" : String.format("You cannot add or remove the %s right since you do not have that right yourself", new Object[]{privilege});
            throw new DKUSecurityException(errorMessage);
        }
    }

    public InfoMessage.InfoMessages setPermissions(SerializedProject project) throws IOException, LimitsStatusComputer.LicenseLimitException, CodedException {
        return this.setPermissions(project, false);
    }

    public InfoMessage.InfoMessages setPermissions(SerializedProject project, boolean skipLicenseCheck) throws IOException, LimitsStatusComputer.LicenseLimitException, CodedException {
        ErrorContext.check((boolean)this.projectExists(project.projectKey), (String)("Project " + project.projectKey + " does not exist"));
        InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
        this.saveInternal(project, TaggableObjectChangedEvent.ProjectEditSubtype.PERMISSIONS_ONLY, skipLicenseCheck);
        if (this.impersonationResolverService.isEnabled()) {
            boolean hasHDFS = false;
            for (SerializedDataset sd : this.datasetsDAO.listUnsafe(project.projectKey)) {
                if (!"HDFS".equals(sd.type)) continue;
                hasHDFS = true;
                break;
            }
            if (hasHDFS) {
                ret.withInfo((InfoMessage.MessageCode)UserCodes.INFO_USER_PROJECT_HDFS_ACL_RESYNC_REQUIRED, "Project contains HDFS datasets. After a permission change, you should resync ACLs (Settings > ACLs resync)");
            }
        }
        return ret;
    }

    @VisibleForTesting
    public static List<SerializedProject.PermissionItem> squashPermissions(List<SerializedProject.PermissionItem> permissions) {
        if (permissions == null) {
            return null;
        }
        ArrayList<SerializedProject.PermissionItem> squashedPermissions = new ArrayList<SerializedProject.PermissionItem>();
        for (SerializedProject.PermissionItem permission : permissions) {
            if (permission == null) continue;
            SerializedProject.PermissionItem existingPermission = squashedPermissions.stream().filter(item -> StringUtils.isNotBlank((String)permission.user) && Objects.equals(item.user, permission.user) || StringUtils.isNotBlank((String)permission.group) && Objects.equals(item.group, permission.group) || StringUtils.isNotBlank((String)permission.pendingUserEmail) && StringUtils.equalsIgnoreCase((String)permission.pendingUserEmail, (String)item.pendingUserEmail)).findFirst().orElse(null);
            if (existingPermission == null) {
                squashedPermissions.add(permission);
                continue;
            }
            existingPermission.addPermissionsFrom(permission);
        }
        return squashedPermissions;
    }

    public void convertPendingUserEmailPermissionsIfMatchingUser(SerializedProject project) {
        if (project == null || project.permissions == null) {
            return;
        }
        try {
            List pendingEmailPermissions = project.permissions.stream().filter(permission -> permission != null && StringUtils.isNotBlank((String)permission.pendingUserEmail)).collect(Collectors.toList());
            if (!pendingEmailPermissions.isEmpty()) {
                GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
                if (!GeneralSettingsService.arePermissionsByEmailEnabled(generalSettings)) {
                    return;
                }
                Multimap<String, String> loginsByEmails = UsersService.buildLoginsByEmailMap(this.usersService.listUsersUnsafe());
                for (SerializedProject.PermissionItem permission2 : pendingEmailPermissions) {
                    Collection matchingUserLogins = loginsByEmails.get((Object)permission2.pendingUserEmail.toLowerCase(Locale.ROOT));
                    if (matchingUserLogins.size() == 1) {
                        String login = (String)matchingUserLogins.iterator().next();
                        PermissionsService.convertPendingPermissionItem(permission2, login);
                        continue;
                    }
                    if (matchingUserLogins.size() <= 1) continue;
                    logger.warnV("Multiple users (%s) found for email %s, not converting permission %s in project %s.", new Object[]{String.join((CharSequence)", ", matchingUserLogins), permission2.pendingUserEmail, JSON.json((Object)permission2), project.projectKey});
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to convert pendingUserEmail permission for project " + project.projectKey), (Throwable)e);
        }
    }

    void resolveInvitationEmailStatuses(SerializedProject sp) {
        try {
            SerializedProject existingProject = this.getOrNullUnsafe(sp.projectKey);
            if (existingProject == null) {
                return;
            }
            HashMap statusesByEmail = new HashMap();
            existingProject.permissions.stream().filter(permission -> permission != null && permission.pendingUserEmail != null && permission.invitationEmailStatus != null).forEach(permission -> statusesByEmail.put(permission.pendingUserEmail.toLowerCase(Locale.ROOT), permission.invitationEmailStatus));
            for (SerializedProject.PermissionItem permission2 : sp.permissions) {
                if (permission2 == null || permission2.pendingUserEmail == null || AbstractInviteEmailSendService.InvitationEmailStatus.SENT.equals((Object)permission2.invitationEmailStatus) || AbstractInviteEmailSendService.InvitationEmailStatus.FAILED.equals((Object)permission2.invitationEmailStatus)) continue;
                String normalizedEmail = permission2.pendingUserEmail.toLowerCase(Locale.ROOT);
                permission2.invitationEmailStatus = statusesByEmail.getOrDefault(normalizedEmail, permission2.invitationEmailStatus);
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to check for existing email permission statuses in project " + sp.projectKey));
        }
    }

    @Override
    public Set<String> collectRelatedProjects(SerializedProject project, boolean downstream, boolean upstream) throws IOException {
        HashSet<String> ret = new HashSet<String>();
        this.collectRelatedProjects(project, downstream, upstream, ret);
        return ret;
    }

    private void collectRelatedProjects(SerializedProject project, boolean downstream, boolean upstream, Set<String> into) throws IOException {
        assert (upstream || downstream);
        logger.debugV("Project save: collecting related projects of %s (up: %s, down: %s)", new Object[]{project.projectKey, upstream, downstream});
        if (downstream) {
            for (ExposedObject eo : project.exposedObjects.objects) {
                if (eo == null || eo.rules == null) continue;
                for (ExposedObject.Rule rule : eo.rules) {
                    into.add(rule.targetProject);
                }
            }
        }
        if (upstream) {
            for (SerializedProject sp : this.listAllUnsafe()) {
                block3: for (ExposedObject eo : sp.exposedObjects.objects) {
                    if (eo == null || eo.rules == null) continue;
                    for (ExposedObject.Rule rule : eo.rules) {
                        if (rule == null || rule.targetProject == null || !rule.targetProject.equals(project.projectKey)) continue;
                        into.add(sp.projectKey);
                        continue block3;
                    }
                }
            }
        }
        logger.debug((Object)("Related projects of " + project.projectKey + ": " + JSON.json(into)));
    }

    public SerializedProject create(SerializedProject project, TaggableObjectChangedEvent.ProjectEditSubtype projectEditSubtype, String projectFolderId) throws Exception {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        AuthCtx authCtx = t.getUser();
        ErrorContext.check((!this.projectExists(project.projectKey) ? 1 : 0) != 0, (String)("Project " + project.projectKey + " already exists"));
        SerializedProject ret = this.saveInternal(project, projectEditSubtype, false);
        this.projectFoldersService.addProject_Check(authCtx, projectFolderId, ret.projectKey);
        this.projectLibrariesEditionService.generateProjectLibrariesContent(t, ret.projectKey);
        return project;
    }

    @Override
    public SerializedProject save(SerializedProject project, TaggableObjectChangedEvent.ProjectEditSubtype projectEditSubtype) throws IOException, LimitsStatusComputer.LicenseLimitException, CodedException {
        ErrorContext.check((boolean)this.projectExists(project.projectKey), (String)("Project " + project.projectKey + " does not exist"));
        return this.saveInternal(project, projectEditSubtype, false);
    }

    private SerializedProject saveInternal(SerializedProject project, TaggableObjectChangedEvent.ProjectEditSubtype projectEditSubtype, boolean skipLicenseCheck) throws IOException, LimitsStatusComputer.LicenseLimitException, CodedException {
        TaggableObjectDiffService.TaggableObjectsDiff diff;
        boolean afterEONull;
        SerializedProject preExisting = this.getOrNull(project.projectKey);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        this.taggableObjectsService.handleCreationVersionTagOnObjectUpdateNullAllowed(project, preExisting);
        boolean collectDownstream = false;
        boolean collectUpstream = false;
        switch (projectEditSubtype) {
            case UNKNOWN: {
                collectDownstream = true;
                collectUpstream = true;
                break;
            }
            case PERMISSIONS_ONLY: {
                collectUpstream = true;
                break;
            }
            case EXPOSED_ONLY: 
            case QUICK_SHARE_ONLY: 
            case LOCAL_SETTINGS_AND_EXPOSED_ONLY: {
                collectDownstream = true;
                break;
            }
        }
        Set<String> relatedProjects = null;
        if (collectDownstream || collectUpstream) {
            relatedProjects = this.collectRelatedProjects(project, collectDownstream, collectUpstream);
            if (preExisting != null) {
                this.collectRelatedProjects(preExisting, collectDownstream, collectUpstream, relatedProjects);
            }
        }
        if (project.settings == null) {
            project.settings = new SerializedProject.ProjectSettings();
        }
        this.convertPendingUserEmailPermissionsIfMatchingUser(project);
        this.resolveInvitationEmailStatuses(project);
        try {
            project.permissions = ProjectsService.squashPermissions(project.permissions);
        }
        catch (Exception e) {
            logger.warnV((Throwable)e, "Failed to squash permissions for project %s", new Object[]{project.projectKey});
        }
        boolean bl = afterEONull = project.exposedObjects == null;
        if (preExisting != null) {
            boolean exposedObjectsEquals;
            boolean beforeEONull = preExisting.exposedObjects == null;
            boolean bl2 = exposedObjectsEquals = beforeEONull && afterEONull || !beforeEONull && preExisting.exposedObjects.equals(project.exposedObjects);
            if (!exposedObjectsEquals) {
                this.customPolicyHooksRegistry.onPreSharedItemsSave(t.getUser(), preExisting, project);
            }
        } else if (!afterEONull && !project.exposedObjects.objects.isEmpty()) {
            this.customPolicyHooksRegistry.onPreSharedItemsSave(t.getUser(), null, project);
        }
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), preExisting, project);
        this.projectsDAO.save(project);
        if (!(skipLicenseCheck || projectEditSubtype != TaggableObjectChangedEvent.ProjectEditSubtype.PERMISSIONS_ONLY && projectEditSubtype != TaggableObjectChangedEvent.ProjectEditSubtype.UNKNOWN)) {
            this.limitsEnforcementService.checkPermissionChangeIsValid();
            this.pubSub.publishAfterTransaction(new ProjectPermissionsChangedEvent(project.projectKey, project.name));
        }
        if ((diff = this.colaborativeMetadataDiffService.diff(preExisting, project, t.getUser().getIdentifier())).metadataChanged() && projectEditSubtype != TaggableObjectChangedEvent.ProjectEditSubtype.DUPLICATION && projectEditSubtype != TaggableObjectChangedEvent.ProjectEditSubtype.GIT) {
            this.colaborativeMetadataDiffService.publishAfterTransaction(diff);
        }
        if (projectEditSubtype != TaggableObjectChangedEvent.ProjectEditSubtype.SUMMARY_ONLY && projectEditSubtype != TaggableObjectChangedEvent.ProjectEditSubtype.DUPLICATION && projectEditSubtype != TaggableObjectChangedEvent.ProjectEditSubtype.GIT && project.projectAppType != SerializedProject.ProjectAppType.APP_INSTANCE) {
            TaggableObjectChangedEvent toce = new TaggableObjectChangedEvent(ITaggingService.TaggableType.PROJECT, project.projectKey, project.projectKey, t.getUser(), TaggableObjectChangedEvent.ActionType.PROJECT_EDIT);
            toce.withProjectEditSubtype(projectEditSubtype);
            if (preExisting != null) {
                boolean bl3 = toce.libDocumentationChanged = preExisting.settings.autogeneratedDocumentationEnabled != project.settings.autogeneratedDocumentationEnabled;
            }
            if (relatedProjects != null) {
                logger.info((Object)("Emitting TOCE with related projects: " + StringUtils.join(relatedProjects, (String)",")));
                toce.relatedProjectsBeforeAndAfter = relatedProjects;
            }
            this.pubSub.publishAfterTransaction(toce);
        }
        this.taggingService.onObjectSaved(project.projectKey, project.tags);
        return project;
    }

    public TaggableObjectsDeletionService.DeletionResult checkProjectDeletability(String projectKey, boolean withDatasetsAndFolders) throws Exception {
        TaggableObjectsDeletionService.DeletionResult deletion = new TaggableObjectsDeletionService.DeletionResult();
        for (String otherProjectKey : this.listProjectKeys()) {
            if (StringUtils.equals((String)otherProjectKey, (String)projectKey)) continue;
            for (SerializedRecipe srec : this.recipesDAO.listUnsafe(otherProjectKey)) {
                ArrayList<String> deps = new ArrayList<String>();
                for (SerializedRecipe.InputRole irole : srec.getInputsUnsafe().values()) {
                    for (SerializedRecipe.RecipeInput ri : irole.items) {
                        deps.add(ri.ref);
                    }
                }
                for (SerializedRecipe.OutputRole orole : srec.getOutputsUnsafe().values()) {
                    for (SerializedRecipe.RecipeOutput ro : orole.items) {
                        deps.add(ro.ref);
                    }
                }
                for (String dep : deps) {
                    DatasetLocUtils.DatasetLoc loc;
                    if (dep == null || !StringUtils.equals((String)(loc = DatasetLocUtils.resolveSmart(otherProjectKey, dep)).getProjectKey(), (String)projectKey)) continue;
                    deletion.withFatalV(ProjectCodes.ERR_PROJECT_CANNOT_DELETE, "Recipe \"" + srec.projectKey + "." + srec.name + "\" references the dataset \"" + loc.getFullName() + "\"", new Object[0]);
                }
            }
            for (LabelingTask task : this.labelingTasksDAO.listUnsafe(otherProjectKey)) {
                for (LabelingTask.LabelingTaskInput input : task.getFlatInputs()) {
                    if (!StringUtils.equals((String)input.getLoc(otherProjectKey).getProjectKey(), (String)projectKey)) continue;
                    deletion.withFatalV(ProjectCodes.ERR_PROJECT_CANNOT_DELETE, "Labeling task \"" + task.projectKey + "." + task.name + "\" references the computable \"" + input.getLoc(otherProjectKey).getFullName() + "\"", new Object[0]);
                }
                for (LabelingTask.LabelingTaskOutput output : task.getFlatOutputs()) {
                    if (!StringUtils.equals((String)output.getLoc(otherProjectKey).getProjectKey(), (String)projectKey)) continue;
                    deletion.withFatalV(ProjectCodes.ERR_PROJECT_CANNOT_DELETE, "Labeling task \"" + task.projectKey + "." + task.name + "\" references the computable \"" + output.getLoc(otherProjectKey).getFullName() + "\"", new Object[0]);
                }
            }
        }
        if (withDatasetsAndFolders && !deletion.anyMessage) {
            deletion.delayedClearManagedDatasets = this.datasetAccessService.list(projectKey);
            deletion.delayedClearOutputManagedFolders = this.getOutputManagedFolders(projectKey);
        }
        if (!deletion.anyMessage) {
            deletion.delayedClearLabelingTasks = this.labelingTasksDAO.list(projectKey);
        }
        return deletion;
    }

    private List<ManagedFolder> getOutputManagedFolders(String projectKey) throws IOException {
        ProjectFlowGraph projectGraph = this.flowGraphService.getProjectGraph(projectKey, true);
        return this.managedFolderDAO.list(projectKey).stream().filter(folder -> this.isOutputOfRecipe((ManagedFolder)folder, projectGraph)).collect(Collectors.toList());
    }

    private boolean isOutputOfRecipe(ManagedFolder folder, ProjectFlowGraph projectGraph) {
        FlowManagedFolder flowManagedFolder = projectGraph.getFolder(folder.projectKey, folder.id);
        return flowManagedFolder != null && !flowManagedFolder.getPredecessors().isEmpty();
    }

    private void clearProjectDatasets_NT(AuthCtx authCtx, TaggableObjectsDeletionService.DeletionResult deletion, boolean clearManagedDatasets) throws Exception {
        if (!deletion.anyMessage && deletion.delayedClearManagedDatasets != null) {
            for (Dataset dataset : deletion.delayedClearManagedDatasets) {
                TaggableObjectsDeletionService.DeletionOptions options = new TaggableObjectsDeletionService.DeletionOptions();
                options.dropMetastoreTable = clearManagedDatasets;
                options.dropData = clearManagedDatasets;
                TaggableObjectsDeletionService.PreDeletionContext preDeletionContext = new TaggableObjectsDeletionService.PreDeletionContext();
                preDeletionContext.inProjectDeletion = true;
                preDeletionContext.lastItemWithDQStatusFromThisProject = false;
                deletion.mergeFrom(this.datasetDeletionService.clearDatasetForDeletion_NT(authCtx, dataset, options, preDeletionContext));
            }
        }
    }

    private void clearLabelingTasks_NT(TaggableObjectsDeletionService.DeletionResult deletion) throws Exception {
        if (!deletion.anyMessage && deletion.delayedClearLabelingTasks != null) {
            for (LabelingTask labelingTask : deletion.delayedClearLabelingTasks) {
                this.labelingTasksCRUDService.clearLabelingTaskForDeletion(labelingTask);
                this.labelingTasksCRUDService.dropMetadataTable(labelingTask);
            }
        }
    }

    private void clearProjectManagedFolders_NT(AuthCtx authCtx, TaggableObjectsDeletionService.DeletionResult deletion, boolean clearOutputManagedFolders) throws Exception {
        if (clearOutputManagedFolders && !deletion.anyMessage && deletion.delayedClearOutputManagedFolders != null) {
            for (ManagedFolder folder : deletion.delayedClearOutputManagedFolders) {
                this.managedFoldersService.clear(authCtx, folder);
            }
        }
    }

    private void unloadAndDeleteProjectNotebooks(String projectKey) throws IOException {
        for (JupyterUtils.ActiveSession activeSession : this.jupyterService.listActiveSessions()) {
            if (!activeSession.projectKey.equals(projectKey)) continue;
            this.jupyterService.unloadSession(activeSession.sessionId);
        }
        try {
            File outputsDir = this.jupyterService.getNotebooksWithOutputsDir(projectKey);
            DKUFileUtils.forceDelete((File)outputsDir);
        }
        catch (IOException e) {
            logger.warn((Object)("Failed to delete notebook with output cells files" + projectKey), (Throwable)e);
        }
    }

    public InfoMessage.InfoMessages projectDeletionAttempt(AuthCtx authCtx, String projectKey, boolean clearManagedDatasets, boolean clearOutputManagedFolders, boolean clearJobAndScenarioLogs) throws Exception {
        return this.projectDeletionAttempt(authCtx, projectKey, clearManagedDatasets, clearOutputManagedFolders, clearJobAndScenarioLogs, false);
    }

    public InfoMessage.InfoMessages projectDeletionAttempt(AuthCtx authCtx, String projectKey, boolean clearManagedDatasets, boolean clearOutputManagedFolders, boolean clearJobAndScenarioLogs, boolean isAppTestInstance) throws Exception {
        TaggableObjectsDeletionService.DeletionResult dr;
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.ADMIN);
            dr = this.checkProjectDeletability(projectKey, true);
        }
        if (!dr.anyMessage) {
            this.clearProjectDatasets_NT(authCtx, dr, clearManagedDatasets);
            this.clearLabelingTasks_NT(dr);
            this.clearProjectManagedFolders_NT(authCtx, dr, clearOutputManagedFolders);
            this.unloadAndDeleteProjectNotebooks(projectKey);
            this.clearProjectRelatedFiles_NT(projectKey, clearJobAndScenarioLogs);
            this.scenarioReportsService.invalidateCachedReportsForProject(projectKey);
            try {
                this.requestsService.deleteRequestsForProject(projectKey);
            }
            catch (CodedSQLException e) {
                logger.warn((Object)("Failed to delete related access requests for project " + projectKey), (Throwable)e);
            }
            try {
                this.requestsService.rejectRequestsForTargetProject_NT(projectKey);
            }
            catch (CodedSQLException e) {
                logger.warn((Object)("Failed to close share requests targeting project " + projectKey), (Throwable)e);
            }
            try {
                this.discussionsService.deleteDiscussionsForProject(projectKey);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to delete discussions for project " + projectKey), (Throwable)e);
            }
            try {
                this.experimentTrackingService.cleanProject(projectKey);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to delete info on experiments for project " + projectKey), (Throwable)e);
            }
            try {
                this.jobsDatabaseService.clearDataQualityForProject(projectKey);
            }
            catch (CodedSQLException e) {
                logger.warn((Object)("Failed to clear Data Quality tables for project " + projectKey), (Throwable)e);
            }
            t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
            try {
                this.deleteProject(authCtx, projectKey);
                if (isAppTestInstance) {
                    t.commit("Delete the test project " + projectKey, 60000L, MinimalRWTransaction.TransactionGitCommitPolicy.IF_NOT_ALL_EXPLICIT);
                } else {
                    t.commit("Deleted project " + projectKey);
                }
            }
            finally {
                if (t != null) {
                    t.close();
                }
            }
            dr.success = true;
        }
        return dr;
    }

    public void deleteProject(AuthCtx authCtx, String projectKey) throws Exception {
        try (TaggableObjectChangedEvent.ProjectBeingDeletedContext ctx = new TaggableObjectChangedEvent.ProjectBeingDeletedContext(projectKey);){
            this.deleteProjectInternal(authCtx, projectKey);
        }
    }

    private void deleteProjectInternal(AuthCtx authCtx, String projectKey) throws Exception {
        HashSet relatedProjectsUpstream = new HashSet();
        HashSet<String> relatedProjects = new HashSet();
        try {
            SerializedProject serializedProject = this.getOrNullUnsafe(projectKey);
            relatedProjects = this.collectRelatedProjects(serializedProject, false, true);
            relatedProjectsUpstream = new HashSet(relatedProjects);
            this.collectRelatedProjects(serializedProject, true, false, relatedProjects);
        }
        catch (Exception e) {
            logger.warn((Object)("Failed to collect related projects for " + projectKey + ". Proceed with project deletion."), (Throwable)e);
        }
        for (Dataset dataset : this.datasetAccessService.list(projectKey)) {
            try {
                this.datasetDeletionService.performDeletion(dataset, null, authCtx, true, false);
                this.datasetSaveService.delete(projectKey, dataset.getName(), false);
            }
            catch (Exception e) {
                logger.warn((Object)("Failed to delete dataset '" + dataset.getName() + "'. Proceed with project deletion."), (Throwable)e);
            }
        }
        try {
            for (String upstreamProjectKey : relatedProjectsUpstream) {
                if (upstreamProjectKey.equals(projectKey)) continue;
                SerializedProject writableSp = this.getMandatory(upstreamProjectKey);
                writableSp.exposedObjects.removeAllExpositionToTarget(projectKey);
                this.save(writableSp, TaggableObjectChangedEvent.ProjectEditSubtype.EXPOSED_ONLY);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to unshare from upstream projects. Proceed with project deletion.", (Throwable)e);
        }
        WebAppBackendRestartThread.stopAll(projectKey, authCtx);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        t.deleteDirectory(this.projectDirectory(projectKey));
        this.webAppsService.deleteForProject(projectKey);
        this.codeStudioRuntimeManager.stopAll(t.getUser(), projectKey);
        this.continuousActivitiesManager.deleteForProject(projectKey);
        this.flowGraphService.invalidateCache();
        this.articlesCacheService.invalidateCacheForProject(projectKey);
        TaggableObjectChangedEvent event = new TaggableObjectChangedEvent(ITaggingService.TaggableType.PROJECT, projectKey, projectKey, t.getUser(), TaggableObjectChangedEvent.ActionType.PROJECT_DELETE);
        event.relatedProjectsBeforeAndAfter = relatedProjects;
        this.pubSub.publishAfterTransaction(event);
        AppsService.handleProjectDeleted(projectKey);
        this.projectFoldersService.deleteForProject_Uncheck(projectKey);
        this.workspacesService.notifyProjectDeleted(authCtx, projectKey);
    }

    public void clearProjectRelatedFiles_NT(String projectKey, boolean clearJobAndScenarioLogs) {
        try {
            if (ApplicationConfigurator.isAutomation()) {
                this.automationBundlesService.deleteAllForProject(projectKey);
            } else {
                this.designBundlesService.deleteAllForProject(projectKey);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to clear bundles", (Throwable)e);
        }
        this.reportsService.deleteForProject(projectKey);
        this.wikisService.deleteForProject(projectKey);
        try {
            File savedModelsFolder = ApplicationConfigurator.getFile((String[])new String[]{"saved_models", projectKey});
            if (savedModelsFolder.exists() && savedModelsFolder.isDirectory()) {
                DKUFileUtils.forceDelete((File)savedModelsFolder);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to clear saved models", (Throwable)e);
        }
        try {
            File promptStudiosFolder = ApplicationConfigurator.getFile((String[])new String[]{"prompt-studios", projectKey});
            if (promptStudiosFolder.isDirectory()) {
                DKUFileUtils.forceDelete((File)promptStudiosFolder);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to clear prompt studios", (Throwable)e);
        }
        try {
            File agentToolsFolder = ApplicationConfigurator.getFile((String[])new String[]{"agent-tools", projectKey});
            if (agentToolsFolder.isDirectory()) {
                DKUFileUtils.forceDelete((File)agentToolsFolder);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to clear agent tools", (Throwable)e);
        }
        try {
            File modelEvaluationStoresFolder = ApplicationConfigurator.getFile((String[])new String[]{"model_evaluation_stores", projectKey});
            if (modelEvaluationStoresFolder.exists() && modelEvaluationStoresFolder.isDirectory()) {
                DKUFileUtils.forceDelete((File)modelEvaluationStoresFolder);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to clear model evaluation stores", (Throwable)e);
        }
        try {
            File analysisDataFolder = ApplicationConfigurator.getFile((String[])new String[]{"analysis-data", projectKey});
            if (analysisDataFolder.exists() && analysisDataFolder.isDirectory()) {
                DKUFileUtils.forceDelete((File)analysisDataFolder);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to clear analysis data and models", (Throwable)e);
        }
        try {
            File projectLibFolder = ApplicationConfigurator.getFile((String[])new String[]{"lib", "projects", projectKey});
            if (projectLibFolder.exists() && projectLibFolder.isDirectory()) {
                DKUFileUtils.forceDelete((File)projectLibFolder);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to clear project libs", (Throwable)e);
        }
        try {
            File codeStudioLibFolder = ApplicationConfigurator.getFile((String[])new String[]{"lib", "code_studio", projectKey});
            if (codeStudioLibFolder.exists() && codeStudioLibFolder.isDirectory()) {
                DKUFileUtils.forceDelete((File)codeStudioLibFolder);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to clear Code Studio resources data", (Throwable)e);
        }
        try {
            File tmpFolder = ApplicationConfigurator.getFile((String)("tmp/" + projectKey));
            if (tmpFolder.exists() && tmpFolder.isDirectory()) {
                DKUFileUtils.forceDelete((File)tmpFolder);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to delete files in tmp/", (Throwable)e);
        }
        if (clearJobAndScenarioLogs) {
            try {
                File jobsLogFolder = FlowJobUtils.jobsFolder(projectKey);
                if (jobsLogFolder.exists() && jobsLogFolder.isDirectory()) {
                    DKUFileUtils.forceDelete((File)jobsLogFolder);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to clear job logs", (Throwable)e);
            }
            try {
                File scenariosLogFolder = ApplicationConfigurator.getFile((String[])new String[]{"scenarios", projectKey});
                if (scenariosLogFolder.exists() && scenariosLogFolder.isDirectory()) {
                    DKUFileUtils.forceDelete((File)scenariosLogFolder);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to clear scenario logs", (Throwable)e);
            }
        }
    }

    public ProjectActivitySummaryBuilder.ProjectActivitySummary updateAndGetProjectActivitySummary(String projectKey, int timeSpan, int nbSpans, boolean totalCommitsOnly) throws Exception {
        this.updateProjectAnalyis(projectKey);
        ProjectActivitySummaryBuilder builder = new ProjectActivitySummaryBuilder(projectKey, timeSpan, nbSpans);
        return builder.build(totalCommitsOnly);
    }

    public ProjectActivitySummaryBuilder.ProjectActivitySummary getProjectActivitySummary(String projectKey, int timeSpan, int nbSpans, boolean totalCommitsOnly) throws Exception {
        ProjectActivitySummaryBuilder builder = new ProjectActivitySummaryBuilder(projectKey, timeSpan, nbSpans);
        return builder.build(totalCommitsOnly);
    }

    private void updateProjectAnalyis(String projectKey) throws Exception {
        GitCommitsAnalyzer gca = new GitCommitsAnalyzer();
        SpringUtils.getInstance().autowire((Object)gca);
        gca.updateProjectAnalysis(projectKey);
    }

    public void removeStatusesFromAllProjects(List<GeneralSettingsDAO.ProjectStatus> statusesToDelete) throws Exception {
        if (statusesToDelete != null && !statusesToDelete.isEmpty()) {
            block0: for (SerializedProject proj : this.listAll()) {
                if (StringUtils.isBlank((String)proj.projectStatus)) continue;
                for (GeneralSettingsDAO.ProjectStatus status : statusesToDelete) {
                    if (!proj.projectStatus.equals(status.name)) continue;
                    proj.projectStatus = null;
                    this.save(proj, TaggableObjectChangedEvent.ProjectEditSubtype.SUMMARY_ONLY);
                    continue block0;
                }
            }
        }
    }

    public static ProjectCompleteMetadata getMetadata(SerializedProject sp) {
        ProjectCompleteMetadata pcm = new ProjectCompleteMetadata();
        pcm.checklists = sp.checklists;
        pcm.label = sp.name;
        pcm.description = sp.description;
        pcm.shortDesc = sp.shortDesc;
        pcm.tags = Sets.newHashSet((Iterable)sp.tags);
        pcm.custom = sp.customMeta;
        pcm.customFields = sp.customFields;
        return pcm;
    }

    public static void setMetadata(SerializedProject sp, ProjectCompleteMetadata pcm) {
        sp.checklists = pcm.checklists;
        sp.name = pcm.label;
        sp.description = pcm.description;
        sp.tags = Lists.newArrayList((Iterable)pcm.tags);
        sp.customMeta = pcm.custom;
        sp.customFields = pcm.customFields;
        sp.shortDesc = pcm.shortDesc;
    }

    @Override
    public RelFile projectDirectory(String projectKey) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)projectKey), (Object)"Project key is not specified");
        return new RelFile(new String[]{"projects", projectKey});
    }

    private RelFile getProjectFile(String projectKey) {
        return this.projectsDAO.getProjectFile(projectKey);
    }

    @UIModel
    public static class UIProject
    extends TaggableObjectsService.TaggableObject {
        public final String projectKey;
        public final String ownerLogin;
        @Nullable
        public List<UIProjectFolder> projectLocation;
        public final SerializedProject.ProjectType projectType;
        public final SerializedProject.ProjectAppType projectAppType;
        public boolean hasSetupSection;
        public final SerializedProject.PermissionsVersion permissionsVersion;
        public String generatingAppId;
        public String generatingAppVersion;
        public AppManifest appManifest;
        public final boolean tutorialProject;
        public final String tutorialId;
        public final boolean disableAutomaticTriggers;
        public final IProjectCommitModeService.ProjectCommitMode commitMode;
        public final String name;
        public final String projectStatus;
        public final String imgColor;
        public final Boolean showInitials;
        public boolean isProjectAdmin;
        public boolean canEditPermissions;
        public boolean canReadProjectContent;
        public boolean canWriteProjectContent;
        public boolean canModerateDashboards;
        public boolean canWriteDashboards;
        public boolean canManageDashboardAuthorizations;
        public boolean canManageExposedElements;
        public boolean canManageAdditionalDashboardUsers;
        public boolean canExportDatasetsData;
        public boolean canReadDashboards;
        public boolean canRunScenarios;
        public boolean canExecuteApp;
        public boolean canShareToWorkspaces;
        public boolean canPublishToDataCollections;
        public boolean canExportGitRepository;
        public boolean sharingRequestsEnabled;
        public String ownerDisplayName;
        public long objectImgHash;
        public boolean isProjectImg;
        public String defaultImgColor;
        public Integer imgPattern;
        public List<PublicUser> contributors = new ArrayList<PublicUser>();
        public ActiveBundleState activeBundleState;
        public ProbesSet metrics;
        public ChecksSet metricsChecks;
        public boolean sparkPipelinesEnabled;
        public boolean sqlPipelinesEnabled;
        public boolean zonesGraphForJobs;
        public boolean autogeneratedDocumentationEnabled;
        public boolean zonesManualPositioning;
        public List<TypeBadge> typeBadges = new ArrayList<TypeBadge>();

        public UIProject(SerializedProject sp) {
            this.projectKey = sp.projectKey;
            this.name = sp.name;
            this.ownerLogin = sp.owner;
            this.projectType = sp.projectType;
            this.permissionsVersion = sp.permissionsVersion;
            this.projectAppType = sp.projectAppType;
            this.hasSetupSection = sp.hasSetupSection;
            if (this.projectAppType == SerializedProject.ProjectAppType.APP_INSTANCE) {
                this.generatingAppId = sp.generatingAppId;
                this.generatingAppVersion = sp.generatingAppVersion;
            }
            this.projectStatus = sp.projectStatus;
            this.imgColor = sp.imgColor;
            this.imgPattern = sp.imgPattern;
            this.showInitials = sp.showInitials;
            this.description = sp.description;
            this.shortDesc = sp.shortDesc;
            this.tags = sp.tags;
            this.checklists = sp.checklists;
            this.sharingRequestsEnabled = ProjectsService.isObjectSharingRequestEnabled(sp, ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN());
            this.tutorialProject = sp.tutorialProject;
            this.tutorialId = sp.tutorialId;
            this.disableAutomaticTriggers = sp.settings.disableAutomaticTriggers;
            this.commitMode = sp.settings.gitCommitMode;
            this.metrics = sp.metrics;
            this.metricsChecks = sp.metricsChecks;
            this.sparkPipelinesEnabled = sp.settings.flowBuildSettings.mergeSparkPipelines;
            this.sqlPipelinesEnabled = sp.settings.flowBuildSettings.mergeSqlPipelines;
            this.zonesGraphForJobs = sp.settings.flowDisplaySettings.zonesGraphForJobs;
            this.customFields = sp.customFields;
            this.creationTag = sp.creationTag;
            this.versionTag = sp.versionTag == null ? sp.creationTag : sp.versionTag;
            this.autogeneratedDocumentationEnabled = sp.settings.autogeneratedDocumentationEnabled;
            this.zonesManualPositioning = sp.settings.flowDisplaySettings.zonesManualPositioning;
        }

        public UIProject(UIProject ps2) {
            this.projectKey = ps2.projectKey;
            this.ownerLogin = ps2.ownerLogin;
            this.ownerDisplayName = ps2.ownerDisplayName;
            this.projectLocation = ps2.projectLocation;
            this.isProjectAdmin = ps2.isProjectAdmin;
            this.canReadProjectContent = ps2.canReadProjectContent;
            this.canWriteProjectContent = ps2.canWriteProjectContent;
            this.canModerateDashboards = ps2.canModerateDashboards;
            this.canManageDashboardAuthorizations = ps2.canManageDashboardAuthorizations;
            this.canManageExposedElements = ps2.canManageExposedElements;
            this.canWriteDashboards = ps2.canWriteDashboards;
            this.canExportDatasetsData = ps2.canExportDatasetsData;
            this.canReadDashboards = ps2.canReadDashboards;
            this.canRunScenarios = ps2.canRunScenarios;
            this.canExecuteApp = ps2.canExecuteApp;
            this.canExportGitRepository = ps2.canExportGitRepository;
            this.projectType = ps2.projectType;
            this.permissionsVersion = ps2.permissionsVersion;
            this.projectAppType = ps2.projectAppType;
            this.generatingAppId = ps2.generatingAppId;
            this.generatingAppVersion = ps2.generatingAppVersion;
            this.appManifest = ps2.appManifest;
            this.activeBundleState = ps2.activeBundleState;
            this.tutorialProject = ps2.tutorialProject;
            this.tutorialId = ps2.tutorialId;
            this.objectImgHash = ps2.objectImgHash;
            this.contributors = ps2.contributors;
            this.name = ps2.name;
            this.description = ps2.description;
            this.shortDesc = ps2.shortDesc;
            this.checklists = ps2.checklists;
            this.tags = ps2.tags;
            this.projectStatus = ps2.projectStatus;
            this.imgColor = ps2.imgColor;
            this.imgPattern = ps2.imgPattern;
            this.showInitials = ps2.showInitials;
            this.commitMode = ps2.commitMode;
            this.disableAutomaticTriggers = ps2.disableAutomaticTriggers;
            this.metrics = ps2.metrics;
            this.metricsChecks = ps2.metricsChecks;
            this.customFields = ps2.customFields;
            this.creationTag = ps2.creationTag;
            this.versionTag = ps2.versionTag;
            this.autogeneratedDocumentationEnabled = ps2.autogeneratedDocumentationEnabled;
            this.zonesManualPositioning = ps2.zonesManualPositioning;
        }

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.PROJECT;
        }

        @Override
        public String getProjectKey() {
            return this.projectKey;
        }

        @Override
        public String getId() {
            return this.projectKey;
        }

        @Override
        public String getDisplayName() {
            return this.name;
        }

        @Override
        public void setProjectKey(String p) {
            throw new Error("cannot set project key");
        }

        @Override
        public void setId(String id) {
            throw new Error("Cannot set id");
        }
    }

    @UIModel
    public static class HomepageProjectItem {
        public boolean onlyLimitedVisibility;
        public boolean canRequestAccess;
        @Nullable
        public ScenarioReportsService.ScenarioDays scenariosDays;
        public final String projectKey;
        final String ownerLogin;
        final String ownerDisplayName;
        final SerializedProject.ProjectType projectType;
        final SerializedProject.ProjectAppType projectAppType;
        boolean isAppAsRecipe = false;
        final long objectImgHash;
        final List<PublicUser> contributors;
        final String name;
        final String description;
        final String shortDesc;
        final List<String> tags;
        @Nullable
        final String projectStatus;
        final String imgColor;
        final Integer imgPattern;
        final Boolean showInitials;
        final ActiveBundleState activeBundleState;
        final boolean isAdmin;
        final boolean canWriteProjectContent;
        final boolean canReadProjectContent;
        final boolean tutorialProject;
        @Nullable
        TaggingService.TagsFile tagsFile;
        @Nullable
        ProjectObjectsCounts projectSummaryStatus;
        @Nullable
        IDSSUsageStatsInternalDB.TimeSeries totalCommits;
        @Nullable
        Long lastCommitTime;
        @Nullable
        Long lastCommitTimeForUser;
        @Nullable
        GitInfo gitInfo;

        public HomepageProjectItem(UIProject ps2) {
            this.projectKey = ps2.projectKey;
            this.ownerLogin = ps2.ownerLogin;
            this.ownerDisplayName = ps2.ownerDisplayName;
            this.projectType = ps2.projectType;
            this.projectAppType = ps2.projectAppType;
            this.objectImgHash = ps2.objectImgHash;
            this.contributors = ps2.contributors;
            this.name = ps2.name;
            this.description = ps2.description;
            this.shortDesc = ps2.shortDesc;
            this.tags = ps2.tags;
            this.projectStatus = ps2.projectStatus;
            this.imgColor = ps2.imgColor;
            this.imgPattern = ps2.imgPattern;
            this.showInitials = ps2.showInitials;
            this.activeBundleState = ps2.activeBundleState;
            this.isAdmin = ps2.isProjectAdmin;
            this.canWriteProjectContent = ps2.canWriteProjectContent;
            this.canReadProjectContent = ps2.canReadProjectContent;
            this.tutorialProject = ps2.tutorialProject;
        }
    }

    public static class ProjectObjectsCounts {
        public int importedDatasets;
        public int managedDatasets;
        public int datasets;
        public int managedFolders;
        public int analyses;
        public int flowModels;
        public int flowEvaluationStores;
        public int flowStreamingEndpoints;
        public int recipes;
        public int flowLabelingTasks;
        public int sqlNotebooks;
        public int searchNotebooks;
        public int jupyterNotebooks;
        public int activeScenarios;
        public int totalScenarios;
        public int dashboards;
        public int totalTasks;
        public int checkedTasks;
        public int wikiArticles;
        public int codeStudios;
        public int flowZones;
        public int retrievableKnowledge;
        public int mlSavedModels;
        public int llmSavedModels;
        public int llmRagModels;
        public int llmFineTunedModels;
        public int agents;
    }

    public static class ProjectImageInfo {
        public long objectImgHash;
        public boolean isProjectImg;
        public String defaultImgColor;
        public String imgColor;
        public Integer imgPattern;
        public Boolean showInitials;
    }

    public static class VisibleProjectSummary {
        public final String projectKey;
        public final String ownerLogin;
        public final String name;
        public final String projectStatus;
        public final List<String> tags;
        @Nullable
        public final String shortDesc;
        public final String imgColor;
        public final Boolean showInitials;
        @Nullable
        public final String ownerDisplayName;
        public long objectImgHash;
        public boolean isProjectImg;
        @Nullable
        public Integer imgPattern;
        @Nullable
        public String defaultImgColor;

        public VisibleProjectSummary(SerializedProject sp, @Nullable ProjectImageInfo projectImageInfo, @Nullable String displayName) {
            this.projectKey = sp.projectKey;
            this.name = sp.name;
            this.ownerLogin = sp.owner;
            this.tags = sp.tags;
            this.shortDesc = sp.shortDesc;
            this.projectStatus = sp.projectStatus;
            this.imgColor = sp.imgColor;
            this.showInitials = sp.showInitials;
            this.imgPattern = sp.imgPattern;
            this.ownerDisplayName = displayName;
            if (projectImageInfo != null) {
                this.objectImgHash = projectImageInfo.objectImgHash;
                this.isProjectImg = projectImageInfo.isProjectImg;
                this.defaultImgColor = projectImageInfo.defaultImgColor;
                this.imgPattern = projectImageInfo.imgPattern;
            }
        }
    }

    public static enum ObjectVisibility {
        NONE,
        READ,
        DISCOVER;

    }

    public static class ProjectCompleteMetadata
    extends ObjectCompleteMetadata {
        String shortDesc;
    }

    @UIModel
    public static class UIProjectFolder {
        public String id;
        public String name;
        public String parentId;

        public static UIProjectFolder fromFolder(ProjectFolder folder) {
            UIProjectFolder result = new UIProjectFolder();
            result.id = folder.id;
            result.name = folder.name;
            result.parentId = folder.parentId;
            return result;
        }
    }

    public static class ProjectSummaryStatus {
        public int importedDatasets;
        public int managedDatasets;
        public int datasets;
        public int flowModels;
        public int flowStreamingEndpoints;
        public int recipes;
        public int analyses;
        public int sqlNotebooks;
        public int searchNotebooks;
        public int jupyterNotebooks;
        public int dashboards;
        public int activeScenarios;
        public int totalScenarios;
        public int totalTasks;
        public int checkedTasks;
    }

    public static class AnyLocWithType
    extends DatasetLocUtils.DatasetLoc {
        public final ITaggingService.TaggableType type;

        public AnyLocWithType(String projectKey, String name, ITaggingService.TaggableType type) {
            super(projectKey, name);
            this.type = type;
        }
    }
}

