/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.filter;

import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.j2ts.annotations.UIModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@UIModel
public class FilterRequest {
    public List<FilterElement> elements = new ArrayList<FilterElement>();

    public static class FilterElement {
        public String column;
        public FilterType type;
        public boolean active;
        public Boolean includeEmptyValues;
        public boolean isAGlobalFilter;
        public AxisDef.Type columnType;
        public String[] selectedValues;
        public String[] excludedValues;
        public ChartFilter.DateFilterType dateFilterType;
        public ChartFilter.DateFilterPart dateFilterPart;
        public ChartFilter.DateRelativeOption dateFilterOption;
        public Double minValue;
        public Double maxValue;
        public String timezone;
        public boolean explicitExclude;
        public List<ChartFilter.ExplicitCondition> explicitConditions;
        Map<String, String> params = new HashMap<String, String>();

        String getParam(String key, String defaultValue) {
            String o = this.params.get(key);
            if (o == null) {
                return defaultValue;
            }
            return o;
        }

        boolean getBooleanParam(String key, boolean defaultValue) {
            String o = this.params.get(key);
            if (o == null) {
                return defaultValue;
            }
            return o.startsWith("y") || o.equalsIgnoreCase("true");
        }

        boolean isEffective() {
            switch (this.type) {
                case ALPHANUM: 
                case ALPHANUM_FACET: {
                    return this.isAlphanumericalFilterEffective();
                }
                case NUMERICAL_FACET: {
                    return this.active && (this.minValue != null || this.maxValue != null || this.includeEmptyValues != null && this.includeEmptyValues == false);
                }
                case DATE_FACET: {
                    if (this.dateFilterType == ChartFilter.DateFilterType.RANGE) {
                        if (!this.active) {
                            return false;
                        }
                        if (this.includeEmptyValues != null && !this.includeEmptyValues.booleanValue()) {
                            return true;
                        }
                        return this.minValue != null || this.maxValue != null || this.timezone != null;
                    }
                    if (this.dateFilterType == ChartFilter.DateFilterType.RELATIVE) {
                        if (!this.active) {
                            return false;
                        }
                        boolean areRelativeOptionsEffective = this.dateFilterOption != null && (this.dateFilterOption.last != 0 || this.dateFilterOption.next != 0 || this.dateFilterOption.containsCurrentDatePart);
                        return areRelativeOptionsEffective || this.includeEmptyValues == false;
                    }
                    return this.isAlphanumericalFilterEffective();
                }
                case GLOBAL_SEARCH: {
                    return this.selectedValues != null && this.selectedValues.length == 1 && this.selectedValues[0] != null && this.selectedValues[0].length() > 0;
                }
                case BOUNDING_BOX_FACET: {
                    return this.active && this.selectedValues != null && this.selectedValues.length > 0;
                }
                case EXPLICIT_FACET: {
                    return this.active && this.explicitExclude && !this.explicitConditions.isEmpty();
                }
            }
            return false;
        }

        private boolean isAlphanumericalFilterEffective() {
            if (!this.active) {
                return false;
            }
            if (this.selectedValues != null) {
                return this.selectedValues.length > 0 || this.isAGlobalFilter;
            }
            return this.excludedValues != null && this.excludedValues.length > 0;
        }
    }

    public static enum FilterType {
        ALPHANUM,
        ALPHANUM_FACET,
        NUMERICAL_FACET,
        BOUNDING_BOX_FACET,
        NAMED_ENTITY_FACET,
        DATE_FACET,
        VALIDITY,
        GLOBAL_SEARCH,
        EXPLICIT_FACET;

    }
}

