/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.expr;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.expressions.Expression;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.EvictingQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class PreviousRowsBuffer {
    public static final int DEFAULT_BUFFER_MAX_SIZE = 1000;
    private final Set<String> columnsToBuffer;
    private final Queue<Map<String, Object>> previousRowsComputedValues;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.shaker.previousRowsBuffer");

    public PreviousRowsBuffer(Expression expr) {
        this(Collections.singletonList(expr));
    }

    public PreviousRowsBuffer(Expression expr, int maxSize) {
        this(Collections.singletonList(expr), maxSize);
    }

    public PreviousRowsBuffer(List<Expression> expressions) {
        this(expressions, DKUApp.getProperty((String)"dku.shaker.previousRowsBufferMaxSize", (int)1000));
    }

    public PreviousRowsBuffer(List<Expression> expressions, int maxSize) {
        int requestedSize;
        HashMap previousRowsRequired = new HashMap();
        for (Expression expr : expressions) {
            Map<String, Integer> previousRowsRequiredForExpr = expr.getNumberOfPreviousRowsRequiredByColumns();
            previousRowsRequiredForExpr.forEach((key, value) -> previousRowsRequired.merge(key, value, Math::max));
        }
        int n = requestedSize = !previousRowsRequired.isEmpty() ? previousRowsRequired.values().stream().mapToInt(value -> value == Integer.MAX_VALUE ? maxSize : value).max().orElse(0) : 0;
        if (requestedSize > 0) {
            if (requestedSize > maxSize) {
                throw new IllegalArgumentException(String.format("Maximum number of previous rows cannot be greater than %d", maxSize));
            }
            this.previousRowsComputedValues = EvictingQueue.create((int)requestedSize);
            this.columnsToBuffer = this.getColumnsToBuffer(previousRowsRequired.keySet());
            logger.debug((Object)("Using row buffer of size : " + requestedSize));
        } else {
            this.previousRowsComputedValues = null;
            this.columnsToBuffer = null;
        }
    }

    public boolean needBuffering() {
        return this.previousRowsComputedValues != null;
    }

    public List<Map<String, Object>> getPreviousRows() {
        return this.previousRowsComputedValues == null ? null : new ArrayList<Map<String, Object>>(this.previousRowsComputedValues);
    }

    public void addRow(Row tableRow, ColumnFactory cf) {
        this.addRow(tableRow, cf, null, null);
    }

    public void addRow(Row tableRow, ColumnFactory cf, String outputColumn, Object out) {
        if (this.previousRowsComputedValues != null) {
            HashMap<String, String> rowValues = new HashMap<String, String>();
            if (this.columnsToBuffer != null) {
                for (String columnName : this.columnsToBuffer) {
                    Column column = cf.getColumn(columnName);
                    if (column == null) continue;
                    rowValues.put(column.getName(), tableRow.get(column));
                }
            } else {
                for (Column column : cf.columns()) {
                    rowValues.put(column.getName(), tableRow.get(column));
                }
            }
            if (outputColumn != null) {
                rowValues.put(outputColumn, out == null ? null : out.toString());
            }
            this.previousRowsComputedValues.add(rowValues);
        }
    }

    private Set<String> getColumnsToBuffer(Set<String> columns) {
        return columns == null || columns.contains("") ? null : columns;
    }
}

