/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.server;

import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.util.ParamDesc;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class ProcessorDesc {
    public String type;
    public String enDescription;
    public String help;
    public String tooltip;
    public String hiddenDescription;
    public String docPage;
    public boolean canUseGenericForm;
    public boolean displayInLibrary = true;
    public boolean disabledByAdmin;
    public boolean deprecated;
    public String replacementDocLink;
    public String replacementName;
    public String filterAndFlagMode;
    public String plugin;
    public List<ParamDesc> params = new ArrayList<ParamDesc>();
    public Object defaultParams;
    public List<ProcessorTag> tags = new ArrayList<ProcessorTag>();

    public ProcessorDesc(String type, String enDescription, boolean canUseGenericForm) {
        this.type = type;
        this.enDescription = enDescription;
        this.canUseGenericForm = canUseGenericForm;
    }

    public ProcessorDesc(String type, String enDescription, String tooltip, boolean canUseGenericForm) {
        this.type = type;
        this.enDescription = enDescription;
        this.tooltip = tooltip;
        this.canUseGenericForm = canUseGenericForm;
    }

    public static ProcessorDesc withGenericForm(String type, String description) {
        return new ProcessorDesc(type, description, true);
    }

    public static ProcessorDesc withCustomForm(String type, String description) {
        return new ProcessorDesc(type, description, false);
    }

    public ProcessorDesc withToolTip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public ProcessorDesc withMandSParam(String name, String enDesc) {
        return this.withParam(name, "generic", true, true, enDesc);
    }

    public ProcessorDesc withMNESParam(String name, String enDesc) {
        return this.withParam(name, "generic", true, false, enDesc);
    }

    public ProcessorDesc withColParam(String name, String enDesc) {
        return this.withParam(name, "column", false, true, enDesc);
    }

    public ProcessorDesc withMNEColParam(String name, String enDesc) {
        return this.withParam(name, "column", true, false, enDesc);
    }

    public ProcessorDesc withBool(String name, String enDesc) {
        ParamDesc pp = new ParamDesc(name, "boolean").withMandatory(false).withCanBeEmpty(true).withLabel(enDesc).withDefaultValue(false);
        return this.withParam(pp);
    }

    public ProcessorDesc withBool(String name, String enDesc, String trueLabel, String falseLabel) {
        ParamDesc pp = new ParamDesc(name, "boolean").withMandatory(false).withCanBeEmpty(true).withLabel(enDesc).withDefaultValue(false);
        pp.choices = Lists.newArrayList((Object[])new String[]{falseLabel, trueLabel});
        return this.withParam(pp);
    }

    public ProcessorDesc withBool(String name, String enDesc, String tooltip) {
        ParamDesc pp = new ParamDesc(name, "boolean").withMandatory(false).withCanBeEmpty(true).withLabel(enDesc).withTooltip(tooltip).withDefaultValue(false);
        return this.withParam(pp);
    }

    public ProcessorDesc withBoolDefaultTrue(String name, String enDesc, String tooltip) {
        ParamDesc pp = new ParamDesc(name, "boolean").withMandatory(false).withCanBeEmpty(true).withLabel(enDesc).withTooltip(tooltip).withDefaultValue(true);
        return this.withParam(pp);
    }

    public ProcessorDesc withBoolDefaultTrue(String name, String enDesc) {
        ParamDesc pp = new ParamDesc(name, "boolean").withMandatory(false).withCanBeEmpty(true).withLabel(enDesc).withDefaultValue(true);
        return this.withParam(pp);
    }

    public ProcessorDesc withUnboundedMandInt(String name, String enDesc) {
        this.params.add(new ParamDesc(name, "int").withMandatory(true).withCanBeEmpty(false).withLabel(enDesc).withDefaultValue(0));
        return this;
    }

    public ProcessorDesc withBoundedMandInt(String name, String enDesc, int min, int max) {
        ParamDesc pp = new ParamDesc(name, "int").withMandatory(true).withCanBeEmpty(false).withLabel(enDesc);
        pp.minI = min;
        pp.maxI = max;
        pp.withDefaultValue(min);
        this.params.add(pp);
        return this;
    }

    public ProcessorDesc withUnboundedMandDouble(String name, String enDesc) {
        this.params.add(new ParamDesc(name, "double").withMandatory(true).withCanBeEmpty(false).withLabel(enDesc).withDefaultValue(0));
        return this;
    }

    public ProcessorDesc withBoundedMandDouble(String name, String enDesc, double min, double max) {
        ParamDesc pp = new ParamDesc(name, "double").withMandatory(true).withCanBeEmpty(false).withLabel(enDesc);
        pp.minD = min;
        pp.maxD = max;
        pp.withDefaultValue(min);
        this.params.add(pp);
        return this;
    }

    public ProcessorDesc withParam(String name, String type, boolean mandatory, boolean canBeEmpty, String enDesc) {
        ParamDesc pp = new ParamDesc(name, type).withMandatory(mandatory).withCanBeEmpty(canBeEmpty).withLabel(enDesc);
        this.params.add(pp);
        return this;
    }

    public ProcessorDesc withParam(ParamDesc pd) {
        this.params.add(pd);
        return this;
    }

    public ProcessorDesc withParam(String name, String type, boolean mandatory, boolean canBeEmpty, String enDesc, String placeholder) {
        ParamDesc pp = new ParamDesc(name, type).withMandatory(mandatory).withCanBeEmpty(canBeEmpty).withLabel(enDesc).withPlaceholder(placeholder);
        this.params.add(pp);
        return this;
    }

    public ProcessorDesc withHiddenDescription(String desc) {
        this.hiddenDescription = desc;
        return this;
    }

    public ProcessorDesc doNotDisplayInLibrary() {
        this.displayInLibrary = false;
        return this;
    }

    public ProcessorDesc deprecate() {
        this.deprecated = true;
        return this;
    }

    public ProcessorDesc withReplacementDocLink(String docLink) {
        this.replacementDocLink = docLink;
        return this;
    }

    public ProcessorDesc withReplacementName(String name) {
        this.replacementName = name;
        return this;
    }

    public ProcessorDesc withFilterAndFlagMode(String mode) {
        this.filterAndFlagMode = mode;
        return this;
    }
}

