/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.spark.sparksql;

import com.dataiku.common.server.APIError;
import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.cluster.HadoopSettings;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.datasets.SamplingParam;
import com.dataiku.dip.io.ResponderKernelLink;
import com.dataiku.dip.remoterun.RemoteRunsRegistry;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.spark.SparkJobExecEnv;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.sparksql.DkuSparkAddFilesResponse;
import com.dataiku.dip.spark.sparksql.DkuSparkSQLExecutionResponse;
import com.dataiku.dip.spark.sparksql.RemoteSparkSQLHandler;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class RemotedSparkSQLHandler
implements RemoteSparkSQLHandler {
    private final ResponderKernelLink serverSocket;
    protected final SparkJobHelper.SparkJobContext context;
    protected final String projectKey;
    protected boolean isClosed = false;
    private static Logger logger = Logger.getLogger((String)"dip.livy.remote.sparksql");

    @Override
    public String registerDataset(String database, String datasetFullName, String tableName, SparkJobExecEnv datasetEnv, String partitionId) throws SQLException {
        try {
            this.ensureConnected();
            RegisterDatasetCommand cmd = new RegisterDatasetCommand(database, datasetFullName, tableName, datasetEnv, partitionId);
            return (String)this.serverSocket.execute((Object)cmd, String.class);
        }
        catch (Exception e) {
            this.checkError();
            throw new SQLException("Failed to run livy Job", e);
        }
    }

    public RemotedSparkSQLHandler(ResponderKernelLink serverSocket, SparkJobHelper.SparkJobContext context, String projectKey) throws Exception {
        this.serverSocket = serverSocket;
        this.context = context;
        this.projectKey = projectKey;
        this.isClosed = false;
    }

    protected abstract void closeRemote();

    @Override
    public void close() throws SQLException {
        if (!this.isClosed) {
            this.isClosed = true;
            try {
                logger.info((Object)"Stopping context");
                this.executeStop();
            }
            catch (Exception e) {
                logger.warn((Object)"Error while stopping spark context on remote driver", (Throwable)e);
            }
            logger.info((Object)"Stopping remote");
            this.closeRemote();
            logger.info((Object)"Closing socket");
            try {
                this.serverSocket.close();
            }
            catch (Exception e) {
                logger.warn((Object)"Error while shutting down connection to remote driver", (Throwable)e);
            }
            logger.info((Object)"Cleaning up resources");
            try {
                this.context.close();
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to close yarn context", (Throwable)e);
            }
        }
    }

    private void executeStop() throws SQLException {
        try {
            this.ensureConnected();
            StopContextCommand req = new StopContextCommand();
            DkuSparkSQLStopResponse resp = (DkuSparkSQLStopResponse)this.serverSocket.execute((Object)req, DkuSparkSQLStopResponse.class);
            if (resp.error != null) {
                throw new SQLException(StringUtils.defaultIfBlank((String)resp.error.message, (String)"Failed to stop remote sql"), new APIError.SerializedErrorException(resp.error));
            }
        }
        catch (Exception e) {
            this.checkError();
            throw new SQLException("Failed to run livy Job", e);
        }
    }

    private void checkError() throws SQLException {
        try {
            File errorFile = new File(this.context.getLocalRunDir(), "error.json");
            if (errorFile.exists()) {
                SerializedError err = (SerializedError)JSON.parseFile((File)errorFile, SerializedError.class);
                throw new SerializedErrorSQLException(err);
            }
        }
        catch (SerializedErrorSQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Failed to retrieve spark remote error");
        }
    }

    private void ensureConnected() throws IOException {
        if (!this.serverSocket.isConnected()) {
            this.serverSocket.waitForConnection(60000);
            logger.info((Object)"Remote Spark driver connected");
        }
    }

    @Override
    public String ping() throws SQLException {
        try {
            this.ensureConnected();
            PingCommand cmd = new PingCommand();
            return (String)this.serverSocket.execute((Object)cmd, String.class);
        }
        catch (Exception e) {
            this.checkError();
            throw new SQLException("Failed to run livy Job", e);
        }
    }

    @Override
    public String registerDataset(String database, String datasetFullName, String tableName, SparkJobExecEnv datasetEnv) throws SQLException {
        return this.registerDataset(database, datasetFullName, tableName, datasetEnv, null);
    }

    @Override
    public DkuSparkSQLExecutionResponse executeStatement(String database, int fetchSize, String sql) throws SQLException {
        try {
            this.ensureConnected();
            ExecuteSQLCommand cmd = new ExecuteSQLCommand(database, fetchSize, sql);
            return (DkuSparkSQLExecutionResponse)this.serverSocket.execute((Object)cmd, DkuSparkSQLExecutionResponse.class);
        }
        catch (Exception e) {
            this.checkError();
            throw new SQLException("Failed to run livy Job", e);
        }
    }

    @Override
    public DkuSparkSQLExecutionResponse executePreparedStatement(String database, String sql) throws SQLException {
        try {
            this.ensureConnected();
            PrepareSQLCommand cmd = new PrepareSQLCommand(database, sql);
            return (DkuSparkSQLExecutionResponse)this.serverSocket.execute((Object)cmd, DkuSparkSQLExecutionResponse.class);
        }
        catch (Exception e) {
            this.checkError();
            throw new SQLException("Failed to run livy Job", e);
        }
    }

    @Override
    public DkuSparkSQLExecutionResponse readDataset(AuthCtx authCtx, HadoopSettings hadoopSettings, SerializedDataset dataset, SamplingParam sampling, List<String> partitions, List<String> columnNames, String filterExpression) throws SQLException {
        try {
            this.ensureConnected();
            SparkJobExecEnv datasetEnv = new SparkJobExecEnv();
            datasetEnv.fillInBackendOrJEK(Lists.newArrayList((Object[])new String[]{dataset.getProjectKey()}), authCtx, null, hadoopSettings, false);
            ReadDatasetCommand cmd = new ReadDatasetCommand(dataset, datasetEnv, sampling, partitions, columnNames, filterExpression);
            return (DkuSparkSQLExecutionResponse)this.serverSocket.execute((Object)cmd, DkuSparkSQLExecutionResponse.class);
        }
        catch (Exception e) {
            this.checkError();
            throw new SQLException("Failed to read dataset over remote-Spark", e);
        }
    }

    @Override
    public DkuSparkSQLExecutionResponse nextBatch(int fetchSize, String sql) throws SQLException {
        try {
            this.ensureConnected();
            NextBatchCommand cmd = new NextBatchCommand(fetchSize, sql);
            return (DkuSparkSQLExecutionResponse)this.serverSocket.execute((Object)cmd, DkuSparkSQLExecutionResponse.class);
        }
        catch (Exception e) {
            this.checkError();
            throw new SQLException("Failed to run livy Job", e);
        }
    }

    @Override
    public DkuSparkSQLExecutionResponse executeStatementAndScript(String database, int fetchSize, String sql, List<ScriptStep> scriptSteps, Schema scriptOutputSchema, String reportLocation, Map<String, String> resourceMapping) throws SQLException {
        try {
            this.ensureConnected();
            ExecuteSQLAndScriptCommand cmd = new ExecuteSQLAndScriptCommand(database, fetchSize, sql, scriptSteps, scriptOutputSchema, reportLocation, resourceMapping);
            return (DkuSparkSQLExecutionResponse)this.serverSocket.execute((Object)cmd, DkuSparkSQLExecutionResponse.class);
        }
        catch (Exception e) {
            this.checkError();
            throw new SQLException("Failed to run livy Job", e);
        }
    }

    @Override
    public DkuSparkAddFilesResponse addFiles(Map<String, String> resourceMapping) throws SQLException {
        HashSet foldersHoldingResources = Sets.newHashSet();
        for (String p : resourceMapping.values()) {
            File f = new File(p);
            foldersHoldingResources.add(f.getParentFile().getAbsolutePath());
        }
        String executionId = "add-files-" + SecretKeyGenerator.generate((int)8);
        String tmpPath = ApplicationConfigurator.getFile((String)"tmp").getAbsolutePath();
        ArrayList readablePaths = Lists.newArrayList((Iterable)foldersHoldingResources);
        RemoteRunsRegistry.add(executionId, this.context.getAuthCtx(), this.projectKey, tmpPath, tmpPath, RemoteRunsRegistry.ExecutionType.SPARK, null, null, readablePaths, readablePaths, Collections.emptyList());
        try {
            this.ensureConnected();
            AddFilesCommand cmd = new AddFilesCommand(executionId, resourceMapping);
            DkuSparkAddFilesResponse dkuSparkAddFilesResponse = (DkuSparkAddFilesResponse)this.serverSocket.execute((Object)cmd, DkuSparkAddFilesResponse.class);
            return dkuSparkAddFilesResponse;
        }
        catch (Exception e) {
            this.checkError();
            throw new SQLException("Failed to run livy Job", e);
        }
        finally {
            RemoteRunsRegistry.remove(executionId);
        }
    }

    @Override
    public void cancel() throws SQLException {
        if (this.serverSocket.isConnected()) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                throw new SQLException("Failed to interrupt connection to Spark driver", e);
            }
        }
    }

    public static class RegisterDatasetCommand
    extends Command {
        public final String database;
        public final String datasetFullName;
        public final String tableName;
        public final SparkJobExecEnv datasetEnv;
        public List<String> partitions;

        public RegisterDatasetCommand(String database, String datasetFullName, String tableName, SparkJobExecEnv datasetEnv, String partitionId) {
            super("registerDataset");
            this.database = database;
            this.datasetFullName = datasetFullName;
            this.tableName = tableName;
            this.datasetEnv = datasetEnv;
            if (partitionId != null) {
                this.partitions = Collections.singletonList(partitionId);
            }
        }

        public RegisterDatasetCommand(String database, String datasetFullName, String tableName, SparkJobExecEnv datasetEnv) {
            this(database, datasetFullName, tableName, datasetEnv, null);
        }
    }

    public static class StopContextCommand
    extends Command {
        public StopContextCommand() {
            super("stopContext");
        }
    }

    public static class DkuSparkSQLStopResponse {
        public SerializedError error = null;
    }

    public static class SerializedErrorSQLException
    extends SQLException {
        private static final long serialVersionUID = 1L;
        public SerializedError error;

        public SerializedErrorSQLException(SerializedError error) {
            super(error.detailedMessage != null ? error.detailedMessage : error.message);
            this.error = error;
        }
    }

    public static class PingCommand
    extends Command {
        public PingCommand() {
            super("ping");
        }
    }

    public static class ExecuteSQLCommand
    extends Command {
        public final String database;
        public final int fetchSize;
        public final String sql;

        public ExecuteSQLCommand(String database, int fetchSize, String sql) {
            super("executeSQL");
            this.database = database;
            this.fetchSize = fetchSize;
            this.sql = sql;
        }
    }

    public static class PrepareSQLCommand
    extends Command {
        public final String database;
        public final String sql;

        public PrepareSQLCommand(String database, String sql) {
            super("prepareSQL");
            this.database = database;
            this.sql = sql;
        }
    }

    public static class ReadDatasetCommand
    extends Command {
        public final SerializedDataset dataset;
        public final SparkJobExecEnv datasetEnv;
        public final SamplingParam sampling;
        public final List<String> partitions;
        public final List<String> columnNames;
        public final String filterExpression;

        public ReadDatasetCommand(SerializedDataset dataset, SparkJobExecEnv datasetEnv, SamplingParam sampling, List<String> partitions, List<String> columnNames, String filterExpression) {
            super("readDataset");
            this.dataset = dataset;
            this.datasetEnv = datasetEnv;
            this.sampling = sampling;
            this.partitions = partitions;
            this.columnNames = columnNames;
            this.filterExpression = filterExpression;
        }
    }

    public static class NextBatchCommand
    extends Command {
        public final int fetchSize;
        public final String sql;

        public NextBatchCommand(int fetchSize, String sql) {
            super("nextBatch");
            this.fetchSize = fetchSize;
            this.sql = sql;
        }
    }

    public static class ExecuteSQLAndScriptCommand
    extends Command {
        public final String database;
        public final int fetchSize;
        public final String sql;
        public final Schema scriptOutputSchema;
        public final List<ScriptStep> scriptSteps;
        public final String reportLocation;
        public final Map<String, String> resourceMapping;

        public ExecuteSQLAndScriptCommand(String database, int fetchSize, String sql, List<ScriptStep> scriptSteps, Schema scriptOutputSchema, String reportLocation, Map<String, String> resourceMapping) {
            super("executeSQLAndScript");
            this.database = database;
            this.fetchSize = fetchSize;
            this.sql = sql;
            this.scriptSteps = scriptSteps;
            this.scriptOutputSchema = scriptOutputSchema;
            this.reportLocation = reportLocation;
            this.resourceMapping = resourceMapping;
        }
    }

    public static class AddFilesCommand
    extends Command {
        public final Map<String, String> resourceMapping;
        public final String executionId;

        public AddFilesCommand(String executionId, Map<String, String> resourceMapping) {
            super("addFiles");
            this.executionId = executionId;
            this.resourceMapping = resourceMapping;
        }
    }

    public static abstract class Command {
        public final String type;

        Command(String type) {
            this.type = type;
        }
    }
}

