/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.streaming.endpoints;

import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimpleConsumer;
import com.dataiku.dip.streaming.endpoints.StreamingEndpointSimplePusher;
import com.dataiku.dip.streaming.endpoints.StringBasedFormats;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dss.shadelib.org.eclipse.jetty.io.EofException;
import com.google.common.collect.Lists;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class KernelStreamingEndpointService {
    private static Logger logger = Logger.getLogger((String)"dip.streaming-endpoints.service");

    public void streamEndpointToHttp(HttpServletResponse resp, StreamingEndpointStreamingRequestSettings settings, StreamingEndpoint se, StreamingEndpointSimplePusher driver) throws IOException, Exception {
        ArrayList columns = Lists.newArrayList();
        if (settings.columns.isEmpty()) {
            for (SchemaColumn sc : se.schema.columns) {
                columns.add(sc.getName());
            }
        } else {
            columns.addAll(settings.columns);
        }
        StreamColumnFactory cf = new StreamColumnFactory();
        StreamRowFactory rf = new StreamRowFactory();
        final StringBasedFormats.JSONLineFormatSerializer serializer = new StringBasedFormats.JSONLineFormatSerializer((ColumnFactory)cf, se.schema, columns);
        resp.setContentType("application/json");
        resp.setStatus(200);
        final ServletOutputStream output = resp.getOutputStream();
        final byte[] eol = "\n".getBytes(StandardCharsets.UTF_8);
        StreamingEndpointSimpleConsumer consumer = new StreamingEndpointSimpleConsumer(){
            String lastState = null;

            @Override
            public void onRow(Row row) throws Exception {
                output.write("record:".getBytes(StandardCharsets.UTF_8));
                output.write(serializer.serialize(row).getBytes(StandardCharsets.UTF_8));
                output.write(eol);
                output.flush();
            }

            @Override
            public void onNewState(String state) throws Exception {
                if (!StringUtils.equals((String)state, (String)this.lastState)) {
                    output.write("state:".getBytes(StandardCharsets.UTF_8));
                    output.write(state.getBytes(StandardCharsets.UTF_8));
                    output.write(eol);
                    output.flush();
                    this.lastState = state;
                }
            }
        };
        try {
            driver.run(consumer, settings.previousState, (ColumnFactory)cf, (RowFactory)rf, se.schema);
        }
        catch (EofException e) {
            logger.info((Object)"Stream stopped on receiving end");
        }
    }

    public static class StreamingEndpointStreamingRequestSettings {
        public String previousState;
        public List<String> columns = Lists.newArrayList();
    }
}

