/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.common.server.SerializedError;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.util.HTTPClientUtils;
import com.dataiku.dip.utils.DKUtils;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class RepeatingListFetcher<T> {
    @Autowired
    protected GeneralSettingsService settingsService;
    protected T fetchedList;
    protected SerializedError fetchException;
    private final String listURL;
    private final Logger logger;
    private final Class<T> classOfT;
    private Map<String, String> specialHeaders = null;

    public RepeatingListFetcher(String listURL, Logger logger, Class<T> classOfT) {
        this.listURL = listURL;
        this.logger = logger;
        this.classOfT = classOfT;
    }

    public void fetchNow() {
        if (this.specialHeaders == null) {
            this.specialHeaders = this.settingsService.getCustomHeadersForTracking(null);
        }
        this.fetchNow(this.specialHeaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchNow(Map<String, String> specialHeaders) {
        Object localFetchedList = null;
        SerializedError localFetchException = null;
        RepeatingListFetcher repeatingListFetcher = this;
        synchronized (repeatingListFetcher) {
            this.fetchedList = null;
            this.fetchException = null;
        }
        try {
            this.logger.info((Object)("Fetching list from " + this.listURL));
            localFetchedList = HTTPClientUtils.getFromJSON_GET((String)this.listURL, this.classOfT, specialHeaders, (ProxySettings)ApplicationConfigurator.getProxySettings());
            this.filterListItems(localFetchedList);
        }
        catch (Exception e) {
            this.logger.warn((Object)("Failed to fetch " + this.classOfT.getName()), (Throwable)e);
            localFetchException = new SerializedError((Throwable)e, !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideErrorStacks(), !ApplicationConfigurator.hideLogTails());
        }
        repeatingListFetcher = this;
        synchronized (repeatingListFetcher) {
            this.fetchedList = localFetchedList;
            this.fetchException = localFetchException;
        }
    }

    public abstract void filterListItems(T var1);

    @PostConstruct
    public void init() {
        this.logger.debug((Object)"Init fetcher service");
        new FetchThread().start();
        this.logger.debug((Object)"Done init fetcher service");
    }

    private class FetchThread
    extends Thread {
        private FetchThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                RepeatingListFetcher.this.fetchNow();
                boolean isExceptionCatchedInPreviousFetch = false;
                FetchThread fetchThread = this;
                synchronized (fetchThread) {
                    isExceptionCatchedInPreviousFetch = RepeatingListFetcher.this.fetchException != null;
                }
                if (isExceptionCatchedInPreviousFetch) {
                    DKUtils.unsafeSleep((long)14400000L);
                    continue;
                }
                DKUtils.unsafeSleep((long)86400000L);
            }
        }
    }
}

