/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.variables;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.ListIterator;

public class VariablesUtils {
    public static String expand(String projectKey, String data) {
        VariablesService vs = (VariablesService)SpringUtils.getBean(VariablesService.class);
        VariablesContext vc = vs.getForProject(projectKey);
        return vc.expand(data);
    }

    public static String expand(String projectKey, String data, AuthCtx ctx) {
        VariablesService vs = (VariablesService)SpringUtils.getBean(VariablesService.class);
        VariablesContext vc = vs.getForProjectAndUserLogin(projectKey, ctx);
        return vc.expand(data);
    }

    public static void expandList(String projectKey, List<String> data) {
        VariablesService vs = (VariablesService)SpringUtils.getBean(VariablesService.class);
        VariablesContext vc = vs.getForProject(projectKey);
        ListIterator<String> it = data.listIterator();
        while (it.hasNext()) {
            String str = it.next();
            it.set(vc.expand(str));
        }
    }

    public static void expandListAllowUnresolved(String projectKey, List<String> data) {
        VariablesService vs = (VariablesService)SpringUtils.getBean(VariablesService.class);
        VariablesContext vc = vs.getForProject(projectKey);
        ListIterator<String> it = data.listIterator();
        while (it.hasNext()) {
            String str = it.next();
            it.set(vc.expandAllowUnresolved(str));
        }
    }

    public static <T> T expandObjectFields(String projectKey, Object obj, String[] fields) {
        JsonObject jobj = JSON.toJsonObject((Object)obj);
        VariablesService vs = (VariablesService)SpringUtils.getBean(VariablesService.class);
        VariablesContext vc = vs.getForProject(projectKey);
        for (String field : fields) {
            if (jobj.get(field) == null) continue;
            jobj.addProperty(field, vc.expand(jobj.get(field).getAsString()));
        }
        return (T)JSON.parse((String)jobj.toString(), obj.getClass());
    }

    public static <T> T expandObjectFieldsAllowUnresolved(String projectKey, Object obj, String[] fields) {
        JsonObject jobj = JSON.toJsonObject((Object)obj);
        VariablesService vs = (VariablesService)SpringUtils.getBean(VariablesService.class);
        VariablesContext vc = vs.getForProject(projectKey);
        for (String field : fields) {
            if (jobj.get(field) == null) continue;
            jobj.addProperty(field, vc.expandAllowUnresolved(jobj.get(field).getAsString()));
        }
        return (T)JSON.parse((String)jobj.toString(), obj.getClass());
    }
}

