/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.bokeh;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.coremodel.DkuComponentMetadataWithCategory;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnv;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppHandler;
import com.dataiku.dip.webapps.WebAppMeta;
import com.dataiku.dip.webapps.WebAppTemplate;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendRunner;
import com.dataiku.dip.webapps.bokeh.BokehWebAppHandler;
import com.dataiku.dip.webapps.bokeh.backend.BokehWebAppBackendRunner;
import com.dataiku.dip.webapps.plugins.WebAppDesc;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class BokehWebAppMeta
implements WebAppMeta,
MetaWithSelectableCodeEnv {
    public static final String TYPE = "BOKEH";
    public static final String LIVELINESS_CHECK_PATH = "/static/js/bokeh.min.js";
    private static final WebAppDesc desc = BokehWebAppMeta.makeDesc();
    public static final BokehWebAppMeta META = new BokehWebAppMeta();

    @Override
    public Class<? extends WebApp.WebAppParams> getParamsClass() {
        return BokehWebAppParams.class;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isCustomWebApp() {
        return false;
    }

    @Override
    public WebAppBackendRunner buildRunner(WebApp webApp, WebAppBackend webAppBackend, JsonObject variables, AuthCtx user, WebAppBackendInstance webAppBackendInstance) {
        return new BokehWebAppBackendRunner(webApp, webAppBackend, variables, user, webAppBackendInstance);
    }

    @Override
    public WebAppHandler buildHandler(WebApp webapp) {
        return new BokehWebAppHandler(webapp);
    }

    @Override
    public CodeEnvModel.EnvLang getEnvLang() {
        return CodeEnvModel.EnvLang.PYTHON;
    }

    private static WebAppDesc makeDesc() {
        String shortDesc = "Use <a target=\"_blank\" rel=\"noopener noreferrer\" href=\"http://bokeh.pydata.org/\">Bokeh</a> to generate interactive visualizations using only Python";
        DkuComponentMetadataWithCategory data = new DkuComponentMetadataWithCategory("Bokeh", shortDesc, "dku-icon-bokeh-48", null);
        return new WebAppDesc(TYPE, data);
    }

    @Override
    public WebAppDesc getWebAppDesc() {
        return desc;
    }

    @Override
    public List<Object> getHashElements(WebApp webApp) {
        BokehWebAppParams params = webApp.getParamsAs(BokehWebAppParams.class);
        ArrayList ret = Lists.newArrayList();
        ret.add(params.forceAuthentication);
        ret.add(params.python);
        ret.add(params.envSelection);
        ret.add(params.nbProcesses);
        return ret;
    }

    public static class BokehWebAppParams
    extends WebApp.WebAppParams
    implements ParamsWithSelectableCodeEnv {
        @JSON.FileTransient
        public String python;
        public boolean autoStartBackend;
        public CodeEnvSelection envSelection = new CodeEnvSelection();
        public int nbProcesses = 0;

        @Override
        public boolean isBackendEnabled() {
            return true;
        }

        @Override
        public boolean isAutoStartBackend() {
            return this.autoStartBackend;
        }

        @Override
        public JsonObject getSensitiveSettings(AuthCtx authCtx) throws IOException, DKUSecurityException {
            Preconditions.checkNotNull((Object)this.python);
            JsonObject ret = super.getSensitiveSettings(authCtx);
            ret.addProperty("type", BokehWebAppMeta.TYPE);
            ret.addProperty("python", this.python);
            return ret;
        }

        @Override
        public boolean isLoadingPythonLibraries() {
            return true;
        }

        @Override
        public boolean isLoadingRLibraries() {
            return false;
        }

        @Override
        public CodeEnvSelection getCodeEnvSelection() {
            return this.envSelection;
        }

        @Override
        public void setCodeEnvSelection(CodeEnvSelection envSelection) {
            this.envSelection = envSelection;
        }

        @Override
        public List<CodeEnvModel.CodeEnvUsage> collectCodeEnvUsage(TaggableObjectsService.TaggableObject object) {
            ArrayList usages = Lists.newArrayList();
            if (this.envSelection.envMode == CodeEnvSelection.EnvMode.EXPLICIT_ENV) {
                usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.PYTHON, this.envSelection.envName, CodeEnvModel.EnvUsage.WEBAPP, object.getProjectKey(), object.getId()));
            }
            return usages;
        }
    }

    public static class BokehWebAppTemplateMeta
    extends WebAppTemplate {
    }
}

