/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.arrays;

import com.google.refine.expr.EvalError;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public class Join
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 2) {
            Object v = args[0];
            Object s = args[1];
            if (v != null && s != null && s instanceof String) {
                String separator = (String)s;
                List<?> list = DKUFormulaUtils.asList(v);
                return StringUtils.join(list, (String)separator);
            }
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects an array and a string");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Join.DOCUMENTATION", "Returns the string obtained by joining the elements of array <code>a</code> with the separator <code>sep</code>.").withParams("array a", "string sep").withReturns("string").withCategory("GREL.FUNCTIONS.CATEGORY.ARRAY", "Array functions").withExample(Example.with("[2007,7,15]", "\"-\"").returns("\"2007-7-15\""));
    }
}

